/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
"use strict";

var $protobuf = require("protobufjs/minimal");

// Common aliases
var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

// Exported root namespace
var $root = $protobuf.roots["default"] || ($protobuf.roots["default"] = {});

$root.proto = (function() {

    /**
     * Namespace proto.
     * @exports proto
     * @namespace
     */
    var proto = {};

    proto.ADVDeviceIdentity = (function() {

        /**
         * Properties of a ADVDeviceIdentity.
         * @memberof proto
         * @interface IADVDeviceIdentity
         * @property {number|null} [rawId] ADVDeviceIdentity rawId
         * @property {number|Long|null} [timestamp] ADVDeviceIdentity timestamp
         * @property {number|null} [keyIndex] ADVDeviceIdentity keyIndex
         */

        /**
         * Constructs a new ADVDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVDeviceIdentity.
         * @implements IADVDeviceIdentity
         * @constructor
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         */
        function ADVDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVDeviceIdentity rawId.
         * @member {number} rawId
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.rawId = 0;

        /**
         * ADVDeviceIdentity timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVDeviceIdentity keyIndex.
         * @member {number} keyIndex
         * @memberof proto.ADVDeviceIdentity
         * @instance
         */
        ADVDeviceIdentity.prototype.keyIndex = 0;

        /**
         * Creates a new ADVDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity instance
         */
        ADVDeviceIdentity.create = function create(properties) {
            return new ADVDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVDeviceIdentity message. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.keyIndex != null && Object.hasOwnProperty.call(message, "keyIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.keyIndex);
            return writer;
        };

        /**
         * Encodes the specified ADVDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.IADVDeviceIdentity} message ADVDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.keyIndex = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                if (!$util.isInteger(message.keyIndex))
                    return "keyIndex: integer expected";
            return null;
        };

        /**
         * Creates a ADVDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVDeviceIdentity} ADVDeviceIdentity
         */
        ADVDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVDeviceIdentity)
                return object;
            var message = new $root.proto.ADVDeviceIdentity();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.keyIndex != null)
                message.keyIndex = object.keyIndex >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a ADVDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVDeviceIdentity
         * @static
         * @param {proto.ADVDeviceIdentity} message ADVDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.keyIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.keyIndex != null && message.hasOwnProperty("keyIndex"))
                object.keyIndex = message.keyIndex;
            return object;
        };

        /**
         * Converts this ADVDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVDeviceIdentity;
    })();

    proto.ADVKeyIndexList = (function() {

        /**
         * Properties of a ADVKeyIndexList.
         * @memberof proto
         * @interface IADVKeyIndexList
         * @property {number|null} [rawId] ADVKeyIndexList rawId
         * @property {number|Long|null} [timestamp] ADVKeyIndexList timestamp
         * @property {number|null} [currentIndex] ADVKeyIndexList currentIndex
         * @property {Array.<number>|null} [validIndexes] ADVKeyIndexList validIndexes
         */

        /**
         * Constructs a new ADVKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVKeyIndexList.
         * @implements IADVKeyIndexList
         * @constructor
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         */
        function ADVKeyIndexList(properties) {
            this.validIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVKeyIndexList rawId.
         * @member {number} rawId
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.rawId = 0;

        /**
         * ADVKeyIndexList timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ADVKeyIndexList currentIndex.
         * @member {number} currentIndex
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.currentIndex = 0;

        /**
         * ADVKeyIndexList validIndexes.
         * @member {Array.<number>} validIndexes
         * @memberof proto.ADVKeyIndexList
         * @instance
         */
        ADVKeyIndexList.prototype.validIndexes = $util.emptyArray;

        /**
         * Creates a new ADVKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList instance
         */
        ADVKeyIndexList.create = function create(properties) {
            return new ADVKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVKeyIndexList message. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.rawId != null && Object.hasOwnProperty.call(message, "rawId"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.rawId);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.timestamp);
            if (message.currentIndex != null && Object.hasOwnProperty.call(message, "currentIndex"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.currentIndex);
            if (message.validIndexes != null && message.validIndexes.length) {
                writer.uint32(/* id 4, wireType 2 =*/34).fork();
                for (var i = 0; i < message.validIndexes.length; ++i)
                    writer.uint32(message.validIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified ADVKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.IADVKeyIndexList} message ADVKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.rawId = reader.uint32();
                    break;
                case 2:
                    message.timestamp = reader.uint64();
                    break;
                case 3:
                    message.currentIndex = reader.uint32();
                    break;
                case 4:
                    if (!(message.validIndexes && message.validIndexes.length))
                        message.validIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.validIndexes.push(reader.uint32());
                    } else
                        message.validIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVKeyIndexList message.
         * @function verify
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                if (!$util.isInteger(message.rawId))
                    return "rawId: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                if (!$util.isInteger(message.currentIndex))
                    return "currentIndex: integer expected";
            if (message.validIndexes != null && message.hasOwnProperty("validIndexes")) {
                if (!Array.isArray(message.validIndexes))
                    return "validIndexes: array expected";
                for (var i = 0; i < message.validIndexes.length; ++i)
                    if (!$util.isInteger(message.validIndexes[i]))
                        return "validIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a ADVKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVKeyIndexList} ADVKeyIndexList
         */
        ADVKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVKeyIndexList)
                return object;
            var message = new $root.proto.ADVKeyIndexList();
            if (object.rawId != null)
                message.rawId = object.rawId >>> 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = true;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber(true);
            if (object.currentIndex != null)
                message.currentIndex = object.currentIndex >>> 0;
            if (object.validIndexes) {
                if (!Array.isArray(object.validIndexes))
                    throw TypeError(".proto.ADVKeyIndexList.validIndexes: array expected");
                message.validIndexes = [];
                for (var i = 0; i < object.validIndexes.length; ++i)
                    message.validIndexes[i] = object.validIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a ADVKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVKeyIndexList
         * @static
         * @param {proto.ADVKeyIndexList} message ADVKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.validIndexes = [];
            if (options.defaults) {
                object.rawId = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
                object.currentIndex = 0;
            }
            if (message.rawId != null && message.hasOwnProperty("rawId"))
                object.rawId = message.rawId;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber(true) : message.timestamp;
            if (message.currentIndex != null && message.hasOwnProperty("currentIndex"))
                object.currentIndex = message.currentIndex;
            if (message.validIndexes && message.validIndexes.length) {
                object.validIndexes = [];
                for (var j = 0; j < message.validIndexes.length; ++j)
                    object.validIndexes[j] = message.validIndexes[j];
            }
            return object;
        };

        /**
         * Converts this ADVKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVKeyIndexList;
    })();

    proto.ADVSignedDeviceIdentity = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentity.
         * @memberof proto
         * @interface IADVSignedDeviceIdentity
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentity details
         * @property {Uint8Array|null} [accountSignatureKey] ADVSignedDeviceIdentity accountSignatureKey
         * @property {Uint8Array|null} [accountSignature] ADVSignedDeviceIdentity accountSignature
         * @property {Uint8Array|null} [deviceSignature] ADVSignedDeviceIdentity deviceSignature
         */

        /**
         * Constructs a new ADVSignedDeviceIdentity.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentity.
         * @implements IADVSignedDeviceIdentity
         * @constructor
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentity(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentity details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignatureKey.
         * @member {Uint8Array} accountSignatureKey
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignatureKey = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.accountSignature = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentity deviceSignature.
         * @member {Uint8Array} deviceSignature
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         */
        ADVSignedDeviceIdentity.prototype.deviceSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentity instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity instance
         */
        ADVSignedDeviceIdentity.create = function create(properties) {
            return new ADVSignedDeviceIdentity(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignatureKey != null && Object.hasOwnProperty.call(message, "accountSignatureKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignatureKey);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.accountSignature);
            if (message.deviceSignature != null && Object.hasOwnProperty.call(message, "deviceSignature"))
                writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.deviceSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentity message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentity.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.IADVSignedDeviceIdentity} message ADVSignedDeviceIdentity message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentity.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentity();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignatureKey = reader.bytes();
                    break;
                case 3:
                    message.accountSignature = reader.bytes();
                    break;
                case 4:
                    message.deviceSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentity message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentity.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentity message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentity.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                if (!(message.accountSignatureKey && typeof message.accountSignatureKey.length === "number" || $util.isString(message.accountSignatureKey)))
                    return "accountSignatureKey: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                if (!(message.deviceSignature && typeof message.deviceSignature.length === "number" || $util.isString(message.deviceSignature)))
                    return "deviceSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentity message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentity} ADVSignedDeviceIdentity
         */
        ADVSignedDeviceIdentity.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentity)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentity();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignatureKey != null)
                if (typeof object.accountSignatureKey === "string")
                    $util.base64.decode(object.accountSignatureKey, message.accountSignatureKey = $util.newBuffer($util.base64.length(object.accountSignatureKey)), 0);
                else if (object.accountSignatureKey.length)
                    message.accountSignatureKey = object.accountSignatureKey;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            if (object.deviceSignature != null)
                if (typeof object.deviceSignature === "string")
                    $util.base64.decode(object.deviceSignature, message.deviceSignature = $util.newBuffer($util.base64.length(object.deviceSignature)), 0);
                else if (object.deviceSignature.length)
                    message.deviceSignature = object.deviceSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentity message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentity
         * @static
         * @param {proto.ADVSignedDeviceIdentity} message ADVSignedDeviceIdentity
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentity.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignatureKey = "";
                else {
                    object.accountSignatureKey = [];
                    if (options.bytes !== Array)
                        object.accountSignatureKey = $util.newBuffer(object.accountSignatureKey);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
                if (options.bytes === String)
                    object.deviceSignature = "";
                else {
                    object.deviceSignature = [];
                    if (options.bytes !== Array)
                        object.deviceSignature = $util.newBuffer(object.deviceSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignatureKey != null && message.hasOwnProperty("accountSignatureKey"))
                object.accountSignatureKey = options.bytes === String ? $util.base64.encode(message.accountSignatureKey, 0, message.accountSignatureKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignatureKey) : message.accountSignatureKey;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            if (message.deviceSignature != null && message.hasOwnProperty("deviceSignature"))
                object.deviceSignature = options.bytes === String ? $util.base64.encode(message.deviceSignature, 0, message.deviceSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceSignature) : message.deviceSignature;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentity to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentity
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentity.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentity;
    })();

    proto.ADVSignedDeviceIdentityHMAC = (function() {

        /**
         * Properties of a ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @interface IADVSignedDeviceIdentityHMAC
         * @property {Uint8Array|null} [details] ADVSignedDeviceIdentityHMAC details
         * @property {Uint8Array|null} [hmac] ADVSignedDeviceIdentityHMAC hmac
         */

        /**
         * Constructs a new ADVSignedDeviceIdentityHMAC.
         * @memberof proto
         * @classdesc Represents a ADVSignedDeviceIdentityHMAC.
         * @implements IADVSignedDeviceIdentityHMAC
         * @constructor
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         */
        function ADVSignedDeviceIdentityHMAC(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedDeviceIdentityHMAC details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedDeviceIdentityHMAC hmac.
         * @member {Uint8Array} hmac
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         */
        ADVSignedDeviceIdentityHMAC.prototype.hmac = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedDeviceIdentityHMAC instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC=} [properties] Properties to set
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC instance
         */
        ADVSignedDeviceIdentityHMAC.create = function create(properties) {
            return new ADVSignedDeviceIdentityHMAC(properties);
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.hmac != null && Object.hasOwnProperty.call(message, "hmac"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.hmac);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedDeviceIdentityHMAC message, length delimited. Does not implicitly {@link proto.ADVSignedDeviceIdentityHMAC.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.IADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedDeviceIdentityHMAC.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.hmac = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedDeviceIdentityHMAC message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedDeviceIdentityHMAC.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedDeviceIdentityHMAC message.
         * @function verify
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedDeviceIdentityHMAC.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                if (!(message.hmac && typeof message.hmac.length === "number" || $util.isString(message.hmac)))
                    return "hmac: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedDeviceIdentityHMAC message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedDeviceIdentityHMAC} ADVSignedDeviceIdentityHMAC
         */
        ADVSignedDeviceIdentityHMAC.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedDeviceIdentityHMAC)
                return object;
            var message = new $root.proto.ADVSignedDeviceIdentityHMAC();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.hmac != null)
                if (typeof object.hmac === "string")
                    $util.base64.decode(object.hmac, message.hmac = $util.newBuffer($util.base64.length(object.hmac)), 0);
                else if (object.hmac.length)
                    message.hmac = object.hmac;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedDeviceIdentityHMAC message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @static
         * @param {proto.ADVSignedDeviceIdentityHMAC} message ADVSignedDeviceIdentityHMAC
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedDeviceIdentityHMAC.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.hmac = "";
                else {
                    object.hmac = [];
                    if (options.bytes !== Array)
                        object.hmac = $util.newBuffer(object.hmac);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.hmac != null && message.hasOwnProperty("hmac"))
                object.hmac = options.bytes === String ? $util.base64.encode(message.hmac, 0, message.hmac.length) : options.bytes === Array ? Array.prototype.slice.call(message.hmac) : message.hmac;
            return object;
        };

        /**
         * Converts this ADVSignedDeviceIdentityHMAC to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedDeviceIdentityHMAC
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedDeviceIdentityHMAC.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedDeviceIdentityHMAC;
    })();

    proto.ADVSignedKeyIndexList = (function() {

        /**
         * Properties of a ADVSignedKeyIndexList.
         * @memberof proto
         * @interface IADVSignedKeyIndexList
         * @property {Uint8Array|null} [details] ADVSignedKeyIndexList details
         * @property {Uint8Array|null} [accountSignature] ADVSignedKeyIndexList accountSignature
         */

        /**
         * Constructs a new ADVSignedKeyIndexList.
         * @memberof proto
         * @classdesc Represents a ADVSignedKeyIndexList.
         * @implements IADVSignedKeyIndexList
         * @constructor
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         */
        function ADVSignedKeyIndexList(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ADVSignedKeyIndexList details.
         * @member {Uint8Array} details
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.details = $util.newBuffer([]);

        /**
         * ADVSignedKeyIndexList accountSignature.
         * @member {Uint8Array} accountSignature
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         */
        ADVSignedKeyIndexList.prototype.accountSignature = $util.newBuffer([]);

        /**
         * Creates a new ADVSignedKeyIndexList instance using the specified properties.
         * @function create
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList=} [properties] Properties to set
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList instance
         */
        ADVSignedKeyIndexList.create = function create(properties) {
            return new ADVSignedKeyIndexList(properties);
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
            if (message.accountSignature != null && Object.hasOwnProperty.call(message, "accountSignature"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.accountSignature);
            return writer;
        };

        /**
         * Encodes the specified ADVSignedKeyIndexList message, length delimited. Does not implicitly {@link proto.ADVSignedKeyIndexList.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.IADVSignedKeyIndexList} message ADVSignedKeyIndexList message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ADVSignedKeyIndexList.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ADVSignedKeyIndexList();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.details = reader.bytes();
                    break;
                case 2:
                    message.accountSignature = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ADVSignedKeyIndexList message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ADVSignedKeyIndexList.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ADVSignedKeyIndexList message.
         * @function verify
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ADVSignedKeyIndexList.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.details != null && message.hasOwnProperty("details"))
                if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                    return "details: buffer expected";
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                if (!(message.accountSignature && typeof message.accountSignature.length === "number" || $util.isString(message.accountSignature)))
                    return "accountSignature: buffer expected";
            return null;
        };

        /**
         * Creates a ADVSignedKeyIndexList message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ADVSignedKeyIndexList} ADVSignedKeyIndexList
         */
        ADVSignedKeyIndexList.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ADVSignedKeyIndexList)
                return object;
            var message = new $root.proto.ADVSignedKeyIndexList();
            if (object.details != null)
                if (typeof object.details === "string")
                    $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                else if (object.details.length)
                    message.details = object.details;
            if (object.accountSignature != null)
                if (typeof object.accountSignature === "string")
                    $util.base64.decode(object.accountSignature, message.accountSignature = $util.newBuffer($util.base64.length(object.accountSignature)), 0);
                else if (object.accountSignature.length)
                    message.accountSignature = object.accountSignature;
            return message;
        };

        /**
         * Creates a plain object from a ADVSignedKeyIndexList message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ADVSignedKeyIndexList
         * @static
         * @param {proto.ADVSignedKeyIndexList} message ADVSignedKeyIndexList
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ADVSignedKeyIndexList.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.details = "";
                else {
                    object.details = [];
                    if (options.bytes !== Array)
                        object.details = $util.newBuffer(object.details);
                }
                if (options.bytes === String)
                    object.accountSignature = "";
                else {
                    object.accountSignature = [];
                    if (options.bytes !== Array)
                        object.accountSignature = $util.newBuffer(object.accountSignature);
                }
            }
            if (message.details != null && message.hasOwnProperty("details"))
                object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
            if (message.accountSignature != null && message.hasOwnProperty("accountSignature"))
                object.accountSignature = options.bytes === String ? $util.base64.encode(message.accountSignature, 0, message.accountSignature.length) : options.bytes === Array ? Array.prototype.slice.call(message.accountSignature) : message.accountSignature;
            return object;
        };

        /**
         * Converts this ADVSignedKeyIndexList to JSON.
         * @function toJSON
         * @memberof proto.ADVSignedKeyIndexList
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ADVSignedKeyIndexList.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ADVSignedKeyIndexList;
    })();

    proto.ActionLink = (function() {

        /**
         * Properties of an ActionLink.
         * @memberof proto
         * @interface IActionLink
         * @property {string|null} [url] ActionLink url
         * @property {string|null} [buttonTitle] ActionLink buttonTitle
         */

        /**
         * Constructs a new ActionLink.
         * @memberof proto
         * @classdesc Represents an ActionLink.
         * @implements IActionLink
         * @constructor
         * @param {proto.IActionLink=} [properties] Properties to set
         */
        function ActionLink(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ActionLink url.
         * @member {string} url
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.url = "";

        /**
         * ActionLink buttonTitle.
         * @member {string} buttonTitle
         * @memberof proto.ActionLink
         * @instance
         */
        ActionLink.prototype.buttonTitle = "";

        /**
         * Creates a new ActionLink instance using the specified properties.
         * @function create
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink=} [properties] Properties to set
         * @returns {proto.ActionLink} ActionLink instance
         */
        ActionLink.create = function create(properties) {
            return new ActionLink(properties);
        };

        /**
         * Encodes the specified ActionLink message. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encode
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.url);
            if (message.buttonTitle != null && Object.hasOwnProperty.call(message, "buttonTitle"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.buttonTitle);
            return writer;
        };

        /**
         * Encodes the specified ActionLink message, length delimited. Does not implicitly {@link proto.ActionLink.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {proto.IActionLink} message ActionLink message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ActionLink.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ActionLink();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.url = reader.string();
                    break;
                case 2:
                    message.buttonTitle = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ActionLink message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ActionLink
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ActionLink} ActionLink
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ActionLink.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ActionLink message.
         * @function verify
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ActionLink.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.url != null && message.hasOwnProperty("url"))
                if (!$util.isString(message.url))
                    return "url: string expected";
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                if (!$util.isString(message.buttonTitle))
                    return "buttonTitle: string expected";
            return null;
        };

        /**
         * Creates an ActionLink message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ActionLink
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ActionLink} ActionLink
         */
        ActionLink.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ActionLink)
                return object;
            var message = new $root.proto.ActionLink();
            if (object.url != null)
                message.url = String(object.url);
            if (object.buttonTitle != null)
                message.buttonTitle = String(object.buttonTitle);
            return message;
        };

        /**
         * Creates a plain object from an ActionLink message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ActionLink
         * @static
         * @param {proto.ActionLink} message ActionLink
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ActionLink.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.url = "";
                object.buttonTitle = "";
            }
            if (message.url != null && message.hasOwnProperty("url"))
                object.url = message.url;
            if (message.buttonTitle != null && message.hasOwnProperty("buttonTitle"))
                object.buttonTitle = message.buttonTitle;
            return object;
        };

        /**
         * Converts this ActionLink to JSON.
         * @function toJSON
         * @memberof proto.ActionLink
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ActionLink.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ActionLink;
    })();

    proto.AutoDownloadSettings = (function() {

        /**
         * Properties of an AutoDownloadSettings.
         * @memberof proto
         * @interface IAutoDownloadSettings
         * @property {boolean|null} [downloadImages] AutoDownloadSettings downloadImages
         * @property {boolean|null} [downloadAudio] AutoDownloadSettings downloadAudio
         * @property {boolean|null} [downloadVideo] AutoDownloadSettings downloadVideo
         * @property {boolean|null} [downloadDocuments] AutoDownloadSettings downloadDocuments
         */

        /**
         * Constructs a new AutoDownloadSettings.
         * @memberof proto
         * @classdesc Represents an AutoDownloadSettings.
         * @implements IAutoDownloadSettings
         * @constructor
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         */
        function AutoDownloadSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AutoDownloadSettings downloadImages.
         * @member {boolean} downloadImages
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadImages = false;

        /**
         * AutoDownloadSettings downloadAudio.
         * @member {boolean} downloadAudio
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadAudio = false;

        /**
         * AutoDownloadSettings downloadVideo.
         * @member {boolean} downloadVideo
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadVideo = false;

        /**
         * AutoDownloadSettings downloadDocuments.
         * @member {boolean} downloadDocuments
         * @memberof proto.AutoDownloadSettings
         * @instance
         */
        AutoDownloadSettings.prototype.downloadDocuments = false;

        /**
         * Creates a new AutoDownloadSettings instance using the specified properties.
         * @function create
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings=} [properties] Properties to set
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings instance
         */
        AutoDownloadSettings.create = function create(properties) {
            return new AutoDownloadSettings(properties);
        };

        /**
         * Encodes the specified AutoDownloadSettings message. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.downloadImages != null && Object.hasOwnProperty.call(message, "downloadImages"))
                writer.uint32(/* id 1, wireType 0 =*/8).bool(message.downloadImages);
            if (message.downloadAudio != null && Object.hasOwnProperty.call(message, "downloadAudio"))
                writer.uint32(/* id 2, wireType 0 =*/16).bool(message.downloadAudio);
            if (message.downloadVideo != null && Object.hasOwnProperty.call(message, "downloadVideo"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.downloadVideo);
            if (message.downloadDocuments != null && Object.hasOwnProperty.call(message, "downloadDocuments"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.downloadDocuments);
            return writer;
        };

        /**
         * Encodes the specified AutoDownloadSettings message, length delimited. Does not implicitly {@link proto.AutoDownloadSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.IAutoDownloadSettings} message AutoDownloadSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AutoDownloadSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AutoDownloadSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.downloadImages = reader.bool();
                    break;
                case 2:
                    message.downloadAudio = reader.bool();
                    break;
                case 3:
                    message.downloadVideo = reader.bool();
                    break;
                case 4:
                    message.downloadDocuments = reader.bool();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AutoDownloadSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AutoDownloadSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AutoDownloadSettings message.
         * @function verify
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AutoDownloadSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages"))
                if (typeof message.downloadImages !== "boolean")
                    return "downloadImages: boolean expected";
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio"))
                if (typeof message.downloadAudio !== "boolean")
                    return "downloadAudio: boolean expected";
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo"))
                if (typeof message.downloadVideo !== "boolean")
                    return "downloadVideo: boolean expected";
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments"))
                if (typeof message.downloadDocuments !== "boolean")
                    return "downloadDocuments: boolean expected";
            return null;
        };

        /**
         * Creates an AutoDownloadSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AutoDownloadSettings} AutoDownloadSettings
         */
        AutoDownloadSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AutoDownloadSettings)
                return object;
            var message = new $root.proto.AutoDownloadSettings();
            if (object.downloadImages != null)
                message.downloadImages = Boolean(object.downloadImages);
            if (object.downloadAudio != null)
                message.downloadAudio = Boolean(object.downloadAudio);
            if (object.downloadVideo != null)
                message.downloadVideo = Boolean(object.downloadVideo);
            if (object.downloadDocuments != null)
                message.downloadDocuments = Boolean(object.downloadDocuments);
            return message;
        };

        /**
         * Creates a plain object from an AutoDownloadSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AutoDownloadSettings
         * @static
         * @param {proto.AutoDownloadSettings} message AutoDownloadSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AutoDownloadSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.downloadImages = false;
                object.downloadAudio = false;
                object.downloadVideo = false;
                object.downloadDocuments = false;
            }
            if (message.downloadImages != null && message.hasOwnProperty("downloadImages"))
                object.downloadImages = message.downloadImages;
            if (message.downloadAudio != null && message.hasOwnProperty("downloadAudio"))
                object.downloadAudio = message.downloadAudio;
            if (message.downloadVideo != null && message.hasOwnProperty("downloadVideo"))
                object.downloadVideo = message.downloadVideo;
            if (message.downloadDocuments != null && message.hasOwnProperty("downloadDocuments"))
                object.downloadDocuments = message.downloadDocuments;
            return object;
        };

        /**
         * Converts this AutoDownloadSettings to JSON.
         * @function toJSON
         * @memberof proto.AutoDownloadSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AutoDownloadSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AutoDownloadSettings;
    })();

    proto.AvatarUserSettings = (function() {

        /**
         * Properties of an AvatarUserSettings.
         * @memberof proto
         * @interface IAvatarUserSettings
         * @property {string|null} [fbid] AvatarUserSettings fbid
         * @property {string|null} [password] AvatarUserSettings password
         */

        /**
         * Constructs a new AvatarUserSettings.
         * @memberof proto
         * @classdesc Represents an AvatarUserSettings.
         * @implements IAvatarUserSettings
         * @constructor
         * @param {proto.IAvatarUserSettings=} [properties] Properties to set
         */
        function AvatarUserSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * AvatarUserSettings fbid.
         * @member {string} fbid
         * @memberof proto.AvatarUserSettings
         * @instance
         */
        AvatarUserSettings.prototype.fbid = "";

        /**
         * AvatarUserSettings password.
         * @member {string} password
         * @memberof proto.AvatarUserSettings
         * @instance
         */
        AvatarUserSettings.prototype.password = "";

        /**
         * Creates a new AvatarUserSettings instance using the specified properties.
         * @function create
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings=} [properties] Properties to set
         * @returns {proto.AvatarUserSettings} AvatarUserSettings instance
         */
        AvatarUserSettings.create = function create(properties) {
            return new AvatarUserSettings(properties);
        };

        /**
         * Encodes the specified AvatarUserSettings message. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings} message AvatarUserSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AvatarUserSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.fbid != null && Object.hasOwnProperty.call(message, "fbid"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.fbid);
            if (message.password != null && Object.hasOwnProperty.call(message, "password"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.password);
            return writer;
        };

        /**
         * Encodes the specified AvatarUserSettings message, length delimited. Does not implicitly {@link proto.AvatarUserSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.IAvatarUserSettings} message AvatarUserSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        AvatarUserSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AvatarUserSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.AvatarUserSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.fbid = reader.string();
                    break;
                case 2:
                    message.password = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an AvatarUserSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        AvatarUserSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an AvatarUserSettings message.
         * @function verify
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        AvatarUserSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.fbid != null && message.hasOwnProperty("fbid"))
                if (!$util.isString(message.fbid))
                    return "fbid: string expected";
            if (message.password != null && message.hasOwnProperty("password"))
                if (!$util.isString(message.password))
                    return "password: string expected";
            return null;
        };

        /**
         * Creates an AvatarUserSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.AvatarUserSettings} AvatarUserSettings
         */
        AvatarUserSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.AvatarUserSettings)
                return object;
            var message = new $root.proto.AvatarUserSettings();
            if (object.fbid != null)
                message.fbid = String(object.fbid);
            if (object.password != null)
                message.password = String(object.password);
            return message;
        };

        /**
         * Creates a plain object from an AvatarUserSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.AvatarUserSettings
         * @static
         * @param {proto.AvatarUserSettings} message AvatarUserSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        AvatarUserSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.fbid = "";
                object.password = "";
            }
            if (message.fbid != null && message.hasOwnProperty("fbid"))
                object.fbid = message.fbid;
            if (message.password != null && message.hasOwnProperty("password"))
                object.password = message.password;
            return object;
        };

        /**
         * Converts this AvatarUserSettings to JSON.
         * @function toJSON
         * @memberof proto.AvatarUserSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        AvatarUserSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return AvatarUserSettings;
    })();

    proto.BizAccountLinkInfo = (function() {

        /**
         * Properties of a BizAccountLinkInfo.
         * @memberof proto
         * @interface IBizAccountLinkInfo
         * @property {number|Long|null} [whatsappBizAcctFbid] BizAccountLinkInfo whatsappBizAcctFbid
         * @property {string|null} [whatsappAcctNumber] BizAccountLinkInfo whatsappAcctNumber
         * @property {number|Long|null} [issueTime] BizAccountLinkInfo issueTime
         * @property {proto.BizAccountLinkInfo.HostStorageType|null} [hostStorage] BizAccountLinkInfo hostStorage
         * @property {proto.BizAccountLinkInfo.AccountType|null} [accountType] BizAccountLinkInfo accountType
         */

        /**
         * Constructs a new BizAccountLinkInfo.
         * @memberof proto
         * @classdesc Represents a BizAccountLinkInfo.
         * @implements IBizAccountLinkInfo
         * @constructor
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         */
        function BizAccountLinkInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountLinkInfo whatsappBizAcctFbid.
         * @member {number|Long} whatsappBizAcctFbid
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappBizAcctFbid = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo whatsappAcctNumber.
         * @member {string} whatsappAcctNumber
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.whatsappAcctNumber = "";

        /**
         * BizAccountLinkInfo issueTime.
         * @member {number|Long} issueTime
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.issueTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizAccountLinkInfo hostStorage.
         * @member {proto.BizAccountLinkInfo.HostStorageType} hostStorage
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.hostStorage = 0;

        /**
         * BizAccountLinkInfo accountType.
         * @member {proto.BizAccountLinkInfo.AccountType} accountType
         * @memberof proto.BizAccountLinkInfo
         * @instance
         */
        BizAccountLinkInfo.prototype.accountType = 0;

        /**
         * Creates a new BizAccountLinkInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo=} [properties] Properties to set
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo instance
         */
        BizAccountLinkInfo.create = function create(properties) {
            return new BizAccountLinkInfo(properties);
        };

        /**
         * Encodes the specified BizAccountLinkInfo message. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.whatsappBizAcctFbid != null && Object.hasOwnProperty.call(message, "whatsappBizAcctFbid"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.whatsappBizAcctFbid);
            if (message.whatsappAcctNumber != null && Object.hasOwnProperty.call(message, "whatsappAcctNumber"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.whatsappAcctNumber);
            if (message.issueTime != null && Object.hasOwnProperty.call(message, "issueTime"))
                writer.uint32(/* id 3, wireType 0 =*/24).uint64(message.issueTime);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 4, wireType 0 =*/32).int32(message.hostStorage);
            if (message.accountType != null && Object.hasOwnProperty.call(message, "accountType"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.accountType);
            return writer;
        };

        /**
         * Encodes the specified BizAccountLinkInfo message, length delimited. Does not implicitly {@link proto.BizAccountLinkInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.IBizAccountLinkInfo} message BizAccountLinkInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountLinkInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountLinkInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.whatsappBizAcctFbid = reader.uint64();
                    break;
                case 2:
                    message.whatsappAcctNumber = reader.string();
                    break;
                case 3:
                    message.issueTime = reader.uint64();
                    break;
                case 4:
                    message.hostStorage = reader.int32();
                    break;
                case 5:
                    message.accountType = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountLinkInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountLinkInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountLinkInfo message.
         * @function verify
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountLinkInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (!$util.isInteger(message.whatsappBizAcctFbid) && !(message.whatsappBizAcctFbid && $util.isInteger(message.whatsappBizAcctFbid.low) && $util.isInteger(message.whatsappBizAcctFbid.high)))
                    return "whatsappBizAcctFbid: integer|Long expected";
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                if (!$util.isString(message.whatsappAcctNumber))
                    return "whatsappAcctNumber: string expected";
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (!$util.isInteger(message.issueTime) && !(message.issueTime && $util.isInteger(message.issueTime.low) && $util.isInteger(message.issueTime.high)))
                    return "issueTime: integer|Long expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                switch (message.accountType) {
                default:
                    return "accountType: enum value expected";
                case 0:
                    break;
                }
            return null;
        };

        /**
         * Creates a BizAccountLinkInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountLinkInfo} BizAccountLinkInfo
         */
        BizAccountLinkInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountLinkInfo)
                return object;
            var message = new $root.proto.BizAccountLinkInfo();
            if (object.whatsappBizAcctFbid != null)
                if ($util.Long)
                    (message.whatsappBizAcctFbid = $util.Long.fromValue(object.whatsappBizAcctFbid)).unsigned = true;
                else if (typeof object.whatsappBizAcctFbid === "string")
                    message.whatsappBizAcctFbid = parseInt(object.whatsappBizAcctFbid, 10);
                else if (typeof object.whatsappBizAcctFbid === "number")
                    message.whatsappBizAcctFbid = object.whatsappBizAcctFbid;
                else if (typeof object.whatsappBizAcctFbid === "object")
                    message.whatsappBizAcctFbid = new $util.LongBits(object.whatsappBizAcctFbid.low >>> 0, object.whatsappBizAcctFbid.high >>> 0).toNumber(true);
            if (object.whatsappAcctNumber != null)
                message.whatsappAcctNumber = String(object.whatsappAcctNumber);
            if (object.issueTime != null)
                if ($util.Long)
                    (message.issueTime = $util.Long.fromValue(object.issueTime)).unsigned = true;
                else if (typeof object.issueTime === "string")
                    message.issueTime = parseInt(object.issueTime, 10);
                else if (typeof object.issueTime === "number")
                    message.issueTime = object.issueTime;
                else if (typeof object.issueTime === "object")
                    message.issueTime = new $util.LongBits(object.issueTime.low >>> 0, object.issueTime.high >>> 0).toNumber(true);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.accountType) {
            case "ENTERPRISE":
            case 0:
                message.accountType = 0;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a BizAccountLinkInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountLinkInfo
         * @static
         * @param {proto.BizAccountLinkInfo} message BizAccountLinkInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountLinkInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.whatsappBizAcctFbid = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.whatsappBizAcctFbid = options.longs === String ? "0" : 0;
                object.whatsappAcctNumber = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.issueTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.issueTime = options.longs === String ? "0" : 0;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.accountType = options.enums === String ? "ENTERPRISE" : 0;
            }
            if (message.whatsappBizAcctFbid != null && message.hasOwnProperty("whatsappBizAcctFbid"))
                if (typeof message.whatsappBizAcctFbid === "number")
                    object.whatsappBizAcctFbid = options.longs === String ? String(message.whatsappBizAcctFbid) : message.whatsappBizAcctFbid;
                else
                    object.whatsappBizAcctFbid = options.longs === String ? $util.Long.prototype.toString.call(message.whatsappBizAcctFbid) : options.longs === Number ? new $util.LongBits(message.whatsappBizAcctFbid.low >>> 0, message.whatsappBizAcctFbid.high >>> 0).toNumber(true) : message.whatsappBizAcctFbid;
            if (message.whatsappAcctNumber != null && message.hasOwnProperty("whatsappAcctNumber"))
                object.whatsappAcctNumber = message.whatsappAcctNumber;
            if (message.issueTime != null && message.hasOwnProperty("issueTime"))
                if (typeof message.issueTime === "number")
                    object.issueTime = options.longs === String ? String(message.issueTime) : message.issueTime;
                else
                    object.issueTime = options.longs === String ? $util.Long.prototype.toString.call(message.issueTime) : options.longs === Number ? new $util.LongBits(message.issueTime.low >>> 0, message.issueTime.high >>> 0).toNumber(true) : message.issueTime;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizAccountLinkInfo.HostStorageType[message.hostStorage] : message.hostStorage;
            if (message.accountType != null && message.hasOwnProperty("accountType"))
                object.accountType = options.enums === String ? $root.proto.BizAccountLinkInfo.AccountType[message.accountType] : message.accountType;
            return object;
        };

        /**
         * Converts this BizAccountLinkInfo to JSON.
         * @function toJSON
         * @memberof proto.BizAccountLinkInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountLinkInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * AccountType enum.
         * @name proto.BizAccountLinkInfo.AccountType
         * @enum {number}
         * @property {number} ENTERPRISE=0 ENTERPRISE value
         */
        BizAccountLinkInfo.AccountType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ENTERPRISE"] = 0;
            return values;
        })();

        /**
         * HostStorageType enum.
         * @name proto.BizAccountLinkInfo.HostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizAccountLinkInfo.HostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        return BizAccountLinkInfo;
    })();

    proto.BizAccountPayload = (function() {

        /**
         * Properties of a BizAccountPayload.
         * @memberof proto
         * @interface IBizAccountPayload
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizAccountPayload vnameCert
         * @property {Uint8Array|null} [bizAcctLinkInfo] BizAccountPayload bizAcctLinkInfo
         */

        /**
         * Constructs a new BizAccountPayload.
         * @memberof proto
         * @classdesc Represents a BizAccountPayload.
         * @implements IBizAccountPayload
         * @constructor
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         */
        function BizAccountPayload(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizAccountPayload vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.vnameCert = null;

        /**
         * BizAccountPayload bizAcctLinkInfo.
         * @member {Uint8Array} bizAcctLinkInfo
         * @memberof proto.BizAccountPayload
         * @instance
         */
        BizAccountPayload.prototype.bizAcctLinkInfo = $util.newBuffer([]);

        /**
         * Creates a new BizAccountPayload instance using the specified properties.
         * @function create
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload=} [properties] Properties to set
         * @returns {proto.BizAccountPayload} BizAccountPayload instance
         */
        BizAccountPayload.create = function create(properties) {
            return new BizAccountPayload(properties);
        };

        /**
         * Encodes the specified BizAccountPayload message. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.bizAcctLinkInfo != null && Object.hasOwnProperty.call(message, "bizAcctLinkInfo"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.bizAcctLinkInfo);
            return writer;
        };

        /**
         * Encodes the specified BizAccountPayload message, length delimited. Does not implicitly {@link proto.BizAccountPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.IBizAccountPayload} message BizAccountPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizAccountPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizAccountPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.bizAcctLinkInfo = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizAccountPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizAccountPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizAccountPayload} BizAccountPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizAccountPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizAccountPayload message.
         * @function verify
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizAccountPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                if (!(message.bizAcctLinkInfo && typeof message.bizAcctLinkInfo.length === "number" || $util.isString(message.bizAcctLinkInfo)))
                    return "bizAcctLinkInfo: buffer expected";
            return null;
        };

        /**
         * Creates a BizAccountPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizAccountPayload} BizAccountPayload
         */
        BizAccountPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizAccountPayload)
                return object;
            var message = new $root.proto.BizAccountPayload();
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizAccountPayload.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.bizAcctLinkInfo != null)
                if (typeof object.bizAcctLinkInfo === "string")
                    $util.base64.decode(object.bizAcctLinkInfo, message.bizAcctLinkInfo = $util.newBuffer($util.base64.length(object.bizAcctLinkInfo)), 0);
                else if (object.bizAcctLinkInfo.length)
                    message.bizAcctLinkInfo = object.bizAcctLinkInfo;
            return message;
        };

        /**
         * Creates a plain object from a BizAccountPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizAccountPayload
         * @static
         * @param {proto.BizAccountPayload} message BizAccountPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizAccountPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vnameCert = null;
                if (options.bytes === String)
                    object.bizAcctLinkInfo = "";
                else {
                    object.bizAcctLinkInfo = [];
                    if (options.bytes !== Array)
                        object.bizAcctLinkInfo = $util.newBuffer(object.bizAcctLinkInfo);
                }
            }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.bizAcctLinkInfo != null && message.hasOwnProperty("bizAcctLinkInfo"))
                object.bizAcctLinkInfo = options.bytes === String ? $util.base64.encode(message.bizAcctLinkInfo, 0, message.bizAcctLinkInfo.length) : options.bytes === Array ? Array.prototype.slice.call(message.bizAcctLinkInfo) : message.bizAcctLinkInfo;
            return object;
        };

        /**
         * Converts this BizAccountPayload to JSON.
         * @function toJSON
         * @memberof proto.BizAccountPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizAccountPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return BizAccountPayload;
    })();

    proto.BizIdentityInfo = (function() {

        /**
         * Properties of a BizIdentityInfo.
         * @memberof proto
         * @interface IBizIdentityInfo
         * @property {proto.BizIdentityInfo.VerifiedLevelValue|null} [vlevel] BizIdentityInfo vlevel
         * @property {proto.IVerifiedNameCertificate|null} [vnameCert] BizIdentityInfo vnameCert
         * @property {boolean|null} [signed] BizIdentityInfo signed
         * @property {boolean|null} [revoked] BizIdentityInfo revoked
         * @property {proto.BizIdentityInfo.HostStorageType|null} [hostStorage] BizIdentityInfo hostStorage
         * @property {proto.BizIdentityInfo.ActualActorsType|null} [actualActors] BizIdentityInfo actualActors
         * @property {number|Long|null} [privacyModeTs] BizIdentityInfo privacyModeTs
         * @property {number|Long|null} [featureControls] BizIdentityInfo featureControls
         */

        /**
         * Constructs a new BizIdentityInfo.
         * @memberof proto
         * @classdesc Represents a BizIdentityInfo.
         * @implements IBizIdentityInfo
         * @constructor
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         */
        function BizIdentityInfo(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * BizIdentityInfo vlevel.
         * @member {proto.BizIdentityInfo.VerifiedLevelValue} vlevel
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vlevel = 0;

        /**
         * BizIdentityInfo vnameCert.
         * @member {proto.IVerifiedNameCertificate|null|undefined} vnameCert
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.vnameCert = null;

        /**
         * BizIdentityInfo signed.
         * @member {boolean} signed
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.signed = false;

        /**
         * BizIdentityInfo revoked.
         * @member {boolean} revoked
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.revoked = false;

        /**
         * BizIdentityInfo hostStorage.
         * @member {proto.BizIdentityInfo.HostStorageType} hostStorage
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.hostStorage = 0;

        /**
         * BizIdentityInfo actualActors.
         * @member {proto.BizIdentityInfo.ActualActorsType} actualActors
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.actualActors = 0;

        /**
         * BizIdentityInfo privacyModeTs.
         * @member {number|Long} privacyModeTs
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.privacyModeTs = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * BizIdentityInfo featureControls.
         * @member {number|Long} featureControls
         * @memberof proto.BizIdentityInfo
         * @instance
         */
        BizIdentityInfo.prototype.featureControls = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new BizIdentityInfo instance using the specified properties.
         * @function create
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo=} [properties] Properties to set
         * @returns {proto.BizIdentityInfo} BizIdentityInfo instance
         */
        BizIdentityInfo.create = function create(properties) {
            return new BizIdentityInfo(properties);
        };

        /**
         * Encodes the specified BizIdentityInfo message. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.vlevel != null && Object.hasOwnProperty.call(message, "vlevel"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.vlevel);
            if (message.vnameCert != null && Object.hasOwnProperty.call(message, "vnameCert"))
                $root.proto.VerifiedNameCertificate.encode(message.vnameCert, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.signed != null && Object.hasOwnProperty.call(message, "signed"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.signed);
            if (message.revoked != null && Object.hasOwnProperty.call(message, "revoked"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.revoked);
            if (message.hostStorage != null && Object.hasOwnProperty.call(message, "hostStorage"))
                writer.uint32(/* id 5, wireType 0 =*/40).int32(message.hostStorage);
            if (message.actualActors != null && Object.hasOwnProperty.call(message, "actualActors"))
                writer.uint32(/* id 6, wireType 0 =*/48).int32(message.actualActors);
            if (message.privacyModeTs != null && Object.hasOwnProperty.call(message, "privacyModeTs"))
                writer.uint32(/* id 7, wireType 0 =*/56).uint64(message.privacyModeTs);
            if (message.featureControls != null && Object.hasOwnProperty.call(message, "featureControls"))
                writer.uint32(/* id 8, wireType 0 =*/64).uint64(message.featureControls);
            return writer;
        };

        /**
         * Encodes the specified BizIdentityInfo message, length delimited. Does not implicitly {@link proto.BizIdentityInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.IBizIdentityInfo} message BizIdentityInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        BizIdentityInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.BizIdentityInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.vlevel = reader.int32();
                    break;
                case 2:
                    message.vnameCert = $root.proto.VerifiedNameCertificate.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.signed = reader.bool();
                    break;
                case 4:
                    message.revoked = reader.bool();
                    break;
                case 5:
                    message.hostStorage = reader.int32();
                    break;
                case 6:
                    message.actualActors = reader.int32();
                    break;
                case 7:
                    message.privacyModeTs = reader.uint64();
                    break;
                case 8:
                    message.featureControls = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a BizIdentityInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        BizIdentityInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a BizIdentityInfo message.
         * @function verify
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        BizIdentityInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                switch (message.vlevel) {
                default:
                    return "vlevel: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert")) {
                var error = $root.proto.VerifiedNameCertificate.verify(message.vnameCert);
                if (error)
                    return "vnameCert." + error;
            }
            if (message.signed != null && message.hasOwnProperty("signed"))
                if (typeof message.signed !== "boolean")
                    return "signed: boolean expected";
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                if (typeof message.revoked !== "boolean")
                    return "revoked: boolean expected";
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                switch (message.hostStorage) {
                default:
                    return "hostStorage: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                switch (message.actualActors) {
                default:
                    return "actualActors: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (!$util.isInteger(message.privacyModeTs) && !(message.privacyModeTs && $util.isInteger(message.privacyModeTs.low) && $util.isInteger(message.privacyModeTs.high)))
                    return "privacyModeTs: integer|Long expected";
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (!$util.isInteger(message.featureControls) && !(message.featureControls && $util.isInteger(message.featureControls.low) && $util.isInteger(message.featureControls.high)))
                    return "featureControls: integer|Long expected";
            return null;
        };

        /**
         * Creates a BizIdentityInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.BizIdentityInfo} BizIdentityInfo
         */
        BizIdentityInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.BizIdentityInfo)
                return object;
            var message = new $root.proto.BizIdentityInfo();
            switch (object.vlevel) {
            case "UNKNOWN":
            case 0:
                message.vlevel = 0;
                break;
            case "LOW":
            case 1:
                message.vlevel = 1;
                break;
            case "HIGH":
            case 2:
                message.vlevel = 2;
                break;
            }
            if (object.vnameCert != null) {
                if (typeof object.vnameCert !== "object")
                    throw TypeError(".proto.BizIdentityInfo.vnameCert: object expected");
                message.vnameCert = $root.proto.VerifiedNameCertificate.fromObject(object.vnameCert);
            }
            if (object.signed != null)
                message.signed = Boolean(object.signed);
            if (object.revoked != null)
                message.revoked = Boolean(object.revoked);
            switch (object.hostStorage) {
            case "ON_PREMISE":
            case 0:
                message.hostStorage = 0;
                break;
            case "FACEBOOK":
            case 1:
                message.hostStorage = 1;
                break;
            }
            switch (object.actualActors) {
            case "SELF":
            case 0:
                message.actualActors = 0;
                break;
            case "BSP":
            case 1:
                message.actualActors = 1;
                break;
            }
            if (object.privacyModeTs != null)
                if ($util.Long)
                    (message.privacyModeTs = $util.Long.fromValue(object.privacyModeTs)).unsigned = true;
                else if (typeof object.privacyModeTs === "string")
                    message.privacyModeTs = parseInt(object.privacyModeTs, 10);
                else if (typeof object.privacyModeTs === "number")
                    message.privacyModeTs = object.privacyModeTs;
                else if (typeof object.privacyModeTs === "object")
                    message.privacyModeTs = new $util.LongBits(object.privacyModeTs.low >>> 0, object.privacyModeTs.high >>> 0).toNumber(true);
            if (object.featureControls != null)
                if ($util.Long)
                    (message.featureControls = $util.Long.fromValue(object.featureControls)).unsigned = true;
                else if (typeof object.featureControls === "string")
                    message.featureControls = parseInt(object.featureControls, 10);
                else if (typeof object.featureControls === "number")
                    message.featureControls = object.featureControls;
                else if (typeof object.featureControls === "object")
                    message.featureControls = new $util.LongBits(object.featureControls.low >>> 0, object.featureControls.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a BizIdentityInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.BizIdentityInfo
         * @static
         * @param {proto.BizIdentityInfo} message BizIdentityInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        BizIdentityInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.vlevel = options.enums === String ? "UNKNOWN" : 0;
                object.vnameCert = null;
                object.signed = false;
                object.revoked = false;
                object.hostStorage = options.enums === String ? "ON_PREMISE" : 0;
                object.actualActors = options.enums === String ? "SELF" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.privacyModeTs = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.privacyModeTs = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.featureControls = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.featureControls = options.longs === String ? "0" : 0;
            }
            if (message.vlevel != null && message.hasOwnProperty("vlevel"))
                object.vlevel = options.enums === String ? $root.proto.BizIdentityInfo.VerifiedLevelValue[message.vlevel] : message.vlevel;
            if (message.vnameCert != null && message.hasOwnProperty("vnameCert"))
                object.vnameCert = $root.proto.VerifiedNameCertificate.toObject(message.vnameCert, options);
            if (message.signed != null && message.hasOwnProperty("signed"))
                object.signed = message.signed;
            if (message.revoked != null && message.hasOwnProperty("revoked"))
                object.revoked = message.revoked;
            if (message.hostStorage != null && message.hasOwnProperty("hostStorage"))
                object.hostStorage = options.enums === String ? $root.proto.BizIdentityInfo.HostStorageType[message.hostStorage] : message.hostStorage;
            if (message.actualActors != null && message.hasOwnProperty("actualActors"))
                object.actualActors = options.enums === String ? $root.proto.BizIdentityInfo.ActualActorsType[message.actualActors] : message.actualActors;
            if (message.privacyModeTs != null && message.hasOwnProperty("privacyModeTs"))
                if (typeof message.privacyModeTs === "number")
                    object.privacyModeTs = options.longs === String ? String(message.privacyModeTs) : message.privacyModeTs;
                else
                    object.privacyModeTs = options.longs === String ? $util.Long.prototype.toString.call(message.privacyModeTs) : options.longs === Number ? new $util.LongBits(message.privacyModeTs.low >>> 0, message.privacyModeTs.high >>> 0).toNumber(true) : message.privacyModeTs;
            if (message.featureControls != null && message.hasOwnProperty("featureControls"))
                if (typeof message.featureControls === "number")
                    object.featureControls = options.longs === String ? String(message.featureControls) : message.featureControls;
                else
                    object.featureControls = options.longs === String ? $util.Long.prototype.toString.call(message.featureControls) : options.longs === Number ? new $util.LongBits(message.featureControls.low >>> 0, message.featureControls.high >>> 0).toNumber(true) : message.featureControls;
            return object;
        };

        /**
         * Converts this BizIdentityInfo to JSON.
         * @function toJSON
         * @memberof proto.BizIdentityInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        BizIdentityInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ActualActorsType enum.
         * @name proto.BizIdentityInfo.ActualActorsType
         * @enum {number}
         * @property {number} SELF=0 SELF value
         * @property {number} BSP=1 BSP value
         */
        BizIdentityInfo.ActualActorsType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SELF"] = 0;
            values[valuesById[1] = "BSP"] = 1;
            return values;
        })();

        /**
         * HostStorageType enum.
         * @name proto.BizIdentityInfo.HostStorageType
         * @enum {number}
         * @property {number} ON_PREMISE=0 ON_PREMISE value
         * @property {number} FACEBOOK=1 FACEBOOK value
         */
        BizIdentityInfo.HostStorageType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "ON_PREMISE"] = 0;
            values[valuesById[1] = "FACEBOOK"] = 1;
            return values;
        })();

        /**
         * VerifiedLevelValue enum.
         * @name proto.BizIdentityInfo.VerifiedLevelValue
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} LOW=1 LOW value
         * @property {number} HIGH=2 HIGH value
         */
        BizIdentityInfo.VerifiedLevelValue = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "LOW"] = 1;
            values[valuesById[2] = "HIGH"] = 2;
            return values;
        })();

        return BizIdentityInfo;
    })();

    proto.CertChain = (function() {

        /**
         * Properties of a CertChain.
         * @memberof proto
         * @interface ICertChain
         * @property {proto.CertChain.INoiseCertificate|null} [leaf] CertChain leaf
         * @property {proto.CertChain.INoiseCertificate|null} [intermediate] CertChain intermediate
         */

        /**
         * Constructs a new CertChain.
         * @memberof proto
         * @classdesc Represents a CertChain.
         * @implements ICertChain
         * @constructor
         * @param {proto.ICertChain=} [properties] Properties to set
         */
        function CertChain(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * CertChain leaf.
         * @member {proto.CertChain.INoiseCertificate|null|undefined} leaf
         * @memberof proto.CertChain
         * @instance
         */
        CertChain.prototype.leaf = null;

        /**
         * CertChain intermediate.
         * @member {proto.CertChain.INoiseCertificate|null|undefined} intermediate
         * @memberof proto.CertChain
         * @instance
         */
        CertChain.prototype.intermediate = null;

        /**
         * Creates a new CertChain instance using the specified properties.
         * @function create
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain=} [properties] Properties to set
         * @returns {proto.CertChain} CertChain instance
         */
        CertChain.create = function create(properties) {
            return new CertChain(properties);
        };

        /**
         * Encodes the specified CertChain message. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @function encode
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain} message CertChain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChain.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.leaf != null && Object.hasOwnProperty.call(message, "leaf"))
                $root.proto.CertChain.NoiseCertificate.encode(message.leaf, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.intermediate != null && Object.hasOwnProperty.call(message, "intermediate"))
                $root.proto.CertChain.NoiseCertificate.encode(message.intermediate, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified CertChain message, length delimited. Does not implicitly {@link proto.CertChain.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.CertChain
         * @static
         * @param {proto.ICertChain} message CertChain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        CertChain.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a CertChain message from the specified reader or buffer.
         * @function decode
         * @memberof proto.CertChain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.CertChain} CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChain.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChain();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.leaf = $root.proto.CertChain.NoiseCertificate.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.intermediate = $root.proto.CertChain.NoiseCertificate.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a CertChain message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.CertChain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.CertChain} CertChain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        CertChain.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a CertChain message.
         * @function verify
         * @memberof proto.CertChain
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        CertChain.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.leaf != null && message.hasOwnProperty("leaf")) {
                var error = $root.proto.CertChain.NoiseCertificate.verify(message.leaf);
                if (error)
                    return "leaf." + error;
            }
            if (message.intermediate != null && message.hasOwnProperty("intermediate")) {
                var error = $root.proto.CertChain.NoiseCertificate.verify(message.intermediate);
                if (error)
                    return "intermediate." + error;
            }
            return null;
        };

        /**
         * Creates a CertChain message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.CertChain
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.CertChain} CertChain
         */
        CertChain.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.CertChain)
                return object;
            var message = new $root.proto.CertChain();
            if (object.leaf != null) {
                if (typeof object.leaf !== "object")
                    throw TypeError(".proto.CertChain.leaf: object expected");
                message.leaf = $root.proto.CertChain.NoiseCertificate.fromObject(object.leaf);
            }
            if (object.intermediate != null) {
                if (typeof object.intermediate !== "object")
                    throw TypeError(".proto.CertChain.intermediate: object expected");
                message.intermediate = $root.proto.CertChain.NoiseCertificate.fromObject(object.intermediate);
            }
            return message;
        };

        /**
         * Creates a plain object from a CertChain message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.CertChain
         * @static
         * @param {proto.CertChain} message CertChain
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        CertChain.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.leaf = null;
                object.intermediate = null;
            }
            if (message.leaf != null && message.hasOwnProperty("leaf"))
                object.leaf = $root.proto.CertChain.NoiseCertificate.toObject(message.leaf, options);
            if (message.intermediate != null && message.hasOwnProperty("intermediate"))
                object.intermediate = $root.proto.CertChain.NoiseCertificate.toObject(message.intermediate, options);
            return object;
        };

        /**
         * Converts this CertChain to JSON.
         * @function toJSON
         * @memberof proto.CertChain
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        CertChain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        CertChain.NoiseCertificate = (function() {

            /**
             * Properties of a NoiseCertificate.
             * @memberof proto.CertChain
             * @interface INoiseCertificate
             * @property {Uint8Array|null} [details] NoiseCertificate details
             * @property {Uint8Array|null} [signature] NoiseCertificate signature
             */

            /**
             * Constructs a new NoiseCertificate.
             * @memberof proto.CertChain
             * @classdesc Represents a NoiseCertificate.
             * @implements INoiseCertificate
             * @constructor
             * @param {proto.CertChain.INoiseCertificate=} [properties] Properties to set
             */
            function NoiseCertificate(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * NoiseCertificate details.
             * @member {Uint8Array} details
             * @memberof proto.CertChain.NoiseCertificate
             * @instance
             */
            NoiseCertificate.prototype.details = $util.newBuffer([]);

            /**
             * NoiseCertificate signature.
             * @member {Uint8Array} signature
             * @memberof proto.CertChain.NoiseCertificate
             * @instance
             */
            NoiseCertificate.prototype.signature = $util.newBuffer([]);

            /**
             * Creates a new NoiseCertificate instance using the specified properties.
             * @function create
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {proto.CertChain.INoiseCertificate=} [properties] Properties to set
             * @returns {proto.CertChain.NoiseCertificate} NoiseCertificate instance
             */
            NoiseCertificate.create = function create(properties) {
                return new NoiseCertificate(properties);
            };

            /**
             * Encodes the specified NoiseCertificate message. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @function encode
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {proto.CertChain.INoiseCertificate} message NoiseCertificate message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            NoiseCertificate.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.details != null && Object.hasOwnProperty.call(message, "details"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.details);
                if (message.signature != null && Object.hasOwnProperty.call(message, "signature"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.signature);
                return writer;
            };

            /**
             * Encodes the specified NoiseCertificate message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {proto.CertChain.INoiseCertificate} message NoiseCertificate message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            NoiseCertificate.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer.
             * @function decode
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.CertChain.NoiseCertificate} NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            NoiseCertificate.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChain.NoiseCertificate();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.details = reader.bytes();
                        break;
                    case 2:
                        message.signature = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a NoiseCertificate message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.CertChain.NoiseCertificate} NoiseCertificate
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            NoiseCertificate.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a NoiseCertificate message.
             * @function verify
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            NoiseCertificate.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.details != null && message.hasOwnProperty("details"))
                    if (!(message.details && typeof message.details.length === "number" || $util.isString(message.details)))
                        return "details: buffer expected";
                if (message.signature != null && message.hasOwnProperty("signature"))
                    if (!(message.signature && typeof message.signature.length === "number" || $util.isString(message.signature)))
                        return "signature: buffer expected";
                return null;
            };

            /**
             * Creates a NoiseCertificate message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.CertChain.NoiseCertificate} NoiseCertificate
             */
            NoiseCertificate.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.CertChain.NoiseCertificate)
                    return object;
                var message = new $root.proto.CertChain.NoiseCertificate();
                if (object.details != null)
                    if (typeof object.details === "string")
                        $util.base64.decode(object.details, message.details = $util.newBuffer($util.base64.length(object.details)), 0);
                    else if (object.details.length)
                        message.details = object.details;
                if (object.signature != null)
                    if (typeof object.signature === "string")
                        $util.base64.decode(object.signature, message.signature = $util.newBuffer($util.base64.length(object.signature)), 0);
                    else if (object.signature.length)
                        message.signature = object.signature;
                return message;
            };

            /**
             * Creates a plain object from a NoiseCertificate message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.CertChain.NoiseCertificate
             * @static
             * @param {proto.CertChain.NoiseCertificate} message NoiseCertificate
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            NoiseCertificate.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if (options.bytes === String)
                        object.details = "";
                    else {
                        object.details = [];
                        if (options.bytes !== Array)
                            object.details = $util.newBuffer(object.details);
                    }
                    if (options.bytes === String)
                        object.signature = "";
                    else {
                        object.signature = [];
                        if (options.bytes !== Array)
                            object.signature = $util.newBuffer(object.signature);
                    }
                }
                if (message.details != null && message.hasOwnProperty("details"))
                    object.details = options.bytes === String ? $util.base64.encode(message.details, 0, message.details.length) : options.bytes === Array ? Array.prototype.slice.call(message.details) : message.details;
                if (message.signature != null && message.hasOwnProperty("signature"))
                    object.signature = options.bytes === String ? $util.base64.encode(message.signature, 0, message.signature.length) : options.bytes === Array ? Array.prototype.slice.call(message.signature) : message.signature;
                return object;
            };

            /**
             * Converts this NoiseCertificate to JSON.
             * @function toJSON
             * @memberof proto.CertChain.NoiseCertificate
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            NoiseCertificate.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            NoiseCertificate.Details = (function() {

                /**
                 * Properties of a Details.
                 * @memberof proto.CertChain.NoiseCertificate
                 * @interface IDetails
                 * @property {number|null} [serial] Details serial
                 * @property {number|null} [issuerSerial] Details issuerSerial
                 * @property {Uint8Array|null} [key] Details key
                 * @property {number|Long|null} [notBefore] Details notBefore
                 * @property {number|Long|null} [notAfter] Details notAfter
                 */

                /**
                 * Constructs a new Details.
                 * @memberof proto.CertChain.NoiseCertificate
                 * @classdesc Represents a Details.
                 * @implements IDetails
                 * @constructor
                 * @param {proto.CertChain.NoiseCertificate.IDetails=} [properties] Properties to set
                 */
                function Details(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Details serial.
                 * @member {number} serial
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 */
                Details.prototype.serial = 0;

                /**
                 * Details issuerSerial.
                 * @member {number} issuerSerial
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 */
                Details.prototype.issuerSerial = 0;

                /**
                 * Details key.
                 * @member {Uint8Array} key
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 */
                Details.prototype.key = $util.newBuffer([]);

                /**
                 * Details notBefore.
                 * @member {number|Long} notBefore
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 */
                Details.prototype.notBefore = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

                /**
                 * Details notAfter.
                 * @member {number|Long} notAfter
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 */
                Details.prototype.notAfter = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

                /**
                 * Creates a new Details instance using the specified properties.
                 * @function create
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {proto.CertChain.NoiseCertificate.IDetails=} [properties] Properties to set
                 * @returns {proto.CertChain.NoiseCertificate.Details} Details instance
                 */
                Details.create = function create(properties) {
                    return new Details(properties);
                };

                /**
                 * Encodes the specified Details message. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @function encode
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {proto.CertChain.NoiseCertificate.IDetails} message Details message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Details.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.serial != null && Object.hasOwnProperty.call(message, "serial"))
                        writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.serial);
                    if (message.issuerSerial != null && Object.hasOwnProperty.call(message, "issuerSerial"))
                        writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.issuerSerial);
                    if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                        writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.key);
                    if (message.notBefore != null && Object.hasOwnProperty.call(message, "notBefore"))
                        writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.notBefore);
                    if (message.notAfter != null && Object.hasOwnProperty.call(message, "notAfter"))
                        writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.notAfter);
                    return writer;
                };

                /**
                 * Encodes the specified Details message, length delimited. Does not implicitly {@link proto.CertChain.NoiseCertificate.Details.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {proto.CertChain.NoiseCertificate.IDetails} message Details message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Details.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a Details message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.CertChain.NoiseCertificate.Details} Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Details.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.CertChain.NoiseCertificate.Details();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.serial = reader.uint32();
                            break;
                        case 2:
                            message.issuerSerial = reader.uint32();
                            break;
                        case 3:
                            message.key = reader.bytes();
                            break;
                        case 4:
                            message.notBefore = reader.uint64();
                            break;
                        case 5:
                            message.notAfter = reader.uint64();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a Details message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.CertChain.NoiseCertificate.Details} Details
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Details.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a Details message.
                 * @function verify
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Details.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.serial != null && message.hasOwnProperty("serial"))
                        if (!$util.isInteger(message.serial))
                            return "serial: integer expected";
                    if (message.issuerSerial != null && message.hasOwnProperty("issuerSerial"))
                        if (!$util.isInteger(message.issuerSerial))
                            return "issuerSerial: integer expected";
                    if (message.key != null && message.hasOwnProperty("key"))
                        if (!(message.key && typeof message.key.length === "number" || $util.isString(message.key)))
                            return "key: buffer expected";
                    if (message.notBefore != null && message.hasOwnProperty("notBefore"))
                        if (!$util.isInteger(message.notBefore) && !(message.notBefore && $util.isInteger(message.notBefore.low) && $util.isInteger(message.notBefore.high)))
                            return "notBefore: integer|Long expected";
                    if (message.notAfter != null && message.hasOwnProperty("notAfter"))
                        if (!$util.isInteger(message.notAfter) && !(message.notAfter && $util.isInteger(message.notAfter.low) && $util.isInteger(message.notAfter.high)))
                            return "notAfter: integer|Long expected";
                    return null;
                };

                /**
                 * Creates a Details message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.CertChain.NoiseCertificate.Details} Details
                 */
                Details.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.CertChain.NoiseCertificate.Details)
                        return object;
                    var message = new $root.proto.CertChain.NoiseCertificate.Details();
                    if (object.serial != null)
                        message.serial = object.serial >>> 0;
                    if (object.issuerSerial != null)
                        message.issuerSerial = object.issuerSerial >>> 0;
                    if (object.key != null)
                        if (typeof object.key === "string")
                            $util.base64.decode(object.key, message.key = $util.newBuffer($util.base64.length(object.key)), 0);
                        else if (object.key.length)
                            message.key = object.key;
                    if (object.notBefore != null)
                        if ($util.Long)
                            (message.notBefore = $util.Long.fromValue(object.notBefore)).unsigned = true;
                        else if (typeof object.notBefore === "string")
                            message.notBefore = parseInt(object.notBefore, 10);
                        else if (typeof object.notBefore === "number")
                            message.notBefore = object.notBefore;
                        else if (typeof object.notBefore === "object")
                            message.notBefore = new $util.LongBits(object.notBefore.low >>> 0, object.notBefore.high >>> 0).toNumber(true);
                    if (object.notAfter != null)
                        if ($util.Long)
                            (message.notAfter = $util.Long.fromValue(object.notAfter)).unsigned = true;
                        else if (typeof object.notAfter === "string")
                            message.notAfter = parseInt(object.notAfter, 10);
                        else if (typeof object.notAfter === "number")
                            message.notAfter = object.notAfter;
                        else if (typeof object.notAfter === "object")
                            message.notAfter = new $util.LongBits(object.notAfter.low >>> 0, object.notAfter.high >>> 0).toNumber(true);
                    return message;
                };

                /**
                 * Creates a plain object from a Details message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @static
                 * @param {proto.CertChain.NoiseCertificate.Details} message Details
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Details.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.serial = 0;
                        object.issuerSerial = 0;
                        if (options.bytes === String)
                            object.key = "";
                        else {
                            object.key = [];
                            if (options.bytes !== Array)
                                object.key = $util.newBuffer(object.key);
                        }
                        if ($util.Long) {
                            var long = new $util.Long(0, 0, true);
                            object.notBefore = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                        } else
                            object.notBefore = options.longs === String ? "0" : 0;
                        if ($util.Long) {
                            var long = new $util.Long(0, 0, true);
                            object.notAfter = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                        } else
                            object.notAfter = options.longs === String ? "0" : 0;
                    }
                    if (message.serial != null && message.hasOwnProperty("serial"))
                        object.serial = message.serial;
                    if (message.issuerSerial != null && message.hasOwnProperty("issuerSerial"))
                        object.issuerSerial = message.issuerSerial;
                    if (message.key != null && message.hasOwnProperty("key"))
                        object.key = options.bytes === String ? $util.base64.encode(message.key, 0, message.key.length) : options.bytes === Array ? Array.prototype.slice.call(message.key) : message.key;
                    if (message.notBefore != null && message.hasOwnProperty("notBefore"))
                        if (typeof message.notBefore === "number")
                            object.notBefore = options.longs === String ? String(message.notBefore) : message.notBefore;
                        else
                            object.notBefore = options.longs === String ? $util.Long.prototype.toString.call(message.notBefore) : options.longs === Number ? new $util.LongBits(message.notBefore.low >>> 0, message.notBefore.high >>> 0).toNumber(true) : message.notBefore;
                    if (message.notAfter != null && message.hasOwnProperty("notAfter"))
                        if (typeof message.notAfter === "number")
                            object.notAfter = options.longs === String ? String(message.notAfter) : message.notAfter;
                        else
                            object.notAfter = options.longs === String ? $util.Long.prototype.toString.call(message.notAfter) : options.longs === Number ? new $util.LongBits(message.notAfter.low >>> 0, message.notAfter.high >>> 0).toNumber(true) : message.notAfter;
                    return object;
                };

                /**
                 * Converts this Details to JSON.
                 * @function toJSON
                 * @memberof proto.CertChain.NoiseCertificate.Details
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Details.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Details;
            })();

            return NoiseCertificate;
        })();

        return CertChain;
    })();

    proto.Chain = (function() {

        /**
         * Properties of a Chain.
         * @memberof proto
         * @interface IChain
         * @property {Uint8Array|null} [senderRatchetKey] Chain senderRatchetKey
         * @property {Uint8Array|null} [senderRatchetKeyPrivate] Chain senderRatchetKeyPrivate
         * @property {proto.IChainKey|null} [chainKey] Chain chainKey
         * @property {Array.<proto.IMessageKey>|null} [messageKeys] Chain messageKeys
         */

        /**
         * Constructs a new Chain.
         * @memberof proto
         * @classdesc Represents a Chain.
         * @implements IChain
         * @constructor
         * @param {proto.IChain=} [properties] Properties to set
         */
        function Chain(properties) {
            this.messageKeys = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Chain senderRatchetKey.
         * @member {Uint8Array} senderRatchetKey
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.senderRatchetKey = $util.newBuffer([]);

        /**
         * Chain senderRatchetKeyPrivate.
         * @member {Uint8Array} senderRatchetKeyPrivate
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.senderRatchetKeyPrivate = $util.newBuffer([]);

        /**
         * Chain chainKey.
         * @member {proto.IChainKey|null|undefined} chainKey
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.chainKey = null;

        /**
         * Chain messageKeys.
         * @member {Array.<proto.IMessageKey>} messageKeys
         * @memberof proto.Chain
         * @instance
         */
        Chain.prototype.messageKeys = $util.emptyArray;

        /**
         * Creates a new Chain instance using the specified properties.
         * @function create
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain=} [properties] Properties to set
         * @returns {proto.Chain} Chain instance
         */
        Chain.create = function create(properties) {
            return new Chain(properties);
        };

        /**
         * Encodes the specified Chain message. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @function encode
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain} message Chain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chain.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderRatchetKey != null && Object.hasOwnProperty.call(message, "senderRatchetKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderRatchetKey);
            if (message.senderRatchetKeyPrivate != null && Object.hasOwnProperty.call(message, "senderRatchetKeyPrivate"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.senderRatchetKeyPrivate);
            if (message.chainKey != null && Object.hasOwnProperty.call(message, "chainKey"))
                $root.proto.ChainKey.encode(message.chainKey, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.messageKeys != null && message.messageKeys.length)
                for (var i = 0; i < message.messageKeys.length; ++i)
                    $root.proto.MessageKey.encode(message.messageKeys[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Chain message, length delimited. Does not implicitly {@link proto.Chain.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Chain
         * @static
         * @param {proto.IChain} message Chain message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Chain.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Chain message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Chain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Chain} Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chain.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Chain();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderRatchetKey = reader.bytes();
                    break;
                case 2:
                    message.senderRatchetKeyPrivate = reader.bytes();
                    break;
                case 3:
                    message.chainKey = $root.proto.ChainKey.decode(reader, reader.uint32());
                    break;
                case 4:
                    if (!(message.messageKeys && message.messageKeys.length))
                        message.messageKeys = [];
                    message.messageKeys.push($root.proto.MessageKey.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Chain message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Chain
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Chain} Chain
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Chain.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Chain message.
         * @function verify
         * @memberof proto.Chain
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Chain.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderRatchetKey != null && message.hasOwnProperty("senderRatchetKey"))
                if (!(message.senderRatchetKey && typeof message.senderRatchetKey.length === "number" || $util.isString(message.senderRatchetKey)))
                    return "senderRatchetKey: buffer expected";
            if (message.senderRatchetKeyPrivate != null && message.hasOwnProperty("senderRatchetKeyPrivate"))
                if (!(message.senderRatchetKeyPrivate && typeof message.senderRatchetKeyPrivate.length === "number" || $util.isString(message.senderRatchetKeyPrivate)))
                    return "senderRatchetKeyPrivate: buffer expected";
            if (message.chainKey != null && message.hasOwnProperty("chainKey")) {
                var error = $root.proto.ChainKey.verify(message.chainKey);
                if (error)
                    return "chainKey." + error;
            }
            if (message.messageKeys != null && message.hasOwnProperty("messageKeys")) {
                if (!Array.isArray(message.messageKeys))
                    return "messageKeys: array expected";
                for (var i = 0; i < message.messageKeys.length; ++i) {
                    var error = $root.proto.MessageKey.verify(message.messageKeys[i]);
                    if (error)
                        return "messageKeys." + error;
                }
            }
            return null;
        };

        /**
         * Creates a Chain message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Chain
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Chain} Chain
         */
        Chain.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Chain)
                return object;
            var message = new $root.proto.Chain();
            if (object.senderRatchetKey != null)
                if (typeof object.senderRatchetKey === "string")
                    $util.base64.decode(object.senderRatchetKey, message.senderRatchetKey = $util.newBuffer($util.base64.length(object.senderRatchetKey)), 0);
                else if (object.senderRatchetKey.length)
                    message.senderRatchetKey = object.senderRatchetKey;
            if (object.senderRatchetKeyPrivate != null)
                if (typeof object.senderRatchetKeyPrivate === "string")
                    $util.base64.decode(object.senderRatchetKeyPrivate, message.senderRatchetKeyPrivate = $util.newBuffer($util.base64.length(object.senderRatchetKeyPrivate)), 0);
                else if (object.senderRatchetKeyPrivate.length)
                    message.senderRatchetKeyPrivate = object.senderRatchetKeyPrivate;
            if (object.chainKey != null) {
                if (typeof object.chainKey !== "object")
                    throw TypeError(".proto.Chain.chainKey: object expected");
                message.chainKey = $root.proto.ChainKey.fromObject(object.chainKey);
            }
            if (object.messageKeys) {
                if (!Array.isArray(object.messageKeys))
                    throw TypeError(".proto.Chain.messageKeys: array expected");
                message.messageKeys = [];
                for (var i = 0; i < object.messageKeys.length; ++i) {
                    if (typeof object.messageKeys[i] !== "object")
                        throw TypeError(".proto.Chain.messageKeys: object expected");
                    message.messageKeys[i] = $root.proto.MessageKey.fromObject(object.messageKeys[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a Chain message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Chain
         * @static
         * @param {proto.Chain} message Chain
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Chain.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.messageKeys = [];
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderRatchetKey = "";
                else {
                    object.senderRatchetKey = [];
                    if (options.bytes !== Array)
                        object.senderRatchetKey = $util.newBuffer(object.senderRatchetKey);
                }
                if (options.bytes === String)
                    object.senderRatchetKeyPrivate = "";
                else {
                    object.senderRatchetKeyPrivate = [];
                    if (options.bytes !== Array)
                        object.senderRatchetKeyPrivate = $util.newBuffer(object.senderRatchetKeyPrivate);
                }
                object.chainKey = null;
            }
            if (message.senderRatchetKey != null && message.hasOwnProperty("senderRatchetKey"))
                object.senderRatchetKey = options.bytes === String ? $util.base64.encode(message.senderRatchetKey, 0, message.senderRatchetKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderRatchetKey) : message.senderRatchetKey;
            if (message.senderRatchetKeyPrivate != null && message.hasOwnProperty("senderRatchetKeyPrivate"))
                object.senderRatchetKeyPrivate = options.bytes === String ? $util.base64.encode(message.senderRatchetKeyPrivate, 0, message.senderRatchetKeyPrivate.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderRatchetKeyPrivate) : message.senderRatchetKeyPrivate;
            if (message.chainKey != null && message.hasOwnProperty("chainKey"))
                object.chainKey = $root.proto.ChainKey.toObject(message.chainKey, options);
            if (message.messageKeys && message.messageKeys.length) {
                object.messageKeys = [];
                for (var j = 0; j < message.messageKeys.length; ++j)
                    object.messageKeys[j] = $root.proto.MessageKey.toObject(message.messageKeys[j], options);
            }
            return object;
        };

        /**
         * Converts this Chain to JSON.
         * @function toJSON
         * @memberof proto.Chain
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Chain.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Chain;
    })();

    proto.ChainKey = (function() {

        /**
         * Properties of a ChainKey.
         * @memberof proto
         * @interface IChainKey
         * @property {number|null} [index] ChainKey index
         * @property {Uint8Array|null} [key] ChainKey key
         */

        /**
         * Constructs a new ChainKey.
         * @memberof proto
         * @classdesc Represents a ChainKey.
         * @implements IChainKey
         * @constructor
         * @param {proto.IChainKey=} [properties] Properties to set
         */
        function ChainKey(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ChainKey index.
         * @member {number} index
         * @memberof proto.ChainKey
         * @instance
         */
        ChainKey.prototype.index = 0;

        /**
         * ChainKey key.
         * @member {Uint8Array} key
         * @memberof proto.ChainKey
         * @instance
         */
        ChainKey.prototype.key = $util.newBuffer([]);

        /**
         * Creates a new ChainKey instance using the specified properties.
         * @function create
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey=} [properties] Properties to set
         * @returns {proto.ChainKey} ChainKey instance
         */
        ChainKey.create = function create(properties) {
            return new ChainKey(properties);
        };

        /**
         * Encodes the specified ChainKey message. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @function encode
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey} message ChainKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ChainKey.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.index);
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.key);
            return writer;
        };

        /**
         * Encodes the specified ChainKey message, length delimited. Does not implicitly {@link proto.ChainKey.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ChainKey
         * @static
         * @param {proto.IChainKey} message ChainKey message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ChainKey.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ChainKey message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ChainKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ChainKey} ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ChainKey.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ChainKey();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.index = reader.uint32();
                    break;
                case 2:
                    message.key = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ChainKey message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ChainKey
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ChainKey} ChainKey
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ChainKey.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ChainKey message.
         * @function verify
         * @memberof proto.ChainKey
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ChainKey.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.key != null && message.hasOwnProperty("key"))
                if (!(message.key && typeof message.key.length === "number" || $util.isString(message.key)))
                    return "key: buffer expected";
            return null;
        };

        /**
         * Creates a ChainKey message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ChainKey
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ChainKey} ChainKey
         */
        ChainKey.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ChainKey)
                return object;
            var message = new $root.proto.ChainKey();
            if (object.index != null)
                message.index = object.index >>> 0;
            if (object.key != null)
                if (typeof object.key === "string")
                    $util.base64.decode(object.key, message.key = $util.newBuffer($util.base64.length(object.key)), 0);
                else if (object.key.length)
                    message.key = object.key;
            return message;
        };

        /**
         * Creates a plain object from a ChainKey message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ChainKey
         * @static
         * @param {proto.ChainKey} message ChainKey
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ChainKey.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.index = 0;
                if (options.bytes === String)
                    object.key = "";
                else {
                    object.key = [];
                    if (options.bytes !== Array)
                        object.key = $util.newBuffer(object.key);
                }
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = options.bytes === String ? $util.base64.encode(message.key, 0, message.key.length) : options.bytes === Array ? Array.prototype.slice.call(message.key) : message.key;
            return object;
        };

        /**
         * Converts this ChainKey to JSON.
         * @function toJSON
         * @memberof proto.ChainKey
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ChainKey.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ChainKey;
    })();

    proto.ClientPayload = (function() {

        /**
         * Properties of a ClientPayload.
         * @memberof proto
         * @interface IClientPayload
         * @property {number|Long|null} [username] ClientPayload username
         * @property {boolean|null} [passive] ClientPayload passive
         * @property {proto.ClientPayload.IUserAgent|null} [userAgent] ClientPayload userAgent
         * @property {proto.ClientPayload.IWebInfo|null} [webInfo] ClientPayload webInfo
         * @property {string|null} [pushName] ClientPayload pushName
         * @property {number|null} [sessionId] ClientPayload sessionId
         * @property {boolean|null} [shortConnect] ClientPayload shortConnect
         * @property {proto.ClientPayload.ConnectType|null} [connectType] ClientPayload connectType
         * @property {proto.ClientPayload.ConnectReason|null} [connectReason] ClientPayload connectReason
         * @property {Array.<number>|null} [shards] ClientPayload shards
         * @property {proto.ClientPayload.IDNSSource|null} [dnsSource] ClientPayload dnsSource
         * @property {number|null} [connectAttemptCount] ClientPayload connectAttemptCount
         * @property {number|null} [device] ClientPayload device
         * @property {proto.ClientPayload.IDevicePairingRegistrationData|null} [devicePairingData] ClientPayload devicePairingData
         * @property {proto.ClientPayload.Product|null} [product] ClientPayload product
         * @property {Uint8Array|null} [fbCat] ClientPayload fbCat
         * @property {Uint8Array|null} [fbUserAgent] ClientPayload fbUserAgent
         * @property {boolean|null} [oc] ClientPayload oc
         * @property {number|null} [lc] ClientPayload lc
         * @property {proto.ClientPayload.IOSAppExtension|null} [iosAppExtension] ClientPayload iosAppExtension
         * @property {number|Long|null} [fbAppId] ClientPayload fbAppId
         * @property {Uint8Array|null} [fbDeviceId] ClientPayload fbDeviceId
         * @property {boolean|null} [pull] ClientPayload pull
         * @property {Uint8Array|null} [paddingBytes] ClientPayload paddingBytes
         * @property {proto.ClientPayload.BizMarketSegment|null} [bizMarketSegment] ClientPayload bizMarketSegment
         * @property {number|null} [yearClass] ClientPayload yearClass
         * @property {number|null} [memClass] ClientPayload memClass
         */

        /**
         * Constructs a new ClientPayload.
         * @memberof proto
         * @classdesc Represents a ClientPayload.
         * @implements IClientPayload
         * @constructor
         * @param {proto.IClientPayload=} [properties] Properties to set
         */
        function ClientPayload(properties) {
            this.shards = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ClientPayload username.
         * @member {number|Long} username
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.username = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload passive.
         * @member {boolean} passive
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.passive = false;

        /**
         * ClientPayload userAgent.
         * @member {proto.ClientPayload.IUserAgent|null|undefined} userAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.userAgent = null;

        /**
         * ClientPayload webInfo.
         * @member {proto.ClientPayload.IWebInfo|null|undefined} webInfo
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.webInfo = null;

        /**
         * ClientPayload pushName.
         * @member {string} pushName
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.pushName = "";

        /**
         * ClientPayload sessionId.
         * @member {number} sessionId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.sessionId = 0;

        /**
         * ClientPayload shortConnect.
         * @member {boolean} shortConnect
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shortConnect = false;

        /**
         * ClientPayload connectType.
         * @member {proto.ClientPayload.ConnectType} connectType
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectType = 0;

        /**
         * ClientPayload connectReason.
         * @member {proto.ClientPayload.ConnectReason} connectReason
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectReason = 0;

        /**
         * ClientPayload shards.
         * @member {Array.<number>} shards
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.shards = $util.emptyArray;

        /**
         * ClientPayload dnsSource.
         * @member {proto.ClientPayload.IDNSSource|null|undefined} dnsSource
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.dnsSource = null;

        /**
         * ClientPayload connectAttemptCount.
         * @member {number} connectAttemptCount
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.connectAttemptCount = 0;

        /**
         * ClientPayload device.
         * @member {number} device
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.device = 0;

        /**
         * ClientPayload devicePairingData.
         * @member {proto.ClientPayload.IDevicePairingRegistrationData|null|undefined} devicePairingData
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.devicePairingData = null;

        /**
         * ClientPayload product.
         * @member {proto.ClientPayload.Product} product
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.product = 0;

        /**
         * ClientPayload fbCat.
         * @member {Uint8Array} fbCat
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbCat = $util.newBuffer([]);

        /**
         * ClientPayload fbUserAgent.
         * @member {Uint8Array} fbUserAgent
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbUserAgent = $util.newBuffer([]);

        /**
         * ClientPayload oc.
         * @member {boolean} oc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.oc = false;

        /**
         * ClientPayload lc.
         * @member {number} lc
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.lc = 0;

        /**
         * ClientPayload iosAppExtension.
         * @member {proto.ClientPayload.IOSAppExtension} iosAppExtension
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.iosAppExtension = 0;

        /**
         * ClientPayload fbAppId.
         * @member {number|Long} fbAppId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbAppId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ClientPayload fbDeviceId.
         * @member {Uint8Array} fbDeviceId
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.fbDeviceId = $util.newBuffer([]);

        /**
         * ClientPayload pull.
         * @member {boolean} pull
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.pull = false;

        /**
         * ClientPayload paddingBytes.
         * @member {Uint8Array} paddingBytes
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.paddingBytes = $util.newBuffer([]);

        /**
         * ClientPayload bizMarketSegment.
         * @member {proto.ClientPayload.BizMarketSegment} bizMarketSegment
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.bizMarketSegment = 0;

        /**
         * ClientPayload yearClass.
         * @member {number} yearClass
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.yearClass = 0;

        /**
         * ClientPayload memClass.
         * @member {number} memClass
         * @memberof proto.ClientPayload
         * @instance
         */
        ClientPayload.prototype.memClass = 0;

        /**
         * Creates a new ClientPayload instance using the specified properties.
         * @function create
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload=} [properties] Properties to set
         * @returns {proto.ClientPayload} ClientPayload instance
         */
        ClientPayload.create = function create(properties) {
            return new ClientPayload(properties);
        };

        /**
         * Encodes the specified ClientPayload message. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encode
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.username != null && Object.hasOwnProperty.call(message, "username"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.username);
            if (message.passive != null && Object.hasOwnProperty.call(message, "passive"))
                writer.uint32(/* id 3, wireType 0 =*/24).bool(message.passive);
            if (message.userAgent != null && Object.hasOwnProperty.call(message, "userAgent"))
                $root.proto.ClientPayload.UserAgent.encode(message.userAgent, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.webInfo != null && Object.hasOwnProperty.call(message, "webInfo"))
                $root.proto.ClientPayload.WebInfo.encode(message.webInfo, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.pushName != null && Object.hasOwnProperty.call(message, "pushName"))
                writer.uint32(/* id 7, wireType 2 =*/58).string(message.pushName);
            if (message.sessionId != null && Object.hasOwnProperty.call(message, "sessionId"))
                writer.uint32(/* id 9, wireType 5 =*/77).sfixed32(message.sessionId);
            if (message.shortConnect != null && Object.hasOwnProperty.call(message, "shortConnect"))
                writer.uint32(/* id 10, wireType 0 =*/80).bool(message.shortConnect);
            if (message.connectType != null && Object.hasOwnProperty.call(message, "connectType"))
                writer.uint32(/* id 12, wireType 0 =*/96).int32(message.connectType);
            if (message.connectReason != null && Object.hasOwnProperty.call(message, "connectReason"))
                writer.uint32(/* id 13, wireType 0 =*/104).int32(message.connectReason);
            if (message.shards != null && message.shards.length)
                for (var i = 0; i < message.shards.length; ++i)
                    writer.uint32(/* id 14, wireType 0 =*/112).int32(message.shards[i]);
            if (message.dnsSource != null && Object.hasOwnProperty.call(message, "dnsSource"))
                $root.proto.ClientPayload.DNSSource.encode(message.dnsSource, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.connectAttemptCount != null && Object.hasOwnProperty.call(message, "connectAttemptCount"))
                writer.uint32(/* id 16, wireType 0 =*/128).uint32(message.connectAttemptCount);
            if (message.device != null && Object.hasOwnProperty.call(message, "device"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.device);
            if (message.devicePairingData != null && Object.hasOwnProperty.call(message, "devicePairingData"))
                $root.proto.ClientPayload.DevicePairingRegistrationData.encode(message.devicePairingData, writer.uint32(/* id 19, wireType 2 =*/154).fork()).ldelim();
            if (message.product != null && Object.hasOwnProperty.call(message, "product"))
                writer.uint32(/* id 20, wireType 0 =*/160).int32(message.product);
            if (message.fbCat != null && Object.hasOwnProperty.call(message, "fbCat"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.fbCat);
            if (message.fbUserAgent != null && Object.hasOwnProperty.call(message, "fbUserAgent"))
                writer.uint32(/* id 22, wireType 2 =*/178).bytes(message.fbUserAgent);
            if (message.oc != null && Object.hasOwnProperty.call(message, "oc"))
                writer.uint32(/* id 23, wireType 0 =*/184).bool(message.oc);
            if (message.lc != null && Object.hasOwnProperty.call(message, "lc"))
                writer.uint32(/* id 24, wireType 0 =*/192).int32(message.lc);
            if (message.iosAppExtension != null && Object.hasOwnProperty.call(message, "iosAppExtension"))
                writer.uint32(/* id 30, wireType 0 =*/240).int32(message.iosAppExtension);
            if (message.fbAppId != null && Object.hasOwnProperty.call(message, "fbAppId"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.fbAppId);
            if (message.fbDeviceId != null && Object.hasOwnProperty.call(message, "fbDeviceId"))
                writer.uint32(/* id 32, wireType 2 =*/258).bytes(message.fbDeviceId);
            if (message.pull != null && Object.hasOwnProperty.call(message, "pull"))
                writer.uint32(/* id 33, wireType 0 =*/264).bool(message.pull);
            if (message.paddingBytes != null && Object.hasOwnProperty.call(message, "paddingBytes"))
                writer.uint32(/* id 34, wireType 2 =*/274).bytes(message.paddingBytes);
            if (message.bizMarketSegment != null && Object.hasOwnProperty.call(message, "bizMarketSegment"))
                writer.uint32(/* id 35, wireType 0 =*/280).int32(message.bizMarketSegment);
            if (message.yearClass != null && Object.hasOwnProperty.call(message, "yearClass"))
                writer.uint32(/* id 36, wireType 0 =*/288).int32(message.yearClass);
            if (message.memClass != null && Object.hasOwnProperty.call(message, "memClass"))
                writer.uint32(/* id 37, wireType 0 =*/296).int32(message.memClass);
            return writer;
        };

        /**
         * Encodes the specified ClientPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.IClientPayload} message ClientPayload message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ClientPayload.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.username = reader.uint64();
                    break;
                case 3:
                    message.passive = reader.bool();
                    break;
                case 5:
                    message.userAgent = $root.proto.ClientPayload.UserAgent.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.webInfo = $root.proto.ClientPayload.WebInfo.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.pushName = reader.string();
                    break;
                case 9:
                    message.sessionId = reader.sfixed32();
                    break;
                case 10:
                    message.shortConnect = reader.bool();
                    break;
                case 12:
                    message.connectType = reader.int32();
                    break;
                case 13:
                    message.connectReason = reader.int32();
                    break;
                case 14:
                    if (!(message.shards && message.shards.length))
                        message.shards = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.shards.push(reader.int32());
                    } else
                        message.shards.push(reader.int32());
                    break;
                case 15:
                    message.dnsSource = $root.proto.ClientPayload.DNSSource.decode(reader, reader.uint32());
                    break;
                case 16:
                    message.connectAttemptCount = reader.uint32();
                    break;
                case 18:
                    message.device = reader.uint32();
                    break;
                case 19:
                    message.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.decode(reader, reader.uint32());
                    break;
                case 20:
                    message.product = reader.int32();
                    break;
                case 21:
                    message.fbCat = reader.bytes();
                    break;
                case 22:
                    message.fbUserAgent = reader.bytes();
                    break;
                case 23:
                    message.oc = reader.bool();
                    break;
                case 24:
                    message.lc = reader.int32();
                    break;
                case 30:
                    message.iosAppExtension = reader.int32();
                    break;
                case 31:
                    message.fbAppId = reader.uint64();
                    break;
                case 32:
                    message.fbDeviceId = reader.bytes();
                    break;
                case 33:
                    message.pull = reader.bool();
                    break;
                case 34:
                    message.paddingBytes = reader.bytes();
                    break;
                case 35:
                    message.bizMarketSegment = reader.int32();
                    break;
                case 36:
                    message.yearClass = reader.int32();
                    break;
                case 37:
                    message.memClass = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ClientPayload message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ClientPayload
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ClientPayload} ClientPayload
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ClientPayload.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ClientPayload message.
         * @function verify
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ClientPayload.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.username != null && message.hasOwnProperty("username"))
                if (!$util.isInteger(message.username) && !(message.username && $util.isInteger(message.username.low) && $util.isInteger(message.username.high)))
                    return "username: integer|Long expected";
            if (message.passive != null && message.hasOwnProperty("passive"))
                if (typeof message.passive !== "boolean")
                    return "passive: boolean expected";
            if (message.userAgent != null && message.hasOwnProperty("userAgent")) {
                var error = $root.proto.ClientPayload.UserAgent.verify(message.userAgent);
                if (error)
                    return "userAgent." + error;
            }
            if (message.webInfo != null && message.hasOwnProperty("webInfo")) {
                var error = $root.proto.ClientPayload.WebInfo.verify(message.webInfo);
                if (error)
                    return "webInfo." + error;
            }
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                if (!$util.isString(message.pushName))
                    return "pushName: string expected";
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                if (!$util.isInteger(message.sessionId))
                    return "sessionId: integer expected";
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                if (typeof message.shortConnect !== "boolean")
                    return "shortConnect: boolean expected";
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                switch (message.connectType) {
                default:
                    return "connectType: enum value expected";
                case 0:
                case 1:
                case 100:
                case 101:
                case 102:
                case 103:
                case 104:
                case 105:
                case 106:
                case 107:
                case 108:
                case 109:
                case 110:
                case 111:
                case 112:
                    break;
                }
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                switch (message.connectReason) {
                default:
                    return "connectReason: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                    break;
                }
            if (message.shards != null && message.hasOwnProperty("shards")) {
                if (!Array.isArray(message.shards))
                    return "shards: array expected";
                for (var i = 0; i < message.shards.length; ++i)
                    if (!$util.isInteger(message.shards[i]))
                        return "shards: integer[] expected";
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource")) {
                var error = $root.proto.ClientPayload.DNSSource.verify(message.dnsSource);
                if (error)
                    return "dnsSource." + error;
            }
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                if (!$util.isInteger(message.connectAttemptCount))
                    return "connectAttemptCount: integer expected";
            if (message.device != null && message.hasOwnProperty("device"))
                if (!$util.isInteger(message.device))
                    return "device: integer expected";
            if (message.devicePairingData != null && message.hasOwnProperty("devicePairingData")) {
                var error = $root.proto.ClientPayload.DevicePairingRegistrationData.verify(message.devicePairingData);
                if (error)
                    return "devicePairingData." + error;
            }
            if (message.product != null && message.hasOwnProperty("product"))
                switch (message.product) {
                default:
                    return "product: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                if (!(message.fbCat && typeof message.fbCat.length === "number" || $util.isString(message.fbCat)))
                    return "fbCat: buffer expected";
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                if (!(message.fbUserAgent && typeof message.fbUserAgent.length === "number" || $util.isString(message.fbUserAgent)))
                    return "fbUserAgent: buffer expected";
            if (message.oc != null && message.hasOwnProperty("oc"))
                if (typeof message.oc !== "boolean")
                    return "oc: boolean expected";
            if (message.lc != null && message.hasOwnProperty("lc"))
                if (!$util.isInteger(message.lc))
                    return "lc: integer expected";
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                switch (message.iosAppExtension) {
                default:
                    return "iosAppExtension: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (!$util.isInteger(message.fbAppId) && !(message.fbAppId && $util.isInteger(message.fbAppId.low) && $util.isInteger(message.fbAppId.high)))
                    return "fbAppId: integer|Long expected";
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                if (!(message.fbDeviceId && typeof message.fbDeviceId.length === "number" || $util.isString(message.fbDeviceId)))
                    return "fbDeviceId: buffer expected";
            if (message.pull != null && message.hasOwnProperty("pull"))
                if (typeof message.pull !== "boolean")
                    return "pull: boolean expected";
            if (message.paddingBytes != null && message.hasOwnProperty("paddingBytes"))
                if (!(message.paddingBytes && typeof message.paddingBytes.length === "number" || $util.isString(message.paddingBytes)))
                    return "paddingBytes: buffer expected";
            if (message.bizMarketSegment != null && message.hasOwnProperty("bizMarketSegment"))
                switch (message.bizMarketSegment) {
                default:
                    return "bizMarketSegment: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.yearClass != null && message.hasOwnProperty("yearClass"))
                if (!$util.isInteger(message.yearClass))
                    return "yearClass: integer expected";
            if (message.memClass != null && message.hasOwnProperty("memClass"))
                if (!$util.isInteger(message.memClass))
                    return "memClass: integer expected";
            return null;
        };

        /**
         * Creates a ClientPayload message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ClientPayload
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ClientPayload} ClientPayload
         */
        ClientPayload.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ClientPayload)
                return object;
            var message = new $root.proto.ClientPayload();
            if (object.username != null)
                if ($util.Long)
                    (message.username = $util.Long.fromValue(object.username)).unsigned = true;
                else if (typeof object.username === "string")
                    message.username = parseInt(object.username, 10);
                else if (typeof object.username === "number")
                    message.username = object.username;
                else if (typeof object.username === "object")
                    message.username = new $util.LongBits(object.username.low >>> 0, object.username.high >>> 0).toNumber(true);
            if (object.passive != null)
                message.passive = Boolean(object.passive);
            if (object.userAgent != null) {
                if (typeof object.userAgent !== "object")
                    throw TypeError(".proto.ClientPayload.userAgent: object expected");
                message.userAgent = $root.proto.ClientPayload.UserAgent.fromObject(object.userAgent);
            }
            if (object.webInfo != null) {
                if (typeof object.webInfo !== "object")
                    throw TypeError(".proto.ClientPayload.webInfo: object expected");
                message.webInfo = $root.proto.ClientPayload.WebInfo.fromObject(object.webInfo);
            }
            if (object.pushName != null)
                message.pushName = String(object.pushName);
            if (object.sessionId != null)
                message.sessionId = object.sessionId | 0;
            if (object.shortConnect != null)
                message.shortConnect = Boolean(object.shortConnect);
            switch (object.connectType) {
            case "CELLULAR_UNKNOWN":
            case 0:
                message.connectType = 0;
                break;
            case "WIFI_UNKNOWN":
            case 1:
                message.connectType = 1;
                break;
            case "CELLULAR_EDGE":
            case 100:
                message.connectType = 100;
                break;
            case "CELLULAR_IDEN":
            case 101:
                message.connectType = 101;
                break;
            case "CELLULAR_UMTS":
            case 102:
                message.connectType = 102;
                break;
            case "CELLULAR_EVDO":
            case 103:
                message.connectType = 103;
                break;
            case "CELLULAR_GPRS":
            case 104:
                message.connectType = 104;
                break;
            case "CELLULAR_HSDPA":
            case 105:
                message.connectType = 105;
                break;
            case "CELLULAR_HSUPA":
            case 106:
                message.connectType = 106;
                break;
            case "CELLULAR_HSPA":
            case 107:
                message.connectType = 107;
                break;
            case "CELLULAR_CDMA":
            case 108:
                message.connectType = 108;
                break;
            case "CELLULAR_1XRTT":
            case 109:
                message.connectType = 109;
                break;
            case "CELLULAR_EHRPD":
            case 110:
                message.connectType = 110;
                break;
            case "CELLULAR_LTE":
            case 111:
                message.connectType = 111;
                break;
            case "CELLULAR_HSPAP":
            case 112:
                message.connectType = 112;
                break;
            }
            switch (object.connectReason) {
            case "PUSH":
            case 0:
                message.connectReason = 0;
                break;
            case "USER_ACTIVATED":
            case 1:
                message.connectReason = 1;
                break;
            case "SCHEDULED":
            case 2:
                message.connectReason = 2;
                break;
            case "ERROR_RECONNECT":
            case 3:
                message.connectReason = 3;
                break;
            case "NETWORK_SWITCH":
            case 4:
                message.connectReason = 4;
                break;
            case "PING_RECONNECT":
            case 5:
                message.connectReason = 5;
                break;
            }
            if (object.shards) {
                if (!Array.isArray(object.shards))
                    throw TypeError(".proto.ClientPayload.shards: array expected");
                message.shards = [];
                for (var i = 0; i < object.shards.length; ++i)
                    message.shards[i] = object.shards[i] | 0;
            }
            if (object.dnsSource != null) {
                if (typeof object.dnsSource !== "object")
                    throw TypeError(".proto.ClientPayload.dnsSource: object expected");
                message.dnsSource = $root.proto.ClientPayload.DNSSource.fromObject(object.dnsSource);
            }
            if (object.connectAttemptCount != null)
                message.connectAttemptCount = object.connectAttemptCount >>> 0;
            if (object.device != null)
                message.device = object.device >>> 0;
            if (object.devicePairingData != null) {
                if (typeof object.devicePairingData !== "object")
                    throw TypeError(".proto.ClientPayload.devicePairingData: object expected");
                message.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.fromObject(object.devicePairingData);
            }
            switch (object.product) {
            case "WHATSAPP":
            case 0:
                message.product = 0;
                break;
            case "MESSENGER":
            case 1:
                message.product = 1;
                break;
            }
            if (object.fbCat != null)
                if (typeof object.fbCat === "string")
                    $util.base64.decode(object.fbCat, message.fbCat = $util.newBuffer($util.base64.length(object.fbCat)), 0);
                else if (object.fbCat.length)
                    message.fbCat = object.fbCat;
            if (object.fbUserAgent != null)
                if (typeof object.fbUserAgent === "string")
                    $util.base64.decode(object.fbUserAgent, message.fbUserAgent = $util.newBuffer($util.base64.length(object.fbUserAgent)), 0);
                else if (object.fbUserAgent.length)
                    message.fbUserAgent = object.fbUserAgent;
            if (object.oc != null)
                message.oc = Boolean(object.oc);
            if (object.lc != null)
                message.lc = object.lc | 0;
            switch (object.iosAppExtension) {
            case "SHARE_EXTENSION":
            case 0:
                message.iosAppExtension = 0;
                break;
            case "SERVICE_EXTENSION":
            case 1:
                message.iosAppExtension = 1;
                break;
            case "INTENTS_EXTENSION":
            case 2:
                message.iosAppExtension = 2;
                break;
            }
            if (object.fbAppId != null)
                if ($util.Long)
                    (message.fbAppId = $util.Long.fromValue(object.fbAppId)).unsigned = true;
                else if (typeof object.fbAppId === "string")
                    message.fbAppId = parseInt(object.fbAppId, 10);
                else if (typeof object.fbAppId === "number")
                    message.fbAppId = object.fbAppId;
                else if (typeof object.fbAppId === "object")
                    message.fbAppId = new $util.LongBits(object.fbAppId.low >>> 0, object.fbAppId.high >>> 0).toNumber(true);
            if (object.fbDeviceId != null)
                if (typeof object.fbDeviceId === "string")
                    $util.base64.decode(object.fbDeviceId, message.fbDeviceId = $util.newBuffer($util.base64.length(object.fbDeviceId)), 0);
                else if (object.fbDeviceId.length)
                    message.fbDeviceId = object.fbDeviceId;
            if (object.pull != null)
                message.pull = Boolean(object.pull);
            if (object.paddingBytes != null)
                if (typeof object.paddingBytes === "string")
                    $util.base64.decode(object.paddingBytes, message.paddingBytes = $util.newBuffer($util.base64.length(object.paddingBytes)), 0);
                else if (object.paddingBytes.length)
                    message.paddingBytes = object.paddingBytes;
            switch (object.bizMarketSegment) {
            case "DEFAULT":
            case 0:
                message.bizMarketSegment = 0;
                break;
            case "DEVX":
            case 1:
                message.bizMarketSegment = 1;
                break;
            case "INBOX":
            case 2:
                message.bizMarketSegment = 2;
                break;
            }
            if (object.yearClass != null)
                message.yearClass = object.yearClass | 0;
            if (object.memClass != null)
                message.memClass = object.memClass | 0;
            return message;
        };

        /**
         * Creates a plain object from a ClientPayload message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ClientPayload
         * @static
         * @param {proto.ClientPayload} message ClientPayload
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ClientPayload.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.shards = [];
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.username = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.username = options.longs === String ? "0" : 0;
                object.passive = false;
                object.userAgent = null;
                object.webInfo = null;
                object.pushName = "";
                object.sessionId = 0;
                object.shortConnect = false;
                object.connectType = options.enums === String ? "CELLULAR_UNKNOWN" : 0;
                object.connectReason = options.enums === String ? "PUSH" : 0;
                object.dnsSource = null;
                object.connectAttemptCount = 0;
                object.device = 0;
                object.devicePairingData = null;
                object.product = options.enums === String ? "WHATSAPP" : 0;
                if (options.bytes === String)
                    object.fbCat = "";
                else {
                    object.fbCat = [];
                    if (options.bytes !== Array)
                        object.fbCat = $util.newBuffer(object.fbCat);
                }
                if (options.bytes === String)
                    object.fbUserAgent = "";
                else {
                    object.fbUserAgent = [];
                    if (options.bytes !== Array)
                        object.fbUserAgent = $util.newBuffer(object.fbUserAgent);
                }
                object.oc = false;
                object.lc = 0;
                object.iosAppExtension = options.enums === String ? "SHARE_EXTENSION" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fbAppId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fbAppId = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fbDeviceId = "";
                else {
                    object.fbDeviceId = [];
                    if (options.bytes !== Array)
                        object.fbDeviceId = $util.newBuffer(object.fbDeviceId);
                }
                object.pull = false;
                if (options.bytes === String)
                    object.paddingBytes = "";
                else {
                    object.paddingBytes = [];
                    if (options.bytes !== Array)
                        object.paddingBytes = $util.newBuffer(object.paddingBytes);
                }
                object.bizMarketSegment = options.enums === String ? "DEFAULT" : 0;
                object.yearClass = 0;
                object.memClass = 0;
            }
            if (message.username != null && message.hasOwnProperty("username"))
                if (typeof message.username === "number")
                    object.username = options.longs === String ? String(message.username) : message.username;
                else
                    object.username = options.longs === String ? $util.Long.prototype.toString.call(message.username) : options.longs === Number ? new $util.LongBits(message.username.low >>> 0, message.username.high >>> 0).toNumber(true) : message.username;
            if (message.passive != null && message.hasOwnProperty("passive"))
                object.passive = message.passive;
            if (message.userAgent != null && message.hasOwnProperty("userAgent"))
                object.userAgent = $root.proto.ClientPayload.UserAgent.toObject(message.userAgent, options);
            if (message.webInfo != null && message.hasOwnProperty("webInfo"))
                object.webInfo = $root.proto.ClientPayload.WebInfo.toObject(message.webInfo, options);
            if (message.pushName != null && message.hasOwnProperty("pushName"))
                object.pushName = message.pushName;
            if (message.sessionId != null && message.hasOwnProperty("sessionId"))
                object.sessionId = message.sessionId;
            if (message.shortConnect != null && message.hasOwnProperty("shortConnect"))
                object.shortConnect = message.shortConnect;
            if (message.connectType != null && message.hasOwnProperty("connectType"))
                object.connectType = options.enums === String ? $root.proto.ClientPayload.ConnectType[message.connectType] : message.connectType;
            if (message.connectReason != null && message.hasOwnProperty("connectReason"))
                object.connectReason = options.enums === String ? $root.proto.ClientPayload.ConnectReason[message.connectReason] : message.connectReason;
            if (message.shards && message.shards.length) {
                object.shards = [];
                for (var j = 0; j < message.shards.length; ++j)
                    object.shards[j] = message.shards[j];
            }
            if (message.dnsSource != null && message.hasOwnProperty("dnsSource"))
                object.dnsSource = $root.proto.ClientPayload.DNSSource.toObject(message.dnsSource, options);
            if (message.connectAttemptCount != null && message.hasOwnProperty("connectAttemptCount"))
                object.connectAttemptCount = message.connectAttemptCount;
            if (message.device != null && message.hasOwnProperty("device"))
                object.device = message.device;
            if (message.devicePairingData != null && message.hasOwnProperty("devicePairingData"))
                object.devicePairingData = $root.proto.ClientPayload.DevicePairingRegistrationData.toObject(message.devicePairingData, options);
            if (message.product != null && message.hasOwnProperty("product"))
                object.product = options.enums === String ? $root.proto.ClientPayload.Product[message.product] : message.product;
            if (message.fbCat != null && message.hasOwnProperty("fbCat"))
                object.fbCat = options.bytes === String ? $util.base64.encode(message.fbCat, 0, message.fbCat.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbCat) : message.fbCat;
            if (message.fbUserAgent != null && message.hasOwnProperty("fbUserAgent"))
                object.fbUserAgent = options.bytes === String ? $util.base64.encode(message.fbUserAgent, 0, message.fbUserAgent.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbUserAgent) : message.fbUserAgent;
            if (message.oc != null && message.hasOwnProperty("oc"))
                object.oc = message.oc;
            if (message.lc != null && message.hasOwnProperty("lc"))
                object.lc = message.lc;
            if (message.iosAppExtension != null && message.hasOwnProperty("iosAppExtension"))
                object.iosAppExtension = options.enums === String ? $root.proto.ClientPayload.IOSAppExtension[message.iosAppExtension] : message.iosAppExtension;
            if (message.fbAppId != null && message.hasOwnProperty("fbAppId"))
                if (typeof message.fbAppId === "number")
                    object.fbAppId = options.longs === String ? String(message.fbAppId) : message.fbAppId;
                else
                    object.fbAppId = options.longs === String ? $util.Long.prototype.toString.call(message.fbAppId) : options.longs === Number ? new $util.LongBits(message.fbAppId.low >>> 0, message.fbAppId.high >>> 0).toNumber(true) : message.fbAppId;
            if (message.fbDeviceId != null && message.hasOwnProperty("fbDeviceId"))
                object.fbDeviceId = options.bytes === String ? $util.base64.encode(message.fbDeviceId, 0, message.fbDeviceId.length) : options.bytes === Array ? Array.prototype.slice.call(message.fbDeviceId) : message.fbDeviceId;
            if (message.pull != null && message.hasOwnProperty("pull"))
                object.pull = message.pull;
            if (message.paddingBytes != null && message.hasOwnProperty("paddingBytes"))
                object.paddingBytes = options.bytes === String ? $util.base64.encode(message.paddingBytes, 0, message.paddingBytes.length) : options.bytes === Array ? Array.prototype.slice.call(message.paddingBytes) : message.paddingBytes;
            if (message.bizMarketSegment != null && message.hasOwnProperty("bizMarketSegment"))
                object.bizMarketSegment = options.enums === String ? $root.proto.ClientPayload.BizMarketSegment[message.bizMarketSegment] : message.bizMarketSegment;
            if (message.yearClass != null && message.hasOwnProperty("yearClass"))
                object.yearClass = message.yearClass;
            if (message.memClass != null && message.hasOwnProperty("memClass"))
                object.memClass = message.memClass;
            return object;
        };

        /**
         * Converts this ClientPayload to JSON.
         * @function toJSON
         * @memberof proto.ClientPayload
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ClientPayload.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * BizMarketSegment enum.
         * @name proto.ClientPayload.BizMarketSegment
         * @enum {number}
         * @property {number} DEFAULT=0 DEFAULT value
         * @property {number} DEVX=1 DEVX value
         * @property {number} INBOX=2 INBOX value
         */
        ClientPayload.BizMarketSegment = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "DEFAULT"] = 0;
            values[valuesById[1] = "DEVX"] = 1;
            values[valuesById[2] = "INBOX"] = 2;
            return values;
        })();

        /**
         * ConnectReason enum.
         * @name proto.ClientPayload.ConnectReason
         * @enum {number}
         * @property {number} PUSH=0 PUSH value
         * @property {number} USER_ACTIVATED=1 USER_ACTIVATED value
         * @property {number} SCHEDULED=2 SCHEDULED value
         * @property {number} ERROR_RECONNECT=3 ERROR_RECONNECT value
         * @property {number} NETWORK_SWITCH=4 NETWORK_SWITCH value
         * @property {number} PING_RECONNECT=5 PING_RECONNECT value
         */
        ClientPayload.ConnectReason = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "PUSH"] = 0;
            values[valuesById[1] = "USER_ACTIVATED"] = 1;
            values[valuesById[2] = "SCHEDULED"] = 2;
            values[valuesById[3] = "ERROR_RECONNECT"] = 3;
            values[valuesById[4] = "NETWORK_SWITCH"] = 4;
            values[valuesById[5] = "PING_RECONNECT"] = 5;
            return values;
        })();

        /**
         * ConnectType enum.
         * @name proto.ClientPayload.ConnectType
         * @enum {number}
         * @property {number} CELLULAR_UNKNOWN=0 CELLULAR_UNKNOWN value
         * @property {number} WIFI_UNKNOWN=1 WIFI_UNKNOWN value
         * @property {number} CELLULAR_EDGE=100 CELLULAR_EDGE value
         * @property {number} CELLULAR_IDEN=101 CELLULAR_IDEN value
         * @property {number} CELLULAR_UMTS=102 CELLULAR_UMTS value
         * @property {number} CELLULAR_EVDO=103 CELLULAR_EVDO value
         * @property {number} CELLULAR_GPRS=104 CELLULAR_GPRS value
         * @property {number} CELLULAR_HSDPA=105 CELLULAR_HSDPA value
         * @property {number} CELLULAR_HSUPA=106 CELLULAR_HSUPA value
         * @property {number} CELLULAR_HSPA=107 CELLULAR_HSPA value
         * @property {number} CELLULAR_CDMA=108 CELLULAR_CDMA value
         * @property {number} CELLULAR_1XRTT=109 CELLULAR_1XRTT value
         * @property {number} CELLULAR_EHRPD=110 CELLULAR_EHRPD value
         * @property {number} CELLULAR_LTE=111 CELLULAR_LTE value
         * @property {number} CELLULAR_HSPAP=112 CELLULAR_HSPAP value
         */
        ClientPayload.ConnectType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CELLULAR_UNKNOWN"] = 0;
            values[valuesById[1] = "WIFI_UNKNOWN"] = 1;
            values[valuesById[100] = "CELLULAR_EDGE"] = 100;
            values[valuesById[101] = "CELLULAR_IDEN"] = 101;
            values[valuesById[102] = "CELLULAR_UMTS"] = 102;
            values[valuesById[103] = "CELLULAR_EVDO"] = 103;
            values[valuesById[104] = "CELLULAR_GPRS"] = 104;
            values[valuesById[105] = "CELLULAR_HSDPA"] = 105;
            values[valuesById[106] = "CELLULAR_HSUPA"] = 106;
            values[valuesById[107] = "CELLULAR_HSPA"] = 107;
            values[valuesById[108] = "CELLULAR_CDMA"] = 108;
            values[valuesById[109] = "CELLULAR_1XRTT"] = 109;
            values[valuesById[110] = "CELLULAR_EHRPD"] = 110;
            values[valuesById[111] = "CELLULAR_LTE"] = 111;
            values[valuesById[112] = "CELLULAR_HSPAP"] = 112;
            return values;
        })();

        ClientPayload.DNSSource = (function() {

            /**
             * Properties of a DNSSource.
             * @memberof proto.ClientPayload
             * @interface IDNSSource
             * @property {proto.ClientPayload.DNSSource.DNSResolutionMethod|null} [dnsMethod] DNSSource dnsMethod
             * @property {boolean|null} [appCached] DNSSource appCached
             */

            /**
             * Constructs a new DNSSource.
             * @memberof proto.ClientPayload
             * @classdesc Represents a DNSSource.
             * @implements IDNSSource
             * @constructor
             * @param {proto.ClientPayload.IDNSSource=} [properties] Properties to set
             */
            function DNSSource(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * DNSSource dnsMethod.
             * @member {proto.ClientPayload.DNSSource.DNSResolutionMethod} dnsMethod
             * @memberof proto.ClientPayload.DNSSource
             * @instance
             */
            DNSSource.prototype.dnsMethod = 0;

            /**
             * DNSSource appCached.
             * @member {boolean} appCached
             * @memberof proto.ClientPayload.DNSSource
             * @instance
             */
            DNSSource.prototype.appCached = false;

            /**
             * Creates a new DNSSource instance using the specified properties.
             * @function create
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {proto.ClientPayload.IDNSSource=} [properties] Properties to set
             * @returns {proto.ClientPayload.DNSSource} DNSSource instance
             */
            DNSSource.create = function create(properties) {
                return new DNSSource(properties);
            };

            /**
             * Encodes the specified DNSSource message. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @function encode
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {proto.ClientPayload.IDNSSource} message DNSSource message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DNSSource.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.dnsMethod != null && Object.hasOwnProperty.call(message, "dnsMethod"))
                    writer.uint32(/* id 15, wireType 0 =*/120).int32(message.dnsMethod);
                if (message.appCached != null && Object.hasOwnProperty.call(message, "appCached"))
                    writer.uint32(/* id 16, wireType 0 =*/128).bool(message.appCached);
                return writer;
            };

            /**
             * Encodes the specified DNSSource message, length delimited. Does not implicitly {@link proto.ClientPayload.DNSSource.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {proto.ClientPayload.IDNSSource} message DNSSource message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DNSSource.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a DNSSource message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ClientPayload.DNSSource} DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DNSSource.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.DNSSource();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 15:
                        message.dnsMethod = reader.int32();
                        break;
                    case 16:
                        message.appCached = reader.bool();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a DNSSource message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ClientPayload.DNSSource} DNSSource
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DNSSource.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a DNSSource message.
             * @function verify
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            DNSSource.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                    switch (message.dnsMethod) {
                    default:
                        return "dnsMethod: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                        break;
                    }
                if (message.appCached != null && message.hasOwnProperty("appCached"))
                    if (typeof message.appCached !== "boolean")
                        return "appCached: boolean expected";
                return null;
            };

            /**
             * Creates a DNSSource message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ClientPayload.DNSSource} DNSSource
             */
            DNSSource.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ClientPayload.DNSSource)
                    return object;
                var message = new $root.proto.ClientPayload.DNSSource();
                switch (object.dnsMethod) {
                case "SYSTEM":
                case 0:
                    message.dnsMethod = 0;
                    break;
                case "GOOGLE":
                case 1:
                    message.dnsMethod = 1;
                    break;
                case "HARDCODED":
                case 2:
                    message.dnsMethod = 2;
                    break;
                case "OVERRIDE":
                case 3:
                    message.dnsMethod = 3;
                    break;
                case "FALLBACK":
                case 4:
                    message.dnsMethod = 4;
                    break;
                }
                if (object.appCached != null)
                    message.appCached = Boolean(object.appCached);
                return message;
            };

            /**
             * Creates a plain object from a DNSSource message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ClientPayload.DNSSource
             * @static
             * @param {proto.ClientPayload.DNSSource} message DNSSource
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            DNSSource.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.dnsMethod = options.enums === String ? "SYSTEM" : 0;
                    object.appCached = false;
                }
                if (message.dnsMethod != null && message.hasOwnProperty("dnsMethod"))
                    object.dnsMethod = options.enums === String ? $root.proto.ClientPayload.DNSSource.DNSResolutionMethod[message.dnsMethod] : message.dnsMethod;
                if (message.appCached != null && message.hasOwnProperty("appCached"))
                    object.appCached = message.appCached;
                return object;
            };

            /**
             * Converts this DNSSource to JSON.
             * @function toJSON
             * @memberof proto.ClientPayload.DNSSource
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            DNSSource.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * DNSResolutionMethod enum.
             * @name proto.ClientPayload.DNSSource.DNSResolutionMethod
             * @enum {number}
             * @property {number} SYSTEM=0 SYSTEM value
             * @property {number} GOOGLE=1 GOOGLE value
             * @property {number} HARDCODED=2 HARDCODED value
             * @property {number} OVERRIDE=3 OVERRIDE value
             * @property {number} FALLBACK=4 FALLBACK value
             */
            DNSSource.DNSResolutionMethod = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "SYSTEM"] = 0;
                values[valuesById[1] = "GOOGLE"] = 1;
                values[valuesById[2] = "HARDCODED"] = 2;
                values[valuesById[3] = "OVERRIDE"] = 3;
                values[valuesById[4] = "FALLBACK"] = 4;
                return values;
            })();

            return DNSSource;
        })();

        ClientPayload.DevicePairingRegistrationData = (function() {

            /**
             * Properties of a DevicePairingRegistrationData.
             * @memberof proto.ClientPayload
             * @interface IDevicePairingRegistrationData
             * @property {Uint8Array|null} [eRegid] DevicePairingRegistrationData eRegid
             * @property {Uint8Array|null} [eKeytype] DevicePairingRegistrationData eKeytype
             * @property {Uint8Array|null} [eIdent] DevicePairingRegistrationData eIdent
             * @property {Uint8Array|null} [eSkeyId] DevicePairingRegistrationData eSkeyId
             * @property {Uint8Array|null} [eSkeyVal] DevicePairingRegistrationData eSkeyVal
             * @property {Uint8Array|null} [eSkeySig] DevicePairingRegistrationData eSkeySig
             * @property {Uint8Array|null} [buildHash] DevicePairingRegistrationData buildHash
             * @property {Uint8Array|null} [deviceProps] DevicePairingRegistrationData deviceProps
             */

            /**
             * Constructs a new DevicePairingRegistrationData.
             * @memberof proto.ClientPayload
             * @classdesc Represents a DevicePairingRegistrationData.
             * @implements IDevicePairingRegistrationData
             * @constructor
             * @param {proto.ClientPayload.IDevicePairingRegistrationData=} [properties] Properties to set
             */
            function DevicePairingRegistrationData(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * DevicePairingRegistrationData eRegid.
             * @member {Uint8Array} eRegid
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eRegid = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData eKeytype.
             * @member {Uint8Array} eKeytype
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eKeytype = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData eIdent.
             * @member {Uint8Array} eIdent
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eIdent = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData eSkeyId.
             * @member {Uint8Array} eSkeyId
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eSkeyId = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData eSkeyVal.
             * @member {Uint8Array} eSkeyVal
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eSkeyVal = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData eSkeySig.
             * @member {Uint8Array} eSkeySig
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.eSkeySig = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData buildHash.
             * @member {Uint8Array} buildHash
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.buildHash = $util.newBuffer([]);

            /**
             * DevicePairingRegistrationData deviceProps.
             * @member {Uint8Array} deviceProps
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             */
            DevicePairingRegistrationData.prototype.deviceProps = $util.newBuffer([]);

            /**
             * Creates a new DevicePairingRegistrationData instance using the specified properties.
             * @function create
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {proto.ClientPayload.IDevicePairingRegistrationData=} [properties] Properties to set
             * @returns {proto.ClientPayload.DevicePairingRegistrationData} DevicePairingRegistrationData instance
             */
            DevicePairingRegistrationData.create = function create(properties) {
                return new DevicePairingRegistrationData(properties);
            };

            /**
             * Encodes the specified DevicePairingRegistrationData message. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @function encode
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {proto.ClientPayload.IDevicePairingRegistrationData} message DevicePairingRegistrationData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DevicePairingRegistrationData.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.eRegid != null && Object.hasOwnProperty.call(message, "eRegid"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.eRegid);
                if (message.eKeytype != null && Object.hasOwnProperty.call(message, "eKeytype"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.eKeytype);
                if (message.eIdent != null && Object.hasOwnProperty.call(message, "eIdent"))
                    writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.eIdent);
                if (message.eSkeyId != null && Object.hasOwnProperty.call(message, "eSkeyId"))
                    writer.uint32(/* id 4, wireType 2 =*/34).bytes(message.eSkeyId);
                if (message.eSkeyVal != null && Object.hasOwnProperty.call(message, "eSkeyVal"))
                    writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.eSkeyVal);
                if (message.eSkeySig != null && Object.hasOwnProperty.call(message, "eSkeySig"))
                    writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.eSkeySig);
                if (message.buildHash != null && Object.hasOwnProperty.call(message, "buildHash"))
                    writer.uint32(/* id 7, wireType 2 =*/58).bytes(message.buildHash);
                if (message.deviceProps != null && Object.hasOwnProperty.call(message, "deviceProps"))
                    writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.deviceProps);
                return writer;
            };

            /**
             * Encodes the specified DevicePairingRegistrationData message, length delimited. Does not implicitly {@link proto.ClientPayload.DevicePairingRegistrationData.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {proto.ClientPayload.IDevicePairingRegistrationData} message DevicePairingRegistrationData message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            DevicePairingRegistrationData.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ClientPayload.DevicePairingRegistrationData} DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DevicePairingRegistrationData.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.eRegid = reader.bytes();
                        break;
                    case 2:
                        message.eKeytype = reader.bytes();
                        break;
                    case 3:
                        message.eIdent = reader.bytes();
                        break;
                    case 4:
                        message.eSkeyId = reader.bytes();
                        break;
                    case 5:
                        message.eSkeyVal = reader.bytes();
                        break;
                    case 6:
                        message.eSkeySig = reader.bytes();
                        break;
                    case 7:
                        message.buildHash = reader.bytes();
                        break;
                    case 8:
                        message.deviceProps = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a DevicePairingRegistrationData message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ClientPayload.DevicePairingRegistrationData} DevicePairingRegistrationData
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            DevicePairingRegistrationData.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a DevicePairingRegistrationData message.
             * @function verify
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            DevicePairingRegistrationData.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                    if (!(message.eRegid && typeof message.eRegid.length === "number" || $util.isString(message.eRegid)))
                        return "eRegid: buffer expected";
                if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                    if (!(message.eKeytype && typeof message.eKeytype.length === "number" || $util.isString(message.eKeytype)))
                        return "eKeytype: buffer expected";
                if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                    if (!(message.eIdent && typeof message.eIdent.length === "number" || $util.isString(message.eIdent)))
                        return "eIdent: buffer expected";
                if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                    if (!(message.eSkeyId && typeof message.eSkeyId.length === "number" || $util.isString(message.eSkeyId)))
                        return "eSkeyId: buffer expected";
                if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                    if (!(message.eSkeyVal && typeof message.eSkeyVal.length === "number" || $util.isString(message.eSkeyVal)))
                        return "eSkeyVal: buffer expected";
                if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                    if (!(message.eSkeySig && typeof message.eSkeySig.length === "number" || $util.isString(message.eSkeySig)))
                        return "eSkeySig: buffer expected";
                if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                    if (!(message.buildHash && typeof message.buildHash.length === "number" || $util.isString(message.buildHash)))
                        return "buildHash: buffer expected";
                if (message.deviceProps != null && message.hasOwnProperty("deviceProps"))
                    if (!(message.deviceProps && typeof message.deviceProps.length === "number" || $util.isString(message.deviceProps)))
                        return "deviceProps: buffer expected";
                return null;
            };

            /**
             * Creates a DevicePairingRegistrationData message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ClientPayload.DevicePairingRegistrationData} DevicePairingRegistrationData
             */
            DevicePairingRegistrationData.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ClientPayload.DevicePairingRegistrationData)
                    return object;
                var message = new $root.proto.ClientPayload.DevicePairingRegistrationData();
                if (object.eRegid != null)
                    if (typeof object.eRegid === "string")
                        $util.base64.decode(object.eRegid, message.eRegid = $util.newBuffer($util.base64.length(object.eRegid)), 0);
                    else if (object.eRegid.length)
                        message.eRegid = object.eRegid;
                if (object.eKeytype != null)
                    if (typeof object.eKeytype === "string")
                        $util.base64.decode(object.eKeytype, message.eKeytype = $util.newBuffer($util.base64.length(object.eKeytype)), 0);
                    else if (object.eKeytype.length)
                        message.eKeytype = object.eKeytype;
                if (object.eIdent != null)
                    if (typeof object.eIdent === "string")
                        $util.base64.decode(object.eIdent, message.eIdent = $util.newBuffer($util.base64.length(object.eIdent)), 0);
                    else if (object.eIdent.length)
                        message.eIdent = object.eIdent;
                if (object.eSkeyId != null)
                    if (typeof object.eSkeyId === "string")
                        $util.base64.decode(object.eSkeyId, message.eSkeyId = $util.newBuffer($util.base64.length(object.eSkeyId)), 0);
                    else if (object.eSkeyId.length)
                        message.eSkeyId = object.eSkeyId;
                if (object.eSkeyVal != null)
                    if (typeof object.eSkeyVal === "string")
                        $util.base64.decode(object.eSkeyVal, message.eSkeyVal = $util.newBuffer($util.base64.length(object.eSkeyVal)), 0);
                    else if (object.eSkeyVal.length)
                        message.eSkeyVal = object.eSkeyVal;
                if (object.eSkeySig != null)
                    if (typeof object.eSkeySig === "string")
                        $util.base64.decode(object.eSkeySig, message.eSkeySig = $util.newBuffer($util.base64.length(object.eSkeySig)), 0);
                    else if (object.eSkeySig.length)
                        message.eSkeySig = object.eSkeySig;
                if (object.buildHash != null)
                    if (typeof object.buildHash === "string")
                        $util.base64.decode(object.buildHash, message.buildHash = $util.newBuffer($util.base64.length(object.buildHash)), 0);
                    else if (object.buildHash.length)
                        message.buildHash = object.buildHash;
                if (object.deviceProps != null)
                    if (typeof object.deviceProps === "string")
                        $util.base64.decode(object.deviceProps, message.deviceProps = $util.newBuffer($util.base64.length(object.deviceProps)), 0);
                    else if (object.deviceProps.length)
                        message.deviceProps = object.deviceProps;
                return message;
            };

            /**
             * Creates a plain object from a DevicePairingRegistrationData message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @static
             * @param {proto.ClientPayload.DevicePairingRegistrationData} message DevicePairingRegistrationData
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            DevicePairingRegistrationData.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if (options.bytes === String)
                        object.eRegid = "";
                    else {
                        object.eRegid = [];
                        if (options.bytes !== Array)
                            object.eRegid = $util.newBuffer(object.eRegid);
                    }
                    if (options.bytes === String)
                        object.eKeytype = "";
                    else {
                        object.eKeytype = [];
                        if (options.bytes !== Array)
                            object.eKeytype = $util.newBuffer(object.eKeytype);
                    }
                    if (options.bytes === String)
                        object.eIdent = "";
                    else {
                        object.eIdent = [];
                        if (options.bytes !== Array)
                            object.eIdent = $util.newBuffer(object.eIdent);
                    }
                    if (options.bytes === String)
                        object.eSkeyId = "";
                    else {
                        object.eSkeyId = [];
                        if (options.bytes !== Array)
                            object.eSkeyId = $util.newBuffer(object.eSkeyId);
                    }
                    if (options.bytes === String)
                        object.eSkeyVal = "";
                    else {
                        object.eSkeyVal = [];
                        if (options.bytes !== Array)
                            object.eSkeyVal = $util.newBuffer(object.eSkeyVal);
                    }
                    if (options.bytes === String)
                        object.eSkeySig = "";
                    else {
                        object.eSkeySig = [];
                        if (options.bytes !== Array)
                            object.eSkeySig = $util.newBuffer(object.eSkeySig);
                    }
                    if (options.bytes === String)
                        object.buildHash = "";
                    else {
                        object.buildHash = [];
                        if (options.bytes !== Array)
                            object.buildHash = $util.newBuffer(object.buildHash);
                    }
                    if (options.bytes === String)
                        object.deviceProps = "";
                    else {
                        object.deviceProps = [];
                        if (options.bytes !== Array)
                            object.deviceProps = $util.newBuffer(object.deviceProps);
                    }
                }
                if (message.eRegid != null && message.hasOwnProperty("eRegid"))
                    object.eRegid = options.bytes === String ? $util.base64.encode(message.eRegid, 0, message.eRegid.length) : options.bytes === Array ? Array.prototype.slice.call(message.eRegid) : message.eRegid;
                if (message.eKeytype != null && message.hasOwnProperty("eKeytype"))
                    object.eKeytype = options.bytes === String ? $util.base64.encode(message.eKeytype, 0, message.eKeytype.length) : options.bytes === Array ? Array.prototype.slice.call(message.eKeytype) : message.eKeytype;
                if (message.eIdent != null && message.hasOwnProperty("eIdent"))
                    object.eIdent = options.bytes === String ? $util.base64.encode(message.eIdent, 0, message.eIdent.length) : options.bytes === Array ? Array.prototype.slice.call(message.eIdent) : message.eIdent;
                if (message.eSkeyId != null && message.hasOwnProperty("eSkeyId"))
                    object.eSkeyId = options.bytes === String ? $util.base64.encode(message.eSkeyId, 0, message.eSkeyId.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyId) : message.eSkeyId;
                if (message.eSkeyVal != null && message.hasOwnProperty("eSkeyVal"))
                    object.eSkeyVal = options.bytes === String ? $util.base64.encode(message.eSkeyVal, 0, message.eSkeyVal.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeyVal) : message.eSkeyVal;
                if (message.eSkeySig != null && message.hasOwnProperty("eSkeySig"))
                    object.eSkeySig = options.bytes === String ? $util.base64.encode(message.eSkeySig, 0, message.eSkeySig.length) : options.bytes === Array ? Array.prototype.slice.call(message.eSkeySig) : message.eSkeySig;
                if (message.buildHash != null && message.hasOwnProperty("buildHash"))
                    object.buildHash = options.bytes === String ? $util.base64.encode(message.buildHash, 0, message.buildHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.buildHash) : message.buildHash;
                if (message.deviceProps != null && message.hasOwnProperty("deviceProps"))
                    object.deviceProps = options.bytes === String ? $util.base64.encode(message.deviceProps, 0, message.deviceProps.length) : options.bytes === Array ? Array.prototype.slice.call(message.deviceProps) : message.deviceProps;
                return object;
            };

            /**
             * Converts this DevicePairingRegistrationData to JSON.
             * @function toJSON
             * @memberof proto.ClientPayload.DevicePairingRegistrationData
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            DevicePairingRegistrationData.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return DevicePairingRegistrationData;
        })();

        /**
         * IOSAppExtension enum.
         * @name proto.ClientPayload.IOSAppExtension
         * @enum {number}
         * @property {number} SHARE_EXTENSION=0 SHARE_EXTENSION value
         * @property {number} SERVICE_EXTENSION=1 SERVICE_EXTENSION value
         * @property {number} INTENTS_EXTENSION=2 INTENTS_EXTENSION value
         */
        ClientPayload.IOSAppExtension = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "SHARE_EXTENSION"] = 0;
            values[valuesById[1] = "SERVICE_EXTENSION"] = 1;
            values[valuesById[2] = "INTENTS_EXTENSION"] = 2;
            return values;
        })();

        /**
         * Product enum.
         * @name proto.ClientPayload.Product
         * @enum {number}
         * @property {number} WHATSAPP=0 WHATSAPP value
         * @property {number} MESSENGER=1 MESSENGER value
         */
        ClientPayload.Product = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "WHATSAPP"] = 0;
            values[valuesById[1] = "MESSENGER"] = 1;
            return values;
        })();

        ClientPayload.UserAgent = (function() {

            /**
             * Properties of a UserAgent.
             * @memberof proto.ClientPayload
             * @interface IUserAgent
             * @property {proto.ClientPayload.UserAgent.Platform|null} [platform] UserAgent platform
             * @property {proto.ClientPayload.UserAgent.IAppVersion|null} [appVersion] UserAgent appVersion
             * @property {string|null} [mcc] UserAgent mcc
             * @property {string|null} [mnc] UserAgent mnc
             * @property {string|null} [osVersion] UserAgent osVersion
             * @property {string|null} [manufacturer] UserAgent manufacturer
             * @property {string|null} [device] UserAgent device
             * @property {string|null} [osBuildNumber] UserAgent osBuildNumber
             * @property {string|null} [phoneId] UserAgent phoneId
             * @property {proto.ClientPayload.UserAgent.ReleaseChannel|null} [releaseChannel] UserAgent releaseChannel
             * @property {string|null} [localeLanguageIso6391] UserAgent localeLanguageIso6391
             * @property {string|null} [localeCountryIso31661Alpha2] UserAgent localeCountryIso31661Alpha2
             * @property {string|null} [deviceBoard] UserAgent deviceBoard
             */

            /**
             * Constructs a new UserAgent.
             * @memberof proto.ClientPayload
             * @classdesc Represents a UserAgent.
             * @implements IUserAgent
             * @constructor
             * @param {proto.ClientPayload.IUserAgent=} [properties] Properties to set
             */
            function UserAgent(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * UserAgent platform.
             * @member {proto.ClientPayload.UserAgent.Platform} platform
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.platform = 0;

            /**
             * UserAgent appVersion.
             * @member {proto.ClientPayload.UserAgent.IAppVersion|null|undefined} appVersion
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.appVersion = null;

            /**
             * UserAgent mcc.
             * @member {string} mcc
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.mcc = "";

            /**
             * UserAgent mnc.
             * @member {string} mnc
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.mnc = "";

            /**
             * UserAgent osVersion.
             * @member {string} osVersion
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.osVersion = "";

            /**
             * UserAgent manufacturer.
             * @member {string} manufacturer
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.manufacturer = "";

            /**
             * UserAgent device.
             * @member {string} device
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.device = "";

            /**
             * UserAgent osBuildNumber.
             * @member {string} osBuildNumber
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.osBuildNumber = "";

            /**
             * UserAgent phoneId.
             * @member {string} phoneId
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.phoneId = "";

            /**
             * UserAgent releaseChannel.
             * @member {proto.ClientPayload.UserAgent.ReleaseChannel} releaseChannel
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.releaseChannel = 0;

            /**
             * UserAgent localeLanguageIso6391.
             * @member {string} localeLanguageIso6391
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.localeLanguageIso6391 = "";

            /**
             * UserAgent localeCountryIso31661Alpha2.
             * @member {string} localeCountryIso31661Alpha2
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.localeCountryIso31661Alpha2 = "";

            /**
             * UserAgent deviceBoard.
             * @member {string} deviceBoard
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             */
            UserAgent.prototype.deviceBoard = "";

            /**
             * Creates a new UserAgent instance using the specified properties.
             * @function create
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {proto.ClientPayload.IUserAgent=} [properties] Properties to set
             * @returns {proto.ClientPayload.UserAgent} UserAgent instance
             */
            UserAgent.create = function create(properties) {
                return new UserAgent(properties);
            };

            /**
             * Encodes the specified UserAgent message. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @function encode
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {proto.ClientPayload.IUserAgent} message UserAgent message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            UserAgent.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.platform != null && Object.hasOwnProperty.call(message, "platform"))
                    writer.uint32(/* id 1, wireType 0 =*/8).int32(message.platform);
                if (message.appVersion != null && Object.hasOwnProperty.call(message, "appVersion"))
                    $root.proto.ClientPayload.UserAgent.AppVersion.encode(message.appVersion, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                if (message.mcc != null && Object.hasOwnProperty.call(message, "mcc"))
                    writer.uint32(/* id 3, wireType 2 =*/26).string(message.mcc);
                if (message.mnc != null && Object.hasOwnProperty.call(message, "mnc"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.mnc);
                if (message.osVersion != null && Object.hasOwnProperty.call(message, "osVersion"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.osVersion);
                if (message.manufacturer != null && Object.hasOwnProperty.call(message, "manufacturer"))
                    writer.uint32(/* id 6, wireType 2 =*/50).string(message.manufacturer);
                if (message.device != null && Object.hasOwnProperty.call(message, "device"))
                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.device);
                if (message.osBuildNumber != null && Object.hasOwnProperty.call(message, "osBuildNumber"))
                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.osBuildNumber);
                if (message.phoneId != null && Object.hasOwnProperty.call(message, "phoneId"))
                    writer.uint32(/* id 9, wireType 2 =*/74).string(message.phoneId);
                if (message.releaseChannel != null && Object.hasOwnProperty.call(message, "releaseChannel"))
                    writer.uint32(/* id 10, wireType 0 =*/80).int32(message.releaseChannel);
                if (message.localeLanguageIso6391 != null && Object.hasOwnProperty.call(message, "localeLanguageIso6391"))
                    writer.uint32(/* id 11, wireType 2 =*/90).string(message.localeLanguageIso6391);
                if (message.localeCountryIso31661Alpha2 != null && Object.hasOwnProperty.call(message, "localeCountryIso31661Alpha2"))
                    writer.uint32(/* id 12, wireType 2 =*/98).string(message.localeCountryIso31661Alpha2);
                if (message.deviceBoard != null && Object.hasOwnProperty.call(message, "deviceBoard"))
                    writer.uint32(/* id 13, wireType 2 =*/106).string(message.deviceBoard);
                return writer;
            };

            /**
             * Encodes the specified UserAgent message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {proto.ClientPayload.IUserAgent} message UserAgent message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            UserAgent.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a UserAgent message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ClientPayload.UserAgent} UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            UserAgent.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.UserAgent();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.platform = reader.int32();
                        break;
                    case 2:
                        message.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.decode(reader, reader.uint32());
                        break;
                    case 3:
                        message.mcc = reader.string();
                        break;
                    case 4:
                        message.mnc = reader.string();
                        break;
                    case 5:
                        message.osVersion = reader.string();
                        break;
                    case 6:
                        message.manufacturer = reader.string();
                        break;
                    case 7:
                        message.device = reader.string();
                        break;
                    case 8:
                        message.osBuildNumber = reader.string();
                        break;
                    case 9:
                        message.phoneId = reader.string();
                        break;
                    case 10:
                        message.releaseChannel = reader.int32();
                        break;
                    case 11:
                        message.localeLanguageIso6391 = reader.string();
                        break;
                    case 12:
                        message.localeCountryIso31661Alpha2 = reader.string();
                        break;
                    case 13:
                        message.deviceBoard = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a UserAgent message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ClientPayload.UserAgent} UserAgent
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            UserAgent.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a UserAgent message.
             * @function verify
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            UserAgent.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.platform != null && message.hasOwnProperty("platform"))
                    switch (message.platform) {
                    default:
                        return "platform: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                    case 5:
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                    case 11:
                    case 12:
                    case 13:
                    case 14:
                    case 15:
                    case 16:
                    case 17:
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                    case 22:
                    case 23:
                    case 24:
                    case 25:
                    case 26:
                    case 27:
                    case 28:
                    case 29:
                    case 30:
                    case 31:
                        break;
                    }
                if (message.appVersion != null && message.hasOwnProperty("appVersion")) {
                    var error = $root.proto.ClientPayload.UserAgent.AppVersion.verify(message.appVersion);
                    if (error)
                        return "appVersion." + error;
                }
                if (message.mcc != null && message.hasOwnProperty("mcc"))
                    if (!$util.isString(message.mcc))
                        return "mcc: string expected";
                if (message.mnc != null && message.hasOwnProperty("mnc"))
                    if (!$util.isString(message.mnc))
                        return "mnc: string expected";
                if (message.osVersion != null && message.hasOwnProperty("osVersion"))
                    if (!$util.isString(message.osVersion))
                        return "osVersion: string expected";
                if (message.manufacturer != null && message.hasOwnProperty("manufacturer"))
                    if (!$util.isString(message.manufacturer))
                        return "manufacturer: string expected";
                if (message.device != null && message.hasOwnProperty("device"))
                    if (!$util.isString(message.device))
                        return "device: string expected";
                if (message.osBuildNumber != null && message.hasOwnProperty("osBuildNumber"))
                    if (!$util.isString(message.osBuildNumber))
                        return "osBuildNumber: string expected";
                if (message.phoneId != null && message.hasOwnProperty("phoneId"))
                    if (!$util.isString(message.phoneId))
                        return "phoneId: string expected";
                if (message.releaseChannel != null && message.hasOwnProperty("releaseChannel"))
                    switch (message.releaseChannel) {
                    default:
                        return "releaseChannel: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                        break;
                    }
                if (message.localeLanguageIso6391 != null && message.hasOwnProperty("localeLanguageIso6391"))
                    if (!$util.isString(message.localeLanguageIso6391))
                        return "localeLanguageIso6391: string expected";
                if (message.localeCountryIso31661Alpha2 != null && message.hasOwnProperty("localeCountryIso31661Alpha2"))
                    if (!$util.isString(message.localeCountryIso31661Alpha2))
                        return "localeCountryIso31661Alpha2: string expected";
                if (message.deviceBoard != null && message.hasOwnProperty("deviceBoard"))
                    if (!$util.isString(message.deviceBoard))
                        return "deviceBoard: string expected";
                return null;
            };

            /**
             * Creates a UserAgent message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ClientPayload.UserAgent} UserAgent
             */
            UserAgent.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ClientPayload.UserAgent)
                    return object;
                var message = new $root.proto.ClientPayload.UserAgent();
                switch (object.platform) {
                case "ANDROID":
                case 0:
                    message.platform = 0;
                    break;
                case "IOS":
                case 1:
                    message.platform = 1;
                    break;
                case "WINDOWS_PHONE":
                case 2:
                    message.platform = 2;
                    break;
                case "BLACKBERRY":
                case 3:
                    message.platform = 3;
                    break;
                case "BLACKBERRYX":
                case 4:
                    message.platform = 4;
                    break;
                case "S40":
                case 5:
                    message.platform = 5;
                    break;
                case "S60":
                case 6:
                    message.platform = 6;
                    break;
                case "PYTHON_CLIENT":
                case 7:
                    message.platform = 7;
                    break;
                case "TIZEN":
                case 8:
                    message.platform = 8;
                    break;
                case "ENTERPRISE":
                case 9:
                    message.platform = 9;
                    break;
                case "SMB_ANDROID":
                case 10:
                    message.platform = 10;
                    break;
                case "KAIOS":
                case 11:
                    message.platform = 11;
                    break;
                case "SMB_IOS":
                case 12:
                    message.platform = 12;
                    break;
                case "WINDOWS":
                case 13:
                    message.platform = 13;
                    break;
                case "WEB":
                case 14:
                    message.platform = 14;
                    break;
                case "PORTAL":
                case 15:
                    message.platform = 15;
                    break;
                case "GREEN_ANDROID":
                case 16:
                    message.platform = 16;
                    break;
                case "GREEN_IPHONE":
                case 17:
                    message.platform = 17;
                    break;
                case "BLUE_ANDROID":
                case 18:
                    message.platform = 18;
                    break;
                case "BLUE_IPHONE":
                case 19:
                    message.platform = 19;
                    break;
                case "FBLITE_ANDROID":
                case 20:
                    message.platform = 20;
                    break;
                case "MLITE_ANDROID":
                case 21:
                    message.platform = 21;
                    break;
                case "IGLITE_ANDROID":
                case 22:
                    message.platform = 22;
                    break;
                case "PAGE":
                case 23:
                    message.platform = 23;
                    break;
                case "MACOS":
                case 24:
                    message.platform = 24;
                    break;
                case "OCULUS_MSG":
                case 25:
                    message.platform = 25;
                    break;
                case "OCULUS_CALL":
                case 26:
                    message.platform = 26;
                    break;
                case "MILAN":
                case 27:
                    message.platform = 27;
                    break;
                case "CAPI":
                case 28:
                    message.platform = 28;
                    break;
                case "WEAROS":
                case 29:
                    message.platform = 29;
                    break;
                case "ARDEVICE":
                case 30:
                    message.platform = 30;
                    break;
                case "VRDEVICE":
                case 31:
                    message.platform = 31;
                    break;
                }
                if (object.appVersion != null) {
                    if (typeof object.appVersion !== "object")
                        throw TypeError(".proto.ClientPayload.UserAgent.appVersion: object expected");
                    message.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.fromObject(object.appVersion);
                }
                if (object.mcc != null)
                    message.mcc = String(object.mcc);
                if (object.mnc != null)
                    message.mnc = String(object.mnc);
                if (object.osVersion != null)
                    message.osVersion = String(object.osVersion);
                if (object.manufacturer != null)
                    message.manufacturer = String(object.manufacturer);
                if (object.device != null)
                    message.device = String(object.device);
                if (object.osBuildNumber != null)
                    message.osBuildNumber = String(object.osBuildNumber);
                if (object.phoneId != null)
                    message.phoneId = String(object.phoneId);
                switch (object.releaseChannel) {
                case "RELEASE":
                case 0:
                    message.releaseChannel = 0;
                    break;
                case "BETA":
                case 1:
                    message.releaseChannel = 1;
                    break;
                case "ALPHA":
                case 2:
                    message.releaseChannel = 2;
                    break;
                case "DEBUG":
                case 3:
                    message.releaseChannel = 3;
                    break;
                }
                if (object.localeLanguageIso6391 != null)
                    message.localeLanguageIso6391 = String(object.localeLanguageIso6391);
                if (object.localeCountryIso31661Alpha2 != null)
                    message.localeCountryIso31661Alpha2 = String(object.localeCountryIso31661Alpha2);
                if (object.deviceBoard != null)
                    message.deviceBoard = String(object.deviceBoard);
                return message;
            };

            /**
             * Creates a plain object from a UserAgent message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ClientPayload.UserAgent
             * @static
             * @param {proto.ClientPayload.UserAgent} message UserAgent
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            UserAgent.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.platform = options.enums === String ? "ANDROID" : 0;
                    object.appVersion = null;
                    object.mcc = "";
                    object.mnc = "";
                    object.osVersion = "";
                    object.manufacturer = "";
                    object.device = "";
                    object.osBuildNumber = "";
                    object.phoneId = "";
                    object.releaseChannel = options.enums === String ? "RELEASE" : 0;
                    object.localeLanguageIso6391 = "";
                    object.localeCountryIso31661Alpha2 = "";
                    object.deviceBoard = "";
                }
                if (message.platform != null && message.hasOwnProperty("platform"))
                    object.platform = options.enums === String ? $root.proto.ClientPayload.UserAgent.Platform[message.platform] : message.platform;
                if (message.appVersion != null && message.hasOwnProperty("appVersion"))
                    object.appVersion = $root.proto.ClientPayload.UserAgent.AppVersion.toObject(message.appVersion, options);
                if (message.mcc != null && message.hasOwnProperty("mcc"))
                    object.mcc = message.mcc;
                if (message.mnc != null && message.hasOwnProperty("mnc"))
                    object.mnc = message.mnc;
                if (message.osVersion != null && message.hasOwnProperty("osVersion"))
                    object.osVersion = message.osVersion;
                if (message.manufacturer != null && message.hasOwnProperty("manufacturer"))
                    object.manufacturer = message.manufacturer;
                if (message.device != null && message.hasOwnProperty("device"))
                    object.device = message.device;
                if (message.osBuildNumber != null && message.hasOwnProperty("osBuildNumber"))
                    object.osBuildNumber = message.osBuildNumber;
                if (message.phoneId != null && message.hasOwnProperty("phoneId"))
                    object.phoneId = message.phoneId;
                if (message.releaseChannel != null && message.hasOwnProperty("releaseChannel"))
                    object.releaseChannel = options.enums === String ? $root.proto.ClientPayload.UserAgent.ReleaseChannel[message.releaseChannel] : message.releaseChannel;
                if (message.localeLanguageIso6391 != null && message.hasOwnProperty("localeLanguageIso6391"))
                    object.localeLanguageIso6391 = message.localeLanguageIso6391;
                if (message.localeCountryIso31661Alpha2 != null && message.hasOwnProperty("localeCountryIso31661Alpha2"))
                    object.localeCountryIso31661Alpha2 = message.localeCountryIso31661Alpha2;
                if (message.deviceBoard != null && message.hasOwnProperty("deviceBoard"))
                    object.deviceBoard = message.deviceBoard;
                return object;
            };

            /**
             * Converts this UserAgent to JSON.
             * @function toJSON
             * @memberof proto.ClientPayload.UserAgent
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            UserAgent.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            UserAgent.AppVersion = (function() {

                /**
                 * Properties of an AppVersion.
                 * @memberof proto.ClientPayload.UserAgent
                 * @interface IAppVersion
                 * @property {number|null} [primary] AppVersion primary
                 * @property {number|null} [secondary] AppVersion secondary
                 * @property {number|null} [tertiary] AppVersion tertiary
                 * @property {number|null} [quaternary] AppVersion quaternary
                 * @property {number|null} [quinary] AppVersion quinary
                 */

                /**
                 * Constructs a new AppVersion.
                 * @memberof proto.ClientPayload.UserAgent
                 * @classdesc Represents an AppVersion.
                 * @implements IAppVersion
                 * @constructor
                 * @param {proto.ClientPayload.UserAgent.IAppVersion=} [properties] Properties to set
                 */
                function AppVersion(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * AppVersion primary.
                 * @member {number} primary
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 */
                AppVersion.prototype.primary = 0;

                /**
                 * AppVersion secondary.
                 * @member {number} secondary
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 */
                AppVersion.prototype.secondary = 0;

                /**
                 * AppVersion tertiary.
                 * @member {number} tertiary
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 */
                AppVersion.prototype.tertiary = 0;

                /**
                 * AppVersion quaternary.
                 * @member {number} quaternary
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 */
                AppVersion.prototype.quaternary = 0;

                /**
                 * AppVersion quinary.
                 * @member {number} quinary
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 */
                AppVersion.prototype.quinary = 0;

                /**
                 * Creates a new AppVersion instance using the specified properties.
                 * @function create
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {proto.ClientPayload.UserAgent.IAppVersion=} [properties] Properties to set
                 * @returns {proto.ClientPayload.UserAgent.AppVersion} AppVersion instance
                 */
                AppVersion.create = function create(properties) {
                    return new AppVersion(properties);
                };

                /**
                 * Encodes the specified AppVersion message. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @function encode
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {proto.ClientPayload.UserAgent.IAppVersion} message AppVersion message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AppVersion.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.primary != null && Object.hasOwnProperty.call(message, "primary"))
                        writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.primary);
                    if (message.secondary != null && Object.hasOwnProperty.call(message, "secondary"))
                        writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.secondary);
                    if (message.tertiary != null && Object.hasOwnProperty.call(message, "tertiary"))
                        writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.tertiary);
                    if (message.quaternary != null && Object.hasOwnProperty.call(message, "quaternary"))
                        writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.quaternary);
                    if (message.quinary != null && Object.hasOwnProperty.call(message, "quinary"))
                        writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.quinary);
                    return writer;
                };

                /**
                 * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.ClientPayload.UserAgent.AppVersion.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {proto.ClientPayload.UserAgent.IAppVersion} message AppVersion message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                AppVersion.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an AppVersion message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.ClientPayload.UserAgent.AppVersion} AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AppVersion.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.primary = reader.uint32();
                            break;
                        case 2:
                            message.secondary = reader.uint32();
                            break;
                        case 3:
                            message.tertiary = reader.uint32();
                            break;
                        case 4:
                            message.quaternary = reader.uint32();
                            break;
                        case 5:
                            message.quinary = reader.uint32();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an AppVersion message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.ClientPayload.UserAgent.AppVersion} AppVersion
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                AppVersion.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an AppVersion message.
                 * @function verify
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                AppVersion.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.primary != null && message.hasOwnProperty("primary"))
                        if (!$util.isInteger(message.primary))
                            return "primary: integer expected";
                    if (message.secondary != null && message.hasOwnProperty("secondary"))
                        if (!$util.isInteger(message.secondary))
                            return "secondary: integer expected";
                    if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                        if (!$util.isInteger(message.tertiary))
                            return "tertiary: integer expected";
                    if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                        if (!$util.isInteger(message.quaternary))
                            return "quaternary: integer expected";
                    if (message.quinary != null && message.hasOwnProperty("quinary"))
                        if (!$util.isInteger(message.quinary))
                            return "quinary: integer expected";
                    return null;
                };

                /**
                 * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.ClientPayload.UserAgent.AppVersion} AppVersion
                 */
                AppVersion.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.ClientPayload.UserAgent.AppVersion)
                        return object;
                    var message = new $root.proto.ClientPayload.UserAgent.AppVersion();
                    if (object.primary != null)
                        message.primary = object.primary >>> 0;
                    if (object.secondary != null)
                        message.secondary = object.secondary >>> 0;
                    if (object.tertiary != null)
                        message.tertiary = object.tertiary >>> 0;
                    if (object.quaternary != null)
                        message.quaternary = object.quaternary >>> 0;
                    if (object.quinary != null)
                        message.quinary = object.quinary >>> 0;
                    return message;
                };

                /**
                 * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @static
                 * @param {proto.ClientPayload.UserAgent.AppVersion} message AppVersion
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                AppVersion.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.primary = 0;
                        object.secondary = 0;
                        object.tertiary = 0;
                        object.quaternary = 0;
                        object.quinary = 0;
                    }
                    if (message.primary != null && message.hasOwnProperty("primary"))
                        object.primary = message.primary;
                    if (message.secondary != null && message.hasOwnProperty("secondary"))
                        object.secondary = message.secondary;
                    if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                        object.tertiary = message.tertiary;
                    if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                        object.quaternary = message.quaternary;
                    if (message.quinary != null && message.hasOwnProperty("quinary"))
                        object.quinary = message.quinary;
                    return object;
                };

                /**
                 * Converts this AppVersion to JSON.
                 * @function toJSON
                 * @memberof proto.ClientPayload.UserAgent.AppVersion
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                AppVersion.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return AppVersion;
            })();

            /**
             * Platform enum.
             * @name proto.ClientPayload.UserAgent.Platform
             * @enum {number}
             * @property {number} ANDROID=0 ANDROID value
             * @property {number} IOS=1 IOS value
             * @property {number} WINDOWS_PHONE=2 WINDOWS_PHONE value
             * @property {number} BLACKBERRY=3 BLACKBERRY value
             * @property {number} BLACKBERRYX=4 BLACKBERRYX value
             * @property {number} S40=5 S40 value
             * @property {number} S60=6 S60 value
             * @property {number} PYTHON_CLIENT=7 PYTHON_CLIENT value
             * @property {number} TIZEN=8 TIZEN value
             * @property {number} ENTERPRISE=9 ENTERPRISE value
             * @property {number} SMB_ANDROID=10 SMB_ANDROID value
             * @property {number} KAIOS=11 KAIOS value
             * @property {number} SMB_IOS=12 SMB_IOS value
             * @property {number} WINDOWS=13 WINDOWS value
             * @property {number} WEB=14 WEB value
             * @property {number} PORTAL=15 PORTAL value
             * @property {number} GREEN_ANDROID=16 GREEN_ANDROID value
             * @property {number} GREEN_IPHONE=17 GREEN_IPHONE value
             * @property {number} BLUE_ANDROID=18 BLUE_ANDROID value
             * @property {number} BLUE_IPHONE=19 BLUE_IPHONE value
             * @property {number} FBLITE_ANDROID=20 FBLITE_ANDROID value
             * @property {number} MLITE_ANDROID=21 MLITE_ANDROID value
             * @property {number} IGLITE_ANDROID=22 IGLITE_ANDROID value
             * @property {number} PAGE=23 PAGE value
             * @property {number} MACOS=24 MACOS value
             * @property {number} OCULUS_MSG=25 OCULUS_MSG value
             * @property {number} OCULUS_CALL=26 OCULUS_CALL value
             * @property {number} MILAN=27 MILAN value
             * @property {number} CAPI=28 CAPI value
             * @property {number} WEAROS=29 WEAROS value
             * @property {number} ARDEVICE=30 ARDEVICE value
             * @property {number} VRDEVICE=31 VRDEVICE value
             */
            UserAgent.Platform = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "ANDROID"] = 0;
                values[valuesById[1] = "IOS"] = 1;
                values[valuesById[2] = "WINDOWS_PHONE"] = 2;
                values[valuesById[3] = "BLACKBERRY"] = 3;
                values[valuesById[4] = "BLACKBERRYX"] = 4;
                values[valuesById[5] = "S40"] = 5;
                values[valuesById[6] = "S60"] = 6;
                values[valuesById[7] = "PYTHON_CLIENT"] = 7;
                values[valuesById[8] = "TIZEN"] = 8;
                values[valuesById[9] = "ENTERPRISE"] = 9;
                values[valuesById[10] = "SMB_ANDROID"] = 10;
                values[valuesById[11] = "KAIOS"] = 11;
                values[valuesById[12] = "SMB_IOS"] = 12;
                values[valuesById[13] = "WINDOWS"] = 13;
                values[valuesById[14] = "WEB"] = 14;
                values[valuesById[15] = "PORTAL"] = 15;
                values[valuesById[16] = "GREEN_ANDROID"] = 16;
                values[valuesById[17] = "GREEN_IPHONE"] = 17;
                values[valuesById[18] = "BLUE_ANDROID"] = 18;
                values[valuesById[19] = "BLUE_IPHONE"] = 19;
                values[valuesById[20] = "FBLITE_ANDROID"] = 20;
                values[valuesById[21] = "MLITE_ANDROID"] = 21;
                values[valuesById[22] = "IGLITE_ANDROID"] = 22;
                values[valuesById[23] = "PAGE"] = 23;
                values[valuesById[24] = "MACOS"] = 24;
                values[valuesById[25] = "OCULUS_MSG"] = 25;
                values[valuesById[26] = "OCULUS_CALL"] = 26;
                values[valuesById[27] = "MILAN"] = 27;
                values[valuesById[28] = "CAPI"] = 28;
                values[valuesById[29] = "WEAROS"] = 29;
                values[valuesById[30] = "ARDEVICE"] = 30;
                values[valuesById[31] = "VRDEVICE"] = 31;
                return values;
            })();

            /**
             * ReleaseChannel enum.
             * @name proto.ClientPayload.UserAgent.ReleaseChannel
             * @enum {number}
             * @property {number} RELEASE=0 RELEASE value
             * @property {number} BETA=1 BETA value
             * @property {number} ALPHA=2 ALPHA value
             * @property {number} DEBUG=3 DEBUG value
             */
            UserAgent.ReleaseChannel = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "RELEASE"] = 0;
                values[valuesById[1] = "BETA"] = 1;
                values[valuesById[2] = "ALPHA"] = 2;
                values[valuesById[3] = "DEBUG"] = 3;
                return values;
            })();

            return UserAgent;
        })();

        ClientPayload.WebInfo = (function() {

            /**
             * Properties of a WebInfo.
             * @memberof proto.ClientPayload
             * @interface IWebInfo
             * @property {string|null} [refToken] WebInfo refToken
             * @property {string|null} [version] WebInfo version
             * @property {proto.ClientPayload.WebInfo.IWebdPayload|null} [webdPayload] WebInfo webdPayload
             * @property {proto.ClientPayload.WebInfo.WebSubPlatform|null} [webSubPlatform] WebInfo webSubPlatform
             */

            /**
             * Constructs a new WebInfo.
             * @memberof proto.ClientPayload
             * @classdesc Represents a WebInfo.
             * @implements IWebInfo
             * @constructor
             * @param {proto.ClientPayload.IWebInfo=} [properties] Properties to set
             */
            function WebInfo(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * WebInfo refToken.
             * @member {string} refToken
             * @memberof proto.ClientPayload.WebInfo
             * @instance
             */
            WebInfo.prototype.refToken = "";

            /**
             * WebInfo version.
             * @member {string} version
             * @memberof proto.ClientPayload.WebInfo
             * @instance
             */
            WebInfo.prototype.version = "";

            /**
             * WebInfo webdPayload.
             * @member {proto.ClientPayload.WebInfo.IWebdPayload|null|undefined} webdPayload
             * @memberof proto.ClientPayload.WebInfo
             * @instance
             */
            WebInfo.prototype.webdPayload = null;

            /**
             * WebInfo webSubPlatform.
             * @member {proto.ClientPayload.WebInfo.WebSubPlatform} webSubPlatform
             * @memberof proto.ClientPayload.WebInfo
             * @instance
             */
            WebInfo.prototype.webSubPlatform = 0;

            /**
             * Creates a new WebInfo instance using the specified properties.
             * @function create
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {proto.ClientPayload.IWebInfo=} [properties] Properties to set
             * @returns {proto.ClientPayload.WebInfo} WebInfo instance
             */
            WebInfo.create = function create(properties) {
                return new WebInfo(properties);
            };

            /**
             * Encodes the specified WebInfo message. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @function encode
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {proto.ClientPayload.IWebInfo} message WebInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            WebInfo.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.refToken != null && Object.hasOwnProperty.call(message, "refToken"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.refToken);
                if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.version);
                if (message.webdPayload != null && Object.hasOwnProperty.call(message, "webdPayload"))
                    $root.proto.ClientPayload.WebInfo.WebdPayload.encode(message.webdPayload, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                if (message.webSubPlatform != null && Object.hasOwnProperty.call(message, "webSubPlatform"))
                    writer.uint32(/* id 4, wireType 0 =*/32).int32(message.webSubPlatform);
                return writer;
            };

            /**
             * Encodes the specified WebInfo message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {proto.ClientPayload.IWebInfo} message WebInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            WebInfo.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a WebInfo message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ClientPayload.WebInfo} WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            WebInfo.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.WebInfo();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.refToken = reader.string();
                        break;
                    case 2:
                        message.version = reader.string();
                        break;
                    case 3:
                        message.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.decode(reader, reader.uint32());
                        break;
                    case 4:
                        message.webSubPlatform = reader.int32();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a WebInfo message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ClientPayload.WebInfo} WebInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            WebInfo.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a WebInfo message.
             * @function verify
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            WebInfo.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.refToken != null && message.hasOwnProperty("refToken"))
                    if (!$util.isString(message.refToken))
                        return "refToken: string expected";
                if (message.version != null && message.hasOwnProperty("version"))
                    if (!$util.isString(message.version))
                        return "version: string expected";
                if (message.webdPayload != null && message.hasOwnProperty("webdPayload")) {
                    var error = $root.proto.ClientPayload.WebInfo.WebdPayload.verify(message.webdPayload);
                    if (error)
                        return "webdPayload." + error;
                }
                if (message.webSubPlatform != null && message.hasOwnProperty("webSubPlatform"))
                    switch (message.webSubPlatform) {
                    default:
                        return "webSubPlatform: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                    case 3:
                    case 4:
                        break;
                    }
                return null;
            };

            /**
             * Creates a WebInfo message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ClientPayload.WebInfo} WebInfo
             */
            WebInfo.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ClientPayload.WebInfo)
                    return object;
                var message = new $root.proto.ClientPayload.WebInfo();
                if (object.refToken != null)
                    message.refToken = String(object.refToken);
                if (object.version != null)
                    message.version = String(object.version);
                if (object.webdPayload != null) {
                    if (typeof object.webdPayload !== "object")
                        throw TypeError(".proto.ClientPayload.WebInfo.webdPayload: object expected");
                    message.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.fromObject(object.webdPayload);
                }
                switch (object.webSubPlatform) {
                case "WEB_BROWSER":
                case 0:
                    message.webSubPlatform = 0;
                    break;
                case "APP_STORE":
                case 1:
                    message.webSubPlatform = 1;
                    break;
                case "WIN_STORE":
                case 2:
                    message.webSubPlatform = 2;
                    break;
                case "DARWIN":
                case 3:
                    message.webSubPlatform = 3;
                    break;
                case "WIN32":
                case 4:
                    message.webSubPlatform = 4;
                    break;
                }
                return message;
            };

            /**
             * Creates a plain object from a WebInfo message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ClientPayload.WebInfo
             * @static
             * @param {proto.ClientPayload.WebInfo} message WebInfo
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            WebInfo.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.refToken = "";
                    object.version = "";
                    object.webdPayload = null;
                    object.webSubPlatform = options.enums === String ? "WEB_BROWSER" : 0;
                }
                if (message.refToken != null && message.hasOwnProperty("refToken"))
                    object.refToken = message.refToken;
                if (message.version != null && message.hasOwnProperty("version"))
                    object.version = message.version;
                if (message.webdPayload != null && message.hasOwnProperty("webdPayload"))
                    object.webdPayload = $root.proto.ClientPayload.WebInfo.WebdPayload.toObject(message.webdPayload, options);
                if (message.webSubPlatform != null && message.hasOwnProperty("webSubPlatform"))
                    object.webSubPlatform = options.enums === String ? $root.proto.ClientPayload.WebInfo.WebSubPlatform[message.webSubPlatform] : message.webSubPlatform;
                return object;
            };

            /**
             * Converts this WebInfo to JSON.
             * @function toJSON
             * @memberof proto.ClientPayload.WebInfo
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            WebInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * WebSubPlatform enum.
             * @name proto.ClientPayload.WebInfo.WebSubPlatform
             * @enum {number}
             * @property {number} WEB_BROWSER=0 WEB_BROWSER value
             * @property {number} APP_STORE=1 APP_STORE value
             * @property {number} WIN_STORE=2 WIN_STORE value
             * @property {number} DARWIN=3 DARWIN value
             * @property {number} WIN32=4 WIN32 value
             */
            WebInfo.WebSubPlatform = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "WEB_BROWSER"] = 0;
                values[valuesById[1] = "APP_STORE"] = 1;
                values[valuesById[2] = "WIN_STORE"] = 2;
                values[valuesById[3] = "DARWIN"] = 3;
                values[valuesById[4] = "WIN32"] = 4;
                return values;
            })();

            WebInfo.WebdPayload = (function() {

                /**
                 * Properties of a WebdPayload.
                 * @memberof proto.ClientPayload.WebInfo
                 * @interface IWebdPayload
                 * @property {boolean|null} [usesParticipantInKey] WebdPayload usesParticipantInKey
                 * @property {boolean|null} [supportsStarredMessages] WebdPayload supportsStarredMessages
                 * @property {boolean|null} [supportsDocumentMessages] WebdPayload supportsDocumentMessages
                 * @property {boolean|null} [supportsUrlMessages] WebdPayload supportsUrlMessages
                 * @property {boolean|null} [supportsMediaRetry] WebdPayload supportsMediaRetry
                 * @property {boolean|null} [supportsE2EImage] WebdPayload supportsE2EImage
                 * @property {boolean|null} [supportsE2EVideo] WebdPayload supportsE2EVideo
                 * @property {boolean|null} [supportsE2EAudio] WebdPayload supportsE2EAudio
                 * @property {boolean|null} [supportsE2EDocument] WebdPayload supportsE2EDocument
                 * @property {string|null} [documentTypes] WebdPayload documentTypes
                 * @property {Uint8Array|null} [features] WebdPayload features
                 */

                /**
                 * Constructs a new WebdPayload.
                 * @memberof proto.ClientPayload.WebInfo
                 * @classdesc Represents a WebdPayload.
                 * @implements IWebdPayload
                 * @constructor
                 * @param {proto.ClientPayload.WebInfo.IWebdPayload=} [properties] Properties to set
                 */
                function WebdPayload(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * WebdPayload usesParticipantInKey.
                 * @member {boolean} usesParticipantInKey
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.usesParticipantInKey = false;

                /**
                 * WebdPayload supportsStarredMessages.
                 * @member {boolean} supportsStarredMessages
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsStarredMessages = false;

                /**
                 * WebdPayload supportsDocumentMessages.
                 * @member {boolean} supportsDocumentMessages
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsDocumentMessages = false;

                /**
                 * WebdPayload supportsUrlMessages.
                 * @member {boolean} supportsUrlMessages
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsUrlMessages = false;

                /**
                 * WebdPayload supportsMediaRetry.
                 * @member {boolean} supportsMediaRetry
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsMediaRetry = false;

                /**
                 * WebdPayload supportsE2EImage.
                 * @member {boolean} supportsE2EImage
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsE2EImage = false;

                /**
                 * WebdPayload supportsE2EVideo.
                 * @member {boolean} supportsE2EVideo
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsE2EVideo = false;

                /**
                 * WebdPayload supportsE2EAudio.
                 * @member {boolean} supportsE2EAudio
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsE2EAudio = false;

                /**
                 * WebdPayload supportsE2EDocument.
                 * @member {boolean} supportsE2EDocument
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.supportsE2EDocument = false;

                /**
                 * WebdPayload documentTypes.
                 * @member {string} documentTypes
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.documentTypes = "";

                /**
                 * WebdPayload features.
                 * @member {Uint8Array} features
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 */
                WebdPayload.prototype.features = $util.newBuffer([]);

                /**
                 * Creates a new WebdPayload instance using the specified properties.
                 * @function create
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {proto.ClientPayload.WebInfo.IWebdPayload=} [properties] Properties to set
                 * @returns {proto.ClientPayload.WebInfo.WebdPayload} WebdPayload instance
                 */
                WebdPayload.create = function create(properties) {
                    return new WebdPayload(properties);
                };

                /**
                 * Encodes the specified WebdPayload message. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @function encode
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {proto.ClientPayload.WebInfo.IWebdPayload} message WebdPayload message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WebdPayload.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.usesParticipantInKey != null && Object.hasOwnProperty.call(message, "usesParticipantInKey"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.usesParticipantInKey);
                    if (message.supportsStarredMessages != null && Object.hasOwnProperty.call(message, "supportsStarredMessages"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.supportsStarredMessages);
                    if (message.supportsDocumentMessages != null && Object.hasOwnProperty.call(message, "supportsDocumentMessages"))
                        writer.uint32(/* id 3, wireType 0 =*/24).bool(message.supportsDocumentMessages);
                    if (message.supportsUrlMessages != null && Object.hasOwnProperty.call(message, "supportsUrlMessages"))
                        writer.uint32(/* id 4, wireType 0 =*/32).bool(message.supportsUrlMessages);
                    if (message.supportsMediaRetry != null && Object.hasOwnProperty.call(message, "supportsMediaRetry"))
                        writer.uint32(/* id 5, wireType 0 =*/40).bool(message.supportsMediaRetry);
                    if (message.supportsE2EImage != null && Object.hasOwnProperty.call(message, "supportsE2EImage"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.supportsE2EImage);
                    if (message.supportsE2EVideo != null && Object.hasOwnProperty.call(message, "supportsE2EVideo"))
                        writer.uint32(/* id 7, wireType 0 =*/56).bool(message.supportsE2EVideo);
                    if (message.supportsE2EAudio != null && Object.hasOwnProperty.call(message, "supportsE2EAudio"))
                        writer.uint32(/* id 8, wireType 0 =*/64).bool(message.supportsE2EAudio);
                    if (message.supportsE2EDocument != null && Object.hasOwnProperty.call(message, "supportsE2EDocument"))
                        writer.uint32(/* id 9, wireType 0 =*/72).bool(message.supportsE2EDocument);
                    if (message.documentTypes != null && Object.hasOwnProperty.call(message, "documentTypes"))
                        writer.uint32(/* id 10, wireType 2 =*/82).string(message.documentTypes);
                    if (message.features != null && Object.hasOwnProperty.call(message, "features"))
                        writer.uint32(/* id 11, wireType 2 =*/90).bytes(message.features);
                    return writer;
                };

                /**
                 * Encodes the specified WebdPayload message, length delimited. Does not implicitly {@link proto.ClientPayload.WebInfo.WebdPayload.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {proto.ClientPayload.WebInfo.IWebdPayload} message WebdPayload message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                WebdPayload.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer.
                 * @function decode
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {proto.ClientPayload.WebInfo.WebdPayload} WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WebdPayload.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.usesParticipantInKey = reader.bool();
                            break;
                        case 2:
                            message.supportsStarredMessages = reader.bool();
                            break;
                        case 3:
                            message.supportsDocumentMessages = reader.bool();
                            break;
                        case 4:
                            message.supportsUrlMessages = reader.bool();
                            break;
                        case 5:
                            message.supportsMediaRetry = reader.bool();
                            break;
                        case 6:
                            message.supportsE2EImage = reader.bool();
                            break;
                        case 7:
                            message.supportsE2EVideo = reader.bool();
                            break;
                        case 8:
                            message.supportsE2EAudio = reader.bool();
                            break;
                        case 9:
                            message.supportsE2EDocument = reader.bool();
                            break;
                        case 10:
                            message.documentTypes = reader.string();
                            break;
                        case 11:
                            message.features = reader.bytes();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a WebdPayload message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {proto.ClientPayload.WebInfo.WebdPayload} WebdPayload
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                WebdPayload.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a WebdPayload message.
                 * @function verify
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                WebdPayload.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.usesParticipantInKey != null && message.hasOwnProperty("usesParticipantInKey"))
                        if (typeof message.usesParticipantInKey !== "boolean")
                            return "usesParticipantInKey: boolean expected";
                    if (message.supportsStarredMessages != null && message.hasOwnProperty("supportsStarredMessages"))
                        if (typeof message.supportsStarredMessages !== "boolean")
                            return "supportsStarredMessages: boolean expected";
                    if (message.supportsDocumentMessages != null && message.hasOwnProperty("supportsDocumentMessages"))
                        if (typeof message.supportsDocumentMessages !== "boolean")
                            return "supportsDocumentMessages: boolean expected";
                    if (message.supportsUrlMessages != null && message.hasOwnProperty("supportsUrlMessages"))
                        if (typeof message.supportsUrlMessages !== "boolean")
                            return "supportsUrlMessages: boolean expected";
                    if (message.supportsMediaRetry != null && message.hasOwnProperty("supportsMediaRetry"))
                        if (typeof message.supportsMediaRetry !== "boolean")
                            return "supportsMediaRetry: boolean expected";
                    if (message.supportsE2EImage != null && message.hasOwnProperty("supportsE2EImage"))
                        if (typeof message.supportsE2EImage !== "boolean")
                            return "supportsE2EImage: boolean expected";
                    if (message.supportsE2EVideo != null && message.hasOwnProperty("supportsE2EVideo"))
                        if (typeof message.supportsE2EVideo !== "boolean")
                            return "supportsE2EVideo: boolean expected";
                    if (message.supportsE2EAudio != null && message.hasOwnProperty("supportsE2EAudio"))
                        if (typeof message.supportsE2EAudio !== "boolean")
                            return "supportsE2EAudio: boolean expected";
                    if (message.supportsE2EDocument != null && message.hasOwnProperty("supportsE2EDocument"))
                        if (typeof message.supportsE2EDocument !== "boolean")
                            return "supportsE2EDocument: boolean expected";
                    if (message.documentTypes != null && message.hasOwnProperty("documentTypes"))
                        if (!$util.isString(message.documentTypes))
                            return "documentTypes: string expected";
                    if (message.features != null && message.hasOwnProperty("features"))
                        if (!(message.features && typeof message.features.length === "number" || $util.isString(message.features)))
                            return "features: buffer expected";
                    return null;
                };

                /**
                 * Creates a WebdPayload message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {proto.ClientPayload.WebInfo.WebdPayload} WebdPayload
                 */
                WebdPayload.fromObject = function fromObject(object) {
                    if (object instanceof $root.proto.ClientPayload.WebInfo.WebdPayload)
                        return object;
                    var message = new $root.proto.ClientPayload.WebInfo.WebdPayload();
                    if (object.usesParticipantInKey != null)
                        message.usesParticipantInKey = Boolean(object.usesParticipantInKey);
                    if (object.supportsStarredMessages != null)
                        message.supportsStarredMessages = Boolean(object.supportsStarredMessages);
                    if (object.supportsDocumentMessages != null)
                        message.supportsDocumentMessages = Boolean(object.supportsDocumentMessages);
                    if (object.supportsUrlMessages != null)
                        message.supportsUrlMessages = Boolean(object.supportsUrlMessages);
                    if (object.supportsMediaRetry != null)
                        message.supportsMediaRetry = Boolean(object.supportsMediaRetry);
                    if (object.supportsE2EImage != null)
                        message.supportsE2EImage = Boolean(object.supportsE2EImage);
                    if (object.supportsE2EVideo != null)
                        message.supportsE2EVideo = Boolean(object.supportsE2EVideo);
                    if (object.supportsE2EAudio != null)
                        message.supportsE2EAudio = Boolean(object.supportsE2EAudio);
                    if (object.supportsE2EDocument != null)
                        message.supportsE2EDocument = Boolean(object.supportsE2EDocument);
                    if (object.documentTypes != null)
                        message.documentTypes = String(object.documentTypes);
                    if (object.features != null)
                        if (typeof object.features === "string")
                            $util.base64.decode(object.features, message.features = $util.newBuffer($util.base64.length(object.features)), 0);
                        else if (object.features.length)
                            message.features = object.features;
                    return message;
                };

                /**
                 * Creates a plain object from a WebdPayload message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @static
                 * @param {proto.ClientPayload.WebInfo.WebdPayload} message WebdPayload
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                WebdPayload.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.usesParticipantInKey = false;
                        object.supportsStarredMessages = false;
                        object.supportsDocumentMessages = false;
                        object.supportsUrlMessages = false;
                        object.supportsMediaRetry = false;
                        object.supportsE2EImage = false;
                        object.supportsE2EVideo = false;
                        object.supportsE2EAudio = false;
                        object.supportsE2EDocument = false;
                        object.documentTypes = "";
                        if (options.bytes === String)
                            object.features = "";
                        else {
                            object.features = [];
                            if (options.bytes !== Array)
                                object.features = $util.newBuffer(object.features);
                        }
                    }
                    if (message.usesParticipantInKey != null && message.hasOwnProperty("usesParticipantInKey"))
                        object.usesParticipantInKey = message.usesParticipantInKey;
                    if (message.supportsStarredMessages != null && message.hasOwnProperty("supportsStarredMessages"))
                        object.supportsStarredMessages = message.supportsStarredMessages;
                    if (message.supportsDocumentMessages != null && message.hasOwnProperty("supportsDocumentMessages"))
                        object.supportsDocumentMessages = message.supportsDocumentMessages;
                    if (message.supportsUrlMessages != null && message.hasOwnProperty("supportsUrlMessages"))
                        object.supportsUrlMessages = message.supportsUrlMessages;
                    if (message.supportsMediaRetry != null && message.hasOwnProperty("supportsMediaRetry"))
                        object.supportsMediaRetry = message.supportsMediaRetry;
                    if (message.supportsE2EImage != null && message.hasOwnProperty("supportsE2EImage"))
                        object.supportsE2EImage = message.supportsE2EImage;
                    if (message.supportsE2EVideo != null && message.hasOwnProperty("supportsE2EVideo"))
                        object.supportsE2EVideo = message.supportsE2EVideo;
                    if (message.supportsE2EAudio != null && message.hasOwnProperty("supportsE2EAudio"))
                        object.supportsE2EAudio = message.supportsE2EAudio;
                    if (message.supportsE2EDocument != null && message.hasOwnProperty("supportsE2EDocument"))
                        object.supportsE2EDocument = message.supportsE2EDocument;
                    if (message.documentTypes != null && message.hasOwnProperty("documentTypes"))
                        object.documentTypes = message.documentTypes;
                    if (message.features != null && message.hasOwnProperty("features"))
                        object.features = options.bytes === String ? $util.base64.encode(message.features, 0, message.features.length) : options.bytes === Array ? Array.prototype.slice.call(message.features) : message.features;
                    return object;
                };

                /**
                 * Converts this WebdPayload to JSON.
                 * @function toJSON
                 * @memberof proto.ClientPayload.WebInfo.WebdPayload
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                WebdPayload.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return WebdPayload;
            })();

            return WebInfo;
        })();

        return ClientPayload;
    })();

    proto.ContextInfo = (function() {

        /**
         * Properties of a ContextInfo.
         * @memberof proto
         * @interface IContextInfo
         * @property {string|null} [stanzaId] ContextInfo stanzaId
         * @property {string|null} [participant] ContextInfo participant
         * @property {proto.IMessage|null} [quotedMessage] ContextInfo quotedMessage
         * @property {string|null} [remoteJid] ContextInfo remoteJid
         * @property {Array.<string>|null} [mentionedJid] ContextInfo mentionedJid
         * @property {string|null} [conversionSource] ContextInfo conversionSource
         * @property {Uint8Array|null} [conversionData] ContextInfo conversionData
         * @property {number|null} [conversionDelaySeconds] ContextInfo conversionDelaySeconds
         * @property {number|null} [forwardingScore] ContextInfo forwardingScore
         * @property {boolean|null} [isForwarded] ContextInfo isForwarded
         * @property {proto.ContextInfo.IAdReplyInfo|null} [quotedAd] ContextInfo quotedAd
         * @property {proto.IMessageKey|null} [placeholderKey] ContextInfo placeholderKey
         * @property {number|null} [expiration] ContextInfo expiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] ContextInfo ephemeralSettingTimestamp
         * @property {Uint8Array|null} [ephemeralSharedSecret] ContextInfo ephemeralSharedSecret
         * @property {proto.ContextInfo.IExternalAdReplyInfo|null} [externalAdReply] ContextInfo externalAdReply
         * @property {string|null} [entryPointConversionSource] ContextInfo entryPointConversionSource
         * @property {string|null} [entryPointConversionApp] ContextInfo entryPointConversionApp
         * @property {number|null} [entryPointConversionDelaySeconds] ContextInfo entryPointConversionDelaySeconds
         * @property {proto.IDisappearingMode|null} [disappearingMode] ContextInfo disappearingMode
         * @property {proto.IActionLink|null} [actionLink] ContextInfo actionLink
         * @property {string|null} [groupSubject] ContextInfo groupSubject
         * @property {string|null} [parentGroupJid] ContextInfo parentGroupJid
         * @property {string|null} [trustBannerType] ContextInfo trustBannerType
         * @property {number|null} [trustBannerAction] ContextInfo trustBannerAction
         */

        /**
         * Constructs a new ContextInfo.
         * @memberof proto
         * @classdesc Represents a ContextInfo.
         * @implements IContextInfo
         * @constructor
         * @param {proto.IContextInfo=} [properties] Properties to set
         */
        function ContextInfo(properties) {
            this.mentionedJid = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ContextInfo stanzaId.
         * @member {string} stanzaId
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.stanzaId = "";

        /**
         * ContextInfo participant.
         * @member {string} participant
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.participant = "";

        /**
         * ContextInfo quotedMessage.
         * @member {proto.IMessage|null|undefined} quotedMessage
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedMessage = null;

        /**
         * ContextInfo remoteJid.
         * @member {string} remoteJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.remoteJid = "";

        /**
         * ContextInfo mentionedJid.
         * @member {Array.<string>} mentionedJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.mentionedJid = $util.emptyArray;

        /**
         * ContextInfo conversionSource.
         * @member {string} conversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionSource = "";

        /**
         * ContextInfo conversionData.
         * @member {Uint8Array} conversionData
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionData = $util.newBuffer([]);

        /**
         * ContextInfo conversionDelaySeconds.
         * @member {number} conversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.conversionDelaySeconds = 0;

        /**
         * ContextInfo forwardingScore.
         * @member {number} forwardingScore
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.forwardingScore = 0;

        /**
         * ContextInfo isForwarded.
         * @member {boolean} isForwarded
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.isForwarded = false;

        /**
         * ContextInfo quotedAd.
         * @member {proto.ContextInfo.IAdReplyInfo|null|undefined} quotedAd
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.quotedAd = null;

        /**
         * ContextInfo placeholderKey.
         * @member {proto.IMessageKey|null|undefined} placeholderKey
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.placeholderKey = null;

        /**
         * ContextInfo expiration.
         * @member {number} expiration
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.expiration = 0;

        /**
         * ContextInfo ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * ContextInfo ephemeralSharedSecret.
         * @member {Uint8Array} ephemeralSharedSecret
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.ephemeralSharedSecret = $util.newBuffer([]);

        /**
         * ContextInfo externalAdReply.
         * @member {proto.ContextInfo.IExternalAdReplyInfo|null|undefined} externalAdReply
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.externalAdReply = null;

        /**
         * ContextInfo entryPointConversionSource.
         * @member {string} entryPointConversionSource
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionSource = "";

        /**
         * ContextInfo entryPointConversionApp.
         * @member {string} entryPointConversionApp
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionApp = "";

        /**
         * ContextInfo entryPointConversionDelaySeconds.
         * @member {number} entryPointConversionDelaySeconds
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.entryPointConversionDelaySeconds = 0;

        /**
         * ContextInfo disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.disappearingMode = null;

        /**
         * ContextInfo actionLink.
         * @member {proto.IActionLink|null|undefined} actionLink
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.actionLink = null;

        /**
         * ContextInfo groupSubject.
         * @member {string} groupSubject
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.groupSubject = "";

        /**
         * ContextInfo parentGroupJid.
         * @member {string} parentGroupJid
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.parentGroupJid = "";

        /**
         * ContextInfo trustBannerType.
         * @member {string} trustBannerType
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.trustBannerType = "";

        /**
         * ContextInfo trustBannerAction.
         * @member {number} trustBannerAction
         * @memberof proto.ContextInfo
         * @instance
         */
        ContextInfo.prototype.trustBannerAction = 0;

        /**
         * Creates a new ContextInfo instance using the specified properties.
         * @function create
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo=} [properties] Properties to set
         * @returns {proto.ContextInfo} ContextInfo instance
         */
        ContextInfo.create = function create(properties) {
            return new ContextInfo(properties);
        };

        /**
         * Encodes the specified ContextInfo message. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encode
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            if (message.participant != null && Object.hasOwnProperty.call(message, "participant"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.participant);
            if (message.quotedMessage != null && Object.hasOwnProperty.call(message, "quotedMessage"))
                $root.proto.Message.encode(message.quotedMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.remoteJid != null && Object.hasOwnProperty.call(message, "remoteJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.remoteJid);
            if (message.mentionedJid != null && message.mentionedJid.length)
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    writer.uint32(/* id 15, wireType 2 =*/122).string(message.mentionedJid[i]);
            if (message.conversionSource != null && Object.hasOwnProperty.call(message, "conversionSource"))
                writer.uint32(/* id 18, wireType 2 =*/146).string(message.conversionSource);
            if (message.conversionData != null && Object.hasOwnProperty.call(message, "conversionData"))
                writer.uint32(/* id 19, wireType 2 =*/154).bytes(message.conversionData);
            if (message.conversionDelaySeconds != null && Object.hasOwnProperty.call(message, "conversionDelaySeconds"))
                writer.uint32(/* id 20, wireType 0 =*/160).uint32(message.conversionDelaySeconds);
            if (message.forwardingScore != null && Object.hasOwnProperty.call(message, "forwardingScore"))
                writer.uint32(/* id 21, wireType 0 =*/168).uint32(message.forwardingScore);
            if (message.isForwarded != null && Object.hasOwnProperty.call(message, "isForwarded"))
                writer.uint32(/* id 22, wireType 0 =*/176).bool(message.isForwarded);
            if (message.quotedAd != null && Object.hasOwnProperty.call(message, "quotedAd"))
                $root.proto.ContextInfo.AdReplyInfo.encode(message.quotedAd, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.placeholderKey != null && Object.hasOwnProperty.call(message, "placeholderKey"))
                $root.proto.MessageKey.encode(message.placeholderKey, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            if (message.expiration != null && Object.hasOwnProperty.call(message, "expiration"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint32(message.expiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 26, wireType 0 =*/208).int64(message.ephemeralSettingTimestamp);
            if (message.ephemeralSharedSecret != null && Object.hasOwnProperty.call(message, "ephemeralSharedSecret"))
                writer.uint32(/* id 27, wireType 2 =*/218).bytes(message.ephemeralSharedSecret);
            if (message.externalAdReply != null && Object.hasOwnProperty.call(message, "externalAdReply"))
                $root.proto.ContextInfo.ExternalAdReplyInfo.encode(message.externalAdReply, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
            if (message.entryPointConversionSource != null && Object.hasOwnProperty.call(message, "entryPointConversionSource"))
                writer.uint32(/* id 29, wireType 2 =*/234).string(message.entryPointConversionSource);
            if (message.entryPointConversionApp != null && Object.hasOwnProperty.call(message, "entryPointConversionApp"))
                writer.uint32(/* id 30, wireType 2 =*/242).string(message.entryPointConversionApp);
            if (message.entryPointConversionDelaySeconds != null && Object.hasOwnProperty.call(message, "entryPointConversionDelaySeconds"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint32(message.entryPointConversionDelaySeconds);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 32, wireType 2 =*/258).fork()).ldelim();
            if (message.actionLink != null && Object.hasOwnProperty.call(message, "actionLink"))
                $root.proto.ActionLink.encode(message.actionLink, writer.uint32(/* id 33, wireType 2 =*/266).fork()).ldelim();
            if (message.groupSubject != null && Object.hasOwnProperty.call(message, "groupSubject"))
                writer.uint32(/* id 34, wireType 2 =*/274).string(message.groupSubject);
            if (message.parentGroupJid != null && Object.hasOwnProperty.call(message, "parentGroupJid"))
                writer.uint32(/* id 35, wireType 2 =*/282).string(message.parentGroupJid);
            if (message.trustBannerType != null && Object.hasOwnProperty.call(message, "trustBannerType"))
                writer.uint32(/* id 37, wireType 2 =*/298).string(message.trustBannerType);
            if (message.trustBannerAction != null && Object.hasOwnProperty.call(message, "trustBannerAction"))
                writer.uint32(/* id 38, wireType 0 =*/304).uint32(message.trustBannerAction);
            return writer;
        };

        /**
         * Encodes the specified ContextInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.IContextInfo} message ContextInfo message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ContextInfo.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContextInfo();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                case 2:
                    message.participant = reader.string();
                    break;
                case 3:
                    message.quotedMessage = $root.proto.Message.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.remoteJid = reader.string();
                    break;
                case 15:
                    if (!(message.mentionedJid && message.mentionedJid.length))
                        message.mentionedJid = [];
                    message.mentionedJid.push(reader.string());
                    break;
                case 18:
                    message.conversionSource = reader.string();
                    break;
                case 19:
                    message.conversionData = reader.bytes();
                    break;
                case 20:
                    message.conversionDelaySeconds = reader.uint32();
                    break;
                case 21:
                    message.forwardingScore = reader.uint32();
                    break;
                case 22:
                    message.isForwarded = reader.bool();
                    break;
                case 23:
                    message.quotedAd = $root.proto.ContextInfo.AdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 24:
                    message.placeholderKey = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                case 25:
                    message.expiration = reader.uint32();
                    break;
                case 26:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 27:
                    message.ephemeralSharedSecret = reader.bytes();
                    break;
                case 28:
                    message.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.decode(reader, reader.uint32());
                    break;
                case 29:
                    message.entryPointConversionSource = reader.string();
                    break;
                case 30:
                    message.entryPointConversionApp = reader.string();
                    break;
                case 31:
                    message.entryPointConversionDelaySeconds = reader.uint32();
                    break;
                case 32:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 33:
                    message.actionLink = $root.proto.ActionLink.decode(reader, reader.uint32());
                    break;
                case 34:
                    message.groupSubject = reader.string();
                    break;
                case 35:
                    message.parentGroupJid = reader.string();
                    break;
                case 37:
                    message.trustBannerType = reader.string();
                    break;
                case 38:
                    message.trustBannerAction = reader.uint32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a ContextInfo message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ContextInfo
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ContextInfo} ContextInfo
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ContextInfo.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a ContextInfo message.
         * @function verify
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ContextInfo.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.participant != null && message.hasOwnProperty("participant"))
                if (!$util.isString(message.participant))
                    return "participant: string expected";
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage")) {
                var error = $root.proto.Message.verify(message.quotedMessage);
                if (error)
                    return "quotedMessage." + error;
            }
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                if (!$util.isString(message.remoteJid))
                    return "remoteJid: string expected";
            if (message.mentionedJid != null && message.hasOwnProperty("mentionedJid")) {
                if (!Array.isArray(message.mentionedJid))
                    return "mentionedJid: array expected";
                for (var i = 0; i < message.mentionedJid.length; ++i)
                    if (!$util.isString(message.mentionedJid[i]))
                        return "mentionedJid: string[] expected";
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                if (!$util.isString(message.conversionSource))
                    return "conversionSource: string expected";
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                if (!(message.conversionData && typeof message.conversionData.length === "number" || $util.isString(message.conversionData)))
                    return "conversionData: buffer expected";
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                if (!$util.isInteger(message.conversionDelaySeconds))
                    return "conversionDelaySeconds: integer expected";
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                if (!$util.isInteger(message.forwardingScore))
                    return "forwardingScore: integer expected";
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                if (typeof message.isForwarded !== "boolean")
                    return "isForwarded: boolean expected";
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd")) {
                var error = $root.proto.ContextInfo.AdReplyInfo.verify(message.quotedAd);
                if (error)
                    return "quotedAd." + error;
            }
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey")) {
                var error = $root.proto.MessageKey.verify(message.placeholderKey);
                if (error)
                    return "placeholderKey." + error;
            }
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                if (!$util.isInteger(message.expiration))
                    return "expiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                if (!(message.ephemeralSharedSecret && typeof message.ephemeralSharedSecret.length === "number" || $util.isString(message.ephemeralSharedSecret)))
                    return "ephemeralSharedSecret: buffer expected";
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply")) {
                var error = $root.proto.ContextInfo.ExternalAdReplyInfo.verify(message.externalAdReply);
                if (error)
                    return "externalAdReply." + error;
            }
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                if (!$util.isString(message.entryPointConversionSource))
                    return "entryPointConversionSource: string expected";
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                if (!$util.isString(message.entryPointConversionApp))
                    return "entryPointConversionApp: string expected";
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                if (!$util.isInteger(message.entryPointConversionDelaySeconds))
                    return "entryPointConversionDelaySeconds: integer expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.actionLink != null && message.hasOwnProperty("actionLink")) {
                var error = $root.proto.ActionLink.verify(message.actionLink);
                if (error)
                    return "actionLink." + error;
            }
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                if (!$util.isString(message.groupSubject))
                    return "groupSubject: string expected";
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                if (!$util.isString(message.parentGroupJid))
                    return "parentGroupJid: string expected";
            if (message.trustBannerType != null && message.hasOwnProperty("trustBannerType"))
                if (!$util.isString(message.trustBannerType))
                    return "trustBannerType: string expected";
            if (message.trustBannerAction != null && message.hasOwnProperty("trustBannerAction"))
                if (!$util.isInteger(message.trustBannerAction))
                    return "trustBannerAction: integer expected";
            return null;
        };

        /**
         * Creates a ContextInfo message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ContextInfo
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ContextInfo} ContextInfo
         */
        ContextInfo.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ContextInfo)
                return object;
            var message = new $root.proto.ContextInfo();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.participant != null)
                message.participant = String(object.participant);
            if (object.quotedMessage != null) {
                if (typeof object.quotedMessage !== "object")
                    throw TypeError(".proto.ContextInfo.quotedMessage: object expected");
                message.quotedMessage = $root.proto.Message.fromObject(object.quotedMessage);
            }
            if (object.remoteJid != null)
                message.remoteJid = String(object.remoteJid);
            if (object.mentionedJid) {
                if (!Array.isArray(object.mentionedJid))
                    throw TypeError(".proto.ContextInfo.mentionedJid: array expected");
                message.mentionedJid = [];
                for (var i = 0; i < object.mentionedJid.length; ++i)
                    message.mentionedJid[i] = String(object.mentionedJid[i]);
            }
            if (object.conversionSource != null)
                message.conversionSource = String(object.conversionSource);
            if (object.conversionData != null)
                if (typeof object.conversionData === "string")
                    $util.base64.decode(object.conversionData, message.conversionData = $util.newBuffer($util.base64.length(object.conversionData)), 0);
                else if (object.conversionData.length)
                    message.conversionData = object.conversionData;
            if (object.conversionDelaySeconds != null)
                message.conversionDelaySeconds = object.conversionDelaySeconds >>> 0;
            if (object.forwardingScore != null)
                message.forwardingScore = object.forwardingScore >>> 0;
            if (object.isForwarded != null)
                message.isForwarded = Boolean(object.isForwarded);
            if (object.quotedAd != null) {
                if (typeof object.quotedAd !== "object")
                    throw TypeError(".proto.ContextInfo.quotedAd: object expected");
                message.quotedAd = $root.proto.ContextInfo.AdReplyInfo.fromObject(object.quotedAd);
            }
            if (object.placeholderKey != null) {
                if (typeof object.placeholderKey !== "object")
                    throw TypeError(".proto.ContextInfo.placeholderKey: object expected");
                message.placeholderKey = $root.proto.MessageKey.fromObject(object.placeholderKey);
            }
            if (object.expiration != null)
                message.expiration = object.expiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            if (object.ephemeralSharedSecret != null)
                if (typeof object.ephemeralSharedSecret === "string")
                    $util.base64.decode(object.ephemeralSharedSecret, message.ephemeralSharedSecret = $util.newBuffer($util.base64.length(object.ephemeralSharedSecret)), 0);
                else if (object.ephemeralSharedSecret.length)
                    message.ephemeralSharedSecret = object.ephemeralSharedSecret;
            if (object.externalAdReply != null) {
                if (typeof object.externalAdReply !== "object")
                    throw TypeError(".proto.ContextInfo.externalAdReply: object expected");
                message.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.fromObject(object.externalAdReply);
            }
            if (object.entryPointConversionSource != null)
                message.entryPointConversionSource = String(object.entryPointConversionSource);
            if (object.entryPointConversionApp != null)
                message.entryPointConversionApp = String(object.entryPointConversionApp);
            if (object.entryPointConversionDelaySeconds != null)
                message.entryPointConversionDelaySeconds = object.entryPointConversionDelaySeconds >>> 0;
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.ContextInfo.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.actionLink != null) {
                if (typeof object.actionLink !== "object")
                    throw TypeError(".proto.ContextInfo.actionLink: object expected");
                message.actionLink = $root.proto.ActionLink.fromObject(object.actionLink);
            }
            if (object.groupSubject != null)
                message.groupSubject = String(object.groupSubject);
            if (object.parentGroupJid != null)
                message.parentGroupJid = String(object.parentGroupJid);
            if (object.trustBannerType != null)
                message.trustBannerType = String(object.trustBannerType);
            if (object.trustBannerAction != null)
                message.trustBannerAction = object.trustBannerAction >>> 0;
            return message;
        };

        /**
         * Creates a plain object from a ContextInfo message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ContextInfo
         * @static
         * @param {proto.ContextInfo} message ContextInfo
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ContextInfo.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.mentionedJid = [];
            if (options.defaults) {
                object.stanzaId = "";
                object.participant = "";
                object.quotedMessage = null;
                object.remoteJid = "";
                object.conversionSource = "";
                if (options.bytes === String)
                    object.conversionData = "";
                else {
                    object.conversionData = [];
                    if (options.bytes !== Array)
                        object.conversionData = $util.newBuffer(object.conversionData);
                }
                object.conversionDelaySeconds = 0;
                object.forwardingScore = 0;
                object.isForwarded = false;
                object.quotedAd = null;
                object.placeholderKey = null;
                object.expiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.ephemeralSharedSecret = "";
                else {
                    object.ephemeralSharedSecret = [];
                    if (options.bytes !== Array)
                        object.ephemeralSharedSecret = $util.newBuffer(object.ephemeralSharedSecret);
                }
                object.externalAdReply = null;
                object.entryPointConversionSource = "";
                object.entryPointConversionApp = "";
                object.entryPointConversionDelaySeconds = 0;
                object.disappearingMode = null;
                object.actionLink = null;
                object.groupSubject = "";
                object.parentGroupJid = "";
                object.trustBannerType = "";
                object.trustBannerAction = 0;
            }
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.participant != null && message.hasOwnProperty("participant"))
                object.participant = message.participant;
            if (message.quotedMessage != null && message.hasOwnProperty("quotedMessage"))
                object.quotedMessage = $root.proto.Message.toObject(message.quotedMessage, options);
            if (message.remoteJid != null && message.hasOwnProperty("remoteJid"))
                object.remoteJid = message.remoteJid;
            if (message.mentionedJid && message.mentionedJid.length) {
                object.mentionedJid = [];
                for (var j = 0; j < message.mentionedJid.length; ++j)
                    object.mentionedJid[j] = message.mentionedJid[j];
            }
            if (message.conversionSource != null && message.hasOwnProperty("conversionSource"))
                object.conversionSource = message.conversionSource;
            if (message.conversionData != null && message.hasOwnProperty("conversionData"))
                object.conversionData = options.bytes === String ? $util.base64.encode(message.conversionData, 0, message.conversionData.length) : options.bytes === Array ? Array.prototype.slice.call(message.conversionData) : message.conversionData;
            if (message.conversionDelaySeconds != null && message.hasOwnProperty("conversionDelaySeconds"))
                object.conversionDelaySeconds = message.conversionDelaySeconds;
            if (message.forwardingScore != null && message.hasOwnProperty("forwardingScore"))
                object.forwardingScore = message.forwardingScore;
            if (message.isForwarded != null && message.hasOwnProperty("isForwarded"))
                object.isForwarded = message.isForwarded;
            if (message.quotedAd != null && message.hasOwnProperty("quotedAd"))
                object.quotedAd = $root.proto.ContextInfo.AdReplyInfo.toObject(message.quotedAd, options);
            if (message.placeholderKey != null && message.hasOwnProperty("placeholderKey"))
                object.placeholderKey = $root.proto.MessageKey.toObject(message.placeholderKey, options);
            if (message.expiration != null && message.hasOwnProperty("expiration"))
                object.expiration = message.expiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.ephemeralSharedSecret != null && message.hasOwnProperty("ephemeralSharedSecret"))
                object.ephemeralSharedSecret = options.bytes === String ? $util.base64.encode(message.ephemeralSharedSecret, 0, message.ephemeralSharedSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeralSharedSecret) : message.ephemeralSharedSecret;
            if (message.externalAdReply != null && message.hasOwnProperty("externalAdReply"))
                object.externalAdReply = $root.proto.ContextInfo.ExternalAdReplyInfo.toObject(message.externalAdReply, options);
            if (message.entryPointConversionSource != null && message.hasOwnProperty("entryPointConversionSource"))
                object.entryPointConversionSource = message.entryPointConversionSource;
            if (message.entryPointConversionApp != null && message.hasOwnProperty("entryPointConversionApp"))
                object.entryPointConversionApp = message.entryPointConversionApp;
            if (message.entryPointConversionDelaySeconds != null && message.hasOwnProperty("entryPointConversionDelaySeconds"))
                object.entryPointConversionDelaySeconds = message.entryPointConversionDelaySeconds;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.actionLink != null && message.hasOwnProperty("actionLink"))
                object.actionLink = $root.proto.ActionLink.toObject(message.actionLink, options);
            if (message.groupSubject != null && message.hasOwnProperty("groupSubject"))
                object.groupSubject = message.groupSubject;
            if (message.parentGroupJid != null && message.hasOwnProperty("parentGroupJid"))
                object.parentGroupJid = message.parentGroupJid;
            if (message.trustBannerType != null && message.hasOwnProperty("trustBannerType"))
                object.trustBannerType = message.trustBannerType;
            if (message.trustBannerAction != null && message.hasOwnProperty("trustBannerAction"))
                object.trustBannerAction = message.trustBannerAction;
            return object;
        };

        /**
         * Converts this ContextInfo to JSON.
         * @function toJSON
         * @memberof proto.ContextInfo
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ContextInfo.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        ContextInfo.AdReplyInfo = (function() {

            /**
             * Properties of an AdReplyInfo.
             * @memberof proto.ContextInfo
             * @interface IAdReplyInfo
             * @property {string|null} [advertiserName] AdReplyInfo advertiserName
             * @property {proto.ContextInfo.AdReplyInfo.MediaType|null} [mediaType] AdReplyInfo mediaType
             * @property {Uint8Array|null} [jpegThumbnail] AdReplyInfo jpegThumbnail
             * @property {string|null} [caption] AdReplyInfo caption
             */

            /**
             * Constructs a new AdReplyInfo.
             * @memberof proto.ContextInfo
             * @classdesc Represents an AdReplyInfo.
             * @implements IAdReplyInfo
             * @constructor
             * @param {proto.ContextInfo.IAdReplyInfo=} [properties] Properties to set
             */
            function AdReplyInfo(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AdReplyInfo advertiserName.
             * @member {string} advertiserName
             * @memberof proto.ContextInfo.AdReplyInfo
             * @instance
             */
            AdReplyInfo.prototype.advertiserName = "";

            /**
             * AdReplyInfo mediaType.
             * @member {proto.ContextInfo.AdReplyInfo.MediaType} mediaType
             * @memberof proto.ContextInfo.AdReplyInfo
             * @instance
             */
            AdReplyInfo.prototype.mediaType = 0;

            /**
             * AdReplyInfo jpegThumbnail.
             * @member {Uint8Array} jpegThumbnail
             * @memberof proto.ContextInfo.AdReplyInfo
             * @instance
             */
            AdReplyInfo.prototype.jpegThumbnail = $util.newBuffer([]);

            /**
             * AdReplyInfo caption.
             * @member {string} caption
             * @memberof proto.ContextInfo.AdReplyInfo
             * @instance
             */
            AdReplyInfo.prototype.caption = "";

            /**
             * Creates a new AdReplyInfo instance using the specified properties.
             * @function create
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {proto.ContextInfo.IAdReplyInfo=} [properties] Properties to set
             * @returns {proto.ContextInfo.AdReplyInfo} AdReplyInfo instance
             */
            AdReplyInfo.create = function create(properties) {
                return new AdReplyInfo(properties);
            };

            /**
             * Encodes the specified AdReplyInfo message. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @function encode
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {proto.ContextInfo.IAdReplyInfo} message AdReplyInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AdReplyInfo.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.advertiserName != null && Object.hasOwnProperty.call(message, "advertiserName"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.advertiserName);
                if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaType);
                if (message.jpegThumbnail != null && Object.hasOwnProperty.call(message, "jpegThumbnail"))
                    writer.uint32(/* id 16, wireType 2 =*/130).bytes(message.jpegThumbnail);
                if (message.caption != null && Object.hasOwnProperty.call(message, "caption"))
                    writer.uint32(/* id 17, wireType 2 =*/138).string(message.caption);
                return writer;
            };

            /**
             * Encodes the specified AdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.AdReplyInfo.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {proto.ContextInfo.IAdReplyInfo} message AdReplyInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ContextInfo.AdReplyInfo} AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AdReplyInfo.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContextInfo.AdReplyInfo();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.advertiserName = reader.string();
                        break;
                    case 2:
                        message.mediaType = reader.int32();
                        break;
                    case 16:
                        message.jpegThumbnail = reader.bytes();
                        break;
                    case 17:
                        message.caption = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an AdReplyInfo message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ContextInfo.AdReplyInfo} AdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an AdReplyInfo message.
             * @function verify
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AdReplyInfo.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                    if (!$util.isString(message.advertiserName))
                        return "advertiserName: string expected";
                if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                    switch (message.mediaType) {
                    default:
                        return "mediaType: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                    if (!(message.jpegThumbnail && typeof message.jpegThumbnail.length === "number" || $util.isString(message.jpegThumbnail)))
                        return "jpegThumbnail: buffer expected";
                if (message.caption != null && message.hasOwnProperty("caption"))
                    if (!$util.isString(message.caption))
                        return "caption: string expected";
                return null;
            };

            /**
             * Creates an AdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ContextInfo.AdReplyInfo} AdReplyInfo
             */
            AdReplyInfo.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ContextInfo.AdReplyInfo)
                    return object;
                var message = new $root.proto.ContextInfo.AdReplyInfo();
                if (object.advertiserName != null)
                    message.advertiserName = String(object.advertiserName);
                switch (object.mediaType) {
                case "NONE":
                case 0:
                    message.mediaType = 0;
                    break;
                case "IMAGE":
                case 1:
                    message.mediaType = 1;
                    break;
                case "VIDEO":
                case 2:
                    message.mediaType = 2;
                    break;
                }
                if (object.jpegThumbnail != null)
                    if (typeof object.jpegThumbnail === "string")
                        $util.base64.decode(object.jpegThumbnail, message.jpegThumbnail = $util.newBuffer($util.base64.length(object.jpegThumbnail)), 0);
                    else if (object.jpegThumbnail.length)
                        message.jpegThumbnail = object.jpegThumbnail;
                if (object.caption != null)
                    message.caption = String(object.caption);
                return message;
            };

            /**
             * Creates a plain object from an AdReplyInfo message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ContextInfo.AdReplyInfo
             * @static
             * @param {proto.ContextInfo.AdReplyInfo} message AdReplyInfo
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AdReplyInfo.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.advertiserName = "";
                    object.mediaType = options.enums === String ? "NONE" : 0;
                    if (options.bytes === String)
                        object.jpegThumbnail = "";
                    else {
                        object.jpegThumbnail = [];
                        if (options.bytes !== Array)
                            object.jpegThumbnail = $util.newBuffer(object.jpegThumbnail);
                    }
                    object.caption = "";
                }
                if (message.advertiserName != null && message.hasOwnProperty("advertiserName"))
                    object.advertiserName = message.advertiserName;
                if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                    object.mediaType = options.enums === String ? $root.proto.ContextInfo.AdReplyInfo.MediaType[message.mediaType] : message.mediaType;
                if (message.jpegThumbnail != null && message.hasOwnProperty("jpegThumbnail"))
                    object.jpegThumbnail = options.bytes === String ? $util.base64.encode(message.jpegThumbnail, 0, message.jpegThumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.jpegThumbnail) : message.jpegThumbnail;
                if (message.caption != null && message.hasOwnProperty("caption"))
                    object.caption = message.caption;
                return object;
            };

            /**
             * Converts this AdReplyInfo to JSON.
             * @function toJSON
             * @memberof proto.ContextInfo.AdReplyInfo
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AdReplyInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * MediaType enum.
             * @name proto.ContextInfo.AdReplyInfo.MediaType
             * @enum {number}
             * @property {number} NONE=0 NONE value
             * @property {number} IMAGE=1 IMAGE value
             * @property {number} VIDEO=2 VIDEO value
             */
            AdReplyInfo.MediaType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return AdReplyInfo;
        })();

        ContextInfo.ExternalAdReplyInfo = (function() {

            /**
             * Properties of an ExternalAdReplyInfo.
             * @memberof proto.ContextInfo
             * @interface IExternalAdReplyInfo
             * @property {string|null} [title] ExternalAdReplyInfo title
             * @property {string|null} [body] ExternalAdReplyInfo body
             * @property {proto.ContextInfo.ExternalAdReplyInfo.MediaType|null} [mediaType] ExternalAdReplyInfo mediaType
             * @property {string|null} [thumbnailUrl] ExternalAdReplyInfo thumbnailUrl
             * @property {string|null} [mediaUrl] ExternalAdReplyInfo mediaUrl
             * @property {Uint8Array|null} [thumbnail] ExternalAdReplyInfo thumbnail
             * @property {string|null} [sourceType] ExternalAdReplyInfo sourceType
             * @property {string|null} [sourceId] ExternalAdReplyInfo sourceId
             * @property {string|null} [sourceUrl] ExternalAdReplyInfo sourceUrl
             * @property {boolean|null} [containsAutoReply] ExternalAdReplyInfo containsAutoReply
             * @property {boolean|null} [renderLargerThumbnail] ExternalAdReplyInfo renderLargerThumbnail
             * @property {boolean|null} [showAdAttribution] ExternalAdReplyInfo showAdAttribution
             * @property {string|null} [ctwaClid] ExternalAdReplyInfo ctwaClid
             */

            /**
             * Constructs a new ExternalAdReplyInfo.
             * @memberof proto.ContextInfo
             * @classdesc Represents an ExternalAdReplyInfo.
             * @implements IExternalAdReplyInfo
             * @constructor
             * @param {proto.ContextInfo.IExternalAdReplyInfo=} [properties] Properties to set
             */
            function ExternalAdReplyInfo(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ExternalAdReplyInfo title.
             * @member {string} title
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.title = "";

            /**
             * ExternalAdReplyInfo body.
             * @member {string} body
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.body = "";

            /**
             * ExternalAdReplyInfo mediaType.
             * @member {proto.ContextInfo.ExternalAdReplyInfo.MediaType} mediaType
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.mediaType = 0;

            /**
             * ExternalAdReplyInfo thumbnailUrl.
             * @member {string} thumbnailUrl
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.thumbnailUrl = "";

            /**
             * ExternalAdReplyInfo mediaUrl.
             * @member {string} mediaUrl
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.mediaUrl = "";

            /**
             * ExternalAdReplyInfo thumbnail.
             * @member {Uint8Array} thumbnail
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.thumbnail = $util.newBuffer([]);

            /**
             * ExternalAdReplyInfo sourceType.
             * @member {string} sourceType
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.sourceType = "";

            /**
             * ExternalAdReplyInfo sourceId.
             * @member {string} sourceId
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.sourceId = "";

            /**
             * ExternalAdReplyInfo sourceUrl.
             * @member {string} sourceUrl
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.sourceUrl = "";

            /**
             * ExternalAdReplyInfo containsAutoReply.
             * @member {boolean} containsAutoReply
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.containsAutoReply = false;

            /**
             * ExternalAdReplyInfo renderLargerThumbnail.
             * @member {boolean} renderLargerThumbnail
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.renderLargerThumbnail = false;

            /**
             * ExternalAdReplyInfo showAdAttribution.
             * @member {boolean} showAdAttribution
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.showAdAttribution = false;

            /**
             * ExternalAdReplyInfo ctwaClid.
             * @member {string} ctwaClid
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             */
            ExternalAdReplyInfo.prototype.ctwaClid = "";

            /**
             * Creates a new ExternalAdReplyInfo instance using the specified properties.
             * @function create
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {proto.ContextInfo.IExternalAdReplyInfo=} [properties] Properties to set
             * @returns {proto.ContextInfo.ExternalAdReplyInfo} ExternalAdReplyInfo instance
             */
            ExternalAdReplyInfo.create = function create(properties) {
                return new ExternalAdReplyInfo(properties);
            };

            /**
             * Encodes the specified ExternalAdReplyInfo message. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @function encode
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {proto.ContextInfo.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ExternalAdReplyInfo.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.title != null && Object.hasOwnProperty.call(message, "title"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.title);
                if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.body);
                if (message.mediaType != null && Object.hasOwnProperty.call(message, "mediaType"))
                    writer.uint32(/* id 3, wireType 0 =*/24).int32(message.mediaType);
                if (message.thumbnailUrl != null && Object.hasOwnProperty.call(message, "thumbnailUrl"))
                    writer.uint32(/* id 4, wireType 2 =*/34).string(message.thumbnailUrl);
                if (message.mediaUrl != null && Object.hasOwnProperty.call(message, "mediaUrl"))
                    writer.uint32(/* id 5, wireType 2 =*/42).string(message.mediaUrl);
                if (message.thumbnail != null && Object.hasOwnProperty.call(message, "thumbnail"))
                    writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.thumbnail);
                if (message.sourceType != null && Object.hasOwnProperty.call(message, "sourceType"))
                    writer.uint32(/* id 7, wireType 2 =*/58).string(message.sourceType);
                if (message.sourceId != null && Object.hasOwnProperty.call(message, "sourceId"))
                    writer.uint32(/* id 8, wireType 2 =*/66).string(message.sourceId);
                if (message.sourceUrl != null && Object.hasOwnProperty.call(message, "sourceUrl"))
                    writer.uint32(/* id 9, wireType 2 =*/74).string(message.sourceUrl);
                if (message.containsAutoReply != null && Object.hasOwnProperty.call(message, "containsAutoReply"))
                    writer.uint32(/* id 10, wireType 0 =*/80).bool(message.containsAutoReply);
                if (message.renderLargerThumbnail != null && Object.hasOwnProperty.call(message, "renderLargerThumbnail"))
                    writer.uint32(/* id 11, wireType 0 =*/88).bool(message.renderLargerThumbnail);
                if (message.showAdAttribution != null && Object.hasOwnProperty.call(message, "showAdAttribution"))
                    writer.uint32(/* id 12, wireType 0 =*/96).bool(message.showAdAttribution);
                if (message.ctwaClid != null && Object.hasOwnProperty.call(message, "ctwaClid"))
                    writer.uint32(/* id 13, wireType 2 =*/106).string(message.ctwaClid);
                return writer;
            };

            /**
             * Encodes the specified ExternalAdReplyInfo message, length delimited. Does not implicitly {@link proto.ContextInfo.ExternalAdReplyInfo.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {proto.ContextInfo.IExternalAdReplyInfo} message ExternalAdReplyInfo message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ExternalAdReplyInfo.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer.
             * @function decode
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.ContextInfo.ExternalAdReplyInfo} ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ExternalAdReplyInfo.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.title = reader.string();
                        break;
                    case 2:
                        message.body = reader.string();
                        break;
                    case 3:
                        message.mediaType = reader.int32();
                        break;
                    case 4:
                        message.thumbnailUrl = reader.string();
                        break;
                    case 5:
                        message.mediaUrl = reader.string();
                        break;
                    case 6:
                        message.thumbnail = reader.bytes();
                        break;
                    case 7:
                        message.sourceType = reader.string();
                        break;
                    case 8:
                        message.sourceId = reader.string();
                        break;
                    case 9:
                        message.sourceUrl = reader.string();
                        break;
                    case 10:
                        message.containsAutoReply = reader.bool();
                        break;
                    case 11:
                        message.renderLargerThumbnail = reader.bool();
                        break;
                    case 12:
                        message.showAdAttribution = reader.bool();
                        break;
                    case 13:
                        message.ctwaClid = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an ExternalAdReplyInfo message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.ContextInfo.ExternalAdReplyInfo} ExternalAdReplyInfo
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ExternalAdReplyInfo.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an ExternalAdReplyInfo message.
             * @function verify
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ExternalAdReplyInfo.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.title != null && message.hasOwnProperty("title"))
                    if (!$util.isString(message.title))
                        return "title: string expected";
                if (message.body != null && message.hasOwnProperty("body"))
                    if (!$util.isString(message.body))
                        return "body: string expected";
                if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                    switch (message.mediaType) {
                    default:
                        return "mediaType: enum value expected";
                    case 0:
                    case 1:
                    case 2:
                        break;
                    }
                if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                    if (!$util.isString(message.thumbnailUrl))
                        return "thumbnailUrl: string expected";
                if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                    if (!$util.isString(message.mediaUrl))
                        return "mediaUrl: string expected";
                if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                    if (!(message.thumbnail && typeof message.thumbnail.length === "number" || $util.isString(message.thumbnail)))
                        return "thumbnail: buffer expected";
                if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                    if (!$util.isString(message.sourceType))
                        return "sourceType: string expected";
                if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                    if (!$util.isString(message.sourceId))
                        return "sourceId: string expected";
                if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                    if (!$util.isString(message.sourceUrl))
                        return "sourceUrl: string expected";
                if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                    if (typeof message.containsAutoReply !== "boolean")
                        return "containsAutoReply: boolean expected";
                if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                    if (typeof message.renderLargerThumbnail !== "boolean")
                        return "renderLargerThumbnail: boolean expected";
                if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                    if (typeof message.showAdAttribution !== "boolean")
                        return "showAdAttribution: boolean expected";
                if (message.ctwaClid != null && message.hasOwnProperty("ctwaClid"))
                    if (!$util.isString(message.ctwaClid))
                        return "ctwaClid: string expected";
                return null;
            };

            /**
             * Creates an ExternalAdReplyInfo message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.ContextInfo.ExternalAdReplyInfo} ExternalAdReplyInfo
             */
            ExternalAdReplyInfo.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.ContextInfo.ExternalAdReplyInfo)
                    return object;
                var message = new $root.proto.ContextInfo.ExternalAdReplyInfo();
                if (object.title != null)
                    message.title = String(object.title);
                if (object.body != null)
                    message.body = String(object.body);
                switch (object.mediaType) {
                case "NONE":
                case 0:
                    message.mediaType = 0;
                    break;
                case "IMAGE":
                case 1:
                    message.mediaType = 1;
                    break;
                case "VIDEO":
                case 2:
                    message.mediaType = 2;
                    break;
                }
                if (object.thumbnailUrl != null)
                    message.thumbnailUrl = String(object.thumbnailUrl);
                if (object.mediaUrl != null)
                    message.mediaUrl = String(object.mediaUrl);
                if (object.thumbnail != null)
                    if (typeof object.thumbnail === "string")
                        $util.base64.decode(object.thumbnail, message.thumbnail = $util.newBuffer($util.base64.length(object.thumbnail)), 0);
                    else if (object.thumbnail.length)
                        message.thumbnail = object.thumbnail;
                if (object.sourceType != null)
                    message.sourceType = String(object.sourceType);
                if (object.sourceId != null)
                    message.sourceId = String(object.sourceId);
                if (object.sourceUrl != null)
                    message.sourceUrl = String(object.sourceUrl);
                if (object.containsAutoReply != null)
                    message.containsAutoReply = Boolean(object.containsAutoReply);
                if (object.renderLargerThumbnail != null)
                    message.renderLargerThumbnail = Boolean(object.renderLargerThumbnail);
                if (object.showAdAttribution != null)
                    message.showAdAttribution = Boolean(object.showAdAttribution);
                if (object.ctwaClid != null)
                    message.ctwaClid = String(object.ctwaClid);
                return message;
            };

            /**
             * Creates a plain object from an ExternalAdReplyInfo message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @static
             * @param {proto.ContextInfo.ExternalAdReplyInfo} message ExternalAdReplyInfo
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ExternalAdReplyInfo.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.title = "";
                    object.body = "";
                    object.mediaType = options.enums === String ? "NONE" : 0;
                    object.thumbnailUrl = "";
                    object.mediaUrl = "";
                    if (options.bytes === String)
                        object.thumbnail = "";
                    else {
                        object.thumbnail = [];
                        if (options.bytes !== Array)
                            object.thumbnail = $util.newBuffer(object.thumbnail);
                    }
                    object.sourceType = "";
                    object.sourceId = "";
                    object.sourceUrl = "";
                    object.containsAutoReply = false;
                    object.renderLargerThumbnail = false;
                    object.showAdAttribution = false;
                    object.ctwaClid = "";
                }
                if (message.title != null && message.hasOwnProperty("title"))
                    object.title = message.title;
                if (message.body != null && message.hasOwnProperty("body"))
                    object.body = message.body;
                if (message.mediaType != null && message.hasOwnProperty("mediaType"))
                    object.mediaType = options.enums === String ? $root.proto.ContextInfo.ExternalAdReplyInfo.MediaType[message.mediaType] : message.mediaType;
                if (message.thumbnailUrl != null && message.hasOwnProperty("thumbnailUrl"))
                    object.thumbnailUrl = message.thumbnailUrl;
                if (message.mediaUrl != null && message.hasOwnProperty("mediaUrl"))
                    object.mediaUrl = message.mediaUrl;
                if (message.thumbnail != null && message.hasOwnProperty("thumbnail"))
                    object.thumbnail = options.bytes === String ? $util.base64.encode(message.thumbnail, 0, message.thumbnail.length) : options.bytes === Array ? Array.prototype.slice.call(message.thumbnail) : message.thumbnail;
                if (message.sourceType != null && message.hasOwnProperty("sourceType"))
                    object.sourceType = message.sourceType;
                if (message.sourceId != null && message.hasOwnProperty("sourceId"))
                    object.sourceId = message.sourceId;
                if (message.sourceUrl != null && message.hasOwnProperty("sourceUrl"))
                    object.sourceUrl = message.sourceUrl;
                if (message.containsAutoReply != null && message.hasOwnProperty("containsAutoReply"))
                    object.containsAutoReply = message.containsAutoReply;
                if (message.renderLargerThumbnail != null && message.hasOwnProperty("renderLargerThumbnail"))
                    object.renderLargerThumbnail = message.renderLargerThumbnail;
                if (message.showAdAttribution != null && message.hasOwnProperty("showAdAttribution"))
                    object.showAdAttribution = message.showAdAttribution;
                if (message.ctwaClid != null && message.hasOwnProperty("ctwaClid"))
                    object.ctwaClid = message.ctwaClid;
                return object;
            };

            /**
             * Converts this ExternalAdReplyInfo to JSON.
             * @function toJSON
             * @memberof proto.ContextInfo.ExternalAdReplyInfo
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ExternalAdReplyInfo.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            /**
             * MediaType enum.
             * @name proto.ContextInfo.ExternalAdReplyInfo.MediaType
             * @enum {number}
             * @property {number} NONE=0 NONE value
             * @property {number} IMAGE=1 IMAGE value
             * @property {number} VIDEO=2 VIDEO value
             */
            ExternalAdReplyInfo.MediaType = (function() {
                var valuesById = {}, values = Object.create(valuesById);
                values[valuesById[0] = "NONE"] = 0;
                values[valuesById[1] = "IMAGE"] = 1;
                values[valuesById[2] = "VIDEO"] = 2;
                return values;
            })();

            return ExternalAdReplyInfo;
        })();

        return ContextInfo;
    })();

    proto.Conversation = (function() {

        /**
         * Properties of a Conversation.
         * @memberof proto
         * @interface IConversation
         * @property {string} id Conversation id
         * @property {Array.<proto.IHistorySyncMsg>|null} [messages] Conversation messages
         * @property {string|null} [newJid] Conversation newJid
         * @property {string|null} [oldJid] Conversation oldJid
         * @property {number|Long|null} [lastMsgTimestamp] Conversation lastMsgTimestamp
         * @property {number|null} [unreadCount] Conversation unreadCount
         * @property {boolean|null} [readOnly] Conversation readOnly
         * @property {boolean|null} [endOfHistoryTransfer] Conversation endOfHistoryTransfer
         * @property {number|null} [ephemeralExpiration] Conversation ephemeralExpiration
         * @property {number|Long|null} [ephemeralSettingTimestamp] Conversation ephemeralSettingTimestamp
         * @property {proto.Conversation.EndOfHistoryTransferType|null} [endOfHistoryTransferType] Conversation endOfHistoryTransferType
         * @property {number|Long|null} [conversationTimestamp] Conversation conversationTimestamp
         * @property {string|null} [name] Conversation name
         * @property {string|null} [pHash] Conversation pHash
         * @property {boolean|null} [notSpam] Conversation notSpam
         * @property {boolean|null} [archived] Conversation archived
         * @property {proto.IDisappearingMode|null} [disappearingMode] Conversation disappearingMode
         * @property {number|null} [unreadMentionCount] Conversation unreadMentionCount
         * @property {boolean|null} [markedAsUnread] Conversation markedAsUnread
         * @property {Array.<proto.IGroupParticipant>|null} [participant] Conversation participant
         * @property {Uint8Array|null} [tcToken] Conversation tcToken
         * @property {number|Long|null} [tcTokenTimestamp] Conversation tcTokenTimestamp
         * @property {Uint8Array|null} [contactPrimaryIdentityKey] Conversation contactPrimaryIdentityKey
         * @property {number|null} [pinned] Conversation pinned
         * @property {number|Long|null} [muteEndTime] Conversation muteEndTime
         * @property {proto.IWallpaperSettings|null} [wallpaper] Conversation wallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] Conversation mediaVisibility
         * @property {number|Long|null} [tcTokenSenderTimestamp] Conversation tcTokenSenderTimestamp
         * @property {boolean|null} [suspended] Conversation suspended
         * @property {boolean|null} [terminated] Conversation terminated
         * @property {number|Long|null} [createdAt] Conversation createdAt
         * @property {string|null} [createdBy] Conversation createdBy
         * @property {string|null} [description] Conversation description
         * @property {boolean|null} [support] Conversation support
         * @property {boolean|null} [isParentGroup] Conversation isParentGroup
         * @property {boolean|null} [isDefaultSubgroup] Conversation isDefaultSubgroup
         * @property {string|null} [parentGroupId] Conversation parentGroupId
         * @property {string|null} [displayName] Conversation displayName
         * @property {string|null} [pnJid] Conversation pnJid
         * @property {boolean|null} [shareOwnPn] Conversation shareOwnPn
         * @property {boolean|null} [pnhDuplicateLidThread] Conversation pnhDuplicateLidThread
         * @property {string|null} [lidJid] Conversation lidJid
         */

        /**
         * Constructs a new Conversation.
         * @memberof proto
         * @classdesc Represents a Conversation.
         * @implements IConversation
         * @constructor
         * @param {proto.IConversation=} [properties] Properties to set
         */
        function Conversation(properties) {
            this.messages = [];
            this.participant = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Conversation id.
         * @member {string} id
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.id = "";

        /**
         * Conversation messages.
         * @member {Array.<proto.IHistorySyncMsg>} messages
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.messages = $util.emptyArray;

        /**
         * Conversation newJid.
         * @member {string} newJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.newJid = "";

        /**
         * Conversation oldJid.
         * @member {string} oldJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.oldJid = "";

        /**
         * Conversation lastMsgTimestamp.
         * @member {number|Long} lastMsgTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.lastMsgTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation unreadCount.
         * @member {number} unreadCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadCount = 0;

        /**
         * Conversation readOnly.
         * @member {boolean} readOnly
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.readOnly = false;

        /**
         * Conversation endOfHistoryTransfer.
         * @member {boolean} endOfHistoryTransfer
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransfer = false;

        /**
         * Conversation ephemeralExpiration.
         * @member {number} ephemeralExpiration
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralExpiration = 0;

        /**
         * Conversation ephemeralSettingTimestamp.
         * @member {number|Long} ephemeralSettingTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.ephemeralSettingTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Conversation endOfHistoryTransferType.
         * @member {proto.Conversation.EndOfHistoryTransferType} endOfHistoryTransferType
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.endOfHistoryTransferType = 0;

        /**
         * Conversation conversationTimestamp.
         * @member {number|Long} conversationTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.conversationTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation name.
         * @member {string} name
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.name = "";

        /**
         * Conversation pHash.
         * @member {string} pHash
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pHash = "";

        /**
         * Conversation notSpam.
         * @member {boolean} notSpam
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.notSpam = false;

        /**
         * Conversation archived.
         * @member {boolean} archived
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.archived = false;

        /**
         * Conversation disappearingMode.
         * @member {proto.IDisappearingMode|null|undefined} disappearingMode
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.disappearingMode = null;

        /**
         * Conversation unreadMentionCount.
         * @member {number} unreadMentionCount
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.unreadMentionCount = 0;

        /**
         * Conversation markedAsUnread.
         * @member {boolean} markedAsUnread
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.markedAsUnread = false;

        /**
         * Conversation participant.
         * @member {Array.<proto.IGroupParticipant>} participant
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.participant = $util.emptyArray;

        /**
         * Conversation tcToken.
         * @member {Uint8Array} tcToken
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcToken = $util.newBuffer([]);

        /**
         * Conversation tcTokenTimestamp.
         * @member {number|Long} tcTokenTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation contactPrimaryIdentityKey.
         * @member {Uint8Array} contactPrimaryIdentityKey
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.contactPrimaryIdentityKey = $util.newBuffer([]);

        /**
         * Conversation pinned.
         * @member {number} pinned
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pinned = 0;

        /**
         * Conversation muteEndTime.
         * @member {number|Long} muteEndTime
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.muteEndTime = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation wallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} wallpaper
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.wallpaper = null;

        /**
         * Conversation mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.mediaVisibility = 0;

        /**
         * Conversation tcTokenSenderTimestamp.
         * @member {number|Long} tcTokenSenderTimestamp
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.tcTokenSenderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation suspended.
         * @member {boolean} suspended
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.suspended = false;

        /**
         * Conversation terminated.
         * @member {boolean} terminated
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.terminated = false;

        /**
         * Conversation createdAt.
         * @member {number|Long} createdAt
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.createdAt = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Conversation createdBy.
         * @member {string} createdBy
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.createdBy = "";

        /**
         * Conversation description.
         * @member {string} description
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.description = "";

        /**
         * Conversation support.
         * @member {boolean} support
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.support = false;

        /**
         * Conversation isParentGroup.
         * @member {boolean} isParentGroup
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.isParentGroup = false;

        /**
         * Conversation isDefaultSubgroup.
         * @member {boolean} isDefaultSubgroup
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.isDefaultSubgroup = false;

        /**
         * Conversation parentGroupId.
         * @member {string} parentGroupId
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.parentGroupId = "";

        /**
         * Conversation displayName.
         * @member {string} displayName
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.displayName = "";

        /**
         * Conversation pnJid.
         * @member {string} pnJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pnJid = "";

        /**
         * Conversation shareOwnPn.
         * @member {boolean} shareOwnPn
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.shareOwnPn = false;

        /**
         * Conversation pnhDuplicateLidThread.
         * @member {boolean} pnhDuplicateLidThread
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.pnhDuplicateLidThread = false;

        /**
         * Conversation lidJid.
         * @member {string} lidJid
         * @memberof proto.Conversation
         * @instance
         */
        Conversation.prototype.lidJid = "";

        /**
         * Creates a new Conversation instance using the specified properties.
         * @function create
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation=} [properties] Properties to set
         * @returns {proto.Conversation} Conversation instance
         */
        Conversation.create = function create(properties) {
            return new Conversation(properties);
        };

        /**
         * Encodes the specified Conversation message. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encode
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.id);
            if (message.messages != null && message.messages.length)
                for (var i = 0; i < message.messages.length; ++i)
                    $root.proto.HistorySyncMsg.encode(message.messages[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.newJid != null && Object.hasOwnProperty.call(message, "newJid"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.newJid);
            if (message.oldJid != null && Object.hasOwnProperty.call(message, "oldJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.oldJid);
            if (message.lastMsgTimestamp != null && Object.hasOwnProperty.call(message, "lastMsgTimestamp"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint64(message.lastMsgTimestamp);
            if (message.unreadCount != null && Object.hasOwnProperty.call(message, "unreadCount"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.unreadCount);
            if (message.readOnly != null && Object.hasOwnProperty.call(message, "readOnly"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.readOnly);
            if (message.endOfHistoryTransfer != null && Object.hasOwnProperty.call(message, "endOfHistoryTransfer"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.endOfHistoryTransfer);
            if (message.ephemeralExpiration != null && Object.hasOwnProperty.call(message, "ephemeralExpiration"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint32(message.ephemeralExpiration);
            if (message.ephemeralSettingTimestamp != null && Object.hasOwnProperty.call(message, "ephemeralSettingTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.ephemeralSettingTimestamp);
            if (message.endOfHistoryTransferType != null && Object.hasOwnProperty.call(message, "endOfHistoryTransferType"))
                writer.uint32(/* id 11, wireType 0 =*/88).int32(message.endOfHistoryTransferType);
            if (message.conversationTimestamp != null && Object.hasOwnProperty.call(message, "conversationTimestamp"))
                writer.uint32(/* id 12, wireType 0 =*/96).uint64(message.conversationTimestamp);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 13, wireType 2 =*/106).string(message.name);
            if (message.pHash != null && Object.hasOwnProperty.call(message, "pHash"))
                writer.uint32(/* id 14, wireType 2 =*/114).string(message.pHash);
            if (message.notSpam != null && Object.hasOwnProperty.call(message, "notSpam"))
                writer.uint32(/* id 15, wireType 0 =*/120).bool(message.notSpam);
            if (message.archived != null && Object.hasOwnProperty.call(message, "archived"))
                writer.uint32(/* id 16, wireType 0 =*/128).bool(message.archived);
            if (message.disappearingMode != null && Object.hasOwnProperty.call(message, "disappearingMode"))
                $root.proto.DisappearingMode.encode(message.disappearingMode, writer.uint32(/* id 17, wireType 2 =*/138).fork()).ldelim();
            if (message.unreadMentionCount != null && Object.hasOwnProperty.call(message, "unreadMentionCount"))
                writer.uint32(/* id 18, wireType 0 =*/144).uint32(message.unreadMentionCount);
            if (message.markedAsUnread != null && Object.hasOwnProperty.call(message, "markedAsUnread"))
                writer.uint32(/* id 19, wireType 0 =*/152).bool(message.markedAsUnread);
            if (message.participant != null && message.participant.length)
                for (var i = 0; i < message.participant.length; ++i)
                    $root.proto.GroupParticipant.encode(message.participant[i], writer.uint32(/* id 20, wireType 2 =*/162).fork()).ldelim();
            if (message.tcToken != null && Object.hasOwnProperty.call(message, "tcToken"))
                writer.uint32(/* id 21, wireType 2 =*/170).bytes(message.tcToken);
            if (message.tcTokenTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenTimestamp"))
                writer.uint32(/* id 22, wireType 0 =*/176).uint64(message.tcTokenTimestamp);
            if (message.contactPrimaryIdentityKey != null && Object.hasOwnProperty.call(message, "contactPrimaryIdentityKey"))
                writer.uint32(/* id 23, wireType 2 =*/186).bytes(message.contactPrimaryIdentityKey);
            if (message.pinned != null && Object.hasOwnProperty.call(message, "pinned"))
                writer.uint32(/* id 24, wireType 0 =*/192).uint32(message.pinned);
            if (message.muteEndTime != null && Object.hasOwnProperty.call(message, "muteEndTime"))
                writer.uint32(/* id 25, wireType 0 =*/200).uint64(message.muteEndTime);
            if (message.wallpaper != null && Object.hasOwnProperty.call(message, "wallpaper"))
                $root.proto.WallpaperSettings.encode(message.wallpaper, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 27, wireType 0 =*/216).int32(message.mediaVisibility);
            if (message.tcTokenSenderTimestamp != null && Object.hasOwnProperty.call(message, "tcTokenSenderTimestamp"))
                writer.uint32(/* id 28, wireType 0 =*/224).uint64(message.tcTokenSenderTimestamp);
            if (message.suspended != null && Object.hasOwnProperty.call(message, "suspended"))
                writer.uint32(/* id 29, wireType 0 =*/232).bool(message.suspended);
            if (message.terminated != null && Object.hasOwnProperty.call(message, "terminated"))
                writer.uint32(/* id 30, wireType 0 =*/240).bool(message.terminated);
            if (message.createdAt != null && Object.hasOwnProperty.call(message, "createdAt"))
                writer.uint32(/* id 31, wireType 0 =*/248).uint64(message.createdAt);
            if (message.createdBy != null && Object.hasOwnProperty.call(message, "createdBy"))
                writer.uint32(/* id 32, wireType 2 =*/258).string(message.createdBy);
            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                writer.uint32(/* id 33, wireType 2 =*/266).string(message.description);
            if (message.support != null && Object.hasOwnProperty.call(message, "support"))
                writer.uint32(/* id 34, wireType 0 =*/272).bool(message.support);
            if (message.isParentGroup != null && Object.hasOwnProperty.call(message, "isParentGroup"))
                writer.uint32(/* id 35, wireType 0 =*/280).bool(message.isParentGroup);
            if (message.isDefaultSubgroup != null && Object.hasOwnProperty.call(message, "isDefaultSubgroup"))
                writer.uint32(/* id 36, wireType 0 =*/288).bool(message.isDefaultSubgroup);
            if (message.parentGroupId != null && Object.hasOwnProperty.call(message, "parentGroupId"))
                writer.uint32(/* id 37, wireType 2 =*/298).string(message.parentGroupId);
            if (message.displayName != null && Object.hasOwnProperty.call(message, "displayName"))
                writer.uint32(/* id 38, wireType 2 =*/306).string(message.displayName);
            if (message.pnJid != null && Object.hasOwnProperty.call(message, "pnJid"))
                writer.uint32(/* id 39, wireType 2 =*/314).string(message.pnJid);
            if (message.shareOwnPn != null && Object.hasOwnProperty.call(message, "shareOwnPn"))
                writer.uint32(/* id 40, wireType 0 =*/320).bool(message.shareOwnPn);
            if (message.pnhDuplicateLidThread != null && Object.hasOwnProperty.call(message, "pnhDuplicateLidThread"))
                writer.uint32(/* id 41, wireType 0 =*/328).bool(message.pnhDuplicateLidThread);
            if (message.lidJid != null && Object.hasOwnProperty.call(message, "lidJid"))
                writer.uint32(/* id 42, wireType 2 =*/338).string(message.lidJid);
            return writer;
        };

        /**
         * Encodes the specified Conversation message, length delimited. Does not implicitly {@link proto.Conversation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {proto.IConversation} message Conversation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Conversation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Conversation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.string();
                    break;
                case 2:
                    if (!(message.messages && message.messages.length))
                        message.messages = [];
                    message.messages.push($root.proto.HistorySyncMsg.decode(reader, reader.uint32()));
                    break;
                case 3:
                    message.newJid = reader.string();
                    break;
                case 4:
                    message.oldJid = reader.string();
                    break;
                case 5:
                    message.lastMsgTimestamp = reader.uint64();
                    break;
                case 6:
                    message.unreadCount = reader.uint32();
                    break;
                case 7:
                    message.readOnly = reader.bool();
                    break;
                case 8:
                    message.endOfHistoryTransfer = reader.bool();
                    break;
                case 9:
                    message.ephemeralExpiration = reader.uint32();
                    break;
                case 10:
                    message.ephemeralSettingTimestamp = reader.int64();
                    break;
                case 11:
                    message.endOfHistoryTransferType = reader.int32();
                    break;
                case 12:
                    message.conversationTimestamp = reader.uint64();
                    break;
                case 13:
                    message.name = reader.string();
                    break;
                case 14:
                    message.pHash = reader.string();
                    break;
                case 15:
                    message.notSpam = reader.bool();
                    break;
                case 16:
                    message.archived = reader.bool();
                    break;
                case 17:
                    message.disappearingMode = $root.proto.DisappearingMode.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.unreadMentionCount = reader.uint32();
                    break;
                case 19:
                    message.markedAsUnread = reader.bool();
                    break;
                case 20:
                    if (!(message.participant && message.participant.length))
                        message.participant = [];
                    message.participant.push($root.proto.GroupParticipant.decode(reader, reader.uint32()));
                    break;
                case 21:
                    message.tcToken = reader.bytes();
                    break;
                case 22:
                    message.tcTokenTimestamp = reader.uint64();
                    break;
                case 23:
                    message.contactPrimaryIdentityKey = reader.bytes();
                    break;
                case 24:
                    message.pinned = reader.uint32();
                    break;
                case 25:
                    message.muteEndTime = reader.uint64();
                    break;
                case 26:
                    message.wallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 27:
                    message.mediaVisibility = reader.int32();
                    break;
                case 28:
                    message.tcTokenSenderTimestamp = reader.uint64();
                    break;
                case 29:
                    message.suspended = reader.bool();
                    break;
                case 30:
                    message.terminated = reader.bool();
                    break;
                case 31:
                    message.createdAt = reader.uint64();
                    break;
                case 32:
                    message.createdBy = reader.string();
                    break;
                case 33:
                    message.description = reader.string();
                    break;
                case 34:
                    message.support = reader.bool();
                    break;
                case 35:
                    message.isParentGroup = reader.bool();
                    break;
                case 36:
                    message.isDefaultSubgroup = reader.bool();
                    break;
                case 37:
                    message.parentGroupId = reader.string();
                    break;
                case 38:
                    message.displayName = reader.string();
                    break;
                case 39:
                    message.pnJid = reader.string();
                    break;
                case 40:
                    message.shareOwnPn = reader.bool();
                    break;
                case 41:
                    message.pnhDuplicateLidThread = reader.bool();
                    break;
                case 42:
                    message.lidJid = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("id"))
                throw $util.ProtocolError("missing required 'id'", { instance: message });
            return message;
        };

        /**
         * Decodes a Conversation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Conversation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Conversation} Conversation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Conversation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Conversation message.
         * @function verify
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Conversation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.id))
                return "id: string expected";
            if (message.messages != null && message.hasOwnProperty("messages")) {
                if (!Array.isArray(message.messages))
                    return "messages: array expected";
                for (var i = 0; i < message.messages.length; ++i) {
                    var error = $root.proto.HistorySyncMsg.verify(message.messages[i]);
                    if (error)
                        return "messages." + error;
                }
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                if (!$util.isString(message.newJid))
                    return "newJid: string expected";
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                if (!$util.isString(message.oldJid))
                    return "oldJid: string expected";
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (!$util.isInteger(message.lastMsgTimestamp) && !(message.lastMsgTimestamp && $util.isInteger(message.lastMsgTimestamp.low) && $util.isInteger(message.lastMsgTimestamp.high)))
                    return "lastMsgTimestamp: integer|Long expected";
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                if (!$util.isInteger(message.unreadCount))
                    return "unreadCount: integer expected";
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                if (typeof message.readOnly !== "boolean")
                    return "readOnly: boolean expected";
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                if (typeof message.endOfHistoryTransfer !== "boolean")
                    return "endOfHistoryTransfer: boolean expected";
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                if (!$util.isInteger(message.ephemeralExpiration))
                    return "ephemeralExpiration: integer expected";
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (!$util.isInteger(message.ephemeralSettingTimestamp) && !(message.ephemeralSettingTimestamp && $util.isInteger(message.ephemeralSettingTimestamp.low) && $util.isInteger(message.ephemeralSettingTimestamp.high)))
                    return "ephemeralSettingTimestamp: integer|Long expected";
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                switch (message.endOfHistoryTransferType) {
                default:
                    return "endOfHistoryTransferType: enum value expected";
                case 0:
                case 1:
                    break;
                }
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (!$util.isInteger(message.conversationTimestamp) && !(message.conversationTimestamp && $util.isInteger(message.conversationTimestamp.low) && $util.isInteger(message.conversationTimestamp.high)))
                    return "conversationTimestamp: integer|Long expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                if (!$util.isString(message.pHash))
                    return "pHash: string expected";
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                if (typeof message.notSpam !== "boolean")
                    return "notSpam: boolean expected";
            if (message.archived != null && message.hasOwnProperty("archived"))
                if (typeof message.archived !== "boolean")
                    return "archived: boolean expected";
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode")) {
                var error = $root.proto.DisappearingMode.verify(message.disappearingMode);
                if (error)
                    return "disappearingMode." + error;
            }
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                if (!$util.isInteger(message.unreadMentionCount))
                    return "unreadMentionCount: integer expected";
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                if (typeof message.markedAsUnread !== "boolean")
                    return "markedAsUnread: boolean expected";
            if (message.participant != null && message.hasOwnProperty("participant")) {
                if (!Array.isArray(message.participant))
                    return "participant: array expected";
                for (var i = 0; i < message.participant.length; ++i) {
                    var error = $root.proto.GroupParticipant.verify(message.participant[i]);
                    if (error)
                        return "participant." + error;
                }
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                if (!(message.tcToken && typeof message.tcToken.length === "number" || $util.isString(message.tcToken)))
                    return "tcToken: buffer expected";
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (!$util.isInteger(message.tcTokenTimestamp) && !(message.tcTokenTimestamp && $util.isInteger(message.tcTokenTimestamp.low) && $util.isInteger(message.tcTokenTimestamp.high)))
                    return "tcTokenTimestamp: integer|Long expected";
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                if (!(message.contactPrimaryIdentityKey && typeof message.contactPrimaryIdentityKey.length === "number" || $util.isString(message.contactPrimaryIdentityKey)))
                    return "contactPrimaryIdentityKey: buffer expected";
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                if (!$util.isInteger(message.pinned))
                    return "pinned: integer expected";
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (!$util.isInteger(message.muteEndTime) && !(message.muteEndTime && $util.isInteger(message.muteEndTime.low) && $util.isInteger(message.muteEndTime.high)))
                    return "muteEndTime: integer|Long expected";
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.wallpaper);
                if (error)
                    return "wallpaper." + error;
            }
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                switch (message.mediaVisibility) {
                default:
                    return "mediaVisibility: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (!$util.isInteger(message.tcTokenSenderTimestamp) && !(message.tcTokenSenderTimestamp && $util.isInteger(message.tcTokenSenderTimestamp.low) && $util.isInteger(message.tcTokenSenderTimestamp.high)))
                    return "tcTokenSenderTimestamp: integer|Long expected";
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                if (typeof message.suspended !== "boolean")
                    return "suspended: boolean expected";
            if (message.terminated != null && message.hasOwnProperty("terminated"))
                if (typeof message.terminated !== "boolean")
                    return "terminated: boolean expected";
            if (message.createdAt != null && message.hasOwnProperty("createdAt"))
                if (!$util.isInteger(message.createdAt) && !(message.createdAt && $util.isInteger(message.createdAt.low) && $util.isInteger(message.createdAt.high)))
                    return "createdAt: integer|Long expected";
            if (message.createdBy != null && message.hasOwnProperty("createdBy"))
                if (!$util.isString(message.createdBy))
                    return "createdBy: string expected";
            if (message.description != null && message.hasOwnProperty("description"))
                if (!$util.isString(message.description))
                    return "description: string expected";
            if (message.support != null && message.hasOwnProperty("support"))
                if (typeof message.support !== "boolean")
                    return "support: boolean expected";
            if (message.isParentGroup != null && message.hasOwnProperty("isParentGroup"))
                if (typeof message.isParentGroup !== "boolean")
                    return "isParentGroup: boolean expected";
            if (message.isDefaultSubgroup != null && message.hasOwnProperty("isDefaultSubgroup"))
                if (typeof message.isDefaultSubgroup !== "boolean")
                    return "isDefaultSubgroup: boolean expected";
            if (message.parentGroupId != null && message.hasOwnProperty("parentGroupId"))
                if (!$util.isString(message.parentGroupId))
                    return "parentGroupId: string expected";
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                if (!$util.isString(message.displayName))
                    return "displayName: string expected";
            if (message.pnJid != null && message.hasOwnProperty("pnJid"))
                if (!$util.isString(message.pnJid))
                    return "pnJid: string expected";
            if (message.shareOwnPn != null && message.hasOwnProperty("shareOwnPn"))
                if (typeof message.shareOwnPn !== "boolean")
                    return "shareOwnPn: boolean expected";
            if (message.pnhDuplicateLidThread != null && message.hasOwnProperty("pnhDuplicateLidThread"))
                if (typeof message.pnhDuplicateLidThread !== "boolean")
                    return "pnhDuplicateLidThread: boolean expected";
            if (message.lidJid != null && message.hasOwnProperty("lidJid"))
                if (!$util.isString(message.lidJid))
                    return "lidJid: string expected";
            return null;
        };

        /**
         * Creates a Conversation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Conversation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Conversation} Conversation
         */
        Conversation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Conversation)
                return object;
            var message = new $root.proto.Conversation();
            if (object.id != null)
                message.id = String(object.id);
            if (object.messages) {
                if (!Array.isArray(object.messages))
                    throw TypeError(".proto.Conversation.messages: array expected");
                message.messages = [];
                for (var i = 0; i < object.messages.length; ++i) {
                    if (typeof object.messages[i] !== "object")
                        throw TypeError(".proto.Conversation.messages: object expected");
                    message.messages[i] = $root.proto.HistorySyncMsg.fromObject(object.messages[i]);
                }
            }
            if (object.newJid != null)
                message.newJid = String(object.newJid);
            if (object.oldJid != null)
                message.oldJid = String(object.oldJid);
            if (object.lastMsgTimestamp != null)
                if ($util.Long)
                    (message.lastMsgTimestamp = $util.Long.fromValue(object.lastMsgTimestamp)).unsigned = true;
                else if (typeof object.lastMsgTimestamp === "string")
                    message.lastMsgTimestamp = parseInt(object.lastMsgTimestamp, 10);
                else if (typeof object.lastMsgTimestamp === "number")
                    message.lastMsgTimestamp = object.lastMsgTimestamp;
                else if (typeof object.lastMsgTimestamp === "object")
                    message.lastMsgTimestamp = new $util.LongBits(object.lastMsgTimestamp.low >>> 0, object.lastMsgTimestamp.high >>> 0).toNumber(true);
            if (object.unreadCount != null)
                message.unreadCount = object.unreadCount >>> 0;
            if (object.readOnly != null)
                message.readOnly = Boolean(object.readOnly);
            if (object.endOfHistoryTransfer != null)
                message.endOfHistoryTransfer = Boolean(object.endOfHistoryTransfer);
            if (object.ephemeralExpiration != null)
                message.ephemeralExpiration = object.ephemeralExpiration >>> 0;
            if (object.ephemeralSettingTimestamp != null)
                if ($util.Long)
                    (message.ephemeralSettingTimestamp = $util.Long.fromValue(object.ephemeralSettingTimestamp)).unsigned = false;
                else if (typeof object.ephemeralSettingTimestamp === "string")
                    message.ephemeralSettingTimestamp = parseInt(object.ephemeralSettingTimestamp, 10);
                else if (typeof object.ephemeralSettingTimestamp === "number")
                    message.ephemeralSettingTimestamp = object.ephemeralSettingTimestamp;
                else if (typeof object.ephemeralSettingTimestamp === "object")
                    message.ephemeralSettingTimestamp = new $util.LongBits(object.ephemeralSettingTimestamp.low >>> 0, object.ephemeralSettingTimestamp.high >>> 0).toNumber();
            switch (object.endOfHistoryTransferType) {
            case "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY":
            case 0:
                message.endOfHistoryTransferType = 0;
                break;
            case "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY":
            case 1:
                message.endOfHistoryTransferType = 1;
                break;
            }
            if (object.conversationTimestamp != null)
                if ($util.Long)
                    (message.conversationTimestamp = $util.Long.fromValue(object.conversationTimestamp)).unsigned = true;
                else if (typeof object.conversationTimestamp === "string")
                    message.conversationTimestamp = parseInt(object.conversationTimestamp, 10);
                else if (typeof object.conversationTimestamp === "number")
                    message.conversationTimestamp = object.conversationTimestamp;
                else if (typeof object.conversationTimestamp === "object")
                    message.conversationTimestamp = new $util.LongBits(object.conversationTimestamp.low >>> 0, object.conversationTimestamp.high >>> 0).toNumber(true);
            if (object.name != null)
                message.name = String(object.name);
            if (object.pHash != null)
                message.pHash = String(object.pHash);
            if (object.notSpam != null)
                message.notSpam = Boolean(object.notSpam);
            if (object.archived != null)
                message.archived = Boolean(object.archived);
            if (object.disappearingMode != null) {
                if (typeof object.disappearingMode !== "object")
                    throw TypeError(".proto.Conversation.disappearingMode: object expected");
                message.disappearingMode = $root.proto.DisappearingMode.fromObject(object.disappearingMode);
            }
            if (object.unreadMentionCount != null)
                message.unreadMentionCount = object.unreadMentionCount >>> 0;
            if (object.markedAsUnread != null)
                message.markedAsUnread = Boolean(object.markedAsUnread);
            if (object.participant) {
                if (!Array.isArray(object.participant))
                    throw TypeError(".proto.Conversation.participant: array expected");
                message.participant = [];
                for (var i = 0; i < object.participant.length; ++i) {
                    if (typeof object.participant[i] !== "object")
                        throw TypeError(".proto.Conversation.participant: object expected");
                    message.participant[i] = $root.proto.GroupParticipant.fromObject(object.participant[i]);
                }
            }
            if (object.tcToken != null)
                if (typeof object.tcToken === "string")
                    $util.base64.decode(object.tcToken, message.tcToken = $util.newBuffer($util.base64.length(object.tcToken)), 0);
                else if (object.tcToken.length)
                    message.tcToken = object.tcToken;
            if (object.tcTokenTimestamp != null)
                if ($util.Long)
                    (message.tcTokenTimestamp = $util.Long.fromValue(object.tcTokenTimestamp)).unsigned = true;
                else if (typeof object.tcTokenTimestamp === "string")
                    message.tcTokenTimestamp = parseInt(object.tcTokenTimestamp, 10);
                else if (typeof object.tcTokenTimestamp === "number")
                    message.tcTokenTimestamp = object.tcTokenTimestamp;
                else if (typeof object.tcTokenTimestamp === "object")
                    message.tcTokenTimestamp = new $util.LongBits(object.tcTokenTimestamp.low >>> 0, object.tcTokenTimestamp.high >>> 0).toNumber(true);
            if (object.contactPrimaryIdentityKey != null)
                if (typeof object.contactPrimaryIdentityKey === "string")
                    $util.base64.decode(object.contactPrimaryIdentityKey, message.contactPrimaryIdentityKey = $util.newBuffer($util.base64.length(object.contactPrimaryIdentityKey)), 0);
                else if (object.contactPrimaryIdentityKey.length)
                    message.contactPrimaryIdentityKey = object.contactPrimaryIdentityKey;
            if (object.pinned != null)
                message.pinned = object.pinned >>> 0;
            if (object.muteEndTime != null)
                if ($util.Long)
                    (message.muteEndTime = $util.Long.fromValue(object.muteEndTime)).unsigned = true;
                else if (typeof object.muteEndTime === "string")
                    message.muteEndTime = parseInt(object.muteEndTime, 10);
                else if (typeof object.muteEndTime === "number")
                    message.muteEndTime = object.muteEndTime;
                else if (typeof object.muteEndTime === "object")
                    message.muteEndTime = new $util.LongBits(object.muteEndTime.low >>> 0, object.muteEndTime.high >>> 0).toNumber(true);
            if (object.wallpaper != null) {
                if (typeof object.wallpaper !== "object")
                    throw TypeError(".proto.Conversation.wallpaper: object expected");
                message.wallpaper = $root.proto.WallpaperSettings.fromObject(object.wallpaper);
            }
            switch (object.mediaVisibility) {
            case "DEFAULT":
            case 0:
                message.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                message.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                message.mediaVisibility = 2;
                break;
            }
            if (object.tcTokenSenderTimestamp != null)
                if ($util.Long)
                    (message.tcTokenSenderTimestamp = $util.Long.fromValue(object.tcTokenSenderTimestamp)).unsigned = true;
                else if (typeof object.tcTokenSenderTimestamp === "string")
                    message.tcTokenSenderTimestamp = parseInt(object.tcTokenSenderTimestamp, 10);
                else if (typeof object.tcTokenSenderTimestamp === "number")
                    message.tcTokenSenderTimestamp = object.tcTokenSenderTimestamp;
                else if (typeof object.tcTokenSenderTimestamp === "object")
                    message.tcTokenSenderTimestamp = new $util.LongBits(object.tcTokenSenderTimestamp.low >>> 0, object.tcTokenSenderTimestamp.high >>> 0).toNumber(true);
            if (object.suspended != null)
                message.suspended = Boolean(object.suspended);
            if (object.terminated != null)
                message.terminated = Boolean(object.terminated);
            if (object.createdAt != null)
                if ($util.Long)
                    (message.createdAt = $util.Long.fromValue(object.createdAt)).unsigned = true;
                else if (typeof object.createdAt === "string")
                    message.createdAt = parseInt(object.createdAt, 10);
                else if (typeof object.createdAt === "number")
                    message.createdAt = object.createdAt;
                else if (typeof object.createdAt === "object")
                    message.createdAt = new $util.LongBits(object.createdAt.low >>> 0, object.createdAt.high >>> 0).toNumber(true);
            if (object.createdBy != null)
                message.createdBy = String(object.createdBy);
            if (object.description != null)
                message.description = String(object.description);
            if (object.support != null)
                message.support = Boolean(object.support);
            if (object.isParentGroup != null)
                message.isParentGroup = Boolean(object.isParentGroup);
            if (object.isDefaultSubgroup != null)
                message.isDefaultSubgroup = Boolean(object.isDefaultSubgroup);
            if (object.parentGroupId != null)
                message.parentGroupId = String(object.parentGroupId);
            if (object.displayName != null)
                message.displayName = String(object.displayName);
            if (object.pnJid != null)
                message.pnJid = String(object.pnJid);
            if (object.shareOwnPn != null)
                message.shareOwnPn = Boolean(object.shareOwnPn);
            if (object.pnhDuplicateLidThread != null)
                message.pnhDuplicateLidThread = Boolean(object.pnhDuplicateLidThread);
            if (object.lidJid != null)
                message.lidJid = String(object.lidJid);
            return message;
        };

        /**
         * Creates a plain object from a Conversation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Conversation
         * @static
         * @param {proto.Conversation} message Conversation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Conversation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.messages = [];
                object.participant = [];
            }
            if (options.defaults) {
                object.id = "";
                object.newJid = "";
                object.oldJid = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.lastMsgTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.lastMsgTimestamp = options.longs === String ? "0" : 0;
                object.unreadCount = 0;
                object.readOnly = false;
                object.endOfHistoryTransfer = false;
                object.ephemeralExpiration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.ephemeralSettingTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.ephemeralSettingTimestamp = options.longs === String ? "0" : 0;
                object.endOfHistoryTransferType = options.enums === String ? "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.conversationTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.conversationTimestamp = options.longs === String ? "0" : 0;
                object.name = "";
                object.pHash = "";
                object.notSpam = false;
                object.archived = false;
                object.disappearingMode = null;
                object.unreadMentionCount = 0;
                object.markedAsUnread = false;
                if (options.bytes === String)
                    object.tcToken = "";
                else {
                    object.tcToken = [];
                    if (options.bytes !== Array)
                        object.tcToken = $util.newBuffer(object.tcToken);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.contactPrimaryIdentityKey = "";
                else {
                    object.contactPrimaryIdentityKey = [];
                    if (options.bytes !== Array)
                        object.contactPrimaryIdentityKey = $util.newBuffer(object.contactPrimaryIdentityKey);
                }
                object.pinned = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.muteEndTime = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.muteEndTime = options.longs === String ? "0" : 0;
                object.wallpaper = null;
                object.mediaVisibility = options.enums === String ? "DEFAULT" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.tcTokenSenderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.tcTokenSenderTimestamp = options.longs === String ? "0" : 0;
                object.suspended = false;
                object.terminated = false;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.createdAt = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.createdAt = options.longs === String ? "0" : 0;
                object.createdBy = "";
                object.description = "";
                object.support = false;
                object.isParentGroup = false;
                object.isDefaultSubgroup = false;
                object.parentGroupId = "";
                object.displayName = "";
                object.pnJid = "";
                object.shareOwnPn = false;
                object.pnhDuplicateLidThread = false;
                object.lidJid = "";
            }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = message.id;
            if (message.messages && message.messages.length) {
                object.messages = [];
                for (var j = 0; j < message.messages.length; ++j)
                    object.messages[j] = $root.proto.HistorySyncMsg.toObject(message.messages[j], options);
            }
            if (message.newJid != null && message.hasOwnProperty("newJid"))
                object.newJid = message.newJid;
            if (message.oldJid != null && message.hasOwnProperty("oldJid"))
                object.oldJid = message.oldJid;
            if (message.lastMsgTimestamp != null && message.hasOwnProperty("lastMsgTimestamp"))
                if (typeof message.lastMsgTimestamp === "number")
                    object.lastMsgTimestamp = options.longs === String ? String(message.lastMsgTimestamp) : message.lastMsgTimestamp;
                else
                    object.lastMsgTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.lastMsgTimestamp) : options.longs === Number ? new $util.LongBits(message.lastMsgTimestamp.low >>> 0, message.lastMsgTimestamp.high >>> 0).toNumber(true) : message.lastMsgTimestamp;
            if (message.unreadCount != null && message.hasOwnProperty("unreadCount"))
                object.unreadCount = message.unreadCount;
            if (message.readOnly != null && message.hasOwnProperty("readOnly"))
                object.readOnly = message.readOnly;
            if (message.endOfHistoryTransfer != null && message.hasOwnProperty("endOfHistoryTransfer"))
                object.endOfHistoryTransfer = message.endOfHistoryTransfer;
            if (message.ephemeralExpiration != null && message.hasOwnProperty("ephemeralExpiration"))
                object.ephemeralExpiration = message.ephemeralExpiration;
            if (message.ephemeralSettingTimestamp != null && message.hasOwnProperty("ephemeralSettingTimestamp"))
                if (typeof message.ephemeralSettingTimestamp === "number")
                    object.ephemeralSettingTimestamp = options.longs === String ? String(message.ephemeralSettingTimestamp) : message.ephemeralSettingTimestamp;
                else
                    object.ephemeralSettingTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.ephemeralSettingTimestamp) : options.longs === Number ? new $util.LongBits(message.ephemeralSettingTimestamp.low >>> 0, message.ephemeralSettingTimestamp.high >>> 0).toNumber() : message.ephemeralSettingTimestamp;
            if (message.endOfHistoryTransferType != null && message.hasOwnProperty("endOfHistoryTransferType"))
                object.endOfHistoryTransferType = options.enums === String ? $root.proto.Conversation.EndOfHistoryTransferType[message.endOfHistoryTransferType] : message.endOfHistoryTransferType;
            if (message.conversationTimestamp != null && message.hasOwnProperty("conversationTimestamp"))
                if (typeof message.conversationTimestamp === "number")
                    object.conversationTimestamp = options.longs === String ? String(message.conversationTimestamp) : message.conversationTimestamp;
                else
                    object.conversationTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.conversationTimestamp) : options.longs === Number ? new $util.LongBits(message.conversationTimestamp.low >>> 0, message.conversationTimestamp.high >>> 0).toNumber(true) : message.conversationTimestamp;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            if (message.pHash != null && message.hasOwnProperty("pHash"))
                object.pHash = message.pHash;
            if (message.notSpam != null && message.hasOwnProperty("notSpam"))
                object.notSpam = message.notSpam;
            if (message.archived != null && message.hasOwnProperty("archived"))
                object.archived = message.archived;
            if (message.disappearingMode != null && message.hasOwnProperty("disappearingMode"))
                object.disappearingMode = $root.proto.DisappearingMode.toObject(message.disappearingMode, options);
            if (message.unreadMentionCount != null && message.hasOwnProperty("unreadMentionCount"))
                object.unreadMentionCount = message.unreadMentionCount;
            if (message.markedAsUnread != null && message.hasOwnProperty("markedAsUnread"))
                object.markedAsUnread = message.markedAsUnread;
            if (message.participant && message.participant.length) {
                object.participant = [];
                for (var j = 0; j < message.participant.length; ++j)
                    object.participant[j] = $root.proto.GroupParticipant.toObject(message.participant[j], options);
            }
            if (message.tcToken != null && message.hasOwnProperty("tcToken"))
                object.tcToken = options.bytes === String ? $util.base64.encode(message.tcToken, 0, message.tcToken.length) : options.bytes === Array ? Array.prototype.slice.call(message.tcToken) : message.tcToken;
            if (message.tcTokenTimestamp != null && message.hasOwnProperty("tcTokenTimestamp"))
                if (typeof message.tcTokenTimestamp === "number")
                    object.tcTokenTimestamp = options.longs === String ? String(message.tcTokenTimestamp) : message.tcTokenTimestamp;
                else
                    object.tcTokenTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenTimestamp.low >>> 0, message.tcTokenTimestamp.high >>> 0).toNumber(true) : message.tcTokenTimestamp;
            if (message.contactPrimaryIdentityKey != null && message.hasOwnProperty("contactPrimaryIdentityKey"))
                object.contactPrimaryIdentityKey = options.bytes === String ? $util.base64.encode(message.contactPrimaryIdentityKey, 0, message.contactPrimaryIdentityKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.contactPrimaryIdentityKey) : message.contactPrimaryIdentityKey;
            if (message.pinned != null && message.hasOwnProperty("pinned"))
                object.pinned = message.pinned;
            if (message.muteEndTime != null && message.hasOwnProperty("muteEndTime"))
                if (typeof message.muteEndTime === "number")
                    object.muteEndTime = options.longs === String ? String(message.muteEndTime) : message.muteEndTime;
                else
                    object.muteEndTime = options.longs === String ? $util.Long.prototype.toString.call(message.muteEndTime) : options.longs === Number ? new $util.LongBits(message.muteEndTime.low >>> 0, message.muteEndTime.high >>> 0).toNumber(true) : message.muteEndTime;
            if (message.wallpaper != null && message.hasOwnProperty("wallpaper"))
                object.wallpaper = $root.proto.WallpaperSettings.toObject(message.wallpaper, options);
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                object.mediaVisibility = options.enums === String ? $root.proto.MediaVisibility[message.mediaVisibility] : message.mediaVisibility;
            if (message.tcTokenSenderTimestamp != null && message.hasOwnProperty("tcTokenSenderTimestamp"))
                if (typeof message.tcTokenSenderTimestamp === "number")
                    object.tcTokenSenderTimestamp = options.longs === String ? String(message.tcTokenSenderTimestamp) : message.tcTokenSenderTimestamp;
                else
                    object.tcTokenSenderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.tcTokenSenderTimestamp) : options.longs === Number ? new $util.LongBits(message.tcTokenSenderTimestamp.low >>> 0, message.tcTokenSenderTimestamp.high >>> 0).toNumber(true) : message.tcTokenSenderTimestamp;
            if (message.suspended != null && message.hasOwnProperty("suspended"))
                object.suspended = message.suspended;
            if (message.terminated != null && message.hasOwnProperty("terminated"))
                object.terminated = message.terminated;
            if (message.createdAt != null && message.hasOwnProperty("createdAt"))
                if (typeof message.createdAt === "number")
                    object.createdAt = options.longs === String ? String(message.createdAt) : message.createdAt;
                else
                    object.createdAt = options.longs === String ? $util.Long.prototype.toString.call(message.createdAt) : options.longs === Number ? new $util.LongBits(message.createdAt.low >>> 0, message.createdAt.high >>> 0).toNumber(true) : message.createdAt;
            if (message.createdBy != null && message.hasOwnProperty("createdBy"))
                object.createdBy = message.createdBy;
            if (message.description != null && message.hasOwnProperty("description"))
                object.description = message.description;
            if (message.support != null && message.hasOwnProperty("support"))
                object.support = message.support;
            if (message.isParentGroup != null && message.hasOwnProperty("isParentGroup"))
                object.isParentGroup = message.isParentGroup;
            if (message.isDefaultSubgroup != null && message.hasOwnProperty("isDefaultSubgroup"))
                object.isDefaultSubgroup = message.isDefaultSubgroup;
            if (message.parentGroupId != null && message.hasOwnProperty("parentGroupId"))
                object.parentGroupId = message.parentGroupId;
            if (message.displayName != null && message.hasOwnProperty("displayName"))
                object.displayName = message.displayName;
            if (message.pnJid != null && message.hasOwnProperty("pnJid"))
                object.pnJid = message.pnJid;
            if (message.shareOwnPn != null && message.hasOwnProperty("shareOwnPn"))
                object.shareOwnPn = message.shareOwnPn;
            if (message.pnhDuplicateLidThread != null && message.hasOwnProperty("pnhDuplicateLidThread"))
                object.pnhDuplicateLidThread = message.pnhDuplicateLidThread;
            if (message.lidJid != null && message.hasOwnProperty("lidJid"))
                object.lidJid = message.lidJid;
            return object;
        };

        /**
         * Converts this Conversation to JSON.
         * @function toJSON
         * @memberof proto.Conversation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Conversation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * EndOfHistoryTransferType enum.
         * @name proto.Conversation.EndOfHistoryTransferType
         * @enum {number}
         * @property {number} COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY=0 COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY value
         * @property {number} COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY=1 COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY value
         */
        Conversation.EndOfHistoryTransferType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "COMPLETE_BUT_MORE_MESSAGES_REMAIN_ON_PRIMARY"] = 0;
            values[valuesById[1] = "COMPLETE_AND_NO_MORE_MESSAGE_REMAIN_ON_PRIMARY"] = 1;
            return values;
        })();

        return Conversation;
    })();

    proto.DeviceListMetadata = (function() {

        /**
         * Properties of a DeviceListMetadata.
         * @memberof proto
         * @interface IDeviceListMetadata
         * @property {Uint8Array|null} [senderKeyHash] DeviceListMetadata senderKeyHash
         * @property {number|Long|null} [senderTimestamp] DeviceListMetadata senderTimestamp
         * @property {Array.<number>|null} [senderKeyIndexes] DeviceListMetadata senderKeyIndexes
         * @property {Uint8Array|null} [recipientKeyHash] DeviceListMetadata recipientKeyHash
         * @property {number|Long|null} [recipientTimestamp] DeviceListMetadata recipientTimestamp
         * @property {Array.<number>|null} [recipientKeyIndexes] DeviceListMetadata recipientKeyIndexes
         */

        /**
         * Constructs a new DeviceListMetadata.
         * @memberof proto
         * @classdesc Represents a DeviceListMetadata.
         * @implements IDeviceListMetadata
         * @constructor
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         */
        function DeviceListMetadata(properties) {
            this.senderKeyIndexes = [];
            this.recipientKeyIndexes = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceListMetadata senderKeyHash.
         * @member {Uint8Array} senderKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata senderTimestamp.
         * @member {number|Long} senderTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata senderKeyIndexes.
         * @member {Array.<number>} senderKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.senderKeyIndexes = $util.emptyArray;

        /**
         * DeviceListMetadata recipientKeyHash.
         * @member {Uint8Array} recipientKeyHash
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyHash = $util.newBuffer([]);

        /**
         * DeviceListMetadata recipientTimestamp.
         * @member {number|Long} recipientTimestamp
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientTimestamp = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * DeviceListMetadata recipientKeyIndexes.
         * @member {Array.<number>} recipientKeyIndexes
         * @memberof proto.DeviceListMetadata
         * @instance
         */
        DeviceListMetadata.prototype.recipientKeyIndexes = $util.emptyArray;

        /**
         * Creates a new DeviceListMetadata instance using the specified properties.
         * @function create
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata=} [properties] Properties to set
         * @returns {proto.DeviceListMetadata} DeviceListMetadata instance
         */
        DeviceListMetadata.create = function create(properties) {
            return new DeviceListMetadata(properties);
        };

        /**
         * Encodes the specified DeviceListMetadata message. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.senderKeyHash != null && Object.hasOwnProperty.call(message, "senderKeyHash"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.senderKeyHash);
            if (message.senderTimestamp != null && Object.hasOwnProperty.call(message, "senderTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.senderTimestamp);
            if (message.senderKeyIndexes != null && message.senderKeyIndexes.length) {
                writer.uint32(/* id 3, wireType 2 =*/26).fork();
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    writer.uint32(message.senderKeyIndexes[i]);
                writer.ldelim();
            }
            if (message.recipientKeyHash != null && Object.hasOwnProperty.call(message, "recipientKeyHash"))
                writer.uint32(/* id 8, wireType 2 =*/66).bytes(message.recipientKeyHash);
            if (message.recipientTimestamp != null && Object.hasOwnProperty.call(message, "recipientTimestamp"))
                writer.uint32(/* id 9, wireType 0 =*/72).uint64(message.recipientTimestamp);
            if (message.recipientKeyIndexes != null && message.recipientKeyIndexes.length) {
                writer.uint32(/* id 10, wireType 2 =*/82).fork();
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    writer.uint32(message.recipientKeyIndexes[i]);
                writer.ldelim();
            }
            return writer;
        };

        /**
         * Encodes the specified DeviceListMetadata message, length delimited. Does not implicitly {@link proto.DeviceListMetadata.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.IDeviceListMetadata} message DeviceListMetadata message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceListMetadata.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceListMetadata();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.senderKeyHash = reader.bytes();
                    break;
                case 2:
                    message.senderTimestamp = reader.uint64();
                    break;
                case 3:
                    if (!(message.senderKeyIndexes && message.senderKeyIndexes.length))
                        message.senderKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.senderKeyIndexes.push(reader.uint32());
                    } else
                        message.senderKeyIndexes.push(reader.uint32());
                    break;
                case 8:
                    message.recipientKeyHash = reader.bytes();
                    break;
                case 9:
                    message.recipientTimestamp = reader.uint64();
                    break;
                case 10:
                    if (!(message.recipientKeyIndexes && message.recipientKeyIndexes.length))
                        message.recipientKeyIndexes = [];
                    if ((tag & 7) === 2) {
                        var end2 = reader.uint32() + reader.pos;
                        while (reader.pos < end2)
                            message.recipientKeyIndexes.push(reader.uint32());
                    } else
                        message.recipientKeyIndexes.push(reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceListMetadata message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceListMetadata.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceListMetadata message.
         * @function verify
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceListMetadata.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                if (!(message.senderKeyHash && typeof message.senderKeyHash.length === "number" || $util.isString(message.senderKeyHash)))
                    return "senderKeyHash: buffer expected";
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (!$util.isInteger(message.senderTimestamp) && !(message.senderTimestamp && $util.isInteger(message.senderTimestamp.low) && $util.isInteger(message.senderTimestamp.high)))
                    return "senderTimestamp: integer|Long expected";
            if (message.senderKeyIndexes != null && message.hasOwnProperty("senderKeyIndexes")) {
                if (!Array.isArray(message.senderKeyIndexes))
                    return "senderKeyIndexes: array expected";
                for (var i = 0; i < message.senderKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.senderKeyIndexes[i]))
                        return "senderKeyIndexes: integer[] expected";
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                if (!(message.recipientKeyHash && typeof message.recipientKeyHash.length === "number" || $util.isString(message.recipientKeyHash)))
                    return "recipientKeyHash: buffer expected";
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (!$util.isInteger(message.recipientTimestamp) && !(message.recipientTimestamp && $util.isInteger(message.recipientTimestamp.low) && $util.isInteger(message.recipientTimestamp.high)))
                    return "recipientTimestamp: integer|Long expected";
            if (message.recipientKeyIndexes != null && message.hasOwnProperty("recipientKeyIndexes")) {
                if (!Array.isArray(message.recipientKeyIndexes))
                    return "recipientKeyIndexes: array expected";
                for (var i = 0; i < message.recipientKeyIndexes.length; ++i)
                    if (!$util.isInteger(message.recipientKeyIndexes[i]))
                        return "recipientKeyIndexes: integer[] expected";
            }
            return null;
        };

        /**
         * Creates a DeviceListMetadata message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceListMetadata} DeviceListMetadata
         */
        DeviceListMetadata.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceListMetadata)
                return object;
            var message = new $root.proto.DeviceListMetadata();
            if (object.senderKeyHash != null)
                if (typeof object.senderKeyHash === "string")
                    $util.base64.decode(object.senderKeyHash, message.senderKeyHash = $util.newBuffer($util.base64.length(object.senderKeyHash)), 0);
                else if (object.senderKeyHash.length)
                    message.senderKeyHash = object.senderKeyHash;
            if (object.senderTimestamp != null)
                if ($util.Long)
                    (message.senderTimestamp = $util.Long.fromValue(object.senderTimestamp)).unsigned = true;
                else if (typeof object.senderTimestamp === "string")
                    message.senderTimestamp = parseInt(object.senderTimestamp, 10);
                else if (typeof object.senderTimestamp === "number")
                    message.senderTimestamp = object.senderTimestamp;
                else if (typeof object.senderTimestamp === "object")
                    message.senderTimestamp = new $util.LongBits(object.senderTimestamp.low >>> 0, object.senderTimestamp.high >>> 0).toNumber(true);
            if (object.senderKeyIndexes) {
                if (!Array.isArray(object.senderKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.senderKeyIndexes: array expected");
                message.senderKeyIndexes = [];
                for (var i = 0; i < object.senderKeyIndexes.length; ++i)
                    message.senderKeyIndexes[i] = object.senderKeyIndexes[i] >>> 0;
            }
            if (object.recipientKeyHash != null)
                if (typeof object.recipientKeyHash === "string")
                    $util.base64.decode(object.recipientKeyHash, message.recipientKeyHash = $util.newBuffer($util.base64.length(object.recipientKeyHash)), 0);
                else if (object.recipientKeyHash.length)
                    message.recipientKeyHash = object.recipientKeyHash;
            if (object.recipientTimestamp != null)
                if ($util.Long)
                    (message.recipientTimestamp = $util.Long.fromValue(object.recipientTimestamp)).unsigned = true;
                else if (typeof object.recipientTimestamp === "string")
                    message.recipientTimestamp = parseInt(object.recipientTimestamp, 10);
                else if (typeof object.recipientTimestamp === "number")
                    message.recipientTimestamp = object.recipientTimestamp;
                else if (typeof object.recipientTimestamp === "object")
                    message.recipientTimestamp = new $util.LongBits(object.recipientTimestamp.low >>> 0, object.recipientTimestamp.high >>> 0).toNumber(true);
            if (object.recipientKeyIndexes) {
                if (!Array.isArray(object.recipientKeyIndexes))
                    throw TypeError(".proto.DeviceListMetadata.recipientKeyIndexes: array expected");
                message.recipientKeyIndexes = [];
                for (var i = 0; i < object.recipientKeyIndexes.length; ++i)
                    message.recipientKeyIndexes[i] = object.recipientKeyIndexes[i] >>> 0;
            }
            return message;
        };

        /**
         * Creates a plain object from a DeviceListMetadata message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceListMetadata
         * @static
         * @param {proto.DeviceListMetadata} message DeviceListMetadata
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceListMetadata.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.senderKeyIndexes = [];
                object.recipientKeyIndexes = [];
            }
            if (options.defaults) {
                if (options.bytes === String)
                    object.senderKeyHash = "";
                else {
                    object.senderKeyHash = [];
                    if (options.bytes !== Array)
                        object.senderKeyHash = $util.newBuffer(object.senderKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.senderTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.senderTimestamp = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.recipientKeyHash = "";
                else {
                    object.recipientKeyHash = [];
                    if (options.bytes !== Array)
                        object.recipientKeyHash = $util.newBuffer(object.recipientKeyHash);
                }
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.recipientTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.recipientTimestamp = options.longs === String ? "0" : 0;
            }
            if (message.senderKeyHash != null && message.hasOwnProperty("senderKeyHash"))
                object.senderKeyHash = options.bytes === String ? $util.base64.encode(message.senderKeyHash, 0, message.senderKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.senderKeyHash) : message.senderKeyHash;
            if (message.senderTimestamp != null && message.hasOwnProperty("senderTimestamp"))
                if (typeof message.senderTimestamp === "number")
                    object.senderTimestamp = options.longs === String ? String(message.senderTimestamp) : message.senderTimestamp;
                else
                    object.senderTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.senderTimestamp) : options.longs === Number ? new $util.LongBits(message.senderTimestamp.low >>> 0, message.senderTimestamp.high >>> 0).toNumber(true) : message.senderTimestamp;
            if (message.senderKeyIndexes && message.senderKeyIndexes.length) {
                object.senderKeyIndexes = [];
                for (var j = 0; j < message.senderKeyIndexes.length; ++j)
                    object.senderKeyIndexes[j] = message.senderKeyIndexes[j];
            }
            if (message.recipientKeyHash != null && message.hasOwnProperty("recipientKeyHash"))
                object.recipientKeyHash = options.bytes === String ? $util.base64.encode(message.recipientKeyHash, 0, message.recipientKeyHash.length) : options.bytes === Array ? Array.prototype.slice.call(message.recipientKeyHash) : message.recipientKeyHash;
            if (message.recipientTimestamp != null && message.hasOwnProperty("recipientTimestamp"))
                if (typeof message.recipientTimestamp === "number")
                    object.recipientTimestamp = options.longs === String ? String(message.recipientTimestamp) : message.recipientTimestamp;
                else
                    object.recipientTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.recipientTimestamp) : options.longs === Number ? new $util.LongBits(message.recipientTimestamp.low >>> 0, message.recipientTimestamp.high >>> 0).toNumber(true) : message.recipientTimestamp;
            if (message.recipientKeyIndexes && message.recipientKeyIndexes.length) {
                object.recipientKeyIndexes = [];
                for (var j = 0; j < message.recipientKeyIndexes.length; ++j)
                    object.recipientKeyIndexes[j] = message.recipientKeyIndexes[j];
            }
            return object;
        };

        /**
         * Converts this DeviceListMetadata to JSON.
         * @function toJSON
         * @memberof proto.DeviceListMetadata
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceListMetadata.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return DeviceListMetadata;
    })();

    proto.DeviceProps = (function() {

        /**
         * Properties of a DeviceProps.
         * @memberof proto
         * @interface IDeviceProps
         * @property {string|null} [os] DeviceProps os
         * @property {proto.DeviceProps.IAppVersion|null} [version] DeviceProps version
         * @property {proto.DeviceProps.PlatformType|null} [platformType] DeviceProps platformType
         * @property {boolean|null} [requireFullSync] DeviceProps requireFullSync
         * @property {proto.DeviceProps.IHistorySyncConfig|null} [historySyncConfig] DeviceProps historySyncConfig
         */

        /**
         * Constructs a new DeviceProps.
         * @memberof proto
         * @classdesc Represents a DeviceProps.
         * @implements IDeviceProps
         * @constructor
         * @param {proto.IDeviceProps=} [properties] Properties to set
         */
        function DeviceProps(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DeviceProps os.
         * @member {string} os
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.os = "";

        /**
         * DeviceProps version.
         * @member {proto.DeviceProps.IAppVersion|null|undefined} version
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.version = null;

        /**
         * DeviceProps platformType.
         * @member {proto.DeviceProps.PlatformType} platformType
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.platformType = 0;

        /**
         * DeviceProps requireFullSync.
         * @member {boolean} requireFullSync
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.requireFullSync = false;

        /**
         * DeviceProps historySyncConfig.
         * @member {proto.DeviceProps.IHistorySyncConfig|null|undefined} historySyncConfig
         * @memberof proto.DeviceProps
         * @instance
         */
        DeviceProps.prototype.historySyncConfig = null;

        /**
         * Creates a new DeviceProps instance using the specified properties.
         * @function create
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps=} [properties] Properties to set
         * @returns {proto.DeviceProps} DeviceProps instance
         */
        DeviceProps.create = function create(properties) {
            return new DeviceProps(properties);
        };

        /**
         * Encodes the specified DeviceProps message. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @function encode
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps} message DeviceProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceProps.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.os != null && Object.hasOwnProperty.call(message, "os"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.os);
            if (message.version != null && Object.hasOwnProperty.call(message, "version"))
                $root.proto.DeviceProps.AppVersion.encode(message.version, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.platformType != null && Object.hasOwnProperty.call(message, "platformType"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.platformType);
            if (message.requireFullSync != null && Object.hasOwnProperty.call(message, "requireFullSync"))
                writer.uint32(/* id 4, wireType 0 =*/32).bool(message.requireFullSync);
            if (message.historySyncConfig != null && Object.hasOwnProperty.call(message, "historySyncConfig"))
                $root.proto.DeviceProps.HistorySyncConfig.encode(message.historySyncConfig, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified DeviceProps message, length delimited. Does not implicitly {@link proto.DeviceProps.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.IDeviceProps} message DeviceProps message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DeviceProps.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DeviceProps message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DeviceProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DeviceProps} DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceProps.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceProps();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.os = reader.string();
                    break;
                case 2:
                    message.version = $root.proto.DeviceProps.AppVersion.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.platformType = reader.int32();
                    break;
                case 4:
                    message.requireFullSync = reader.bool();
                    break;
                case 5:
                    message.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DeviceProps message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DeviceProps
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DeviceProps} DeviceProps
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DeviceProps.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DeviceProps message.
         * @function verify
         * @memberof proto.DeviceProps
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DeviceProps.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.os != null && message.hasOwnProperty("os"))
                if (!$util.isString(message.os))
                    return "os: string expected";
            if (message.version != null && message.hasOwnProperty("version")) {
                var error = $root.proto.DeviceProps.AppVersion.verify(message.version);
                if (error)
                    return "version." + error;
            }
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                switch (message.platformType) {
                default:
                    return "platformType: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                case 5:
                case 6:
                case 7:
                case 8:
                case 9:
                case 10:
                case 11:
                case 12:
                case 13:
                    break;
                }
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                if (typeof message.requireFullSync !== "boolean")
                    return "requireFullSync: boolean expected";
            if (message.historySyncConfig != null && message.hasOwnProperty("historySyncConfig")) {
                var error = $root.proto.DeviceProps.HistorySyncConfig.verify(message.historySyncConfig);
                if (error)
                    return "historySyncConfig." + error;
            }
            return null;
        };

        /**
         * Creates a DeviceProps message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DeviceProps
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DeviceProps} DeviceProps
         */
        DeviceProps.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DeviceProps)
                return object;
            var message = new $root.proto.DeviceProps();
            if (object.os != null)
                message.os = String(object.os);
            if (object.version != null) {
                if (typeof object.version !== "object")
                    throw TypeError(".proto.DeviceProps.version: object expected");
                message.version = $root.proto.DeviceProps.AppVersion.fromObject(object.version);
            }
            switch (object.platformType) {
            case "UNKNOWN":
            case 0:
                message.platformType = 0;
                break;
            case "CHROME":
            case 1:
                message.platformType = 1;
                break;
            case "FIREFOX":
            case 2:
                message.platformType = 2;
                break;
            case "IE":
            case 3:
                message.platformType = 3;
                break;
            case "OPERA":
            case 4:
                message.platformType = 4;
                break;
            case "SAFARI":
            case 5:
                message.platformType = 5;
                break;
            case "EDGE":
            case 6:
                message.platformType = 6;
                break;
            case "DESKTOP":
            case 7:
                message.platformType = 7;
                break;
            case "IPAD":
            case 8:
                message.platformType = 8;
                break;
            case "ANDROID_TABLET":
            case 9:
                message.platformType = 9;
                break;
            case "OHANA":
            case 10:
                message.platformType = 10;
                break;
            case "ALOHA":
            case 11:
                message.platformType = 11;
                break;
            case "CATALINA":
            case 12:
                message.platformType = 12;
                break;
            case "TCL_TV":
            case 13:
                message.platformType = 13;
                break;
            }
            if (object.requireFullSync != null)
                message.requireFullSync = Boolean(object.requireFullSync);
            if (object.historySyncConfig != null) {
                if (typeof object.historySyncConfig !== "object")
                    throw TypeError(".proto.DeviceProps.historySyncConfig: object expected");
                message.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.fromObject(object.historySyncConfig);
            }
            return message;
        };

        /**
         * Creates a plain object from a DeviceProps message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DeviceProps
         * @static
         * @param {proto.DeviceProps} message DeviceProps
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DeviceProps.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.os = "";
                object.version = null;
                object.platformType = options.enums === String ? "UNKNOWN" : 0;
                object.requireFullSync = false;
                object.historySyncConfig = null;
            }
            if (message.os != null && message.hasOwnProperty("os"))
                object.os = message.os;
            if (message.version != null && message.hasOwnProperty("version"))
                object.version = $root.proto.DeviceProps.AppVersion.toObject(message.version, options);
            if (message.platformType != null && message.hasOwnProperty("platformType"))
                object.platformType = options.enums === String ? $root.proto.DeviceProps.PlatformType[message.platformType] : message.platformType;
            if (message.requireFullSync != null && message.hasOwnProperty("requireFullSync"))
                object.requireFullSync = message.requireFullSync;
            if (message.historySyncConfig != null && message.hasOwnProperty("historySyncConfig"))
                object.historySyncConfig = $root.proto.DeviceProps.HistorySyncConfig.toObject(message.historySyncConfig, options);
            return object;
        };

        /**
         * Converts this DeviceProps to JSON.
         * @function toJSON
         * @memberof proto.DeviceProps
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DeviceProps.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        DeviceProps.AppVersion = (function() {

            /**
             * Properties of an AppVersion.
             * @memberof proto.DeviceProps
             * @interface IAppVersion
             * @property {number|null} [primary] AppVersion primary
             * @property {number|null} [secondary] AppVersion secondary
             * @property {number|null} [tertiary] AppVersion tertiary
             * @property {number|null} [quaternary] AppVersion quaternary
             * @property {number|null} [quinary] AppVersion quinary
             */

            /**
             * Constructs a new AppVersion.
             * @memberof proto.DeviceProps
             * @classdesc Represents an AppVersion.
             * @implements IAppVersion
             * @constructor
             * @param {proto.DeviceProps.IAppVersion=} [properties] Properties to set
             */
            function AppVersion(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AppVersion primary.
             * @member {number} primary
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             */
            AppVersion.prototype.primary = 0;

            /**
             * AppVersion secondary.
             * @member {number} secondary
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             */
            AppVersion.prototype.secondary = 0;

            /**
             * AppVersion tertiary.
             * @member {number} tertiary
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             */
            AppVersion.prototype.tertiary = 0;

            /**
             * AppVersion quaternary.
             * @member {number} quaternary
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             */
            AppVersion.prototype.quaternary = 0;

            /**
             * AppVersion quinary.
             * @member {number} quinary
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             */
            AppVersion.prototype.quinary = 0;

            /**
             * Creates a new AppVersion instance using the specified properties.
             * @function create
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {proto.DeviceProps.IAppVersion=} [properties] Properties to set
             * @returns {proto.DeviceProps.AppVersion} AppVersion instance
             */
            AppVersion.create = function create(properties) {
                return new AppVersion(properties);
            };

            /**
             * Encodes the specified AppVersion message. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @function encode
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {proto.DeviceProps.IAppVersion} message AppVersion message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppVersion.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.primary != null && Object.hasOwnProperty.call(message, "primary"))
                    writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.primary);
                if (message.secondary != null && Object.hasOwnProperty.call(message, "secondary"))
                    writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.secondary);
                if (message.tertiary != null && Object.hasOwnProperty.call(message, "tertiary"))
                    writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.tertiary);
                if (message.quaternary != null && Object.hasOwnProperty.call(message, "quaternary"))
                    writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.quaternary);
                if (message.quinary != null && Object.hasOwnProperty.call(message, "quinary"))
                    writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.quinary);
                return writer;
            };

            /**
             * Encodes the specified AppVersion message, length delimited. Does not implicitly {@link proto.DeviceProps.AppVersion.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {proto.DeviceProps.IAppVersion} message AppVersion message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppVersion.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an AppVersion message from the specified reader or buffer.
             * @function decode
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.DeviceProps.AppVersion} AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppVersion.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceProps.AppVersion();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.primary = reader.uint32();
                        break;
                    case 2:
                        message.secondary = reader.uint32();
                        break;
                    case 3:
                        message.tertiary = reader.uint32();
                        break;
                    case 4:
                        message.quaternary = reader.uint32();
                        break;
                    case 5:
                        message.quinary = reader.uint32();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an AppVersion message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.DeviceProps.AppVersion} AppVersion
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppVersion.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an AppVersion message.
             * @function verify
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AppVersion.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.primary != null && message.hasOwnProperty("primary"))
                    if (!$util.isInteger(message.primary))
                        return "primary: integer expected";
                if (message.secondary != null && message.hasOwnProperty("secondary"))
                    if (!$util.isInteger(message.secondary))
                        return "secondary: integer expected";
                if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                    if (!$util.isInteger(message.tertiary))
                        return "tertiary: integer expected";
                if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                    if (!$util.isInteger(message.quaternary))
                        return "quaternary: integer expected";
                if (message.quinary != null && message.hasOwnProperty("quinary"))
                    if (!$util.isInteger(message.quinary))
                        return "quinary: integer expected";
                return null;
            };

            /**
             * Creates an AppVersion message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.DeviceProps.AppVersion} AppVersion
             */
            AppVersion.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.DeviceProps.AppVersion)
                    return object;
                var message = new $root.proto.DeviceProps.AppVersion();
                if (object.primary != null)
                    message.primary = object.primary >>> 0;
                if (object.secondary != null)
                    message.secondary = object.secondary >>> 0;
                if (object.tertiary != null)
                    message.tertiary = object.tertiary >>> 0;
                if (object.quaternary != null)
                    message.quaternary = object.quaternary >>> 0;
                if (object.quinary != null)
                    message.quinary = object.quinary >>> 0;
                return message;
            };

            /**
             * Creates a plain object from an AppVersion message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.DeviceProps.AppVersion
             * @static
             * @param {proto.DeviceProps.AppVersion} message AppVersion
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            AppVersion.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.primary = 0;
                    object.secondary = 0;
                    object.tertiary = 0;
                    object.quaternary = 0;
                    object.quinary = 0;
                }
                if (message.primary != null && message.hasOwnProperty("primary"))
                    object.primary = message.primary;
                if (message.secondary != null && message.hasOwnProperty("secondary"))
                    object.secondary = message.secondary;
                if (message.tertiary != null && message.hasOwnProperty("tertiary"))
                    object.tertiary = message.tertiary;
                if (message.quaternary != null && message.hasOwnProperty("quaternary"))
                    object.quaternary = message.quaternary;
                if (message.quinary != null && message.hasOwnProperty("quinary"))
                    object.quinary = message.quinary;
                return object;
            };

            /**
             * Converts this AppVersion to JSON.
             * @function toJSON
             * @memberof proto.DeviceProps.AppVersion
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            AppVersion.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return AppVersion;
        })();

        DeviceProps.HistorySyncConfig = (function() {

            /**
             * Properties of a HistorySyncConfig.
             * @memberof proto.DeviceProps
             * @interface IHistorySyncConfig
             * @property {number|null} [fullSyncDaysLimit] HistorySyncConfig fullSyncDaysLimit
             * @property {number|null} [fullSyncSizeMbLimit] HistorySyncConfig fullSyncSizeMbLimit
             * @property {number|null} [storageQuotaMb] HistorySyncConfig storageQuotaMb
             */

            /**
             * Constructs a new HistorySyncConfig.
             * @memberof proto.DeviceProps
             * @classdesc Represents a HistorySyncConfig.
             * @implements IHistorySyncConfig
             * @constructor
             * @param {proto.DeviceProps.IHistorySyncConfig=} [properties] Properties to set
             */
            function HistorySyncConfig(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * HistorySyncConfig fullSyncDaysLimit.
             * @member {number} fullSyncDaysLimit
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @instance
             */
            HistorySyncConfig.prototype.fullSyncDaysLimit = 0;

            /**
             * HistorySyncConfig fullSyncSizeMbLimit.
             * @member {number} fullSyncSizeMbLimit
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @instance
             */
            HistorySyncConfig.prototype.fullSyncSizeMbLimit = 0;

            /**
             * HistorySyncConfig storageQuotaMb.
             * @member {number} storageQuotaMb
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @instance
             */
            HistorySyncConfig.prototype.storageQuotaMb = 0;

            /**
             * Creates a new HistorySyncConfig instance using the specified properties.
             * @function create
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {proto.DeviceProps.IHistorySyncConfig=} [properties] Properties to set
             * @returns {proto.DeviceProps.HistorySyncConfig} HistorySyncConfig instance
             */
            HistorySyncConfig.create = function create(properties) {
                return new HistorySyncConfig(properties);
            };

            /**
             * Encodes the specified HistorySyncConfig message. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @function encode
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {proto.DeviceProps.IHistorySyncConfig} message HistorySyncConfig message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HistorySyncConfig.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.fullSyncDaysLimit != null && Object.hasOwnProperty.call(message, "fullSyncDaysLimit"))
                    writer.uint32(/* id 1, wireType 0 =*/8).uint32(message.fullSyncDaysLimit);
                if (message.fullSyncSizeMbLimit != null && Object.hasOwnProperty.call(message, "fullSyncSizeMbLimit"))
                    writer.uint32(/* id 2, wireType 0 =*/16).uint32(message.fullSyncSizeMbLimit);
                if (message.storageQuotaMb != null && Object.hasOwnProperty.call(message, "storageQuotaMb"))
                    writer.uint32(/* id 3, wireType 0 =*/24).uint32(message.storageQuotaMb);
                return writer;
            };

            /**
             * Encodes the specified HistorySyncConfig message, length delimited. Does not implicitly {@link proto.DeviceProps.HistorySyncConfig.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {proto.DeviceProps.IHistorySyncConfig} message HistorySyncConfig message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HistorySyncConfig.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer.
             * @function decode
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.DeviceProps.HistorySyncConfig} HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HistorySyncConfig.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DeviceProps.HistorySyncConfig();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.fullSyncDaysLimit = reader.uint32();
                        break;
                    case 2:
                        message.fullSyncSizeMbLimit = reader.uint32();
                        break;
                    case 3:
                        message.storageQuotaMb = reader.uint32();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a HistorySyncConfig message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.DeviceProps.HistorySyncConfig} HistorySyncConfig
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HistorySyncConfig.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a HistorySyncConfig message.
             * @function verify
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            HistorySyncConfig.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.fullSyncDaysLimit != null && message.hasOwnProperty("fullSyncDaysLimit"))
                    if (!$util.isInteger(message.fullSyncDaysLimit))
                        return "fullSyncDaysLimit: integer expected";
                if (message.fullSyncSizeMbLimit != null && message.hasOwnProperty("fullSyncSizeMbLimit"))
                    if (!$util.isInteger(message.fullSyncSizeMbLimit))
                        return "fullSyncSizeMbLimit: integer expected";
                if (message.storageQuotaMb != null && message.hasOwnProperty("storageQuotaMb"))
                    if (!$util.isInteger(message.storageQuotaMb))
                        return "storageQuotaMb: integer expected";
                return null;
            };

            /**
             * Creates a HistorySyncConfig message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.DeviceProps.HistorySyncConfig} HistorySyncConfig
             */
            HistorySyncConfig.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.DeviceProps.HistorySyncConfig)
                    return object;
                var message = new $root.proto.DeviceProps.HistorySyncConfig();
                if (object.fullSyncDaysLimit != null)
                    message.fullSyncDaysLimit = object.fullSyncDaysLimit >>> 0;
                if (object.fullSyncSizeMbLimit != null)
                    message.fullSyncSizeMbLimit = object.fullSyncSizeMbLimit >>> 0;
                if (object.storageQuotaMb != null)
                    message.storageQuotaMb = object.storageQuotaMb >>> 0;
                return message;
            };

            /**
             * Creates a plain object from a HistorySyncConfig message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @static
             * @param {proto.DeviceProps.HistorySyncConfig} message HistorySyncConfig
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            HistorySyncConfig.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.fullSyncDaysLimit = 0;
                    object.fullSyncSizeMbLimit = 0;
                    object.storageQuotaMb = 0;
                }
                if (message.fullSyncDaysLimit != null && message.hasOwnProperty("fullSyncDaysLimit"))
                    object.fullSyncDaysLimit = message.fullSyncDaysLimit;
                if (message.fullSyncSizeMbLimit != null && message.hasOwnProperty("fullSyncSizeMbLimit"))
                    object.fullSyncSizeMbLimit = message.fullSyncSizeMbLimit;
                if (message.storageQuotaMb != null && message.hasOwnProperty("storageQuotaMb"))
                    object.storageQuotaMb = message.storageQuotaMb;
                return object;
            };

            /**
             * Converts this HistorySyncConfig to JSON.
             * @function toJSON
             * @memberof proto.DeviceProps.HistorySyncConfig
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            HistorySyncConfig.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return HistorySyncConfig;
        })();

        /**
         * PlatformType enum.
         * @name proto.DeviceProps.PlatformType
         * @enum {number}
         * @property {number} UNKNOWN=0 UNKNOWN value
         * @property {number} CHROME=1 CHROME value
         * @property {number} FIREFOX=2 FIREFOX value
         * @property {number} IE=3 IE value
         * @property {number} OPERA=4 OPERA value
         * @property {number} SAFARI=5 SAFARI value
         * @property {number} EDGE=6 EDGE value
         * @property {number} DESKTOP=7 DESKTOP value
         * @property {number} IPAD=8 IPAD value
         * @property {number} ANDROID_TABLET=9 ANDROID_TABLET value
         * @property {number} OHANA=10 OHANA value
         * @property {number} ALOHA=11 ALOHA value
         * @property {number} CATALINA=12 CATALINA value
         * @property {number} TCL_TV=13 TCL_TV value
         */
        DeviceProps.PlatformType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "UNKNOWN"] = 0;
            values[valuesById[1] = "CHROME"] = 1;
            values[valuesById[2] = "FIREFOX"] = 2;
            values[valuesById[3] = "IE"] = 3;
            values[valuesById[4] = "OPERA"] = 4;
            values[valuesById[5] = "SAFARI"] = 5;
            values[valuesById[6] = "EDGE"] = 6;
            values[valuesById[7] = "DESKTOP"] = 7;
            values[valuesById[8] = "IPAD"] = 8;
            values[valuesById[9] = "ANDROID_TABLET"] = 9;
            values[valuesById[10] = "OHANA"] = 10;
            values[valuesById[11] = "ALOHA"] = 11;
            values[valuesById[12] = "CATALINA"] = 12;
            values[valuesById[13] = "TCL_TV"] = 13;
            return values;
        })();

        return DeviceProps;
    })();

    proto.DisappearingMode = (function() {

        /**
         * Properties of a DisappearingMode.
         * @memberof proto
         * @interface IDisappearingMode
         * @property {proto.DisappearingMode.Initiator|null} [initiator] DisappearingMode initiator
         */

        /**
         * Constructs a new DisappearingMode.
         * @memberof proto
         * @classdesc Represents a DisappearingMode.
         * @implements IDisappearingMode
         * @constructor
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         */
        function DisappearingMode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * DisappearingMode initiator.
         * @member {proto.DisappearingMode.Initiator} initiator
         * @memberof proto.DisappearingMode
         * @instance
         */
        DisappearingMode.prototype.initiator = 0;

        /**
         * Creates a new DisappearingMode instance using the specified properties.
         * @function create
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode=} [properties] Properties to set
         * @returns {proto.DisappearingMode} DisappearingMode instance
         */
        DisappearingMode.create = function create(properties) {
            return new DisappearingMode(properties);
        };

        /**
         * Encodes the specified DisappearingMode message. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encode
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.initiator != null && Object.hasOwnProperty.call(message, "initiator"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.initiator);
            return writer;
        };

        /**
         * Encodes the specified DisappearingMode message, length delimited. Does not implicitly {@link proto.DisappearingMode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.IDisappearingMode} message DisappearingMode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        DisappearingMode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.DisappearingMode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.initiator = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a DisappearingMode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.DisappearingMode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.DisappearingMode} DisappearingMode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        DisappearingMode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a DisappearingMode message.
         * @function verify
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        DisappearingMode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                switch (message.initiator) {
                default:
                    return "initiator: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a DisappearingMode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.DisappearingMode} DisappearingMode
         */
        DisappearingMode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.DisappearingMode)
                return object;
            var message = new $root.proto.DisappearingMode();
            switch (object.initiator) {
            case "CHANGED_IN_CHAT":
            case 0:
                message.initiator = 0;
                break;
            case "INITIATED_BY_ME":
            case 1:
                message.initiator = 1;
                break;
            case "INITIATED_BY_OTHER":
            case 2:
                message.initiator = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a DisappearingMode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.DisappearingMode
         * @static
         * @param {proto.DisappearingMode} message DisappearingMode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        DisappearingMode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.initiator = options.enums === String ? "CHANGED_IN_CHAT" : 0;
            if (message.initiator != null && message.hasOwnProperty("initiator"))
                object.initiator = options.enums === String ? $root.proto.DisappearingMode.Initiator[message.initiator] : message.initiator;
            return object;
        };

        /**
         * Converts this DisappearingMode to JSON.
         * @function toJSON
         * @memberof proto.DisappearingMode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        DisappearingMode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Initiator enum.
         * @name proto.DisappearingMode.Initiator
         * @enum {number}
         * @property {number} CHANGED_IN_CHAT=0 CHANGED_IN_CHAT value
         * @property {number} INITIATED_BY_ME=1 INITIATED_BY_ME value
         * @property {number} INITIATED_BY_OTHER=2 INITIATED_BY_OTHER value
         */
        DisappearingMode.Initiator = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "CHANGED_IN_CHAT"] = 0;
            values[valuesById[1] = "INITIATED_BY_ME"] = 1;
            values[valuesById[2] = "INITIATED_BY_OTHER"] = 2;
            return values;
        })();

        return DisappearingMode;
    })();

    proto.EphemeralSetting = (function() {

        /**
         * Properties of an EphemeralSetting.
         * @memberof proto
         * @interface IEphemeralSetting
         * @property {number|null} [duration] EphemeralSetting duration
         * @property {number|Long|null} [timestamp] EphemeralSetting timestamp
         */

        /**
         * Constructs a new EphemeralSetting.
         * @memberof proto
         * @classdesc Represents an EphemeralSetting.
         * @implements IEphemeralSetting
         * @constructor
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         */
        function EphemeralSetting(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * EphemeralSetting duration.
         * @member {number} duration
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.duration = 0;

        /**
         * EphemeralSetting timestamp.
         * @member {number|Long} timestamp
         * @memberof proto.EphemeralSetting
         * @instance
         */
        EphemeralSetting.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new EphemeralSetting instance using the specified properties.
         * @function create
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting=} [properties] Properties to set
         * @returns {proto.EphemeralSetting} EphemeralSetting instance
         */
        EphemeralSetting.create = function create(properties) {
            return new EphemeralSetting(properties);
        };

        /**
         * Encodes the specified EphemeralSetting message. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.duration != null && Object.hasOwnProperty.call(message, "duration"))
                writer.uint32(/* id 1, wireType 5 =*/13).sfixed32(message.duration);
            if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                writer.uint32(/* id 2, wireType 1 =*/17).sfixed64(message.timestamp);
            return writer;
        };

        /**
         * Encodes the specified EphemeralSetting message, length delimited. Does not implicitly {@link proto.EphemeralSetting.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.IEphemeralSetting} message EphemeralSetting message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        EphemeralSetting.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer.
         * @function decode
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.EphemeralSetting();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.duration = reader.sfixed32();
                    break;
                case 2:
                    message.timestamp = reader.sfixed64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an EphemeralSetting message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.EphemeralSetting
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.EphemeralSetting} EphemeralSetting
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        EphemeralSetting.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an EphemeralSetting message.
         * @function verify
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        EphemeralSetting.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.duration != null && message.hasOwnProperty("duration"))
                if (!$util.isInteger(message.duration))
                    return "duration: integer expected";
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                    return "timestamp: integer|Long expected";
            return null;
        };

        /**
         * Creates an EphemeralSetting message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.EphemeralSetting} EphemeralSetting
         */
        EphemeralSetting.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.EphemeralSetting)
                return object;
            var message = new $root.proto.EphemeralSetting();
            if (object.duration != null)
                message.duration = object.duration | 0;
            if (object.timestamp != null)
                if ($util.Long)
                    (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                else if (typeof object.timestamp === "string")
                    message.timestamp = parseInt(object.timestamp, 10);
                else if (typeof object.timestamp === "number")
                    message.timestamp = object.timestamp;
                else if (typeof object.timestamp === "object")
                    message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from an EphemeralSetting message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.EphemeralSetting
         * @static
         * @param {proto.EphemeralSetting} message EphemeralSetting
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        EphemeralSetting.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.duration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.timestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.timestamp = options.longs === String ? "0" : 0;
            }
            if (message.duration != null && message.hasOwnProperty("duration"))
                object.duration = message.duration;
            if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                if (typeof message.timestamp === "number")
                    object.timestamp = options.longs === String ? String(message.timestamp) : message.timestamp;
                else
                    object.timestamp = options.longs === String ? $util.Long.prototype.toString.call(message.timestamp) : options.longs === Number ? new $util.LongBits(message.timestamp.low >>> 0, message.timestamp.high >>> 0).toNumber() : message.timestamp;
            return object;
        };

        /**
         * Converts this EphemeralSetting to JSON.
         * @function toJSON
         * @memberof proto.EphemeralSetting
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        EphemeralSetting.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return EphemeralSetting;
    })();

    proto.ExitCode = (function() {

        /**
         * Properties of an ExitCode.
         * @memberof proto
         * @interface IExitCode
         * @property {number|Long|null} [code] ExitCode code
         * @property {string|null} [text] ExitCode text
         */

        /**
         * Constructs a new ExitCode.
         * @memberof proto
         * @classdesc Represents an ExitCode.
         * @implements IExitCode
         * @constructor
         * @param {proto.IExitCode=} [properties] Properties to set
         */
        function ExitCode(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExitCode code.
         * @member {number|Long} code
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.code = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExitCode text.
         * @member {string} text
         * @memberof proto.ExitCode
         * @instance
         */
        ExitCode.prototype.text = "";

        /**
         * Creates a new ExitCode instance using the specified properties.
         * @function create
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode=} [properties] Properties to set
         * @returns {proto.ExitCode} ExitCode instance
         */
        ExitCode.create = function create(properties) {
            return new ExitCode(properties);
        };

        /**
         * Encodes the specified ExitCode message. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encode
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                writer.uint32(/* id 1, wireType 0 =*/8).uint64(message.code);
            if (message.text != null && Object.hasOwnProperty.call(message, "text"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.text);
            return writer;
        };

        /**
         * Encodes the specified ExitCode message, length delimited. Does not implicitly {@link proto.ExitCode.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {proto.IExitCode} message ExitCode message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExitCode.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExitCode();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.code = reader.uint64();
                    break;
                case 2:
                    message.text = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExitCode message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExitCode
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExitCode} ExitCode
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExitCode.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExitCode message.
         * @function verify
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExitCode.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.code != null && message.hasOwnProperty("code"))
                if (!$util.isInteger(message.code) && !(message.code && $util.isInteger(message.code.low) && $util.isInteger(message.code.high)))
                    return "code: integer|Long expected";
            if (message.text != null && message.hasOwnProperty("text"))
                if (!$util.isString(message.text))
                    return "text: string expected";
            return null;
        };

        /**
         * Creates an ExitCode message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExitCode
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExitCode} ExitCode
         */
        ExitCode.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExitCode)
                return object;
            var message = new $root.proto.ExitCode();
            if (object.code != null)
                if ($util.Long)
                    (message.code = $util.Long.fromValue(object.code)).unsigned = true;
                else if (typeof object.code === "string")
                    message.code = parseInt(object.code, 10);
                else if (typeof object.code === "number")
                    message.code = object.code;
                else if (typeof object.code === "object")
                    message.code = new $util.LongBits(object.code.low >>> 0, object.code.high >>> 0).toNumber(true);
            if (object.text != null)
                message.text = String(object.text);
            return message;
        };

        /**
         * Creates a plain object from an ExitCode message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExitCode
         * @static
         * @param {proto.ExitCode} message ExitCode
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExitCode.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.code = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.code = options.longs === String ? "0" : 0;
                object.text = "";
            }
            if (message.code != null && message.hasOwnProperty("code"))
                if (typeof message.code === "number")
                    object.code = options.longs === String ? String(message.code) : message.code;
                else
                    object.code = options.longs === String ? $util.Long.prototype.toString.call(message.code) : options.longs === Number ? new $util.LongBits(message.code.low >>> 0, message.code.high >>> 0).toNumber(true) : message.code;
            if (message.text != null && message.hasOwnProperty("text"))
                object.text = message.text;
            return object;
        };

        /**
         * Converts this ExitCode to JSON.
         * @function toJSON
         * @memberof proto.ExitCode
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExitCode.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExitCode;
    })();

    proto.ExternalBlobReference = (function() {

        /**
         * Properties of an ExternalBlobReference.
         * @memberof proto
         * @interface IExternalBlobReference
         * @property {Uint8Array|null} [mediaKey] ExternalBlobReference mediaKey
         * @property {string|null} [directPath] ExternalBlobReference directPath
         * @property {string|null} [handle] ExternalBlobReference handle
         * @property {number|Long|null} [fileSizeBytes] ExternalBlobReference fileSizeBytes
         * @property {Uint8Array|null} [fileSha256] ExternalBlobReference fileSha256
         * @property {Uint8Array|null} [fileEncSha256] ExternalBlobReference fileEncSha256
         */

        /**
         * Constructs a new ExternalBlobReference.
         * @memberof proto
         * @classdesc Represents an ExternalBlobReference.
         * @implements IExternalBlobReference
         * @constructor
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         */
        function ExternalBlobReference(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * ExternalBlobReference mediaKey.
         * @member {Uint8Array} mediaKey
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.mediaKey = $util.newBuffer([]);

        /**
         * ExternalBlobReference directPath.
         * @member {string} directPath
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.directPath = "";

        /**
         * ExternalBlobReference handle.
         * @member {string} handle
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.handle = "";

        /**
         * ExternalBlobReference fileSizeBytes.
         * @member {number|Long} fileSizeBytes
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSizeBytes = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * ExternalBlobReference fileSha256.
         * @member {Uint8Array} fileSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileSha256 = $util.newBuffer([]);

        /**
         * ExternalBlobReference fileEncSha256.
         * @member {Uint8Array} fileEncSha256
         * @memberof proto.ExternalBlobReference
         * @instance
         */
        ExternalBlobReference.prototype.fileEncSha256 = $util.newBuffer([]);

        /**
         * Creates a new ExternalBlobReference instance using the specified properties.
         * @function create
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference=} [properties] Properties to set
         * @returns {proto.ExternalBlobReference} ExternalBlobReference instance
         */
        ExternalBlobReference.create = function create(properties) {
            return new ExternalBlobReference(properties);
        };

        /**
         * Encodes the specified ExternalBlobReference message. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.mediaKey != null && Object.hasOwnProperty.call(message, "mediaKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.mediaKey);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.directPath);
            if (message.handle != null && Object.hasOwnProperty.call(message, "handle"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.handle);
            if (message.fileSizeBytes != null && Object.hasOwnProperty.call(message, "fileSizeBytes"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint64(message.fileSizeBytes);
            if (message.fileSha256 != null && Object.hasOwnProperty.call(message, "fileSha256"))
                writer.uint32(/* id 5, wireType 2 =*/42).bytes(message.fileSha256);
            if (message.fileEncSha256 != null && Object.hasOwnProperty.call(message, "fileEncSha256"))
                writer.uint32(/* id 6, wireType 2 =*/50).bytes(message.fileEncSha256);
            return writer;
        };

        /**
         * Encodes the specified ExternalBlobReference message, length delimited. Does not implicitly {@link proto.ExternalBlobReference.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.IExternalBlobReference} message ExternalBlobReference message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        ExternalBlobReference.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer.
         * @function decode
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.ExternalBlobReference();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.mediaKey = reader.bytes();
                    break;
                case 2:
                    message.directPath = reader.string();
                    break;
                case 3:
                    message.handle = reader.string();
                    break;
                case 4:
                    message.fileSizeBytes = reader.uint64();
                    break;
                case 5:
                    message.fileSha256 = reader.bytes();
                    break;
                case 6:
                    message.fileEncSha256 = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an ExternalBlobReference message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        ExternalBlobReference.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an ExternalBlobReference message.
         * @function verify
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        ExternalBlobReference.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                if (!(message.mediaKey && typeof message.mediaKey.length === "number" || $util.isString(message.mediaKey)))
                    return "mediaKey: buffer expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.handle != null && message.hasOwnProperty("handle"))
                if (!$util.isString(message.handle))
                    return "handle: string expected";
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (!$util.isInteger(message.fileSizeBytes) && !(message.fileSizeBytes && $util.isInteger(message.fileSizeBytes.low) && $util.isInteger(message.fileSizeBytes.high)))
                    return "fileSizeBytes: integer|Long expected";
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                if (!(message.fileSha256 && typeof message.fileSha256.length === "number" || $util.isString(message.fileSha256)))
                    return "fileSha256: buffer expected";
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                if (!(message.fileEncSha256 && typeof message.fileEncSha256.length === "number" || $util.isString(message.fileEncSha256)))
                    return "fileEncSha256: buffer expected";
            return null;
        };

        /**
         * Creates an ExternalBlobReference message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.ExternalBlobReference} ExternalBlobReference
         */
        ExternalBlobReference.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.ExternalBlobReference)
                return object;
            var message = new $root.proto.ExternalBlobReference();
            if (object.mediaKey != null)
                if (typeof object.mediaKey === "string")
                    $util.base64.decode(object.mediaKey, message.mediaKey = $util.newBuffer($util.base64.length(object.mediaKey)), 0);
                else if (object.mediaKey.length)
                    message.mediaKey = object.mediaKey;
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            if (object.handle != null)
                message.handle = String(object.handle);
            if (object.fileSizeBytes != null)
                if ($util.Long)
                    (message.fileSizeBytes = $util.Long.fromValue(object.fileSizeBytes)).unsigned = true;
                else if (typeof object.fileSizeBytes === "string")
                    message.fileSizeBytes = parseInt(object.fileSizeBytes, 10);
                else if (typeof object.fileSizeBytes === "number")
                    message.fileSizeBytes = object.fileSizeBytes;
                else if (typeof object.fileSizeBytes === "object")
                    message.fileSizeBytes = new $util.LongBits(object.fileSizeBytes.low >>> 0, object.fileSizeBytes.high >>> 0).toNumber(true);
            if (object.fileSha256 != null)
                if (typeof object.fileSha256 === "string")
                    $util.base64.decode(object.fileSha256, message.fileSha256 = $util.newBuffer($util.base64.length(object.fileSha256)), 0);
                else if (object.fileSha256.length)
                    message.fileSha256 = object.fileSha256;
            if (object.fileEncSha256 != null)
                if (typeof object.fileEncSha256 === "string")
                    $util.base64.decode(object.fileEncSha256, message.fileEncSha256 = $util.newBuffer($util.base64.length(object.fileEncSha256)), 0);
                else if (object.fileEncSha256.length)
                    message.fileEncSha256 = object.fileEncSha256;
            return message;
        };

        /**
         * Creates a plain object from an ExternalBlobReference message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.ExternalBlobReference
         * @static
         * @param {proto.ExternalBlobReference} message ExternalBlobReference
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        ExternalBlobReference.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.mediaKey = "";
                else {
                    object.mediaKey = [];
                    if (options.bytes !== Array)
                        object.mediaKey = $util.newBuffer(object.mediaKey);
                }
                object.directPath = "";
                object.handle = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.fileSizeBytes = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.fileSizeBytes = options.longs === String ? "0" : 0;
                if (options.bytes === String)
                    object.fileSha256 = "";
                else {
                    object.fileSha256 = [];
                    if (options.bytes !== Array)
                        object.fileSha256 = $util.newBuffer(object.fileSha256);
                }
                if (options.bytes === String)
                    object.fileEncSha256 = "";
                else {
                    object.fileEncSha256 = [];
                    if (options.bytes !== Array)
                        object.fileEncSha256 = $util.newBuffer(object.fileEncSha256);
                }
            }
            if (message.mediaKey != null && message.hasOwnProperty("mediaKey"))
                object.mediaKey = options.bytes === String ? $util.base64.encode(message.mediaKey, 0, message.mediaKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.mediaKey) : message.mediaKey;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.handle != null && message.hasOwnProperty("handle"))
                object.handle = message.handle;
            if (message.fileSizeBytes != null && message.hasOwnProperty("fileSizeBytes"))
                if (typeof message.fileSizeBytes === "number")
                    object.fileSizeBytes = options.longs === String ? String(message.fileSizeBytes) : message.fileSizeBytes;
                else
                    object.fileSizeBytes = options.longs === String ? $util.Long.prototype.toString.call(message.fileSizeBytes) : options.longs === Number ? new $util.LongBits(message.fileSizeBytes.low >>> 0, message.fileSizeBytes.high >>> 0).toNumber(true) : message.fileSizeBytes;
            if (message.fileSha256 != null && message.hasOwnProperty("fileSha256"))
                object.fileSha256 = options.bytes === String ? $util.base64.encode(message.fileSha256, 0, message.fileSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileSha256) : message.fileSha256;
            if (message.fileEncSha256 != null && message.hasOwnProperty("fileEncSha256"))
                object.fileEncSha256 = options.bytes === String ? $util.base64.encode(message.fileEncSha256, 0, message.fileEncSha256.length) : options.bytes === Array ? Array.prototype.slice.call(message.fileEncSha256) : message.fileEncSha256;
            return object;
        };

        /**
         * Converts this ExternalBlobReference to JSON.
         * @function toJSON
         * @memberof proto.ExternalBlobReference
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        ExternalBlobReference.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return ExternalBlobReference;
    })();

    proto.GlobalSettings = (function() {

        /**
         * Properties of a GlobalSettings.
         * @memberof proto
         * @interface IGlobalSettings
         * @property {proto.IWallpaperSettings|null} [lightThemeWallpaper] GlobalSettings lightThemeWallpaper
         * @property {proto.MediaVisibility|null} [mediaVisibility] GlobalSettings mediaVisibility
         * @property {proto.IWallpaperSettings|null} [darkThemeWallpaper] GlobalSettings darkThemeWallpaper
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadWiFi] GlobalSettings autoDownloadWiFi
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadCellular] GlobalSettings autoDownloadCellular
         * @property {proto.IAutoDownloadSettings|null} [autoDownloadRoaming] GlobalSettings autoDownloadRoaming
         * @property {boolean|null} [showIndividualNotificationsPreview] GlobalSettings showIndividualNotificationsPreview
         * @property {boolean|null} [showGroupNotificationsPreview] GlobalSettings showGroupNotificationsPreview
         * @property {number|null} [disappearingModeDuration] GlobalSettings disappearingModeDuration
         * @property {number|Long|null} [disappearingModeTimestamp] GlobalSettings disappearingModeTimestamp
         * @property {proto.IAvatarUserSettings|null} [avatarUserSettings] GlobalSettings avatarUserSettings
         */

        /**
         * Constructs a new GlobalSettings.
         * @memberof proto
         * @classdesc Represents a GlobalSettings.
         * @implements IGlobalSettings
         * @constructor
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         */
        function GlobalSettings(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GlobalSettings lightThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} lightThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.lightThemeWallpaper = null;

        /**
         * GlobalSettings mediaVisibility.
         * @member {proto.MediaVisibility} mediaVisibility
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.mediaVisibility = 0;

        /**
         * GlobalSettings darkThemeWallpaper.
         * @member {proto.IWallpaperSettings|null|undefined} darkThemeWallpaper
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.darkThemeWallpaper = null;

        /**
         * GlobalSettings autoDownloadWiFi.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadWiFi
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadWiFi = null;

        /**
         * GlobalSettings autoDownloadCellular.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadCellular
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadCellular = null;

        /**
         * GlobalSettings autoDownloadRoaming.
         * @member {proto.IAutoDownloadSettings|null|undefined} autoDownloadRoaming
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.autoDownloadRoaming = null;

        /**
         * GlobalSettings showIndividualNotificationsPreview.
         * @member {boolean} showIndividualNotificationsPreview
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.showIndividualNotificationsPreview = false;

        /**
         * GlobalSettings showGroupNotificationsPreview.
         * @member {boolean} showGroupNotificationsPreview
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.showGroupNotificationsPreview = false;

        /**
         * GlobalSettings disappearingModeDuration.
         * @member {number} disappearingModeDuration
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.disappearingModeDuration = 0;

        /**
         * GlobalSettings disappearingModeTimestamp.
         * @member {number|Long} disappearingModeTimestamp
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.disappearingModeTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * GlobalSettings avatarUserSettings.
         * @member {proto.IAvatarUserSettings|null|undefined} avatarUserSettings
         * @memberof proto.GlobalSettings
         * @instance
         */
        GlobalSettings.prototype.avatarUserSettings = null;

        /**
         * Creates a new GlobalSettings instance using the specified properties.
         * @function create
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings=} [properties] Properties to set
         * @returns {proto.GlobalSettings} GlobalSettings instance
         */
        GlobalSettings.create = function create(properties) {
            return new GlobalSettings(properties);
        };

        /**
         * Encodes the specified GlobalSettings message. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encode
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lightThemeWallpaper != null && Object.hasOwnProperty.call(message, "lightThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.lightThemeWallpaper, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.mediaVisibility != null && Object.hasOwnProperty.call(message, "mediaVisibility"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.mediaVisibility);
            if (message.darkThemeWallpaper != null && Object.hasOwnProperty.call(message, "darkThemeWallpaper"))
                $root.proto.WallpaperSettings.encode(message.darkThemeWallpaper, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.autoDownloadWiFi != null && Object.hasOwnProperty.call(message, "autoDownloadWiFi"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadWiFi, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.autoDownloadCellular != null && Object.hasOwnProperty.call(message, "autoDownloadCellular"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadCellular, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.autoDownloadRoaming != null && Object.hasOwnProperty.call(message, "autoDownloadRoaming"))
                $root.proto.AutoDownloadSettings.encode(message.autoDownloadRoaming, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.showIndividualNotificationsPreview != null && Object.hasOwnProperty.call(message, "showIndividualNotificationsPreview"))
                writer.uint32(/* id 7, wireType 0 =*/56).bool(message.showIndividualNotificationsPreview);
            if (message.showGroupNotificationsPreview != null && Object.hasOwnProperty.call(message, "showGroupNotificationsPreview"))
                writer.uint32(/* id 8, wireType 0 =*/64).bool(message.showGroupNotificationsPreview);
            if (message.disappearingModeDuration != null && Object.hasOwnProperty.call(message, "disappearingModeDuration"))
                writer.uint32(/* id 9, wireType 0 =*/72).int32(message.disappearingModeDuration);
            if (message.disappearingModeTimestamp != null && Object.hasOwnProperty.call(message, "disappearingModeTimestamp"))
                writer.uint32(/* id 10, wireType 0 =*/80).int64(message.disappearingModeTimestamp);
            if (message.avatarUserSettings != null && Object.hasOwnProperty.call(message, "avatarUserSettings"))
                $root.proto.AvatarUserSettings.encode(message.avatarUserSettings, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified GlobalSettings message, length delimited. Does not implicitly {@link proto.GlobalSettings.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.IGlobalSettings} message GlobalSettings message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GlobalSettings.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer.
         * @function decode
         * @memberof proto.GlobalSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.GlobalSettings} GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GlobalSettings.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.GlobalSettings();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.lightThemeWallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.mediaVisibility = reader.int32();
                    break;
                case 3:
                    message.darkThemeWallpaper = $root.proto.WallpaperSettings.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.autoDownloadWiFi = $root.proto.AutoDownloadSettings.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.autoDownloadCellular = $root.proto.AutoDownloadSettings.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.autoDownloadRoaming = $root.proto.AutoDownloadSettings.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.showIndividualNotificationsPreview = reader.bool();
                    break;
                case 8:
                    message.showGroupNotificationsPreview = reader.bool();
                    break;
                case 9:
                    message.disappearingModeDuration = reader.int32();
                    break;
                case 10:
                    message.disappearingModeTimestamp = reader.int64();
                    break;
                case 11:
                    message.avatarUserSettings = $root.proto.AvatarUserSettings.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a GlobalSettings message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.GlobalSettings
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.GlobalSettings} GlobalSettings
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GlobalSettings.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GlobalSettings message.
         * @function verify
         * @memberof proto.GlobalSettings
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GlobalSettings.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.lightThemeWallpaper != null && message.hasOwnProperty("lightThemeWallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.lightThemeWallpaper);
                if (error)
                    return "lightThemeWallpaper." + error;
            }
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                switch (message.mediaVisibility) {
                default:
                    return "mediaVisibility: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.darkThemeWallpaper != null && message.hasOwnProperty("darkThemeWallpaper")) {
                var error = $root.proto.WallpaperSettings.verify(message.darkThemeWallpaper);
                if (error)
                    return "darkThemeWallpaper." + error;
            }
            if (message.autoDownloadWiFi != null && message.hasOwnProperty("autoDownloadWiFi")) {
                var error = $root.proto.AutoDownloadSettings.verify(message.autoDownloadWiFi);
                if (error)
                    return "autoDownloadWiFi." + error;
            }
            if (message.autoDownloadCellular != null && message.hasOwnProperty("autoDownloadCellular")) {
                var error = $root.proto.AutoDownloadSettings.verify(message.autoDownloadCellular);
                if (error)
                    return "autoDownloadCellular." + error;
            }
            if (message.autoDownloadRoaming != null && message.hasOwnProperty("autoDownloadRoaming")) {
                var error = $root.proto.AutoDownloadSettings.verify(message.autoDownloadRoaming);
                if (error)
                    return "autoDownloadRoaming." + error;
            }
            if (message.showIndividualNotificationsPreview != null && message.hasOwnProperty("showIndividualNotificationsPreview"))
                if (typeof message.showIndividualNotificationsPreview !== "boolean")
                    return "showIndividualNotificationsPreview: boolean expected";
            if (message.showGroupNotificationsPreview != null && message.hasOwnProperty("showGroupNotificationsPreview"))
                if (typeof message.showGroupNotificationsPreview !== "boolean")
                    return "showGroupNotificationsPreview: boolean expected";
            if (message.disappearingModeDuration != null && message.hasOwnProperty("disappearingModeDuration"))
                if (!$util.isInteger(message.disappearingModeDuration))
                    return "disappearingModeDuration: integer expected";
            if (message.disappearingModeTimestamp != null && message.hasOwnProperty("disappearingModeTimestamp"))
                if (!$util.isInteger(message.disappearingModeTimestamp) && !(message.disappearingModeTimestamp && $util.isInteger(message.disappearingModeTimestamp.low) && $util.isInteger(message.disappearingModeTimestamp.high)))
                    return "disappearingModeTimestamp: integer|Long expected";
            if (message.avatarUserSettings != null && message.hasOwnProperty("avatarUserSettings")) {
                var error = $root.proto.AvatarUserSettings.verify(message.avatarUserSettings);
                if (error)
                    return "avatarUserSettings." + error;
            }
            return null;
        };

        /**
         * Creates a GlobalSettings message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.GlobalSettings
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.GlobalSettings} GlobalSettings
         */
        GlobalSettings.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.GlobalSettings)
                return object;
            var message = new $root.proto.GlobalSettings();
            if (object.lightThemeWallpaper != null) {
                if (typeof object.lightThemeWallpaper !== "object")
                    throw TypeError(".proto.GlobalSettings.lightThemeWallpaper: object expected");
                message.lightThemeWallpaper = $root.proto.WallpaperSettings.fromObject(object.lightThemeWallpaper);
            }
            switch (object.mediaVisibility) {
            case "DEFAULT":
            case 0:
                message.mediaVisibility = 0;
                break;
            case "OFF":
            case 1:
                message.mediaVisibility = 1;
                break;
            case "ON":
            case 2:
                message.mediaVisibility = 2;
                break;
            }
            if (object.darkThemeWallpaper != null) {
                if (typeof object.darkThemeWallpaper !== "object")
                    throw TypeError(".proto.GlobalSettings.darkThemeWallpaper: object expected");
                message.darkThemeWallpaper = $root.proto.WallpaperSettings.fromObject(object.darkThemeWallpaper);
            }
            if (object.autoDownloadWiFi != null) {
                if (typeof object.autoDownloadWiFi !== "object")
                    throw TypeError(".proto.GlobalSettings.autoDownloadWiFi: object expected");
                message.autoDownloadWiFi = $root.proto.AutoDownloadSettings.fromObject(object.autoDownloadWiFi);
            }
            if (object.autoDownloadCellular != null) {
                if (typeof object.autoDownloadCellular !== "object")
                    throw TypeError(".proto.GlobalSettings.autoDownloadCellular: object expected");
                message.autoDownloadCellular = $root.proto.AutoDownloadSettings.fromObject(object.autoDownloadCellular);
            }
            if (object.autoDownloadRoaming != null) {
                if (typeof object.autoDownloadRoaming !== "object")
                    throw TypeError(".proto.GlobalSettings.autoDownloadRoaming: object expected");
                message.autoDownloadRoaming = $root.proto.AutoDownloadSettings.fromObject(object.autoDownloadRoaming);
            }
            if (object.showIndividualNotificationsPreview != null)
                message.showIndividualNotificationsPreview = Boolean(object.showIndividualNotificationsPreview);
            if (object.showGroupNotificationsPreview != null)
                message.showGroupNotificationsPreview = Boolean(object.showGroupNotificationsPreview);
            if (object.disappearingModeDuration != null)
                message.disappearingModeDuration = object.disappearingModeDuration | 0;
            if (object.disappearingModeTimestamp != null)
                if ($util.Long)
                    (message.disappearingModeTimestamp = $util.Long.fromValue(object.disappearingModeTimestamp)).unsigned = false;
                else if (typeof object.disappearingModeTimestamp === "string")
                    message.disappearingModeTimestamp = parseInt(object.disappearingModeTimestamp, 10);
                else if (typeof object.disappearingModeTimestamp === "number")
                    message.disappearingModeTimestamp = object.disappearingModeTimestamp;
                else if (typeof object.disappearingModeTimestamp === "object")
                    message.disappearingModeTimestamp = new $util.LongBits(object.disappearingModeTimestamp.low >>> 0, object.disappearingModeTimestamp.high >>> 0).toNumber();
            if (object.avatarUserSettings != null) {
                if (typeof object.avatarUserSettings !== "object")
                    throw TypeError(".proto.GlobalSettings.avatarUserSettings: object expected");
                message.avatarUserSettings = $root.proto.AvatarUserSettings.fromObject(object.avatarUserSettings);
            }
            return message;
        };

        /**
         * Creates a plain object from a GlobalSettings message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.GlobalSettings
         * @static
         * @param {proto.GlobalSettings} message GlobalSettings
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GlobalSettings.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.lightThemeWallpaper = null;
                object.mediaVisibility = options.enums === String ? "DEFAULT" : 0;
                object.darkThemeWallpaper = null;
                object.autoDownloadWiFi = null;
                object.autoDownloadCellular = null;
                object.autoDownloadRoaming = null;
                object.showIndividualNotificationsPreview = false;
                object.showGroupNotificationsPreview = false;
                object.disappearingModeDuration = 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.disappearingModeTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.disappearingModeTimestamp = options.longs === String ? "0" : 0;
                object.avatarUserSettings = null;
            }
            if (message.lightThemeWallpaper != null && message.hasOwnProperty("lightThemeWallpaper"))
                object.lightThemeWallpaper = $root.proto.WallpaperSettings.toObject(message.lightThemeWallpaper, options);
            if (message.mediaVisibility != null && message.hasOwnProperty("mediaVisibility"))
                object.mediaVisibility = options.enums === String ? $root.proto.MediaVisibility[message.mediaVisibility] : message.mediaVisibility;
            if (message.darkThemeWallpaper != null && message.hasOwnProperty("darkThemeWallpaper"))
                object.darkThemeWallpaper = $root.proto.WallpaperSettings.toObject(message.darkThemeWallpaper, options);
            if (message.autoDownloadWiFi != null && message.hasOwnProperty("autoDownloadWiFi"))
                object.autoDownloadWiFi = $root.proto.AutoDownloadSettings.toObject(message.autoDownloadWiFi, options);
            if (message.autoDownloadCellular != null && message.hasOwnProperty("autoDownloadCellular"))
                object.autoDownloadCellular = $root.proto.AutoDownloadSettings.toObject(message.autoDownloadCellular, options);
            if (message.autoDownloadRoaming != null && message.hasOwnProperty("autoDownloadRoaming"))
                object.autoDownloadRoaming = $root.proto.AutoDownloadSettings.toObject(message.autoDownloadRoaming, options);
            if (message.showIndividualNotificationsPreview != null && message.hasOwnProperty("showIndividualNotificationsPreview"))
                object.showIndividualNotificationsPreview = message.showIndividualNotificationsPreview;
            if (message.showGroupNotificationsPreview != null && message.hasOwnProperty("showGroupNotificationsPreview"))
                object.showGroupNotificationsPreview = message.showGroupNotificationsPreview;
            if (message.disappearingModeDuration != null && message.hasOwnProperty("disappearingModeDuration"))
                object.disappearingModeDuration = message.disappearingModeDuration;
            if (message.disappearingModeTimestamp != null && message.hasOwnProperty("disappearingModeTimestamp"))
                if (typeof message.disappearingModeTimestamp === "number")
                    object.disappearingModeTimestamp = options.longs === String ? String(message.disappearingModeTimestamp) : message.disappearingModeTimestamp;
                else
                    object.disappearingModeTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.disappearingModeTimestamp) : options.longs === Number ? new $util.LongBits(message.disappearingModeTimestamp.low >>> 0, message.disappearingModeTimestamp.high >>> 0).toNumber() : message.disappearingModeTimestamp;
            if (message.avatarUserSettings != null && message.hasOwnProperty("avatarUserSettings"))
                object.avatarUserSettings = $root.proto.AvatarUserSettings.toObject(message.avatarUserSettings, options);
            return object;
        };

        /**
         * Converts this GlobalSettings to JSON.
         * @function toJSON
         * @memberof proto.GlobalSettings
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GlobalSettings.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return GlobalSettings;
    })();

    proto.GroupParticipant = (function() {

        /**
         * Properties of a GroupParticipant.
         * @memberof proto
         * @interface IGroupParticipant
         * @property {string} userJid GroupParticipant userJid
         * @property {proto.GroupParticipant.Rank|null} [rank] GroupParticipant rank
         */

        /**
         * Constructs a new GroupParticipant.
         * @memberof proto
         * @classdesc Represents a GroupParticipant.
         * @implements IGroupParticipant
         * @constructor
         * @param {proto.IGroupParticipant=} [properties] Properties to set
         */
        function GroupParticipant(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * GroupParticipant userJid.
         * @member {string} userJid
         * @memberof proto.GroupParticipant
         * @instance
         */
        GroupParticipant.prototype.userJid = "";

        /**
         * GroupParticipant rank.
         * @member {proto.GroupParticipant.Rank} rank
         * @memberof proto.GroupParticipant
         * @instance
         */
        GroupParticipant.prototype.rank = 0;

        /**
         * Creates a new GroupParticipant instance using the specified properties.
         * @function create
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant=} [properties] Properties to set
         * @returns {proto.GroupParticipant} GroupParticipant instance
         */
        GroupParticipant.create = function create(properties) {
            return new GroupParticipant(properties);
        };

        /**
         * Encodes the specified GroupParticipant message. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @function encode
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant} message GroupParticipant message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupParticipant.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 2 =*/10).string(message.userJid);
            if (message.rank != null && Object.hasOwnProperty.call(message, "rank"))
                writer.uint32(/* id 2, wireType 0 =*/16).int32(message.rank);
            return writer;
        };

        /**
         * Encodes the specified GroupParticipant message, length delimited. Does not implicitly {@link proto.GroupParticipant.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.IGroupParticipant} message GroupParticipant message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        GroupParticipant.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer.
         * @function decode
         * @memberof proto.GroupParticipant
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.GroupParticipant} GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupParticipant.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.GroupParticipant();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.userJid = reader.string();
                    break;
                case 2:
                    message.rank = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("userJid"))
                throw $util.ProtocolError("missing required 'userJid'", { instance: message });
            return message;
        };

        /**
         * Decodes a GroupParticipant message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.GroupParticipant
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.GroupParticipant} GroupParticipant
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        GroupParticipant.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a GroupParticipant message.
         * @function verify
         * @memberof proto.GroupParticipant
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        GroupParticipant.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (!$util.isString(message.userJid))
                return "userJid: string expected";
            if (message.rank != null && message.hasOwnProperty("rank"))
                switch (message.rank) {
                default:
                    return "rank: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            return null;
        };

        /**
         * Creates a GroupParticipant message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.GroupParticipant
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.GroupParticipant} GroupParticipant
         */
        GroupParticipant.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.GroupParticipant)
                return object;
            var message = new $root.proto.GroupParticipant();
            if (object.userJid != null)
                message.userJid = String(object.userJid);
            switch (object.rank) {
            case "REGULAR":
            case 0:
                message.rank = 0;
                break;
            case "ADMIN":
            case 1:
                message.rank = 1;
                break;
            case "SUPERADMIN":
            case 2:
                message.rank = 2;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a GroupParticipant message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.GroupParticipant
         * @static
         * @param {proto.GroupParticipant} message GroupParticipant
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        GroupParticipant.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.userJid = "";
                object.rank = options.enums === String ? "REGULAR" : 0;
            }
            if (message.userJid != null && message.hasOwnProperty("userJid"))
                object.userJid = message.userJid;
            if (message.rank != null && message.hasOwnProperty("rank"))
                object.rank = options.enums === String ? $root.proto.GroupParticipant.Rank[message.rank] : message.rank;
            return object;
        };

        /**
         * Converts this GroupParticipant to JSON.
         * @function toJSON
         * @memberof proto.GroupParticipant
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        GroupParticipant.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * Rank enum.
         * @name proto.GroupParticipant.Rank
         * @enum {number}
         * @property {number} REGULAR=0 REGULAR value
         * @property {number} ADMIN=1 ADMIN value
         * @property {number} SUPERADMIN=2 SUPERADMIN value
         */
        GroupParticipant.Rank = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "REGULAR"] = 0;
            values[valuesById[1] = "ADMIN"] = 1;
            values[valuesById[2] = "SUPERADMIN"] = 2;
            return values;
        })();

        return GroupParticipant;
    })();

    proto.HandshakeMessage = (function() {

        /**
         * Properties of a HandshakeMessage.
         * @memberof proto
         * @interface IHandshakeMessage
         * @property {proto.HandshakeMessage.IClientHello|null} [clientHello] HandshakeMessage clientHello
         * @property {proto.HandshakeMessage.IServerHello|null} [serverHello] HandshakeMessage serverHello
         * @property {proto.HandshakeMessage.IClientFinish|null} [clientFinish] HandshakeMessage clientFinish
         */

        /**
         * Constructs a new HandshakeMessage.
         * @memberof proto
         * @classdesc Represents a HandshakeMessage.
         * @implements IHandshakeMessage
         * @constructor
         * @param {proto.IHandshakeMessage=} [properties] Properties to set
         */
        function HandshakeMessage(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HandshakeMessage clientHello.
         * @member {proto.HandshakeMessage.IClientHello|null|undefined} clientHello
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.clientHello = null;

        /**
         * HandshakeMessage serverHello.
         * @member {proto.HandshakeMessage.IServerHello|null|undefined} serverHello
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.serverHello = null;

        /**
         * HandshakeMessage clientFinish.
         * @member {proto.HandshakeMessage.IClientFinish|null|undefined} clientFinish
         * @memberof proto.HandshakeMessage
         * @instance
         */
        HandshakeMessage.prototype.clientFinish = null;

        /**
         * Creates a new HandshakeMessage instance using the specified properties.
         * @function create
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage=} [properties] Properties to set
         * @returns {proto.HandshakeMessage} HandshakeMessage instance
         */
        HandshakeMessage.create = function create(properties) {
            return new HandshakeMessage(properties);
        };

        /**
         * Encodes the specified HandshakeMessage message. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @function encode
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage} message HandshakeMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HandshakeMessage.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.clientHello != null && Object.hasOwnProperty.call(message, "clientHello"))
                $root.proto.HandshakeMessage.ClientHello.encode(message.clientHello, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.serverHello != null && Object.hasOwnProperty.call(message, "serverHello"))
                $root.proto.HandshakeMessage.ServerHello.encode(message.serverHello, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.clientFinish != null && Object.hasOwnProperty.call(message, "clientFinish"))
                $root.proto.HandshakeMessage.ClientFinish.encode(message.clientFinish, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HandshakeMessage message, length delimited. Does not implicitly {@link proto.HandshakeMessage.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.IHandshakeMessage} message HandshakeMessage message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HandshakeMessage.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HandshakeMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HandshakeMessage} HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HandshakeMessage.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HandshakeMessage();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 2:
                    message.clientHello = $root.proto.HandshakeMessage.ClientHello.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.serverHello = $root.proto.HandshakeMessage.ServerHello.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.clientFinish = $root.proto.HandshakeMessage.ClientFinish.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HandshakeMessage message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HandshakeMessage
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HandshakeMessage} HandshakeMessage
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HandshakeMessage.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HandshakeMessage message.
         * @function verify
         * @memberof proto.HandshakeMessage
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HandshakeMessage.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.clientHello != null && message.hasOwnProperty("clientHello")) {
                var error = $root.proto.HandshakeMessage.ClientHello.verify(message.clientHello);
                if (error)
                    return "clientHello." + error;
            }
            if (message.serverHello != null && message.hasOwnProperty("serverHello")) {
                var error = $root.proto.HandshakeMessage.ServerHello.verify(message.serverHello);
                if (error)
                    return "serverHello." + error;
            }
            if (message.clientFinish != null && message.hasOwnProperty("clientFinish")) {
                var error = $root.proto.HandshakeMessage.ClientFinish.verify(message.clientFinish);
                if (error)
                    return "clientFinish." + error;
            }
            return null;
        };

        /**
         * Creates a HandshakeMessage message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HandshakeMessage
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HandshakeMessage} HandshakeMessage
         */
        HandshakeMessage.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HandshakeMessage)
                return object;
            var message = new $root.proto.HandshakeMessage();
            if (object.clientHello != null) {
                if (typeof object.clientHello !== "object")
                    throw TypeError(".proto.HandshakeMessage.clientHello: object expected");
                message.clientHello = $root.proto.HandshakeMessage.ClientHello.fromObject(object.clientHello);
            }
            if (object.serverHello != null) {
                if (typeof object.serverHello !== "object")
                    throw TypeError(".proto.HandshakeMessage.serverHello: object expected");
                message.serverHello = $root.proto.HandshakeMessage.ServerHello.fromObject(object.serverHello);
            }
            if (object.clientFinish != null) {
                if (typeof object.clientFinish !== "object")
                    throw TypeError(".proto.HandshakeMessage.clientFinish: object expected");
                message.clientFinish = $root.proto.HandshakeMessage.ClientFinish.fromObject(object.clientFinish);
            }
            return message;
        };

        /**
         * Creates a plain object from a HandshakeMessage message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HandshakeMessage
         * @static
         * @param {proto.HandshakeMessage} message HandshakeMessage
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HandshakeMessage.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.clientHello = null;
                object.serverHello = null;
                object.clientFinish = null;
            }
            if (message.clientHello != null && message.hasOwnProperty("clientHello"))
                object.clientHello = $root.proto.HandshakeMessage.ClientHello.toObject(message.clientHello, options);
            if (message.serverHello != null && message.hasOwnProperty("serverHello"))
                object.serverHello = $root.proto.HandshakeMessage.ServerHello.toObject(message.serverHello, options);
            if (message.clientFinish != null && message.hasOwnProperty("clientFinish"))
                object.clientFinish = $root.proto.HandshakeMessage.ClientFinish.toObject(message.clientFinish, options);
            return object;
        };

        /**
         * Converts this HandshakeMessage to JSON.
         * @function toJSON
         * @memberof proto.HandshakeMessage
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HandshakeMessage.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        HandshakeMessage.ClientFinish = (function() {

            /**
             * Properties of a ClientFinish.
             * @memberof proto.HandshakeMessage
             * @interface IClientFinish
             * @property {Uint8Array|null} ["static"] ClientFinish static
             * @property {Uint8Array|null} [payload] ClientFinish payload
             */

            /**
             * Constructs a new ClientFinish.
             * @memberof proto.HandshakeMessage
             * @classdesc Represents a ClientFinish.
             * @implements IClientFinish
             * @constructor
             * @param {proto.HandshakeMessage.IClientFinish=} [properties] Properties to set
             */
            function ClientFinish(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ClientFinish static.
             * @member {Uint8Array} static
             * @memberof proto.HandshakeMessage.ClientFinish
             * @instance
             */
            ClientFinish.prototype["static"] = $util.newBuffer([]);

            /**
             * ClientFinish payload.
             * @member {Uint8Array} payload
             * @memberof proto.HandshakeMessage.ClientFinish
             * @instance
             */
            ClientFinish.prototype.payload = $util.newBuffer([]);

            /**
             * Creates a new ClientFinish instance using the specified properties.
             * @function create
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {proto.HandshakeMessage.IClientFinish=} [properties] Properties to set
             * @returns {proto.HandshakeMessage.ClientFinish} ClientFinish instance
             */
            ClientFinish.create = function create(properties) {
                return new ClientFinish(properties);
            };

            /**
             * Encodes the specified ClientFinish message. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @function encode
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {proto.HandshakeMessage.IClientFinish} message ClientFinish message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ClientFinish.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message["static"]);
                if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.payload);
                return writer;
            };

            /**
             * Encodes the specified ClientFinish message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientFinish.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {proto.HandshakeMessage.IClientFinish} message ClientFinish message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ClientFinish.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ClientFinish message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HandshakeMessage.ClientFinish} ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ClientFinish.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HandshakeMessage.ClientFinish();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message["static"] = reader.bytes();
                        break;
                    case 2:
                        message.payload = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ClientFinish message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HandshakeMessage.ClientFinish} ClientFinish
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ClientFinish.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ClientFinish message.
             * @function verify
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ClientFinish.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message["static"] != null && message.hasOwnProperty("static"))
                    if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                        return "static: buffer expected";
                if (message.payload != null && message.hasOwnProperty("payload"))
                    if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                        return "payload: buffer expected";
                return null;
            };

            /**
             * Creates a ClientFinish message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HandshakeMessage.ClientFinish} ClientFinish
             */
            ClientFinish.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HandshakeMessage.ClientFinish)
                    return object;
                var message = new $root.proto.HandshakeMessage.ClientFinish();
                if (object["static"] != null)
                    if (typeof object["static"] === "string")
                        $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                    else if (object["static"].length)
                        message["static"] = object["static"];
                if (object.payload != null)
                    if (typeof object.payload === "string")
                        $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                    else if (object.payload.length)
                        message.payload = object.payload;
                return message;
            };

            /**
             * Creates a plain object from a ClientFinish message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HandshakeMessage.ClientFinish
             * @static
             * @param {proto.HandshakeMessage.ClientFinish} message ClientFinish
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ClientFinish.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if (options.bytes === String)
                        object["static"] = "";
                    else {
                        object["static"] = [];
                        if (options.bytes !== Array)
                            object["static"] = $util.newBuffer(object["static"]);
                    }
                    if (options.bytes === String)
                        object.payload = "";
                    else {
                        object.payload = [];
                        if (options.bytes !== Array)
                            object.payload = $util.newBuffer(object.payload);
                    }
                }
                if (message["static"] != null && message.hasOwnProperty("static"))
                    object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
                if (message.payload != null && message.hasOwnProperty("payload"))
                    object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
                return object;
            };

            /**
             * Converts this ClientFinish to JSON.
             * @function toJSON
             * @memberof proto.HandshakeMessage.ClientFinish
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ClientFinish.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return ClientFinish;
        })();

        HandshakeMessage.ClientHello = (function() {

            /**
             * Properties of a ClientHello.
             * @memberof proto.HandshakeMessage
             * @interface IClientHello
             * @property {Uint8Array|null} [ephemeral] ClientHello ephemeral
             * @property {Uint8Array|null} ["static"] ClientHello static
             * @property {Uint8Array|null} [payload] ClientHello payload
             */

            /**
             * Constructs a new ClientHello.
             * @memberof proto.HandshakeMessage
             * @classdesc Represents a ClientHello.
             * @implements IClientHello
             * @constructor
             * @param {proto.HandshakeMessage.IClientHello=} [properties] Properties to set
             */
            function ClientHello(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ClientHello ephemeral.
             * @member {Uint8Array} ephemeral
             * @memberof proto.HandshakeMessage.ClientHello
             * @instance
             */
            ClientHello.prototype.ephemeral = $util.newBuffer([]);

            /**
             * ClientHello static.
             * @member {Uint8Array} static
             * @memberof proto.HandshakeMessage.ClientHello
             * @instance
             */
            ClientHello.prototype["static"] = $util.newBuffer([]);

            /**
             * ClientHello payload.
             * @member {Uint8Array} payload
             * @memberof proto.HandshakeMessage.ClientHello
             * @instance
             */
            ClientHello.prototype.payload = $util.newBuffer([]);

            /**
             * Creates a new ClientHello instance using the specified properties.
             * @function create
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {proto.HandshakeMessage.IClientHello=} [properties] Properties to set
             * @returns {proto.HandshakeMessage.ClientHello} ClientHello instance
             */
            ClientHello.create = function create(properties) {
                return new ClientHello(properties);
            };

            /**
             * Encodes the specified ClientHello message. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @function encode
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {proto.HandshakeMessage.IClientHello} message ClientHello message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ClientHello.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.ephemeral != null && Object.hasOwnProperty.call(message, "ephemeral"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.ephemeral);
                if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message["static"]);
                if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                    writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.payload);
                return writer;
            };

            /**
             * Encodes the specified ClientHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ClientHello.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {proto.HandshakeMessage.IClientHello} message ClientHello message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ClientHello.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ClientHello message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HandshakeMessage.ClientHello} ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ClientHello.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HandshakeMessage.ClientHello();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.ephemeral = reader.bytes();
                        break;
                    case 2:
                        message["static"] = reader.bytes();
                        break;
                    case 3:
                        message.payload = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ClientHello message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HandshakeMessage.ClientHello} ClientHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ClientHello.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ClientHello message.
             * @function verify
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ClientHello.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                    if (!(message.ephemeral && typeof message.ephemeral.length === "number" || $util.isString(message.ephemeral)))
                        return "ephemeral: buffer expected";
                if (message["static"] != null && message.hasOwnProperty("static"))
                    if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                        return "static: buffer expected";
                if (message.payload != null && message.hasOwnProperty("payload"))
                    if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                        return "payload: buffer expected";
                return null;
            };

            /**
             * Creates a ClientHello message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HandshakeMessage.ClientHello} ClientHello
             */
            ClientHello.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HandshakeMessage.ClientHello)
                    return object;
                var message = new $root.proto.HandshakeMessage.ClientHello();
                if (object.ephemeral != null)
                    if (typeof object.ephemeral === "string")
                        $util.base64.decode(object.ephemeral, message.ephemeral = $util.newBuffer($util.base64.length(object.ephemeral)), 0);
                    else if (object.ephemeral.length)
                        message.ephemeral = object.ephemeral;
                if (object["static"] != null)
                    if (typeof object["static"] === "string")
                        $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                    else if (object["static"].length)
                        message["static"] = object["static"];
                if (object.payload != null)
                    if (typeof object.payload === "string")
                        $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                    else if (object.payload.length)
                        message.payload = object.payload;
                return message;
            };

            /**
             * Creates a plain object from a ClientHello message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HandshakeMessage.ClientHello
             * @static
             * @param {proto.HandshakeMessage.ClientHello} message ClientHello
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ClientHello.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if (options.bytes === String)
                        object.ephemeral = "";
                    else {
                        object.ephemeral = [];
                        if (options.bytes !== Array)
                            object.ephemeral = $util.newBuffer(object.ephemeral);
                    }
                    if (options.bytes === String)
                        object["static"] = "";
                    else {
                        object["static"] = [];
                        if (options.bytes !== Array)
                            object["static"] = $util.newBuffer(object["static"]);
                    }
                    if (options.bytes === String)
                        object.payload = "";
                    else {
                        object.payload = [];
                        if (options.bytes !== Array)
                            object.payload = $util.newBuffer(object.payload);
                    }
                }
                if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                    object.ephemeral = options.bytes === String ? $util.base64.encode(message.ephemeral, 0, message.ephemeral.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeral) : message.ephemeral;
                if (message["static"] != null && message.hasOwnProperty("static"))
                    object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
                if (message.payload != null && message.hasOwnProperty("payload"))
                    object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
                return object;
            };

            /**
             * Converts this ClientHello to JSON.
             * @function toJSON
             * @memberof proto.HandshakeMessage.ClientHello
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ClientHello.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return ClientHello;
        })();

        HandshakeMessage.ServerHello = (function() {

            /**
             * Properties of a ServerHello.
             * @memberof proto.HandshakeMessage
             * @interface IServerHello
             * @property {Uint8Array|null} [ephemeral] ServerHello ephemeral
             * @property {Uint8Array|null} ["static"] ServerHello static
             * @property {Uint8Array|null} [payload] ServerHello payload
             */

            /**
             * Constructs a new ServerHello.
             * @memberof proto.HandshakeMessage
             * @classdesc Represents a ServerHello.
             * @implements IServerHello
             * @constructor
             * @param {proto.HandshakeMessage.IServerHello=} [properties] Properties to set
             */
            function ServerHello(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * ServerHello ephemeral.
             * @member {Uint8Array} ephemeral
             * @memberof proto.HandshakeMessage.ServerHello
             * @instance
             */
            ServerHello.prototype.ephemeral = $util.newBuffer([]);

            /**
             * ServerHello static.
             * @member {Uint8Array} static
             * @memberof proto.HandshakeMessage.ServerHello
             * @instance
             */
            ServerHello.prototype["static"] = $util.newBuffer([]);

            /**
             * ServerHello payload.
             * @member {Uint8Array} payload
             * @memberof proto.HandshakeMessage.ServerHello
             * @instance
             */
            ServerHello.prototype.payload = $util.newBuffer([]);

            /**
             * Creates a new ServerHello instance using the specified properties.
             * @function create
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {proto.HandshakeMessage.IServerHello=} [properties] Properties to set
             * @returns {proto.HandshakeMessage.ServerHello} ServerHello instance
             */
            ServerHello.create = function create(properties) {
                return new ServerHello(properties);
            };

            /**
             * Encodes the specified ServerHello message. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @function encode
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {proto.HandshakeMessage.IServerHello} message ServerHello message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServerHello.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.ephemeral != null && Object.hasOwnProperty.call(message, "ephemeral"))
                    writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.ephemeral);
                if (message["static"] != null && Object.hasOwnProperty.call(message, "static"))
                    writer.uint32(/* id 2, wireType 2 =*/18).bytes(message["static"]);
                if (message.payload != null && Object.hasOwnProperty.call(message, "payload"))
                    writer.uint32(/* id 3, wireType 2 =*/26).bytes(message.payload);
                return writer;
            };

            /**
             * Encodes the specified ServerHello message, length delimited. Does not implicitly {@link proto.HandshakeMessage.ServerHello.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {proto.HandshakeMessage.IServerHello} message ServerHello message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            ServerHello.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a ServerHello message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HandshakeMessage.ServerHello} ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServerHello.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HandshakeMessage.ServerHello();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.ephemeral = reader.bytes();
                        break;
                    case 2:
                        message["static"] = reader.bytes();
                        break;
                    case 3:
                        message.payload = reader.bytes();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a ServerHello message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HandshakeMessage.ServerHello} ServerHello
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            ServerHello.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a ServerHello message.
             * @function verify
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            ServerHello.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                    if (!(message.ephemeral && typeof message.ephemeral.length === "number" || $util.isString(message.ephemeral)))
                        return "ephemeral: buffer expected";
                if (message["static"] != null && message.hasOwnProperty("static"))
                    if (!(message["static"] && typeof message["static"].length === "number" || $util.isString(message["static"])))
                        return "static: buffer expected";
                if (message.payload != null && message.hasOwnProperty("payload"))
                    if (!(message.payload && typeof message.payload.length === "number" || $util.isString(message.payload)))
                        return "payload: buffer expected";
                return null;
            };

            /**
             * Creates a ServerHello message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HandshakeMessage.ServerHello} ServerHello
             */
            ServerHello.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HandshakeMessage.ServerHello)
                    return object;
                var message = new $root.proto.HandshakeMessage.ServerHello();
                if (object.ephemeral != null)
                    if (typeof object.ephemeral === "string")
                        $util.base64.decode(object.ephemeral, message.ephemeral = $util.newBuffer($util.base64.length(object.ephemeral)), 0);
                    else if (object.ephemeral.length)
                        message.ephemeral = object.ephemeral;
                if (object["static"] != null)
                    if (typeof object["static"] === "string")
                        $util.base64.decode(object["static"], message["static"] = $util.newBuffer($util.base64.length(object["static"])), 0);
                    else if (object["static"].length)
                        message["static"] = object["static"];
                if (object.payload != null)
                    if (typeof object.payload === "string")
                        $util.base64.decode(object.payload, message.payload = $util.newBuffer($util.base64.length(object.payload)), 0);
                    else if (object.payload.length)
                        message.payload = object.payload;
                return message;
            };

            /**
             * Creates a plain object from a ServerHello message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HandshakeMessage.ServerHello
             * @static
             * @param {proto.HandshakeMessage.ServerHello} message ServerHello
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            ServerHello.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    if (options.bytes === String)
                        object.ephemeral = "";
                    else {
                        object.ephemeral = [];
                        if (options.bytes !== Array)
                            object.ephemeral = $util.newBuffer(object.ephemeral);
                    }
                    if (options.bytes === String)
                        object["static"] = "";
                    else {
                        object["static"] = [];
                        if (options.bytes !== Array)
                            object["static"] = $util.newBuffer(object["static"]);
                    }
                    if (options.bytes === String)
                        object.payload = "";
                    else {
                        object.payload = [];
                        if (options.bytes !== Array)
                            object.payload = $util.newBuffer(object.payload);
                    }
                }
                if (message.ephemeral != null && message.hasOwnProperty("ephemeral"))
                    object.ephemeral = options.bytes === String ? $util.base64.encode(message.ephemeral, 0, message.ephemeral.length) : options.bytes === Array ? Array.prototype.slice.call(message.ephemeral) : message.ephemeral;
                if (message["static"] != null && message.hasOwnProperty("static"))
                    object["static"] = options.bytes === String ? $util.base64.encode(message["static"], 0, message["static"].length) : options.bytes === Array ? Array.prototype.slice.call(message["static"]) : message["static"];
                if (message.payload != null && message.hasOwnProperty("payload"))
                    object.payload = options.bytes === String ? $util.base64.encode(message.payload, 0, message.payload.length) : options.bytes === Array ? Array.prototype.slice.call(message.payload) : message.payload;
                return object;
            };

            /**
             * Converts this ServerHello to JSON.
             * @function toJSON
             * @memberof proto.HandshakeMessage.ServerHello
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            ServerHello.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return ServerHello;
        })();

        return HandshakeMessage;
    })();

    proto.HistorySync = (function() {

        /**
         * Properties of a HistorySync.
         * @memberof proto
         * @interface IHistorySync
         * @property {proto.HistorySync.HistorySyncType} syncType HistorySync syncType
         * @property {Array.<proto.IConversation>|null} [conversations] HistorySync conversations
         * @property {Array.<proto.IWebMessageInfo>|null} [statusV3Messages] HistorySync statusV3Messages
         * @property {number|null} [chunkOrder] HistorySync chunkOrder
         * @property {number|null} [progress] HistorySync progress
         * @property {Array.<proto.IPushname>|null} [pushnames] HistorySync pushnames
         * @property {proto.IGlobalSettings|null} [globalSettings] HistorySync globalSettings
         * @property {Uint8Array|null} [threadIdUserSecret] HistorySync threadIdUserSecret
         * @property {number|null} [threadDsTimeframeOffset] HistorySync threadDsTimeframeOffset
         * @property {Array.<proto.IStickerMetadata>|null} [recentStickers] HistorySync recentStickers
         * @property {Array.<proto.IPastParticipants>|null} [pastParticipants] HistorySync pastParticipants
         */

        /**
         * Constructs a new HistorySync.
         * @memberof proto
         * @classdesc Represents a HistorySync.
         * @implements IHistorySync
         * @constructor
         * @param {proto.IHistorySync=} [properties] Properties to set
         */
        function HistorySync(properties) {
            this.conversations = [];
            this.statusV3Messages = [];
            this.pushnames = [];
            this.recentStickers = [];
            this.pastParticipants = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HistorySync syncType.
         * @member {proto.HistorySync.HistorySyncType} syncType
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.syncType = 0;

        /**
         * HistorySync conversations.
         * @member {Array.<proto.IConversation>} conversations
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.conversations = $util.emptyArray;

        /**
         * HistorySync statusV3Messages.
         * @member {Array.<proto.IWebMessageInfo>} statusV3Messages
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.statusV3Messages = $util.emptyArray;

        /**
         * HistorySync chunkOrder.
         * @member {number} chunkOrder
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.chunkOrder = 0;

        /**
         * HistorySync progress.
         * @member {number} progress
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.progress = 0;

        /**
         * HistorySync pushnames.
         * @member {Array.<proto.IPushname>} pushnames
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.pushnames = $util.emptyArray;

        /**
         * HistorySync globalSettings.
         * @member {proto.IGlobalSettings|null|undefined} globalSettings
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.globalSettings = null;

        /**
         * HistorySync threadIdUserSecret.
         * @member {Uint8Array} threadIdUserSecret
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.threadIdUserSecret = $util.newBuffer([]);

        /**
         * HistorySync threadDsTimeframeOffset.
         * @member {number} threadDsTimeframeOffset
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.threadDsTimeframeOffset = 0;

        /**
         * HistorySync recentStickers.
         * @member {Array.<proto.IStickerMetadata>} recentStickers
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.recentStickers = $util.emptyArray;

        /**
         * HistorySync pastParticipants.
         * @member {Array.<proto.IPastParticipants>} pastParticipants
         * @memberof proto.HistorySync
         * @instance
         */
        HistorySync.prototype.pastParticipants = $util.emptyArray;

        /**
         * Creates a new HistorySync instance using the specified properties.
         * @function create
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync=} [properties] Properties to set
         * @returns {proto.HistorySync} HistorySync instance
         */
        HistorySync.create = function create(properties) {
            return new HistorySync(properties);
        };

        /**
         * Encodes the specified HistorySync message. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @function encode
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync} message HistorySync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySync.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.syncType);
            if (message.conversations != null && message.conversations.length)
                for (var i = 0; i < message.conversations.length; ++i)
                    $root.proto.Conversation.encode(message.conversations[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.statusV3Messages != null && message.statusV3Messages.length)
                for (var i = 0; i < message.statusV3Messages.length; ++i)
                    $root.proto.WebMessageInfo.encode(message.statusV3Messages[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.chunkOrder != null && Object.hasOwnProperty.call(message, "chunkOrder"))
                writer.uint32(/* id 5, wireType 0 =*/40).uint32(message.chunkOrder);
            if (message.progress != null && Object.hasOwnProperty.call(message, "progress"))
                writer.uint32(/* id 6, wireType 0 =*/48).uint32(message.progress);
            if (message.pushnames != null && message.pushnames.length)
                for (var i = 0; i < message.pushnames.length; ++i)
                    $root.proto.Pushname.encode(message.pushnames[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.globalSettings != null && Object.hasOwnProperty.call(message, "globalSettings"))
                $root.proto.GlobalSettings.encode(message.globalSettings, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.threadIdUserSecret != null && Object.hasOwnProperty.call(message, "threadIdUserSecret"))
                writer.uint32(/* id 9, wireType 2 =*/74).bytes(message.threadIdUserSecret);
            if (message.threadDsTimeframeOffset != null && Object.hasOwnProperty.call(message, "threadDsTimeframeOffset"))
                writer.uint32(/* id 10, wireType 0 =*/80).uint32(message.threadDsTimeframeOffset);
            if (message.recentStickers != null && message.recentStickers.length)
                for (var i = 0; i < message.recentStickers.length; ++i)
                    $root.proto.StickerMetadata.encode(message.recentStickers[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
            if (message.pastParticipants != null && message.pastParticipants.length)
                for (var i = 0; i < message.pastParticipants.length; ++i)
                    $root.proto.PastParticipants.encode(message.pastParticipants[i], writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified HistorySync message, length delimited. Does not implicitly {@link proto.HistorySync.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HistorySync
         * @static
         * @param {proto.IHistorySync} message HistorySync message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySync.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HistorySync message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HistorySync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HistorySync} HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySync.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HistorySync();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.syncType = reader.int32();
                    break;
                case 2:
                    if (!(message.conversations && message.conversations.length))
                        message.conversations = [];
                    message.conversations.push($root.proto.Conversation.decode(reader, reader.uint32()));
                    break;
                case 3:
                    if (!(message.statusV3Messages && message.statusV3Messages.length))
                        message.statusV3Messages = [];
                    message.statusV3Messages.push($root.proto.WebMessageInfo.decode(reader, reader.uint32()));
                    break;
                case 5:
                    message.chunkOrder = reader.uint32();
                    break;
                case 6:
                    message.progress = reader.uint32();
                    break;
                case 7:
                    if (!(message.pushnames && message.pushnames.length))
                        message.pushnames = [];
                    message.pushnames.push($root.proto.Pushname.decode(reader, reader.uint32()));
                    break;
                case 8:
                    message.globalSettings = $root.proto.GlobalSettings.decode(reader, reader.uint32());
                    break;
                case 9:
                    message.threadIdUserSecret = reader.bytes();
                    break;
                case 10:
                    message.threadDsTimeframeOffset = reader.uint32();
                    break;
                case 11:
                    if (!(message.recentStickers && message.recentStickers.length))
                        message.recentStickers = [];
                    message.recentStickers.push($root.proto.StickerMetadata.decode(reader, reader.uint32()));
                    break;
                case 12:
                    if (!(message.pastParticipants && message.pastParticipants.length))
                        message.pastParticipants = [];
                    message.pastParticipants.push($root.proto.PastParticipants.decode(reader, reader.uint32()));
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            if (!message.hasOwnProperty("syncType"))
                throw $util.ProtocolError("missing required 'syncType'", { instance: message });
            return message;
        };

        /**
         * Decodes a HistorySync message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HistorySync
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HistorySync} HistorySync
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySync.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HistorySync message.
         * @function verify
         * @memberof proto.HistorySync
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HistorySync.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            switch (message.syncType) {
            default:
                return "syncType: enum value expected";
            case 0:
            case 1:
            case 2:
            case 3:
            case 4:
            case 5:
                break;
            }
            if (message.conversations != null && message.hasOwnProperty("conversations")) {
                if (!Array.isArray(message.conversations))
                    return "conversations: array expected";
                for (var i = 0; i < message.conversations.length; ++i) {
                    var error = $root.proto.Conversation.verify(message.conversations[i]);
                    if (error)
                        return "conversations." + error;
                }
            }
            if (message.statusV3Messages != null && message.hasOwnProperty("statusV3Messages")) {
                if (!Array.isArray(message.statusV3Messages))
                    return "statusV3Messages: array expected";
                for (var i = 0; i < message.statusV3Messages.length; ++i) {
                    var error = $root.proto.WebMessageInfo.verify(message.statusV3Messages[i]);
                    if (error)
                        return "statusV3Messages." + error;
                }
            }
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                if (!$util.isInteger(message.chunkOrder))
                    return "chunkOrder: integer expected";
            if (message.progress != null && message.hasOwnProperty("progress"))
                if (!$util.isInteger(message.progress))
                    return "progress: integer expected";
            if (message.pushnames != null && message.hasOwnProperty("pushnames")) {
                if (!Array.isArray(message.pushnames))
                    return "pushnames: array expected";
                for (var i = 0; i < message.pushnames.length; ++i) {
                    var error = $root.proto.Pushname.verify(message.pushnames[i]);
                    if (error)
                        return "pushnames." + error;
                }
            }
            if (message.globalSettings != null && message.hasOwnProperty("globalSettings")) {
                var error = $root.proto.GlobalSettings.verify(message.globalSettings);
                if (error)
                    return "globalSettings." + error;
            }
            if (message.threadIdUserSecret != null && message.hasOwnProperty("threadIdUserSecret"))
                if (!(message.threadIdUserSecret && typeof message.threadIdUserSecret.length === "number" || $util.isString(message.threadIdUserSecret)))
                    return "threadIdUserSecret: buffer expected";
            if (message.threadDsTimeframeOffset != null && message.hasOwnProperty("threadDsTimeframeOffset"))
                if (!$util.isInteger(message.threadDsTimeframeOffset))
                    return "threadDsTimeframeOffset: integer expected";
            if (message.recentStickers != null && message.hasOwnProperty("recentStickers")) {
                if (!Array.isArray(message.recentStickers))
                    return "recentStickers: array expected";
                for (var i = 0; i < message.recentStickers.length; ++i) {
                    var error = $root.proto.StickerMetadata.verify(message.recentStickers[i]);
                    if (error)
                        return "recentStickers." + error;
                }
            }
            if (message.pastParticipants != null && message.hasOwnProperty("pastParticipants")) {
                if (!Array.isArray(message.pastParticipants))
                    return "pastParticipants: array expected";
                for (var i = 0; i < message.pastParticipants.length; ++i) {
                    var error = $root.proto.PastParticipants.verify(message.pastParticipants[i]);
                    if (error)
                        return "pastParticipants." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HistorySync message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HistorySync
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HistorySync} HistorySync
         */
        HistorySync.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HistorySync)
                return object;
            var message = new $root.proto.HistorySync();
            switch (object.syncType) {
            case "INITIAL_BOOTSTRAP":
            case 0:
                message.syncType = 0;
                break;
            case "INITIAL_STATUS_V3":
            case 1:
                message.syncType = 1;
                break;
            case "FULL":
            case 2:
                message.syncType = 2;
                break;
            case "RECENT":
            case 3:
                message.syncType = 3;
                break;
            case "PUSH_NAME":
            case 4:
                message.syncType = 4;
                break;
            case "NON_BLOCKING_DATA":
            case 5:
                message.syncType = 5;
                break;
            }
            if (object.conversations) {
                if (!Array.isArray(object.conversations))
                    throw TypeError(".proto.HistorySync.conversations: array expected");
                message.conversations = [];
                for (var i = 0; i < object.conversations.length; ++i) {
                    if (typeof object.conversations[i] !== "object")
                        throw TypeError(".proto.HistorySync.conversations: object expected");
                    message.conversations[i] = $root.proto.Conversation.fromObject(object.conversations[i]);
                }
            }
            if (object.statusV3Messages) {
                if (!Array.isArray(object.statusV3Messages))
                    throw TypeError(".proto.HistorySync.statusV3Messages: array expected");
                message.statusV3Messages = [];
                for (var i = 0; i < object.statusV3Messages.length; ++i) {
                    if (typeof object.statusV3Messages[i] !== "object")
                        throw TypeError(".proto.HistorySync.statusV3Messages: object expected");
                    message.statusV3Messages[i] = $root.proto.WebMessageInfo.fromObject(object.statusV3Messages[i]);
                }
            }
            if (object.chunkOrder != null)
                message.chunkOrder = object.chunkOrder >>> 0;
            if (object.progress != null)
                message.progress = object.progress >>> 0;
            if (object.pushnames) {
                if (!Array.isArray(object.pushnames))
                    throw TypeError(".proto.HistorySync.pushnames: array expected");
                message.pushnames = [];
                for (var i = 0; i < object.pushnames.length; ++i) {
                    if (typeof object.pushnames[i] !== "object")
                        throw TypeError(".proto.HistorySync.pushnames: object expected");
                    message.pushnames[i] = $root.proto.Pushname.fromObject(object.pushnames[i]);
                }
            }
            if (object.globalSettings != null) {
                if (typeof object.globalSettings !== "object")
                    throw TypeError(".proto.HistorySync.globalSettings: object expected");
                message.globalSettings = $root.proto.GlobalSettings.fromObject(object.globalSettings);
            }
            if (object.threadIdUserSecret != null)
                if (typeof object.threadIdUserSecret === "string")
                    $util.base64.decode(object.threadIdUserSecret, message.threadIdUserSecret = $util.newBuffer($util.base64.length(object.threadIdUserSecret)), 0);
                else if (object.threadIdUserSecret.length)
                    message.threadIdUserSecret = object.threadIdUserSecret;
            if (object.threadDsTimeframeOffset != null)
                message.threadDsTimeframeOffset = object.threadDsTimeframeOffset >>> 0;
            if (object.recentStickers) {
                if (!Array.isArray(object.recentStickers))
                    throw TypeError(".proto.HistorySync.recentStickers: array expected");
                message.recentStickers = [];
                for (var i = 0; i < object.recentStickers.length; ++i) {
                    if (typeof object.recentStickers[i] !== "object")
                        throw TypeError(".proto.HistorySync.recentStickers: object expected");
                    message.recentStickers[i] = $root.proto.StickerMetadata.fromObject(object.recentStickers[i]);
                }
            }
            if (object.pastParticipants) {
                if (!Array.isArray(object.pastParticipants))
                    throw TypeError(".proto.HistorySync.pastParticipants: array expected");
                message.pastParticipants = [];
                for (var i = 0; i < object.pastParticipants.length; ++i) {
                    if (typeof object.pastParticipants[i] !== "object")
                        throw TypeError(".proto.HistorySync.pastParticipants: object expected");
                    message.pastParticipants[i] = $root.proto.PastParticipants.fromObject(object.pastParticipants[i]);
                }
            }
            return message;
        };

        /**
         * Creates a plain object from a HistorySync message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HistorySync
         * @static
         * @param {proto.HistorySync} message HistorySync
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HistorySync.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults) {
                object.conversations = [];
                object.statusV3Messages = [];
                object.pushnames = [];
                object.recentStickers = [];
                object.pastParticipants = [];
            }
            if (options.defaults) {
                object.syncType = options.enums === String ? "INITIAL_BOOTSTRAP" : 0;
                object.chunkOrder = 0;
                object.progress = 0;
                object.globalSettings = null;
                if (options.bytes === String)
                    object.threadIdUserSecret = "";
                else {
                    object.threadIdUserSecret = [];
                    if (options.bytes !== Array)
                        object.threadIdUserSecret = $util.newBuffer(object.threadIdUserSecret);
                }
                object.threadDsTimeframeOffset = 0;
            }
            if (message.syncType != null && message.hasOwnProperty("syncType"))
                object.syncType = options.enums === String ? $root.proto.HistorySync.HistorySyncType[message.syncType] : message.syncType;
            if (message.conversations && message.conversations.length) {
                object.conversations = [];
                for (var j = 0; j < message.conversations.length; ++j)
                    object.conversations[j] = $root.proto.Conversation.toObject(message.conversations[j], options);
            }
            if (message.statusV3Messages && message.statusV3Messages.length) {
                object.statusV3Messages = [];
                for (var j = 0; j < message.statusV3Messages.length; ++j)
                    object.statusV3Messages[j] = $root.proto.WebMessageInfo.toObject(message.statusV3Messages[j], options);
            }
            if (message.chunkOrder != null && message.hasOwnProperty("chunkOrder"))
                object.chunkOrder = message.chunkOrder;
            if (message.progress != null && message.hasOwnProperty("progress"))
                object.progress = message.progress;
            if (message.pushnames && message.pushnames.length) {
                object.pushnames = [];
                for (var j = 0; j < message.pushnames.length; ++j)
                    object.pushnames[j] = $root.proto.Pushname.toObject(message.pushnames[j], options);
            }
            if (message.globalSettings != null && message.hasOwnProperty("globalSettings"))
                object.globalSettings = $root.proto.GlobalSettings.toObject(message.globalSettings, options);
            if (message.threadIdUserSecret != null && message.hasOwnProperty("threadIdUserSecret"))
                object.threadIdUserSecret = options.bytes === String ? $util.base64.encode(message.threadIdUserSecret, 0, message.threadIdUserSecret.length) : options.bytes === Array ? Array.prototype.slice.call(message.threadIdUserSecret) : message.threadIdUserSecret;
            if (message.threadDsTimeframeOffset != null && message.hasOwnProperty("threadDsTimeframeOffset"))
                object.threadDsTimeframeOffset = message.threadDsTimeframeOffset;
            if (message.recentStickers && message.recentStickers.length) {
                object.recentStickers = [];
                for (var j = 0; j < message.recentStickers.length; ++j)
                    object.recentStickers[j] = $root.proto.StickerMetadata.toObject(message.recentStickers[j], options);
            }
            if (message.pastParticipants && message.pastParticipants.length) {
                object.pastParticipants = [];
                for (var j = 0; j < message.pastParticipants.length; ++j)
                    object.pastParticipants[j] = $root.proto.PastParticipants.toObject(message.pastParticipants[j], options);
            }
            return object;
        };

        /**
         * Converts this HistorySync to JSON.
         * @function toJSON
         * @memberof proto.HistorySync
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HistorySync.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * HistorySyncType enum.
         * @name proto.HistorySync.HistorySyncType
         * @enum {number}
         * @property {number} INITIAL_BOOTSTRAP=0 INITIAL_BOOTSTRAP value
         * @property {number} INITIAL_STATUS_V3=1 INITIAL_STATUS_V3 value
         * @property {number} FULL=2 FULL value
         * @property {number} RECENT=3 RECENT value
         * @property {number} PUSH_NAME=4 PUSH_NAME value
         * @property {number} NON_BLOCKING_DATA=5 NON_BLOCKING_DATA value
         */
        HistorySync.HistorySyncType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "INITIAL_BOOTSTRAP"] = 0;
            values[valuesById[1] = "INITIAL_STATUS_V3"] = 1;
            values[valuesById[2] = "FULL"] = 2;
            values[valuesById[3] = "RECENT"] = 3;
            values[valuesById[4] = "PUSH_NAME"] = 4;
            values[valuesById[5] = "NON_BLOCKING_DATA"] = 5;
            return values;
        })();

        return HistorySync;
    })();

    proto.HistorySyncMsg = (function() {

        /**
         * Properties of a HistorySyncMsg.
         * @memberof proto
         * @interface IHistorySyncMsg
         * @property {proto.IWebMessageInfo|null} [message] HistorySyncMsg message
         * @property {number|Long|null} [msgOrderId] HistorySyncMsg msgOrderId
         */

        /**
         * Constructs a new HistorySyncMsg.
         * @memberof proto
         * @classdesc Represents a HistorySyncMsg.
         * @implements IHistorySyncMsg
         * @constructor
         * @param {proto.IHistorySyncMsg=} [properties] Properties to set
         */
        function HistorySyncMsg(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HistorySyncMsg message.
         * @member {proto.IWebMessageInfo|null|undefined} message
         * @memberof proto.HistorySyncMsg
         * @instance
         */
        HistorySyncMsg.prototype.message = null;

        /**
         * HistorySyncMsg msgOrderId.
         * @member {number|Long} msgOrderId
         * @memberof proto.HistorySyncMsg
         * @instance
         */
        HistorySyncMsg.prototype.msgOrderId = $util.Long ? $util.Long.fromBits(0,0,true) : 0;

        /**
         * Creates a new HistorySyncMsg instance using the specified properties.
         * @function create
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg=} [properties] Properties to set
         * @returns {proto.HistorySyncMsg} HistorySyncMsg instance
         */
        HistorySyncMsg.create = function create(properties) {
            return new HistorySyncMsg(properties);
        };

        /**
         * Encodes the specified HistorySyncMsg message. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @function encode
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg} message HistorySyncMsg message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncMsg.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                $root.proto.WebMessageInfo.encode(message.message, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.msgOrderId != null && Object.hasOwnProperty.call(message, "msgOrderId"))
                writer.uint32(/* id 2, wireType 0 =*/16).uint64(message.msgOrderId);
            return writer;
        };

        /**
         * Encodes the specified HistorySyncMsg message, length delimited. Does not implicitly {@link proto.HistorySyncMsg.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.IHistorySyncMsg} message HistorySyncMsg message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HistorySyncMsg.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncMsg.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HistorySyncMsg();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.message = $root.proto.WebMessageInfo.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.msgOrderId = reader.uint64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HistorySyncMsg message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HistorySyncMsg.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HistorySyncMsg message.
         * @function verify
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HistorySyncMsg.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.message != null && message.hasOwnProperty("message")) {
                var error = $root.proto.WebMessageInfo.verify(message.message);
                if (error)
                    return "message." + error;
            }
            if (message.msgOrderId != null && message.hasOwnProperty("msgOrderId"))
                if (!$util.isInteger(message.msgOrderId) && !(message.msgOrderId && $util.isInteger(message.msgOrderId.low) && $util.isInteger(message.msgOrderId.high)))
                    return "msgOrderId: integer|Long expected";
            return null;
        };

        /**
         * Creates a HistorySyncMsg message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HistorySyncMsg} HistorySyncMsg
         */
        HistorySyncMsg.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HistorySyncMsg)
                return object;
            var message = new $root.proto.HistorySyncMsg();
            if (object.message != null) {
                if (typeof object.message !== "object")
                    throw TypeError(".proto.HistorySyncMsg.message: object expected");
                message.message = $root.proto.WebMessageInfo.fromObject(object.message);
            }
            if (object.msgOrderId != null)
                if ($util.Long)
                    (message.msgOrderId = $util.Long.fromValue(object.msgOrderId)).unsigned = true;
                else if (typeof object.msgOrderId === "string")
                    message.msgOrderId = parseInt(object.msgOrderId, 10);
                else if (typeof object.msgOrderId === "number")
                    message.msgOrderId = object.msgOrderId;
                else if (typeof object.msgOrderId === "object")
                    message.msgOrderId = new $util.LongBits(object.msgOrderId.low >>> 0, object.msgOrderId.high >>> 0).toNumber(true);
            return message;
        };

        /**
         * Creates a plain object from a HistorySyncMsg message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HistorySyncMsg
         * @static
         * @param {proto.HistorySyncMsg} message HistorySyncMsg
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HistorySyncMsg.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.message = null;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, true);
                    object.msgOrderId = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.msgOrderId = options.longs === String ? "0" : 0;
            }
            if (message.message != null && message.hasOwnProperty("message"))
                object.message = $root.proto.WebMessageInfo.toObject(message.message, options);
            if (message.msgOrderId != null && message.hasOwnProperty("msgOrderId"))
                if (typeof message.msgOrderId === "number")
                    object.msgOrderId = options.longs === String ? String(message.msgOrderId) : message.msgOrderId;
                else
                    object.msgOrderId = options.longs === String ? $util.Long.prototype.toString.call(message.msgOrderId) : options.longs === Number ? new $util.LongBits(message.msgOrderId.low >>> 0, message.msgOrderId.high >>> 0).toNumber(true) : message.msgOrderId;
            return object;
        };

        /**
         * Converts this HistorySyncMsg to JSON.
         * @function toJSON
         * @memberof proto.HistorySyncMsg
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HistorySyncMsg.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return HistorySyncMsg;
    })();

    proto.HydratedTemplateButton = (function() {

        /**
         * Properties of a HydratedTemplateButton.
         * @memberof proto
         * @interface IHydratedTemplateButton
         * @property {number|null} [index] HydratedTemplateButton index
         * @property {proto.HydratedTemplateButton.IHydratedQuickReplyButton|null} [quickReplyButton] HydratedTemplateButton quickReplyButton
         * @property {proto.HydratedTemplateButton.IHydratedURLButton|null} [urlButton] HydratedTemplateButton urlButton
         * @property {proto.HydratedTemplateButton.IHydratedCallButton|null} [callButton] HydratedTemplateButton callButton
         */

        /**
         * Constructs a new HydratedTemplateButton.
         * @memberof proto
         * @classdesc Represents a HydratedTemplateButton.
         * @implements IHydratedTemplateButton
         * @constructor
         * @param {proto.IHydratedTemplateButton=} [properties] Properties to set
         */
        function HydratedTemplateButton(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * HydratedTemplateButton index.
         * @member {number} index
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.index = 0;

        /**
         * HydratedTemplateButton quickReplyButton.
         * @member {proto.HydratedTemplateButton.IHydratedQuickReplyButton|null|undefined} quickReplyButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.quickReplyButton = null;

        /**
         * HydratedTemplateButton urlButton.
         * @member {proto.HydratedTemplateButton.IHydratedURLButton|null|undefined} urlButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.urlButton = null;

        /**
         * HydratedTemplateButton callButton.
         * @member {proto.HydratedTemplateButton.IHydratedCallButton|null|undefined} callButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        HydratedTemplateButton.prototype.callButton = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * HydratedTemplateButton hydratedButton.
         * @member {"quickReplyButton"|"urlButton"|"callButton"|undefined} hydratedButton
         * @memberof proto.HydratedTemplateButton
         * @instance
         */
        Object.defineProperty(HydratedTemplateButton.prototype, "hydratedButton", {
            get: $util.oneOfGetter($oneOfFields = ["quickReplyButton", "urlButton", "callButton"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new HydratedTemplateButton instance using the specified properties.
         * @function create
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton=} [properties] Properties to set
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton instance
         */
        HydratedTemplateButton.create = function create(properties) {
            return new HydratedTemplateButton(properties);
        };

        /**
         * Encodes the specified HydratedTemplateButton message. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @function encode
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton} message HydratedTemplateButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedTemplateButton.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.quickReplyButton != null && Object.hasOwnProperty.call(message, "quickReplyButton"))
                $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.encode(message.quickReplyButton, writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.urlButton != null && Object.hasOwnProperty.call(message, "urlButton"))
                $root.proto.HydratedTemplateButton.HydratedURLButton.encode(message.urlButton, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.callButton != null && Object.hasOwnProperty.call(message, "callButton"))
                $root.proto.HydratedTemplateButton.HydratedCallButton.encode(message.callButton, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.index != null && Object.hasOwnProperty.call(message, "index"))
                writer.uint32(/* id 4, wireType 0 =*/32).uint32(message.index);
            return writer;
        };

        /**
         * Encodes the specified HydratedTemplateButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.IHydratedTemplateButton} message HydratedTemplateButton message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        HydratedTemplateButton.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer.
         * @function decode
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedTemplateButton.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedTemplateButton();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 4:
                    message.index = reader.uint32();
                    break;
                case 1:
                    message.quickReplyButton = $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.decode(reader, reader.uint32());
                    break;
                case 2:
                    message.urlButton = $root.proto.HydratedTemplateButton.HydratedURLButton.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.callButton = $root.proto.HydratedTemplateButton.HydratedCallButton.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a HydratedTemplateButton message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        HydratedTemplateButton.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a HydratedTemplateButton message.
         * @function verify
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        HydratedTemplateButton.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.index != null && message.hasOwnProperty("index"))
                if (!$util.isInteger(message.index))
                    return "index: integer expected";
            if (message.quickReplyButton != null && message.hasOwnProperty("quickReplyButton")) {
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.verify(message.quickReplyButton);
                    if (error)
                        return "quickReplyButton." + error;
                }
            }
            if (message.urlButton != null && message.hasOwnProperty("urlButton")) {
                if (properties.hydratedButton === 1)
                    return "hydratedButton: multiple values";
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedTemplateButton.HydratedURLButton.verify(message.urlButton);
                    if (error)
                        return "urlButton." + error;
                }
            }
            if (message.callButton != null && message.hasOwnProperty("callButton")) {
                if (properties.hydratedButton === 1)
                    return "hydratedButton: multiple values";
                properties.hydratedButton = 1;
                {
                    var error = $root.proto.HydratedTemplateButton.HydratedCallButton.verify(message.callButton);
                    if (error)
                        return "callButton." + error;
                }
            }
            return null;
        };

        /**
         * Creates a HydratedTemplateButton message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.HydratedTemplateButton} HydratedTemplateButton
         */
        HydratedTemplateButton.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.HydratedTemplateButton)
                return object;
            var message = new $root.proto.HydratedTemplateButton();
            if (object.index != null)
                message.index = object.index >>> 0;
            if (object.quickReplyButton != null) {
                if (typeof object.quickReplyButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.quickReplyButton: object expected");
                message.quickReplyButton = $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.fromObject(object.quickReplyButton);
            }
            if (object.urlButton != null) {
                if (typeof object.urlButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.urlButton: object expected");
                message.urlButton = $root.proto.HydratedTemplateButton.HydratedURLButton.fromObject(object.urlButton);
            }
            if (object.callButton != null) {
                if (typeof object.callButton !== "object")
                    throw TypeError(".proto.HydratedTemplateButton.callButton: object expected");
                message.callButton = $root.proto.HydratedTemplateButton.HydratedCallButton.fromObject(object.callButton);
            }
            return message;
        };

        /**
         * Creates a plain object from a HydratedTemplateButton message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.HydratedTemplateButton
         * @static
         * @param {proto.HydratedTemplateButton} message HydratedTemplateButton
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        HydratedTemplateButton.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.index = 0;
            if (message.quickReplyButton != null && message.hasOwnProperty("quickReplyButton")) {
                object.quickReplyButton = $root.proto.HydratedTemplateButton.HydratedQuickReplyButton.toObject(message.quickReplyButton, options);
                if (options.oneofs)
                    object.hydratedButton = "quickReplyButton";
            }
            if (message.urlButton != null && message.hasOwnProperty("urlButton")) {
                object.urlButton = $root.proto.HydratedTemplateButton.HydratedURLButton.toObject(message.urlButton, options);
                if (options.oneofs)
                    object.hydratedButton = "urlButton";
            }
            if (message.callButton != null && message.hasOwnProperty("callButton")) {
                object.callButton = $root.proto.HydratedTemplateButton.HydratedCallButton.toObject(message.callButton, options);
                if (options.oneofs)
                    object.hydratedButton = "callButton";
            }
            if (message.index != null && message.hasOwnProperty("index"))
                object.index = message.index;
            return object;
        };

        /**
         * Converts this HydratedTemplateButton to JSON.
         * @function toJSON
         * @memberof proto.HydratedTemplateButton
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        HydratedTemplateButton.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        HydratedTemplateButton.HydratedCallButton = (function() {

            /**
             * Properties of a HydratedCallButton.
             * @memberof proto.HydratedTemplateButton
             * @interface IHydratedCallButton
             * @property {string|null} [displayText] HydratedCallButton displayText
             * @property {string|null} [phoneNumber] HydratedCallButton phoneNumber
             */

            /**
             * Constructs a new HydratedCallButton.
             * @memberof proto.HydratedTemplateButton
             * @classdesc Represents a HydratedCallButton.
             * @implements IHydratedCallButton
             * @constructor
             * @param {proto.HydratedTemplateButton.IHydratedCallButton=} [properties] Properties to set
             */
            function HydratedCallButton(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * HydratedCallButton displayText.
             * @member {string} displayText
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @instance
             */
            HydratedCallButton.prototype.displayText = "";

            /**
             * HydratedCallButton phoneNumber.
             * @member {string} phoneNumber
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @instance
             */
            HydratedCallButton.prototype.phoneNumber = "";

            /**
             * Creates a new HydratedCallButton instance using the specified properties.
             * @function create
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedCallButton=} [properties] Properties to set
             * @returns {proto.HydratedTemplateButton.HydratedCallButton} HydratedCallButton instance
             */
            HydratedCallButton.create = function create(properties) {
                return new HydratedCallButton(properties);
            };

            /**
             * Encodes the specified HydratedCallButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @function encode
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedCallButton} message HydratedCallButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedCallButton.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
                if (message.phoneNumber != null && Object.hasOwnProperty.call(message, "phoneNumber"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.phoneNumber);
                return writer;
            };

            /**
             * Encodes the specified HydratedCallButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedCallButton.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedCallButton} message HydratedCallButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedCallButton.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HydratedTemplateButton.HydratedCallButton} HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedCallButton.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedTemplateButton.HydratedCallButton();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.displayText = reader.string();
                        break;
                    case 2:
                        message.phoneNumber = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a HydratedCallButton message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HydratedTemplateButton.HydratedCallButton} HydratedCallButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedCallButton.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a HydratedCallButton message.
             * @function verify
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            HydratedCallButton.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    if (!$util.isString(message.displayText))
                        return "displayText: string expected";
                if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                    if (!$util.isString(message.phoneNumber))
                        return "phoneNumber: string expected";
                return null;
            };

            /**
             * Creates a HydratedCallButton message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HydratedTemplateButton.HydratedCallButton} HydratedCallButton
             */
            HydratedCallButton.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HydratedTemplateButton.HydratedCallButton)
                    return object;
                var message = new $root.proto.HydratedTemplateButton.HydratedCallButton();
                if (object.displayText != null)
                    message.displayText = String(object.displayText);
                if (object.phoneNumber != null)
                    message.phoneNumber = String(object.phoneNumber);
                return message;
            };

            /**
             * Creates a plain object from a HydratedCallButton message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @static
             * @param {proto.HydratedTemplateButton.HydratedCallButton} message HydratedCallButton
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            HydratedCallButton.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.displayText = "";
                    object.phoneNumber = "";
                }
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    object.displayText = message.displayText;
                if (message.phoneNumber != null && message.hasOwnProperty("phoneNumber"))
                    object.phoneNumber = message.phoneNumber;
                return object;
            };

            /**
             * Converts this HydratedCallButton to JSON.
             * @function toJSON
             * @memberof proto.HydratedTemplateButton.HydratedCallButton
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            HydratedCallButton.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return HydratedCallButton;
        })();

        HydratedTemplateButton.HydratedQuickReplyButton = (function() {

            /**
             * Properties of a HydratedQuickReplyButton.
             * @memberof proto.HydratedTemplateButton
             * @interface IHydratedQuickReplyButton
             * @property {string|null} [displayText] HydratedQuickReplyButton displayText
             * @property {string|null} [id] HydratedQuickReplyButton id
             */

            /**
             * Constructs a new HydratedQuickReplyButton.
             * @memberof proto.HydratedTemplateButton
             * @classdesc Represents a HydratedQuickReplyButton.
             * @implements IHydratedQuickReplyButton
             * @constructor
             * @param {proto.HydratedTemplateButton.IHydratedQuickReplyButton=} [properties] Properties to set
             */
            function HydratedQuickReplyButton(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * HydratedQuickReplyButton displayText.
             * @member {string} displayText
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @instance
             */
            HydratedQuickReplyButton.prototype.displayText = "";

            /**
             * HydratedQuickReplyButton id.
             * @member {string} id
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @instance
             */
            HydratedQuickReplyButton.prototype.id = "";

            /**
             * Creates a new HydratedQuickReplyButton instance using the specified properties.
             * @function create
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedQuickReplyButton=} [properties] Properties to set
             * @returns {proto.HydratedTemplateButton.HydratedQuickReplyButton} HydratedQuickReplyButton instance
             */
            HydratedQuickReplyButton.create = function create(properties) {
                return new HydratedQuickReplyButton(properties);
            };

            /**
             * Encodes the specified HydratedQuickReplyButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @function encode
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedQuickReplyButton} message HydratedQuickReplyButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedQuickReplyButton.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
                if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.id);
                return writer;
            };

            /**
             * Encodes the specified HydratedQuickReplyButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedQuickReplyButton.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedQuickReplyButton} message HydratedQuickReplyButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedQuickReplyButton.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HydratedTemplateButton.HydratedQuickReplyButton} HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedQuickReplyButton.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedTemplateButton.HydratedQuickReplyButton();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.displayText = reader.string();
                        break;
                    case 2:
                        message.id = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a HydratedQuickReplyButton message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HydratedTemplateButton.HydratedQuickReplyButton} HydratedQuickReplyButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedQuickReplyButton.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a HydratedQuickReplyButton message.
             * @function verify
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            HydratedQuickReplyButton.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    if (!$util.isString(message.displayText))
                        return "displayText: string expected";
                if (message.id != null && message.hasOwnProperty("id"))
                    if (!$util.isString(message.id))
                        return "id: string expected";
                return null;
            };

            /**
             * Creates a HydratedQuickReplyButton message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HydratedTemplateButton.HydratedQuickReplyButton} HydratedQuickReplyButton
             */
            HydratedQuickReplyButton.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HydratedTemplateButton.HydratedQuickReplyButton)
                    return object;
                var message = new $root.proto.HydratedTemplateButton.HydratedQuickReplyButton();
                if (object.displayText != null)
                    message.displayText = String(object.displayText);
                if (object.id != null)
                    message.id = String(object.id);
                return message;
            };

            /**
             * Creates a plain object from a HydratedQuickReplyButton message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @static
             * @param {proto.HydratedTemplateButton.HydratedQuickReplyButton} message HydratedQuickReplyButton
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            HydratedQuickReplyButton.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.displayText = "";
                    object.id = "";
                }
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    object.displayText = message.displayText;
                if (message.id != null && message.hasOwnProperty("id"))
                    object.id = message.id;
                return object;
            };

            /**
             * Converts this HydratedQuickReplyButton to JSON.
             * @function toJSON
             * @memberof proto.HydratedTemplateButton.HydratedQuickReplyButton
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            HydratedQuickReplyButton.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return HydratedQuickReplyButton;
        })();

        HydratedTemplateButton.HydratedURLButton = (function() {

            /**
             * Properties of a HydratedURLButton.
             * @memberof proto.HydratedTemplateButton
             * @interface IHydratedURLButton
             * @property {string|null} [displayText] HydratedURLButton displayText
             * @property {string|null} [url] HydratedURLButton url
             */

            /**
             * Constructs a new HydratedURLButton.
             * @memberof proto.HydratedTemplateButton
             * @classdesc Represents a HydratedURLButton.
             * @implements IHydratedURLButton
             * @constructor
             * @param {proto.HydratedTemplateButton.IHydratedURLButton=} [properties] Properties to set
             */
            function HydratedURLButton(properties) {
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * HydratedURLButton displayText.
             * @member {string} displayText
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @instance
             */
            HydratedURLButton.prototype.displayText = "";

            /**
             * HydratedURLButton url.
             * @member {string} url
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @instance
             */
            HydratedURLButton.prototype.url = "";

            /**
             * Creates a new HydratedURLButton instance using the specified properties.
             * @function create
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedURLButton=} [properties] Properties to set
             * @returns {proto.HydratedTemplateButton.HydratedURLButton} HydratedURLButton instance
             */
            HydratedURLButton.create = function create(properties) {
                return new HydratedURLButton(properties);
            };

            /**
             * Encodes the specified HydratedURLButton message. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @function encode
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedURLButton} message HydratedURLButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedURLButton.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.displayText != null && Object.hasOwnProperty.call(message, "displayText"))
                    writer.uint32(/* id 1, wireType 2 =*/10).string(message.displayText);
                if (message.url != null && Object.hasOwnProperty.call(message, "url"))
                    writer.uint32(/* id 2, wireType 2 =*/18).string(message.url);
                return writer;
            };

            /**
             * Encodes the specified HydratedURLButton message, length delimited. Does not implicitly {@link proto.HydratedTemplateButton.HydratedURLButton.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {proto.HydratedTemplateButton.IHydratedURLButton} message HydratedURLButton message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            HydratedURLButton.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer.
             * @function decode
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.HydratedTemplateButton.HydratedURLButton} HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedURLButton.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.HydratedTemplateButton.HydratedURLButton();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        message.displayText = reader.string();
                        break;
                    case 2:
                        message.url = reader.string();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes a HydratedURLButton message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.HydratedTemplateButton.HydratedURLButton} HydratedURLButton
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            HydratedURLButton.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies a HydratedURLButton message.
             * @function verify
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            HydratedURLButton.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    if (!$util.isString(message.displayText))
                        return "displayText: string expected";
                if (message.url != null && message.hasOwnProperty("url"))
                    if (!$util.isString(message.url))
                        return "url: string expected";
                return null;
            };

            /**
             * Creates a HydratedURLButton message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.HydratedTemplateButton.HydratedURLButton} HydratedURLButton
             */
            HydratedURLButton.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.HydratedTemplateButton.HydratedURLButton)
                    return object;
                var message = new $root.proto.HydratedTemplateButton.HydratedURLButton();
                if (object.displayText != null)
                    message.displayText = String(object.displayText);
                if (object.url != null)
                    message.url = String(object.url);
                return message;
            };

            /**
             * Creates a plain object from a HydratedURLButton message. Also converts values to other types if specified.
             * @function toObject
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @static
             * @param {proto.HydratedTemplateButton.HydratedURLButton} message HydratedURLButton
             * @param {$protobuf.IConversionOptions} [options] Conversion options
             * @returns {Object.<string,*>} Plain object
             */
            HydratedURLButton.toObject = function toObject(message, options) {
                if (!options)
                    options = {};
                var object = {};
                if (options.defaults) {
                    object.displayText = "";
                    object.url = "";
                }
                if (message.displayText != null && message.hasOwnProperty("displayText"))
                    object.displayText = message.displayText;
                if (message.url != null && message.hasOwnProperty("url"))
                    object.url = message.url;
                return object;
            };

            /**
             * Converts this HydratedURLButton to JSON.
             * @function toJSON
             * @memberof proto.HydratedTemplateButton.HydratedURLButton
             * @instance
             * @returns {Object.<string,*>} JSON object
             */
            HydratedURLButton.prototype.toJSON = function toJSON() {
                return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
            };

            return HydratedURLButton;
        })();

        return HydratedTemplateButton;
    })();

    proto.IdentityKeyPairStructure = (function() {

        /**
         * Properties of an IdentityKeyPairStructure.
         * @memberof proto
         * @interface IIdentityKeyPairStructure
         * @property {Uint8Array|null} [publicKey] IdentityKeyPairStructure publicKey
         * @property {Uint8Array|null} [privateKey] IdentityKeyPairStructure privateKey
         */

        /**
         * Constructs a new IdentityKeyPairStructure.
         * @memberof proto
         * @classdesc Represents an IdentityKeyPairStructure.
         * @implements IIdentityKeyPairStructure
         * @constructor
         * @param {proto.IIdentityKeyPairStructure=} [properties] Properties to set
         */
        function IdentityKeyPairStructure(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * IdentityKeyPairStructure publicKey.
         * @member {Uint8Array} publicKey
         * @memberof proto.IdentityKeyPairStructure
         * @instance
         */
        IdentityKeyPairStructure.prototype.publicKey = $util.newBuffer([]);

        /**
         * IdentityKeyPairStructure privateKey.
         * @member {Uint8Array} privateKey
         * @memberof proto.IdentityKeyPairStructure
         * @instance
         */
        IdentityKeyPairStructure.prototype.privateKey = $util.newBuffer([]);

        /**
         * Creates a new IdentityKeyPairStructure instance using the specified properties.
         * @function create
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {proto.IIdentityKeyPairStructure=} [properties] Properties to set
         * @returns {proto.IdentityKeyPairStructure} IdentityKeyPairStructure instance
         */
        IdentityKeyPairStructure.create = function create(properties) {
            return new IdentityKeyPairStructure(properties);
        };

        /**
         * Encodes the specified IdentityKeyPairStructure message. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @function encode
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {proto.IIdentityKeyPairStructure} message IdentityKeyPairStructure message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        IdentityKeyPairStructure.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.publicKey != null && Object.hasOwnProperty.call(message, "publicKey"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.publicKey);
            if (message.privateKey != null && Object.hasOwnProperty.call(message, "privateKey"))
                writer.uint32(/* id 2, wireType 2 =*/18).bytes(message.privateKey);
            return writer;
        };

        /**
         * Encodes the specified IdentityKeyPairStructure message, length delimited. Does not implicitly {@link proto.IdentityKeyPairStructure.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {proto.IIdentityKeyPairStructure} message IdentityKeyPairStructure message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        IdentityKeyPairStructure.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer.
         * @function decode
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.IdentityKeyPairStructure} IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        IdentityKeyPairStructure.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.IdentityKeyPairStructure();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.publicKey = reader.bytes();
                    break;
                case 2:
                    message.privateKey = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an IdentityKeyPairStructure message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.IdentityKeyPairStructure} IdentityKeyPairStructure
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        IdentityKeyPairStructure.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an IdentityKeyPairStructure message.
         * @function verify
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        IdentityKeyPairStructure.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.publicKey != null && message.hasOwnProperty("publicKey"))
                if (!(message.publicKey && typeof message.publicKey.length === "number" || $util.isString(message.publicKey)))
                    return "publicKey: buffer expected";
            if (message.privateKey != null && message.hasOwnProperty("privateKey"))
                if (!(message.privateKey && typeof message.privateKey.length === "number" || $util.isString(message.privateKey)))
                    return "privateKey: buffer expected";
            return null;
        };

        /**
         * Creates an IdentityKeyPairStructure message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.IdentityKeyPairStructure} IdentityKeyPairStructure
         */
        IdentityKeyPairStructure.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.IdentityKeyPairStructure)
                return object;
            var message = new $root.proto.IdentityKeyPairStructure();
            if (object.publicKey != null)
                if (typeof object.publicKey === "string")
                    $util.base64.decode(object.publicKey, message.publicKey = $util.newBuffer($util.base64.length(object.publicKey)), 0);
                else if (object.publicKey.length)
                    message.publicKey = object.publicKey;
            if (object.privateKey != null)
                if (typeof object.privateKey === "string")
                    $util.base64.decode(object.privateKey, message.privateKey = $util.newBuffer($util.base64.length(object.privateKey)), 0);
                else if (object.privateKey.length)
                    message.privateKey = object.privateKey;
            return message;
        };

        /**
         * Creates a plain object from an IdentityKeyPairStructure message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.IdentityKeyPairStructure
         * @static
         * @param {proto.IdentityKeyPairStructure} message IdentityKeyPairStructure
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        IdentityKeyPairStructure.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                if (options.bytes === String)
                    object.publicKey = "";
                else {
                    object.publicKey = [];
                    if (options.bytes !== Array)
                        object.publicKey = $util.newBuffer(object.publicKey);
                }
                if (options.bytes === String)
                    object.privateKey = "";
                else {
                    object.privateKey = [];
                    if (options.bytes !== Array)
                        object.privateKey = $util.newBuffer(object.privateKey);
                }
            }
            if (message.publicKey != null && message.hasOwnProperty("publicKey"))
                object.publicKey = options.bytes === String ? $util.base64.encode(message.publicKey, 0, message.publicKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.publicKey) : message.publicKey;
            if (message.privateKey != null && message.hasOwnProperty("privateKey"))
                object.privateKey = options.bytes === String ? $util.base64.encode(message.privateKey, 0, message.privateKey.length) : options.bytes === Array ? Array.prototype.slice.call(message.privateKey) : message.privateKey;
            return object;
        };

        /**
         * Converts this IdentityKeyPairStructure to JSON.
         * @function toJSON
         * @memberof proto.IdentityKeyPairStructure
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        IdentityKeyPairStructure.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return IdentityKeyPairStructure;
    })();

    proto.InteractiveAnnotation = (function() {

        /**
         * Properties of an InteractiveAnnotation.
         * @memberof proto
         * @interface IInteractiveAnnotation
         * @property {Array.<proto.IPoint>|null} [polygonVertices] InteractiveAnnotation polygonVertices
         * @property {proto.ILocation|null} [location] InteractiveAnnotation location
         */

        /**
         * Constructs a new InteractiveAnnotation.
         * @memberof proto
         * @classdesc Represents an InteractiveAnnotation.
         * @implements IInteractiveAnnotation
         * @constructor
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         */
        function InteractiveAnnotation(properties) {
            this.polygonVertices = [];
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * InteractiveAnnotation polygonVertices.
         * @member {Array.<proto.IPoint>} polygonVertices
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.polygonVertices = $util.emptyArray;

        /**
         * InteractiveAnnotation location.
         * @member {proto.ILocation|null|undefined} location
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        InteractiveAnnotation.prototype.location = null;

        // OneOf field names bound to virtual getters and setters
        var $oneOfFields;

        /**
         * InteractiveAnnotation action.
         * @member {"location"|undefined} action
         * @memberof proto.InteractiveAnnotation
         * @instance
         */
        Object.defineProperty(InteractiveAnnotation.prototype, "action", {
            get: $util.oneOfGetter($oneOfFields = ["location"]),
            set: $util.oneOfSetter($oneOfFields)
        });

        /**
         * Creates a new InteractiveAnnotation instance using the specified properties.
         * @function create
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation=} [properties] Properties to set
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation instance
         */
        InteractiveAnnotation.create = function create(properties) {
            return new InteractiveAnnotation(properties);
        };

        /**
         * Encodes the specified InteractiveAnnotation message. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.polygonVertices != null && message.polygonVertices.length)
                for (var i = 0; i < message.polygonVertices.length; ++i)
                    $root.proto.Point.encode(message.polygonVertices[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
            if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                $root.proto.Location.encode(message.location, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified InteractiveAnnotation message, length delimited. Does not implicitly {@link proto.InteractiveAnnotation.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.IInteractiveAnnotation} message InteractiveAnnotation message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        InteractiveAnnotation.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer.
         * @function decode
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.InteractiveAnnotation();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    if (!(message.polygonVertices && message.polygonVertices.length))
                        message.polygonVertices = [];
                    message.polygonVertices.push($root.proto.Point.decode(reader, reader.uint32()));
                    break;
                case 2:
                    message.location = $root.proto.Location.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes an InteractiveAnnotation message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        InteractiveAnnotation.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies an InteractiveAnnotation message.
         * @function verify
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        InteractiveAnnotation.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            var properties = {};
            if (message.polygonVertices != null && message.hasOwnProperty("polygonVertices")) {
                if (!Array.isArray(message.polygonVertices))
                    return "polygonVertices: array expected";
                for (var i = 0; i < message.polygonVertices.length; ++i) {
                    var error = $root.proto.Point.verify(message.polygonVertices[i]);
                    if (error)
                        return "polygonVertices." + error;
                }
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                properties.action = 1;
                {
                    var error = $root.proto.Location.verify(message.location);
                    if (error)
                        return "location." + error;
                }
            }
            return null;
        };

        /**
         * Creates an InteractiveAnnotation message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.InteractiveAnnotation} InteractiveAnnotation
         */
        InteractiveAnnotation.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.InteractiveAnnotation)
                return object;
            var message = new $root.proto.InteractiveAnnotation();
            if (object.polygonVertices) {
                if (!Array.isArray(object.polygonVertices))
                    throw TypeError(".proto.InteractiveAnnotation.polygonVertices: array expected");
                message.polygonVertices = [];
                for (var i = 0; i < object.polygonVertices.length; ++i) {
                    if (typeof object.polygonVertices[i] !== "object")
                        throw TypeError(".proto.InteractiveAnnotation.polygonVertices: object expected");
                    message.polygonVertices[i] = $root.proto.Point.fromObject(object.polygonVertices[i]);
                }
            }
            if (object.location != null) {
                if (typeof object.location !== "object")
                    throw TypeError(".proto.InteractiveAnnotation.location: object expected");
                message.location = $root.proto.Location.fromObject(object.location);
            }
            return message;
        };

        /**
         * Creates a plain object from an InteractiveAnnotation message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.InteractiveAnnotation
         * @static
         * @param {proto.InteractiveAnnotation} message InteractiveAnnotation
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        InteractiveAnnotation.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.arrays || options.defaults)
                object.polygonVertices = [];
            if (message.polygonVertices && message.polygonVertices.length) {
                object.polygonVertices = [];
                for (var j = 0; j < message.polygonVertices.length; ++j)
                    object.polygonVertices[j] = $root.proto.Point.toObject(message.polygonVertices[j], options);
            }
            if (message.location != null && message.hasOwnProperty("location")) {
                object.location = $root.proto.Location.toObject(message.location, options);
                if (options.oneofs)
                    object.action = "location";
            }
            return object;
        };

        /**
         * Converts this InteractiveAnnotation to JSON.
         * @function toJSON
         * @memberof proto.InteractiveAnnotation
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        InteractiveAnnotation.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return InteractiveAnnotation;
    })();

    proto.KeepInChat = (function() {

        /**
         * Properties of a KeepInChat.
         * @memberof proto
         * @interface IKeepInChat
         * @property {proto.KeepType|null} [keepType] KeepInChat keepType
         * @property {number|Long|null} [serverTimestamp] KeepInChat serverTimestamp
         * @property {proto.IMessageKey|null} [key] KeepInChat key
         * @property {string|null} [deviceJid] KeepInChat deviceJid
         * @property {number|Long|null} [clientTimestampMs] KeepInChat clientTimestampMs
         * @property {number|Long|null} [serverTimestampMs] KeepInChat serverTimestampMs
         */

        /**
         * Constructs a new KeepInChat.
         * @memberof proto
         * @classdesc Represents a KeepInChat.
         * @implements IKeepInChat
         * @constructor
         * @param {proto.IKeepInChat=} [properties] Properties to set
         */
        function KeepInChat(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * KeepInChat keepType.
         * @member {proto.KeepType} keepType
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.keepType = 0;

        /**
         * KeepInChat serverTimestamp.
         * @member {number|Long} serverTimestamp
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.serverTimestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * KeepInChat key.
         * @member {proto.IMessageKey|null|undefined} key
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.key = null;

        /**
         * KeepInChat deviceJid.
         * @member {string} deviceJid
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.deviceJid = "";

        /**
         * KeepInChat clientTimestampMs.
         * @member {number|Long} clientTimestampMs
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.clientTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * KeepInChat serverTimestampMs.
         * @member {number|Long} serverTimestampMs
         * @memberof proto.KeepInChat
         * @instance
         */
        KeepInChat.prototype.serverTimestampMs = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

        /**
         * Creates a new KeepInChat instance using the specified properties.
         * @function create
         * @memberof proto.KeepInChat
         * @static
         * @param {proto.IKeepInChat=} [properties] Properties to set
         * @returns {proto.KeepInChat} KeepInChat instance
         */
        KeepInChat.create = function create(properties) {
            return new KeepInChat(properties);
        };

        /**
         * Encodes the specified KeepInChat message. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @function encode
         * @memberof proto.KeepInChat
         * @static
         * @param {proto.IKeepInChat} message KeepInChat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeepInChat.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.keepType != null && Object.hasOwnProperty.call(message, "keepType"))
                writer.uint32(/* id 1, wireType 0 =*/8).int32(message.keepType);
            if (message.serverTimestamp != null && Object.hasOwnProperty.call(message, "serverTimestamp"))
                writer.uint32(/* id 2, wireType 0 =*/16).int64(message.serverTimestamp);
            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                $root.proto.MessageKey.encode(message.key, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.deviceJid != null && Object.hasOwnProperty.call(message, "deviceJid"))
                writer.uint32(/* id 4, wireType 2 =*/34).string(message.deviceJid);
            if (message.clientTimestampMs != null && Object.hasOwnProperty.call(message, "clientTimestampMs"))
                writer.uint32(/* id 5, wireType 0 =*/40).int64(message.clientTimestampMs);
            if (message.serverTimestampMs != null && Object.hasOwnProperty.call(message, "serverTimestampMs"))
                writer.uint32(/* id 6, wireType 0 =*/48).int64(message.serverTimestampMs);
            return writer;
        };

        /**
         * Encodes the specified KeepInChat message, length delimited. Does not implicitly {@link proto.KeepInChat.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.KeepInChat
         * @static
         * @param {proto.IKeepInChat} message KeepInChat message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeepInChat.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a KeepInChat message from the specified reader or buffer.
         * @function decode
         * @memberof proto.KeepInChat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.KeepInChat} KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeepInChat.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.KeepInChat();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.keepType = reader.int32();
                    break;
                case 2:
                    message.serverTimestamp = reader.int64();
                    break;
                case 3:
                    message.key = $root.proto.MessageKey.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.deviceJid = reader.string();
                    break;
                case 5:
                    message.clientTimestampMs = reader.int64();
                    break;
                case 6:
                    message.serverTimestampMs = reader.int64();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a KeepInChat message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.KeepInChat
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.KeepInChat} KeepInChat
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeepInChat.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a KeepInChat message.
         * @function verify
         * @memberof proto.KeepInChat
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        KeepInChat.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.keepType != null && message.hasOwnProperty("keepType"))
                switch (message.keepType) {
                default:
                    return "keepType: enum value expected";
                case 0:
                case 1:
                case 2:
                    break;
                }
            if (message.serverTimestamp != null && message.hasOwnProperty("serverTimestamp"))
                if (!$util.isInteger(message.serverTimestamp) && !(message.serverTimestamp && $util.isInteger(message.serverTimestamp.low) && $util.isInteger(message.serverTimestamp.high)))
                    return "serverTimestamp: integer|Long expected";
            if (message.key != null && message.hasOwnProperty("key")) {
                var error = $root.proto.MessageKey.verify(message.key);
                if (error)
                    return "key." + error;
            }
            if (message.deviceJid != null && message.hasOwnProperty("deviceJid"))
                if (!$util.isString(message.deviceJid))
                    return "deviceJid: string expected";
            if (message.clientTimestampMs != null && message.hasOwnProperty("clientTimestampMs"))
                if (!$util.isInteger(message.clientTimestampMs) && !(message.clientTimestampMs && $util.isInteger(message.clientTimestampMs.low) && $util.isInteger(message.clientTimestampMs.high)))
                    return "clientTimestampMs: integer|Long expected";
            if (message.serverTimestampMs != null && message.hasOwnProperty("serverTimestampMs"))
                if (!$util.isInteger(message.serverTimestampMs) && !(message.serverTimestampMs && $util.isInteger(message.serverTimestampMs.low) && $util.isInteger(message.serverTimestampMs.high)))
                    return "serverTimestampMs: integer|Long expected";
            return null;
        };

        /**
         * Creates a KeepInChat message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.KeepInChat
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.KeepInChat} KeepInChat
         */
        KeepInChat.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.KeepInChat)
                return object;
            var message = new $root.proto.KeepInChat();
            switch (object.keepType) {
            case "UNKNOWN":
            case 0:
                message.keepType = 0;
                break;
            case "KEEP_FOR_ALL":
            case 1:
                message.keepType = 1;
                break;
            case "UNDO_KEEP_FOR_ALL":
            case 2:
                message.keepType = 2;
                break;
            }
            if (object.serverTimestamp != null)
                if ($util.Long)
                    (message.serverTimestamp = $util.Long.fromValue(object.serverTimestamp)).unsigned = false;
                else if (typeof object.serverTimestamp === "string")
                    message.serverTimestamp = parseInt(object.serverTimestamp, 10);
                else if (typeof object.serverTimestamp === "number")
                    message.serverTimestamp = object.serverTimestamp;
                else if (typeof object.serverTimestamp === "object")
                    message.serverTimestamp = new $util.LongBits(object.serverTimestamp.low >>> 0, object.serverTimestamp.high >>> 0).toNumber();
            if (object.key != null) {
                if (typeof object.key !== "object")
                    throw TypeError(".proto.KeepInChat.key: object expected");
                message.key = $root.proto.MessageKey.fromObject(object.key);
            }
            if (object.deviceJid != null)
                message.deviceJid = String(object.deviceJid);
            if (object.clientTimestampMs != null)
                if ($util.Long)
                    (message.clientTimestampMs = $util.Long.fromValue(object.clientTimestampMs)).unsigned = false;
                else if (typeof object.clientTimestampMs === "string")
                    message.clientTimestampMs = parseInt(object.clientTimestampMs, 10);
                else if (typeof object.clientTimestampMs === "number")
                    message.clientTimestampMs = object.clientTimestampMs;
                else if (typeof object.clientTimestampMs === "object")
                    message.clientTimestampMs = new $util.LongBits(object.clientTimestampMs.low >>> 0, object.clientTimestampMs.high >>> 0).toNumber();
            if (object.serverTimestampMs != null)
                if ($util.Long)
                    (message.serverTimestampMs = $util.Long.fromValue(object.serverTimestampMs)).unsigned = false;
                else if (typeof object.serverTimestampMs === "string")
                    message.serverTimestampMs = parseInt(object.serverTimestampMs, 10);
                else if (typeof object.serverTimestampMs === "number")
                    message.serverTimestampMs = object.serverTimestampMs;
                else if (typeof object.serverTimestampMs === "object")
                    message.serverTimestampMs = new $util.LongBits(object.serverTimestampMs.low >>> 0, object.serverTimestampMs.high >>> 0).toNumber();
            return message;
        };

        /**
         * Creates a plain object from a KeepInChat message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.KeepInChat
         * @static
         * @param {proto.KeepInChat} message KeepInChat
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        KeepInChat.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.keepType = options.enums === String ? "UNKNOWN" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.serverTimestamp = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.serverTimestamp = options.longs === String ? "0" : 0;
                object.key = null;
                object.deviceJid = "";
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.clientTimestampMs = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.clientTimestampMs = options.longs === String ? "0" : 0;
                if ($util.Long) {
                    var long = new $util.Long(0, 0, false);
                    object.serverTimestampMs = options.longs === String ? long.toString() : options.longs === Number ? long.toNumber() : long;
                } else
                    object.serverTimestampMs = options.longs === String ? "0" : 0;
            }
            if (message.keepType != null && message.hasOwnProperty("keepType"))
                object.keepType = options.enums === String ? $root.proto.KeepType[message.keepType] : message.keepType;
            if (message.serverTimestamp != null && message.hasOwnProperty("serverTimestamp"))
                if (typeof message.serverTimestamp === "number")
                    object.serverTimestamp = options.longs === String ? String(message.serverTimestamp) : message.serverTimestamp;
                else
                    object.serverTimestamp = options.longs === String ? $util.Long.prototype.toString.call(message.serverTimestamp) : options.longs === Number ? new $util.LongBits(message.serverTimestamp.low >>> 0, message.serverTimestamp.high >>> 0).toNumber() : message.serverTimestamp;
            if (message.key != null && message.hasOwnProperty("key"))
                object.key = $root.proto.MessageKey.toObject(message.key, options);
            if (message.deviceJid != null && message.hasOwnProperty("deviceJid"))
                object.deviceJid = message.deviceJid;
            if (message.clientTimestampMs != null && message.hasOwnProperty("clientTimestampMs"))
                if (typeof message.clientTimestampMs === "number")
                    object.clientTimestampMs = options.longs === String ? String(message.clientTimestampMs) : message.clientTimestampMs;
                else
                    object.clientTimestampMs = options.longs === String ? $util.Long.prototype.toString.call(message.clientTimestampMs) : options.longs === Number ? new $util.LongBits(message.clientTimestampMs.low >>> 0, message.clientTimestampMs.high >>> 0).toNumber() : message.clientTimestampMs;
            if (message.serverTimestampMs != null && message.hasOwnProperty("serverTimestampMs"))
                if (typeof message.serverTimestampMs === "number")
                    object.serverTimestampMs = options.longs === String ? String(message.serverTimestampMs) : message.serverTimestampMs;
                else
                    object.serverTimestampMs = options.longs === String ? $util.Long.prototype.toString.call(message.serverTimestampMs) : options.longs === Number ? new $util.LongBits(message.serverTimestampMs.low >>> 0, message.serverTimestampMs.high >>> 0).toNumber() : message.serverTimestampMs;
            return object;
        };

        /**
         * Converts this KeepInChat to JSON.
         * @function toJSON
         * @memberof proto.KeepInChat
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        KeepInChat.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return KeepInChat;
    })();

    /**
     * KeepType enum.
     * @name proto.KeepType
     * @enum {number}
     * @property {number} UNKNOWN=0 UNKNOWN value
     * @property {number} KEEP_FOR_ALL=1 KEEP_FOR_ALL value
     * @property {number} UNDO_KEEP_FOR_ALL=2 UNDO_KEEP_FOR_ALL value
     */
    proto.KeepType = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "UNKNOWN"] = 0;
        values[valuesById[1] = "KEEP_FOR_ALL"] = 1;
        values[valuesById[2] = "UNDO_KEEP_FOR_ALL"] = 2;
        return values;
    })();

    proto.KeyId = (function() {

        /**
         * Properties of a KeyId.
         * @memberof proto
         * @interface IKeyId
         * @property {Uint8Array|null} [id] KeyId id
         */

        /**
         * Constructs a new KeyId.
         * @memberof proto
         * @classdesc Represents a KeyId.
         * @implements IKeyId
         * @constructor
         * @param {proto.IKeyId=} [properties] Properties to set
         */
        function KeyId(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * KeyId id.
         * @member {Uint8Array} id
         * @memberof proto.KeyId
         * @instance
         */
        KeyId.prototype.id = $util.newBuffer([]);

        /**
         * Creates a new KeyId instance using the specified properties.
         * @function create
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId=} [properties] Properties to set
         * @returns {proto.KeyId} KeyId instance
         */
        KeyId.create = function create(properties) {
            return new KeyId(properties);
        };

        /**
         * Encodes the specified KeyId message. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @function encode
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId} message KeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyId.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                writer.uint32(/* id 1, wireType 2 =*/10).bytes(message.id);
            return writer;
        };

        /**
         * Encodes the specified KeyId message, length delimited. Does not implicitly {@link proto.KeyId.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.KeyId
         * @static
         * @param {proto.IKeyId} message KeyId message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        KeyId.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a KeyId message from the specified reader or buffer.
         * @function decode
         * @memberof proto.KeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.KeyId} KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyId.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.KeyId();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.id = reader.bytes();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a KeyId message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.KeyId
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.KeyId} KeyId
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        KeyId.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a KeyId message.
         * @function verify
         * @memberof proto.KeyId
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        KeyId.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.id != null && message.hasOwnProperty("id"))
                if (!(message.id && typeof message.id.length === "number" || $util.isString(message.id)))
                    return "id: buffer expected";
            return null;
        };

        /**
         * Creates a KeyId message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.KeyId
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.KeyId} KeyId
         */
        KeyId.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.KeyId)
                return object;
            var message = new $root.proto.KeyId();
            if (object.id != null)
                if (typeof object.id === "string")
                    $util.base64.decode(object.id, message.id = $util.newBuffer($util.base64.length(object.id)), 0);
                else if (object.id.length)
                    message.id = object.id;
            return message;
        };

        /**
         * Creates a plain object from a KeyId message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.KeyId
         * @static
         * @param {proto.KeyId} message KeyId
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        KeyId.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                if (options.bytes === String)
                    object.id = "";
                else {
                    object.id = [];
                    if (options.bytes !== Array)
                        object.id = $util.newBuffer(object.id);
                }
            if (message.id != null && message.hasOwnProperty("id"))
                object.id = options.bytes === String ? $util.base64.encode(message.id, 0, message.id.length) : options.bytes === Array ? Array.prototype.slice.call(message.id) : message.id;
            return object;
        };

        /**
         * Converts this KeyId to JSON.
         * @function toJSON
         * @memberof proto.KeyId
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        KeyId.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return KeyId;
    })();

    proto.LocalizedName = (function() {

        /**
         * Properties of a LocalizedName.
         * @memberof proto
         * @interface ILocalizedName
         * @property {string|null} [lg] LocalizedName lg
         * @property {string|null} [lc] LocalizedName lc
         * @property {string|null} [verifiedName] LocalizedName verifiedName
         */

        /**
         * Constructs a new LocalizedName.
         * @memberof proto
         * @classdesc Represents a LocalizedName.
         * @implements ILocalizedName
         * @constructor
         * @param {proto.ILocalizedName=} [properties] Properties to set
         */
        function LocalizedName(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * LocalizedName lg.
         * @member {string} lg
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.lg = "";

        /**
         * LocalizedName lc.
         * @member {string} lc
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.lc = "";

        /**
         * LocalizedName verifiedName.
         * @member {string} verifiedName
         * @memberof proto.LocalizedName
         * @instance
         */
        LocalizedName.prototype.verifiedName = "";

        /**
         * Creates a new LocalizedName instance using the specified properties.
         * @function create
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName=} [properties] Properties to set
         * @returns {proto.LocalizedName} LocalizedName instance
         */
        LocalizedName.create = function create(properties) {
            return new LocalizedName(properties);
        };

        /**
         * Encodes the specified LocalizedName message. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @function encode
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName} message LocalizedName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocalizedName.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.lg != null && Object.hasOwnProperty.call(message, "lg"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.lg);
            if (message.lc != null && Object.hasOwnProperty.call(message, "lc"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.lc);
            if (message.verifiedName != null && Object.hasOwnProperty.call(message, "verifiedName"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.verifiedName);
            return writer;
        };

        /**
         * Encodes the specified LocalizedName message, length delimited. Does not implicitly {@link proto.LocalizedName.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.ILocalizedName} message LocalizedName message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        LocalizedName.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a LocalizedName message from the specified reader or buffer.
         * @function decode
         * @memberof proto.LocalizedName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.LocalizedName} LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocalizedName.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.LocalizedName();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.lg = reader.string();
                    break;
                case 2:
                    message.lc = reader.string();
                    break;
                case 3:
                    message.verifiedName = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a LocalizedName message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.LocalizedName
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.LocalizedName} LocalizedName
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        LocalizedName.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a LocalizedName message.
         * @function verify
         * @memberof proto.LocalizedName
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        LocalizedName.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.lg != null && message.hasOwnProperty("lg"))
                if (!$util.isString(message.lg))
                    return "lg: string expected";
            if (message.lc != null && message.hasOwnProperty("lc"))
                if (!$util.isString(message.lc))
                    return "lc: string expected";
            if (message.verifiedName != null && message.hasOwnProperty("verifiedName"))
                if (!$util.isString(message.verifiedName))
                    return "verifiedName: string expected";
            return null;
        };

        /**
         * Creates a LocalizedName message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.LocalizedName
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.LocalizedName} LocalizedName
         */
        LocalizedName.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.LocalizedName)
                return object;
            var message = new $root.proto.LocalizedName();
            if (object.lg != null)
                message.lg = String(object.lg);
            if (object.lc != null)
                message.lc = String(object.lc);
            if (object.verifiedName != null)
                message.verifiedName = String(object.verifiedName);
            return message;
        };

        /**
         * Creates a plain object from a LocalizedName message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.LocalizedName
         * @static
         * @param {proto.LocalizedName} message LocalizedName
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        LocalizedName.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.lg = "";
                object.lc = "";
                object.verifiedName = "";
            }
            if (message.lg != null && message.hasOwnProperty("lg"))
                object.lg = message.lg;
            if (message.lc != null && message.hasOwnProperty("lc"))
                object.lc = message.lc;
            if (message.verifiedName != null && message.hasOwnProperty("verifiedName"))
                object.verifiedName = message.verifiedName;
            return object;
        };

        /**
         * Converts this LocalizedName to JSON.
         * @function toJSON
         * @memberof proto.LocalizedName
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        LocalizedName.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return LocalizedName;
    })();

    proto.Location = (function() {

        /**
         * Properties of a Location.
         * @memberof proto
         * @interface ILocation
         * @property {number|null} [degreesLatitude] Location degreesLatitude
         * @property {number|null} [degreesLongitude] Location degreesLongitude
         * @property {string|null} [name] Location name
         */

        /**
         * Constructs a new Location.
         * @memberof proto
         * @classdesc Represents a Location.
         * @implements ILocation
         * @constructor
         * @param {proto.ILocation=} [properties] Properties to set
         */
        function Location(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Location degreesLatitude.
         * @member {number} degreesLatitude
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.degreesLatitude = 0;

        /**
         * Location degreesLongitude.
         * @member {number} degreesLongitude
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.degreesLongitude = 0;

        /**
         * Location name.
         * @member {string} name
         * @memberof proto.Location
         * @instance
         */
        Location.prototype.name = "";

        /**
         * Creates a new Location instance using the specified properties.
         * @function create
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation=} [properties] Properties to set
         * @returns {proto.Location} Location instance
         */
        Location.create = function create(properties) {
            return new Location(properties);
        };

        /**
         * Encodes the specified Location message. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @function encode
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation} message Location message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Location.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.degreesLatitude != null && Object.hasOwnProperty.call(message, "degreesLatitude"))
                writer.uint32(/* id 1, wireType 1 =*/9).double(message.degreesLatitude);
            if (message.degreesLongitude != null && Object.hasOwnProperty.call(message, "degreesLongitude"))
                writer.uint32(/* id 2, wireType 1 =*/17).double(message.degreesLongitude);
            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                writer.uint32(/* id 3, wireType 2 =*/26).string(message.name);
            return writer;
        };

        /**
         * Encodes the specified Location message, length delimited. Does not implicitly {@link proto.Location.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Location
         * @static
         * @param {proto.ILocation} message Location message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Location.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Location message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Location
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Location} Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Location.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Location();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.degreesLatitude = reader.double();
                    break;
                case 2:
                    message.degreesLongitude = reader.double();
                    break;
                case 3:
                    message.name = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Location message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Location
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Location} Location
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Location.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Location message.
         * @function verify
         * @memberof proto.Location
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Location.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                if (typeof message.degreesLatitude !== "number")
                    return "degreesLatitude: number expected";
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                if (typeof message.degreesLongitude !== "number")
                    return "degreesLongitude: number expected";
            if (message.name != null && message.hasOwnProperty("name"))
                if (!$util.isString(message.name))
                    return "name: string expected";
            return null;
        };

        /**
         * Creates a Location message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Location
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Location} Location
         */
        Location.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Location)
                return object;
            var message = new $root.proto.Location();
            if (object.degreesLatitude != null)
                message.degreesLatitude = Number(object.degreesLatitude);
            if (object.degreesLongitude != null)
                message.degreesLongitude = Number(object.degreesLongitude);
            if (object.name != null)
                message.name = String(object.name);
            return message;
        };

        /**
         * Creates a plain object from a Location message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Location
         * @static
         * @param {proto.Location} message Location
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Location.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.degreesLatitude = 0;
                object.degreesLongitude = 0;
                object.name = "";
            }
            if (message.degreesLatitude != null && message.hasOwnProperty("degreesLatitude"))
                object.degreesLatitude = options.json && !isFinite(message.degreesLatitude) ? String(message.degreesLatitude) : message.degreesLatitude;
            if (message.degreesLongitude != null && message.hasOwnProperty("degreesLongitude"))
                object.degreesLongitude = options.json && !isFinite(message.degreesLongitude) ? String(message.degreesLongitude) : message.degreesLongitude;
            if (message.name != null && message.hasOwnProperty("name"))
                object.name = message.name;
            return object;
        };

        /**
         * Converts this Location to JSON.
         * @function toJSON
         * @memberof proto.Location
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Location.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return Location;
    })();

    proto.MediaData = (function() {

        /**
         * Properties of a MediaData.
         * @memberof proto
         * @interface IMediaData
         * @property {string|null} [localPath] MediaData localPath
         */

        /**
         * Constructs a new MediaData.
         * @memberof proto
         * @classdesc Represents a MediaData.
         * @implements IMediaData
         * @constructor
         * @param {proto.IMediaData=} [properties] Properties to set
         */
        function MediaData(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MediaData localPath.
         * @member {string} localPath
         * @memberof proto.MediaData
         * @instance
         */
        MediaData.prototype.localPath = "";

        /**
         * Creates a new MediaData instance using the specified properties.
         * @function create
         * @memberof proto.MediaData
         * @static
         * @param {proto.IMediaData=} [properties] Properties to set
         * @returns {proto.MediaData} MediaData instance
         */
        MediaData.create = function create(properties) {
            return new MediaData(properties);
        };

        /**
         * Encodes the specified MediaData message. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @function encode
         * @memberof proto.MediaData
         * @static
         * @param {proto.IMediaData} message MediaData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaData.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.localPath != null && Object.hasOwnProperty.call(message, "localPath"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.localPath);
            return writer;
        };

        /**
         * Encodes the specified MediaData message, length delimited. Does not implicitly {@link proto.MediaData.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MediaData
         * @static
         * @param {proto.IMediaData} message MediaData message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaData.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MediaData message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MediaData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MediaData} MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaData.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MediaData();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.localPath = reader.string();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MediaData message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MediaData
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MediaData} MediaData
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaData.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MediaData message.
         * @function verify
         * @memberof proto.MediaData
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MediaData.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.localPath != null && message.hasOwnProperty("localPath"))
                if (!$util.isString(message.localPath))
                    return "localPath: string expected";
            return null;
        };

        /**
         * Creates a MediaData message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MediaData
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MediaData} MediaData
         */
        MediaData.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MediaData)
                return object;
            var message = new $root.proto.MediaData();
            if (object.localPath != null)
                message.localPath = String(object.localPath);
            return message;
        };

        /**
         * Creates a plain object from a MediaData message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MediaData
         * @static
         * @param {proto.MediaData} message MediaData
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MediaData.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults)
                object.localPath = "";
            if (message.localPath != null && message.hasOwnProperty("localPath"))
                object.localPath = message.localPath;
            return object;
        };

        /**
         * Converts this MediaData to JSON.
         * @function toJSON
         * @memberof proto.MediaData
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MediaData.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        return MediaData;
    })();

    proto.MediaRetryNotification = (function() {

        /**
         * Properties of a MediaRetryNotification.
         * @memberof proto
         * @interface IMediaRetryNotification
         * @property {string|null} [stanzaId] MediaRetryNotification stanzaId
         * @property {string|null} [directPath] MediaRetryNotification directPath
         * @property {proto.MediaRetryNotification.ResultType|null} [result] MediaRetryNotification result
         */

        /**
         * Constructs a new MediaRetryNotification.
         * @memberof proto
         * @classdesc Represents a MediaRetryNotification.
         * @implements IMediaRetryNotification
         * @constructor
         * @param {proto.IMediaRetryNotification=} [properties] Properties to set
         */
        function MediaRetryNotification(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * MediaRetryNotification stanzaId.
         * @member {string} stanzaId
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.stanzaId = "";

        /**
         * MediaRetryNotification directPath.
         * @member {string} directPath
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.directPath = "";

        /**
         * MediaRetryNotification result.
         * @member {proto.MediaRetryNotification.ResultType} result
         * @memberof proto.MediaRetryNotification
         * @instance
         */
        MediaRetryNotification.prototype.result = 0;

        /**
         * Creates a new MediaRetryNotification instance using the specified properties.
         * @function create
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification=} [properties] Properties to set
         * @returns {proto.MediaRetryNotification} MediaRetryNotification instance
         */
        MediaRetryNotification.create = function create(properties) {
            return new MediaRetryNotification(properties);
        };

        /**
         * Encodes the specified MediaRetryNotification message. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @function encode
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification} message MediaRetryNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaRetryNotification.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.stanzaId != null && Object.hasOwnProperty.call(message, "stanzaId"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.stanzaId);
            if (message.directPath != null && Object.hasOwnProperty.call(message, "directPath"))
                writer.uint32(/* id 2, wireType 2 =*/18).string(message.directPath);
            if (message.result != null && Object.hasOwnProperty.call(message, "result"))
                writer.uint32(/* id 3, wireType 0 =*/24).int32(message.result);
            return writer;
        };

        /**
         * Encodes the specified MediaRetryNotification message, length delimited. Does not implicitly {@link proto.MediaRetryNotification.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.IMediaRetryNotification} message MediaRetryNotification message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        MediaRetryNotification.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer.
         * @function decode
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaRetryNotification.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.MediaRetryNotification();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.stanzaId = reader.string();
                    break;
                case 2:
                    message.directPath = reader.string();
                    break;
                case 3:
                    message.result = reader.int32();
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a MediaRetryNotification message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        MediaRetryNotification.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a MediaRetryNotification message.
         * @function verify
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        MediaRetryNotification.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                if (!$util.isString(message.stanzaId))
                    return "stanzaId: string expected";
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                if (!$util.isString(message.directPath))
                    return "directPath: string expected";
            if (message.result != null && message.hasOwnProperty("result"))
                switch (message.result) {
                default:
                    return "result: enum value expected";
                case 0:
                case 1:
                case 2:
                case 3:
                    break;
                }
            return null;
        };

        /**
         * Creates a MediaRetryNotification message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.MediaRetryNotification} MediaRetryNotification
         */
        MediaRetryNotification.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.MediaRetryNotification)
                return object;
            var message = new $root.proto.MediaRetryNotification();
            if (object.stanzaId != null)
                message.stanzaId = String(object.stanzaId);
            if (object.directPath != null)
                message.directPath = String(object.directPath);
            switch (object.result) {
            case "GENERAL_ERROR":
            case 0:
                message.result = 0;
                break;
            case "SUCCESS":
            case 1:
                message.result = 1;
                break;
            case "NOT_FOUND":
            case 2:
                message.result = 2;
                break;
            case "DECRYPTION_ERROR":
            case 3:
                message.result = 3;
                break;
            }
            return message;
        };

        /**
         * Creates a plain object from a MediaRetryNotification message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.MediaRetryNotification
         * @static
         * @param {proto.MediaRetryNotification} message MediaRetryNotification
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        MediaRetryNotification.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.stanzaId = "";
                object.directPath = "";
                object.result = options.enums === String ? "GENERAL_ERROR" : 0;
            }
            if (message.stanzaId != null && message.hasOwnProperty("stanzaId"))
                object.stanzaId = message.stanzaId;
            if (message.directPath != null && message.hasOwnProperty("directPath"))
                object.directPath = message.directPath;
            if (message.result != null && message.hasOwnProperty("result"))
                object.result = options.enums === String ? $root.proto.MediaRetryNotification.ResultType[message.result] : message.result;
            return object;
        };

        /**
         * Converts this MediaRetryNotification to JSON.
         * @function toJSON
         * @memberof proto.MediaRetryNotification
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        MediaRetryNotification.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        /**
         * ResultType enum.
         * @name proto.MediaRetryNotification.ResultType
         * @enum {number}
         * @property {number} GENERAL_ERROR=0 GENERAL_ERROR value
         * @property {number} SUCCESS=1 SUCCESS value
         * @property {number} NOT_FOUND=2 NOT_FOUND value
         * @property {number} DECRYPTION_ERROR=3 DECRYPTION_ERROR value
         */
        MediaRetryNotification.ResultType = (function() {
            var valuesById = {}, values = Object.create(valuesById);
            values[valuesById[0] = "GENERAL_ERROR"] = 0;
            values[valuesById[1] = "SUCCESS"] = 1;
            values[valuesById[2] = "NOT_FOUND"] = 2;
            values[valuesById[3] = "DECRYPTION_ERROR"] = 3;
            return values;
        })();

        return MediaRetryNotification;
    })();

    /**
     * MediaVisibility enum.
     * @name proto.MediaVisibility
     * @enum {number}
     * @property {number} DEFAULT=0 DEFAULT value
     * @property {number} OFF=1 OFF value
     * @property {number} ON=2 ON value
     */
    proto.MediaVisibility = (function() {
        var valuesById = {}, values = Object.create(valuesById);
        values[valuesById[0] = "DEFAULT"] = 0;
        values[valuesById[1] = "OFF"] = 1;
        values[valuesById[2] = "ON"] = 2;
        return values;
    })();

    proto.Message = (function() {

        /**
         * Properties of a Message.
         * @memberof proto
         * @interface IMessage
         * @property {string|null} [conversation] Message conversation
         * @property {proto.Message.ISenderKeyDistributionMessage|null} [senderKeyDistributionMessage] Message senderKeyDistributionMessage
         * @property {proto.Message.IImageMessage|null} [imageMessage] Message imageMessage
         * @property {proto.Message.IContactMessage|null} [contactMessage] Message contactMessage
         * @property {proto.Message.ILocationMessage|null} [locationMessage] Message locationMessage
         * @property {proto.Message.IExtendedTextMessage|null} [extendedTextMessage] Message extendedTextMessage
         * @property {proto.Message.IDocumentMessage|null} [documentMessage] Message documentMessage
         * @property {proto.Message.IAudioMessage|null} [audioMessage] Message audioMessage
         * @property {proto.Message.IVideoMessage|null} [videoMessage] Message videoMessage
         * @property {proto.Message.ICall|null} [call] Message call
         * @property {proto.Message.IChat|null} [chat] Message chat
         * @property {proto.Message.IProtocolMessage|null} [protocolMessage] Message protocolMessage
         * @property {proto.Message.IContactsArrayMessage|null} [contactsArrayMessage] Message contactsArrayMessage
         * @property {proto.Message.IHighlyStructuredMessage|null} [highlyStructuredMessage] Message highlyStructuredMessage
         * @property {proto.Message.ISenderKeyDistributionMessage|null} [fastRatchetKeySenderKeyDistributionMessage] Message fastRatchetKeySenderKeyDistributionMessage
         * @property {proto.Message.ISendPaymentMessage|null} [sendPaymentMessage] Message sendPaymentMessage
         * @property {proto.Message.ILiveLocationMessage|null} [liveLocationMessage] Message liveLocationMessage
         * @property {proto.Message.IRequestPaymentMessage|null} [requestPaymentMessage] Message requestPaymentMessage
         * @property {proto.Message.IDeclinePaymentRequestMessage|null} [declinePaymentRequestMessage] Message declinePaymentRequestMessage
         * @property {proto.Message.ICancelPaymentRequestMessage|null} [cancelPaymentRequestMessage] Message cancelPaymentRequestMessage
         * @property {proto.Message.ITemplateMessage|null} [templateMessage] Message templateMessage
         * @property {proto.Message.IStickerMessage|null} [stickerMessage] Message stickerMessage
         * @property {proto.Message.IGroupInviteMessage|null} [groupInviteMessage] Message groupInviteMessage
         * @property {proto.Message.ITemplateButtonReplyMessage|null} [templateButtonReplyMessage] Message templateButtonReplyMessage
         * @property {proto.Message.IProductMessage|null} [productMessage] Message productMessage
         * @property {proto.Message.IDeviceSentMessage|null} [deviceSentMessage] Message deviceSentMessage
         * @property {proto.IMessageContextInfo|null} [messageContextInfo] Message messageContextInfo
         * @property {proto.Message.IListMessage|null} [listMessage] Message listMessage
         * @property {proto.Message.IFutureProofMessage|null} [viewOnceMessage] Message viewOnceMessage
         * @property {proto.Message.IOrderMessage|null} [orderMessage] Message orderMessage
         * @property {proto.Message.IListResponseMessage|null} [listResponseMessage] Message listResponseMessage
         * @property {proto.Message.IFutureProofMessage|null} [ephemeralMessage] Message ephemeralMessage
         * @property {proto.Message.IInvoiceMessage|null} [invoiceMessage] Message invoiceMessage
         * @property {proto.Message.IButtonsMessage|null} [buttonsMessage] Message buttonsMessage
         * @property {proto.Message.IButtonsResponseMessage|null} [buttonsResponseMessage] Message buttonsResponseMessage
         * @property {proto.Message.IPaymentInviteMessage|null} [paymentInviteMessage] Message paymentInviteMessage
         * @property {proto.Message.IInteractiveMessage|null} [interactiveMessage] Message interactiveMessage
         * @property {proto.Message.IReactionMessage|null} [reactionMessage] Message reactionMessage
         * @property {proto.Message.IStickerSyncRMRMessage|null} [stickerSyncRmrMessage] Message stickerSyncRmrMessage
         * @property {proto.Message.IInteractiveResponseMessage|null} [interactiveResponseMessage] Message interactiveResponseMessage
         * @property {proto.Message.IPollCreationMessage|null} [pollCreationMessage] Message pollCreationMessage
         * @property {proto.Message.IPollUpdateMessage|null} [pollUpdateMessage] Message pollUpdateMessage
         * @property {proto.Message.IKeepInChatMessage|null} [keepInChatMessage] Message keepInChatMessage
         * @property {proto.Message.IFutureProofMessage|null} [documentWithCaptionMessage] Message documentWithCaptionMessage
         * @property {proto.Message.IRequestPhoneNumberMessage|null} [requestPhoneNumberMessage] Message requestPhoneNumberMessage
         * @property {proto.Message.IFutureProofMessage|null} [viewOnceMessageV2] Message viewOnceMessageV2
         * @property {proto.Message.IEncReactionMessage|null} [encReactionMessage] Message encReactionMessage
         * @property {proto.Message.IFutureProofMessage|null} [editedMessage] Message editedMessage
         * @property {proto.Message.IFutureProofMessage|null} [viewOnceMessageV2Extension] Message viewOnceMessageV2Extension
         */

        /**
         * Constructs a new Message.
         * @memberof proto
         * @classdesc Represents a Message.
         * @implements IMessage
         * @constructor
         * @param {proto.IMessage=} [properties] Properties to set
         */
        function Message(properties) {
            if (properties)
                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                    if (properties[keys[i]] != null)
                        this[keys[i]] = properties[keys[i]];
        }

        /**
         * Message conversation.
         * @member {string} conversation
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.conversation = "";

        /**
         * Message senderKeyDistributionMessage.
         * @member {proto.Message.ISenderKeyDistributionMessage|null|undefined} senderKeyDistributionMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.senderKeyDistributionMessage = null;

        /**
         * Message imageMessage.
         * @member {proto.Message.IImageMessage|null|undefined} imageMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.imageMessage = null;

        /**
         * Message contactMessage.
         * @member {proto.Message.IContactMessage|null|undefined} contactMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.contactMessage = null;

        /**
         * Message locationMessage.
         * @member {proto.Message.ILocationMessage|null|undefined} locationMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.locationMessage = null;

        /**
         * Message extendedTextMessage.
         * @member {proto.Message.IExtendedTextMessage|null|undefined} extendedTextMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.extendedTextMessage = null;

        /**
         * Message documentMessage.
         * @member {proto.Message.IDocumentMessage|null|undefined} documentMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.documentMessage = null;

        /**
         * Message audioMessage.
         * @member {proto.Message.IAudioMessage|null|undefined} audioMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.audioMessage = null;

        /**
         * Message videoMessage.
         * @member {proto.Message.IVideoMessage|null|undefined} videoMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.videoMessage = null;

        /**
         * Message call.
         * @member {proto.Message.ICall|null|undefined} call
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.call = null;

        /**
         * Message chat.
         * @member {proto.Message.IChat|null|undefined} chat
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.chat = null;

        /**
         * Message protocolMessage.
         * @member {proto.Message.IProtocolMessage|null|undefined} protocolMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.protocolMessage = null;

        /**
         * Message contactsArrayMessage.
         * @member {proto.Message.IContactsArrayMessage|null|undefined} contactsArrayMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.contactsArrayMessage = null;

        /**
         * Message highlyStructuredMessage.
         * @member {proto.Message.IHighlyStructuredMessage|null|undefined} highlyStructuredMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.highlyStructuredMessage = null;

        /**
         * Message fastRatchetKeySenderKeyDistributionMessage.
         * @member {proto.Message.ISenderKeyDistributionMessage|null|undefined} fastRatchetKeySenderKeyDistributionMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.fastRatchetKeySenderKeyDistributionMessage = null;

        /**
         * Message sendPaymentMessage.
         * @member {proto.Message.ISendPaymentMessage|null|undefined} sendPaymentMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.sendPaymentMessage = null;

        /**
         * Message liveLocationMessage.
         * @member {proto.Message.ILiveLocationMessage|null|undefined} liveLocationMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.liveLocationMessage = null;

        /**
         * Message requestPaymentMessage.
         * @member {proto.Message.IRequestPaymentMessage|null|undefined} requestPaymentMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.requestPaymentMessage = null;

        /**
         * Message declinePaymentRequestMessage.
         * @member {proto.Message.IDeclinePaymentRequestMessage|null|undefined} declinePaymentRequestMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.declinePaymentRequestMessage = null;

        /**
         * Message cancelPaymentRequestMessage.
         * @member {proto.Message.ICancelPaymentRequestMessage|null|undefined} cancelPaymentRequestMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.cancelPaymentRequestMessage = null;

        /**
         * Message templateMessage.
         * @member {proto.Message.ITemplateMessage|null|undefined} templateMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.templateMessage = null;

        /**
         * Message stickerMessage.
         * @member {proto.Message.IStickerMessage|null|undefined} stickerMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.stickerMessage = null;

        /**
         * Message groupInviteMessage.
         * @member {proto.Message.IGroupInviteMessage|null|undefined} groupInviteMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.groupInviteMessage = null;

        /**
         * Message templateButtonReplyMessage.
         * @member {proto.Message.ITemplateButtonReplyMessage|null|undefined} templateButtonReplyMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.templateButtonReplyMessage = null;

        /**
         * Message productMessage.
         * @member {proto.Message.IProductMessage|null|undefined} productMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.productMessage = null;

        /**
         * Message deviceSentMessage.
         * @member {proto.Message.IDeviceSentMessage|null|undefined} deviceSentMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.deviceSentMessage = null;

        /**
         * Message messageContextInfo.
         * @member {proto.IMessageContextInfo|null|undefined} messageContextInfo
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.messageContextInfo = null;

        /**
         * Message listMessage.
         * @member {proto.Message.IListMessage|null|undefined} listMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.listMessage = null;

        /**
         * Message viewOnceMessage.
         * @member {proto.Message.IFutureProofMessage|null|undefined} viewOnceMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.viewOnceMessage = null;

        /**
         * Message orderMessage.
         * @member {proto.Message.IOrderMessage|null|undefined} orderMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.orderMessage = null;

        /**
         * Message listResponseMessage.
         * @member {proto.Message.IListResponseMessage|null|undefined} listResponseMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.listResponseMessage = null;

        /**
         * Message ephemeralMessage.
         * @member {proto.Message.IFutureProofMessage|null|undefined} ephemeralMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.ephemeralMessage = null;

        /**
         * Message invoiceMessage.
         * @member {proto.Message.IInvoiceMessage|null|undefined} invoiceMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.invoiceMessage = null;

        /**
         * Message buttonsMessage.
         * @member {proto.Message.IButtonsMessage|null|undefined} buttonsMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.buttonsMessage = null;

        /**
         * Message buttonsResponseMessage.
         * @member {proto.Message.IButtonsResponseMessage|null|undefined} buttonsResponseMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.buttonsResponseMessage = null;

        /**
         * Message paymentInviteMessage.
         * @member {proto.Message.IPaymentInviteMessage|null|undefined} paymentInviteMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.paymentInviteMessage = null;

        /**
         * Message interactiveMessage.
         * @member {proto.Message.IInteractiveMessage|null|undefined} interactiveMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.interactiveMessage = null;

        /**
         * Message reactionMessage.
         * @member {proto.Message.IReactionMessage|null|undefined} reactionMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.reactionMessage = null;

        /**
         * Message stickerSyncRmrMessage.
         * @member {proto.Message.IStickerSyncRMRMessage|null|undefined} stickerSyncRmrMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.stickerSyncRmrMessage = null;

        /**
         * Message interactiveResponseMessage.
         * @member {proto.Message.IInteractiveResponseMessage|null|undefined} interactiveResponseMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.interactiveResponseMessage = null;

        /**
         * Message pollCreationMessage.
         * @member {proto.Message.IPollCreationMessage|null|undefined} pollCreationMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.pollCreationMessage = null;

        /**
         * Message pollUpdateMessage.
         * @member {proto.Message.IPollUpdateMessage|null|undefined} pollUpdateMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.pollUpdateMessage = null;

        /**
         * Message keepInChatMessage.
         * @member {proto.Message.IKeepInChatMessage|null|undefined} keepInChatMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.keepInChatMessage = null;

        /**
         * Message documentWithCaptionMessage.
         * @member {proto.Message.IFutureProofMessage|null|undefined} documentWithCaptionMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.documentWithCaptionMessage = null;

        /**
         * Message requestPhoneNumberMessage.
         * @member {proto.Message.IRequestPhoneNumberMessage|null|undefined} requestPhoneNumberMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.requestPhoneNumberMessage = null;

        /**
         * Message viewOnceMessageV2.
         * @member {proto.Message.IFutureProofMessage|null|undefined} viewOnceMessageV2
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.viewOnceMessageV2 = null;

        /**
         * Message encReactionMessage.
         * @member {proto.Message.IEncReactionMessage|null|undefined} encReactionMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.encReactionMessage = null;

        /**
         * Message editedMessage.
         * @member {proto.Message.IFutureProofMessage|null|undefined} editedMessage
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.editedMessage = null;

        /**
         * Message viewOnceMessageV2Extension.
         * @member {proto.Message.IFutureProofMessage|null|undefined} viewOnceMessageV2Extension
         * @memberof proto.Message
         * @instance
         */
        Message.prototype.viewOnceMessageV2Extension = null;

        /**
         * Creates a new Message instance using the specified properties.
         * @function create
         * @memberof proto.Message
         * @static
         * @param {proto.IMessage=} [properties] Properties to set
         * @returns {proto.Message} Message instance
         */
        Message.create = function create(properties) {
            return new Message(properties);
        };

        /**
         * Encodes the specified Message message. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @function encode
         * @memberof proto.Message
         * @static
         * @param {proto.IMessage} message Message message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Message.encode = function encode(message, writer) {
            if (!writer)
                writer = $Writer.create();
            if (message.conversation != null && Object.hasOwnProperty.call(message, "conversation"))
                writer.uint32(/* id 1, wireType 2 =*/10).string(message.conversation);
            if (message.senderKeyDistributionMessage != null && Object.hasOwnProperty.call(message, "senderKeyDistributionMessage"))
                $root.proto.Message.SenderKeyDistributionMessage.encode(message.senderKeyDistributionMessage, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
            if (message.imageMessage != null && Object.hasOwnProperty.call(message, "imageMessage"))
                $root.proto.Message.ImageMessage.encode(message.imageMessage, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
            if (message.contactMessage != null && Object.hasOwnProperty.call(message, "contactMessage"))
                $root.proto.Message.ContactMessage.encode(message.contactMessage, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
            if (message.locationMessage != null && Object.hasOwnProperty.call(message, "locationMessage"))
                $root.proto.Message.LocationMessage.encode(message.locationMessage, writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
            if (message.extendedTextMessage != null && Object.hasOwnProperty.call(message, "extendedTextMessage"))
                $root.proto.Message.ExtendedTextMessage.encode(message.extendedTextMessage, writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
            if (message.documentMessage != null && Object.hasOwnProperty.call(message, "documentMessage"))
                $root.proto.Message.DocumentMessage.encode(message.documentMessage, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
            if (message.audioMessage != null && Object.hasOwnProperty.call(message, "audioMessage"))
                $root.proto.Message.AudioMessage.encode(message.audioMessage, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
            if (message.videoMessage != null && Object.hasOwnProperty.call(message, "videoMessage"))
                $root.proto.Message.VideoMessage.encode(message.videoMessage, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
            if (message.call != null && Object.hasOwnProperty.call(message, "call"))
                $root.proto.Message.Call.encode(message.call, writer.uint32(/* id 10, wireType 2 =*/82).fork()).ldelim();
            if (message.chat != null && Object.hasOwnProperty.call(message, "chat"))
                $root.proto.Message.Chat.encode(message.chat, writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
            if (message.protocolMessage != null && Object.hasOwnProperty.call(message, "protocolMessage"))
                $root.proto.Message.ProtocolMessage.encode(message.protocolMessage, writer.uint32(/* id 12, wireType 2 =*/98).fork()).ldelim();
            if (message.contactsArrayMessage != null && Object.hasOwnProperty.call(message, "contactsArrayMessage"))
                $root.proto.Message.ContactsArrayMessage.encode(message.contactsArrayMessage, writer.uint32(/* id 13, wireType 2 =*/106).fork()).ldelim();
            if (message.highlyStructuredMessage != null && Object.hasOwnProperty.call(message, "highlyStructuredMessage"))
                $root.proto.Message.HighlyStructuredMessage.encode(message.highlyStructuredMessage, writer.uint32(/* id 14, wireType 2 =*/114).fork()).ldelim();
            if (message.fastRatchetKeySenderKeyDistributionMessage != null && Object.hasOwnProperty.call(message, "fastRatchetKeySenderKeyDistributionMessage"))
                $root.proto.Message.SenderKeyDistributionMessage.encode(message.fastRatchetKeySenderKeyDistributionMessage, writer.uint32(/* id 15, wireType 2 =*/122).fork()).ldelim();
            if (message.sendPaymentMessage != null && Object.hasOwnProperty.call(message, "sendPaymentMessage"))
                $root.proto.Message.SendPaymentMessage.encode(message.sendPaymentMessage, writer.uint32(/* id 16, wireType 2 =*/130).fork()).ldelim();
            if (message.liveLocationMessage != null && Object.hasOwnProperty.call(message, "liveLocationMessage"))
                $root.proto.Message.LiveLocationMessage.encode(message.liveLocationMessage, writer.uint32(/* id 18, wireType 2 =*/146).fork()).ldelim();
            if (message.requestPaymentMessage != null && Object.hasOwnProperty.call(message, "requestPaymentMessage"))
                $root.proto.Message.RequestPaymentMessage.encode(message.requestPaymentMessage, writer.uint32(/* id 22, wireType 2 =*/178).fork()).ldelim();
            if (message.declinePaymentRequestMessage != null && Object.hasOwnProperty.call(message, "declinePaymentRequestMessage"))
                $root.proto.Message.DeclinePaymentRequestMessage.encode(message.declinePaymentRequestMessage, writer.uint32(/* id 23, wireType 2 =*/186).fork()).ldelim();
            if (message.cancelPaymentRequestMessage != null && Object.hasOwnProperty.call(message, "cancelPaymentRequestMessage"))
                $root.proto.Message.CancelPaymentRequestMessage.encode(message.cancelPaymentRequestMessage, writer.uint32(/* id 24, wireType 2 =*/194).fork()).ldelim();
            if (message.templateMessage != null && Object.hasOwnProperty.call(message, "templateMessage"))
                $root.proto.Message.TemplateMessage.encode(message.templateMessage, writer.uint32(/* id 25, wireType 2 =*/202).fork()).ldelim();
            if (message.stickerMessage != null && Object.hasOwnProperty.call(message, "stickerMessage"))
                $root.proto.Message.StickerMessage.encode(message.stickerMessage, writer.uint32(/* id 26, wireType 2 =*/210).fork()).ldelim();
            if (message.groupInviteMessage != null && Object.hasOwnProperty.call(message, "groupInviteMessage"))
                $root.proto.Message.GroupInviteMessage.encode(message.groupInviteMessage, writer.uint32(/* id 28, wireType 2 =*/226).fork()).ldelim();
            if (message.templateButtonReplyMessage != null && Object.hasOwnProperty.call(message, "templateButtonReplyMessage"))
                $root.proto.Message.TemplateButtonReplyMessage.encode(message.templateButtonReplyMessage, writer.uint32(/* id 29, wireType 2 =*/234).fork()).ldelim();
            if (message.productMessage != null && Object.hasOwnProperty.call(message, "productMessage"))
                $root.proto.Message.ProductMessage.encode(message.productMessage, writer.uint32(/* id 30, wireType 2 =*/242).fork()).ldelim();
            if (message.deviceSentMessage != null && Object.hasOwnProperty.call(message, "deviceSentMessage"))
                $root.proto.Message.DeviceSentMessage.encode(message.deviceSentMessage, writer.uint32(/* id 31, wireType 2 =*/250).fork()).ldelim();
            if (message.messageContextInfo != null && Object.hasOwnProperty.call(message, "messageContextInfo"))
                $root.proto.MessageContextInfo.encode(message.messageContextInfo, writer.uint32(/* id 35, wireType 2 =*/282).fork()).ldelim();
            if (message.listMessage != null && Object.hasOwnProperty.call(message, "listMessage"))
                $root.proto.Message.ListMessage.encode(message.listMessage, writer.uint32(/* id 36, wireType 2 =*/290).fork()).ldelim();
            if (message.viewOnceMessage != null && Object.hasOwnProperty.call(message, "viewOnceMessage"))
                $root.proto.Message.FutureProofMessage.encode(message.viewOnceMessage, writer.uint32(/* id 37, wireType 2 =*/298).fork()).ldelim();
            if (message.orderMessage != null && Object.hasOwnProperty.call(message, "orderMessage"))
                $root.proto.Message.OrderMessage.encode(message.orderMessage, writer.uint32(/* id 38, wireType 2 =*/306).fork()).ldelim();
            if (message.listResponseMessage != null && Object.hasOwnProperty.call(message, "listResponseMessage"))
                $root.proto.Message.ListResponseMessage.encode(message.listResponseMessage, writer.uint32(/* id 39, wireType 2 =*/314).fork()).ldelim();
            if (message.ephemeralMessage != null && Object.hasOwnProperty.call(message, "ephemeralMessage"))
                $root.proto.Message.FutureProofMessage.encode(message.ephemeralMessage, writer.uint32(/* id 40, wireType 2 =*/322).fork()).ldelim();
            if (message.invoiceMessage != null && Object.hasOwnProperty.call(message, "invoiceMessage"))
                $root.proto.Message.InvoiceMessage.encode(message.invoiceMessage, writer.uint32(/* id 41, wireType 2 =*/330).fork()).ldelim();
            if (message.buttonsMessage != null && Object.hasOwnProperty.call(message, "buttonsMessage"))
                $root.proto.Message.ButtonsMessage.encode(message.buttonsMessage, writer.uint32(/* id 42, wireType 2 =*/338).fork()).ldelim();
            if (message.buttonsResponseMessage != null && Object.hasOwnProperty.call(message, "buttonsResponseMessage"))
                $root.proto.Message.ButtonsResponseMessage.encode(message.buttonsResponseMessage, writer.uint32(/* id 43, wireType 2 =*/346).fork()).ldelim();
            if (message.paymentInviteMessage != null && Object.hasOwnProperty.call(message, "paymentInviteMessage"))
                $root.proto.Message.PaymentInviteMessage.encode(message.paymentInviteMessage, writer.uint32(/* id 44, wireType 2 =*/354).fork()).ldelim();
            if (message.interactiveMessage != null && Object.hasOwnProperty.call(message, "interactiveMessage"))
                $root.proto.Message.InteractiveMessage.encode(message.interactiveMessage, writer.uint32(/* id 45, wireType 2 =*/362).fork()).ldelim();
            if (message.reactionMessage != null && Object.hasOwnProperty.call(message, "reactionMessage"))
                $root.proto.Message.ReactionMessage.encode(message.reactionMessage, writer.uint32(/* id 46, wireType 2 =*/370).fork()).ldelim();
            if (message.stickerSyncRmrMessage != null && Object.hasOwnProperty.call(message, "stickerSyncRmrMessage"))
                $root.proto.Message.StickerSyncRMRMessage.encode(message.stickerSyncRmrMessage, writer.uint32(/* id 47, wireType 2 =*/378).fork()).ldelim();
            if (message.interactiveResponseMessage != null && Object.hasOwnProperty.call(message, "interactiveResponseMessage"))
                $root.proto.Message.InteractiveResponseMessage.encode(message.interactiveResponseMessage, writer.uint32(/* id 48, wireType 2 =*/386).fork()).ldelim();
            if (message.pollCreationMessage != null && Object.hasOwnProperty.call(message, "pollCreationMessage"))
                $root.proto.Message.PollCreationMessage.encode(message.pollCreationMessage, writer.uint32(/* id 49, wireType 2 =*/394).fork()).ldelim();
            if (message.pollUpdateMessage != null && Object.hasOwnProperty.call(message, "pollUpdateMessage"))
                $root.proto.Message.PollUpdateMessage.encode(message.pollUpdateMessage, writer.uint32(/* id 50, wireType 2 =*/402).fork()).ldelim();
            if (message.keepInChatMessage != null && Object.hasOwnProperty.call(message, "keepInChatMessage"))
                $root.proto.Message.KeepInChatMessage.encode(message.keepInChatMessage, writer.uint32(/* id 51, wireType 2 =*/410).fork()).ldelim();
            if (message.documentWithCaptionMessage != null && Object.hasOwnProperty.call(message, "documentWithCaptionMessage"))
                $root.proto.Message.FutureProofMessage.encode(message.documentWithCaptionMessage, writer.uint32(/* id 53, wireType 2 =*/426).fork()).ldelim();
            if (message.requestPhoneNumberMessage != null && Object.hasOwnProperty.call(message, "requestPhoneNumberMessage"))
                $root.proto.Message.RequestPhoneNumberMessage.encode(message.requestPhoneNumberMessage, writer.uint32(/* id 54, wireType 2 =*/434).fork()).ldelim();
            if (message.viewOnceMessageV2 != null && Object.hasOwnProperty.call(message, "viewOnceMessageV2"))
                $root.proto.Message.FutureProofMessage.encode(message.viewOnceMessageV2, writer.uint32(/* id 55, wireType 2 =*/442).fork()).ldelim();
            if (message.encReactionMessage != null && Object.hasOwnProperty.call(message, "encReactionMessage"))
                $root.proto.Message.EncReactionMessage.encode(message.encReactionMessage, writer.uint32(/* id 56, wireType 2 =*/450).fork()).ldelim();
            if (message.editedMessage != null && Object.hasOwnProperty.call(message, "editedMessage"))
                $root.proto.Message.FutureProofMessage.encode(message.editedMessage, writer.uint32(/* id 58, wireType 2 =*/466).fork()).ldelim();
            if (message.viewOnceMessageV2Extension != null && Object.hasOwnProperty.call(message, "viewOnceMessageV2Extension"))
                $root.proto.Message.FutureProofMessage.encode(message.viewOnceMessageV2Extension, writer.uint32(/* id 59, wireType 2 =*/474).fork()).ldelim();
            return writer;
        };

        /**
         * Encodes the specified Message message, length delimited. Does not implicitly {@link proto.Message.verify|verify} messages.
         * @function encodeDelimited
         * @memberof proto.Message
         * @static
         * @param {proto.IMessage} message Message message or plain object to encode
         * @param {$protobuf.Writer} [writer] Writer to encode to
         * @returns {$protobuf.Writer} Writer
         */
        Message.encodeDelimited = function encodeDelimited(message, writer) {
            return this.encode(message, writer).ldelim();
        };

        /**
         * Decodes a Message message from the specified reader or buffer.
         * @function decode
         * @memberof proto.Message
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @param {number} [length] Message length if known beforehand
         * @returns {proto.Message} Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Message.decode = function decode(reader, length) {
            if (!(reader instanceof $Reader))
                reader = $Reader.create(reader);
            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Message();
            while (reader.pos < end) {
                var tag = reader.uint32();
                switch (tag >>> 3) {
                case 1:
                    message.conversation = reader.string();
                    break;
                case 2:
                    message.senderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.decode(reader, reader.uint32());
                    break;
                case 3:
                    message.imageMessage = $root.proto.Message.ImageMessage.decode(reader, reader.uint32());
                    break;
                case 4:
                    message.contactMessage = $root.proto.Message.ContactMessage.decode(reader, reader.uint32());
                    break;
                case 5:
                    message.locationMessage = $root.proto.Message.LocationMessage.decode(reader, reader.uint32());
                    break;
                case 6:
                    message.extendedTextMessage = $root.proto.Message.ExtendedTextMessage.decode(reader, reader.uint32());
                    break;
                case 7:
                    message.documentMessage = $root.proto.Message.DocumentMessage.decode(reader, reader.uint32());
                    break;
                case 8:
                    message.audioMessage = $root.proto.Message.AudioMessage.decode(reader, reader.uint32());
                    break;
                case 9:
                    message.videoMessage = $root.proto.Message.VideoMessage.decode(reader, reader.uint32());
                    break;
                case 10:
                    message.call = $root.proto.Message.Call.decode(reader, reader.uint32());
                    break;
                case 11:
                    message.chat = $root.proto.Message.Chat.decode(reader, reader.uint32());
                    break;
                case 12:
                    message.protocolMessage = $root.proto.Message.ProtocolMessage.decode(reader, reader.uint32());
                    break;
                case 13:
                    message.contactsArrayMessage = $root.proto.Message.ContactsArrayMessage.decode(reader, reader.uint32());
                    break;
                case 14:
                    message.highlyStructuredMessage = $root.proto.Message.HighlyStructuredMessage.decode(reader, reader.uint32());
                    break;
                case 15:
                    message.fastRatchetKeySenderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.decode(reader, reader.uint32());
                    break;
                case 16:
                    message.sendPaymentMessage = $root.proto.Message.SendPaymentMessage.decode(reader, reader.uint32());
                    break;
                case 18:
                    message.liveLocationMessage = $root.proto.Message.LiveLocationMessage.decode(reader, reader.uint32());
                    break;
                case 22:
                    message.requestPaymentMessage = $root.proto.Message.RequestPaymentMessage.decode(reader, reader.uint32());
                    break;
                case 23:
                    message.declinePaymentRequestMessage = $root.proto.Message.DeclinePaymentRequestMessage.decode(reader, reader.uint32());
                    break;
                case 24:
                    message.cancelPaymentRequestMessage = $root.proto.Message.CancelPaymentRequestMessage.decode(reader, reader.uint32());
                    break;
                case 25:
                    message.templateMessage = $root.proto.Message.TemplateMessage.decode(reader, reader.uint32());
                    break;
                case 26:
                    message.stickerMessage = $root.proto.Message.StickerMessage.decode(reader, reader.uint32());
                    break;
                case 28:
                    message.groupInviteMessage = $root.proto.Message.GroupInviteMessage.decode(reader, reader.uint32());
                    break;
                case 29:
                    message.templateButtonReplyMessage = $root.proto.Message.TemplateButtonReplyMessage.decode(reader, reader.uint32());
                    break;
                case 30:
                    message.productMessage = $root.proto.Message.ProductMessage.decode(reader, reader.uint32());
                    break;
                case 31:
                    message.deviceSentMessage = $root.proto.Message.DeviceSentMessage.decode(reader, reader.uint32());
                    break;
                case 35:
                    message.messageContextInfo = $root.proto.MessageContextInfo.decode(reader, reader.uint32());
                    break;
                case 36:
                    message.listMessage = $root.proto.Message.ListMessage.decode(reader, reader.uint32());
                    break;
                case 37:
                    message.viewOnceMessage = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                case 38:
                    message.orderMessage = $root.proto.Message.OrderMessage.decode(reader, reader.uint32());
                    break;
                case 39:
                    message.listResponseMessage = $root.proto.Message.ListResponseMessage.decode(reader, reader.uint32());
                    break;
                case 40:
                    message.ephemeralMessage = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                case 41:
                    message.invoiceMessage = $root.proto.Message.InvoiceMessage.decode(reader, reader.uint32());
                    break;
                case 42:
                    message.buttonsMessage = $root.proto.Message.ButtonsMessage.decode(reader, reader.uint32());
                    break;
                case 43:
                    message.buttonsResponseMessage = $root.proto.Message.ButtonsResponseMessage.decode(reader, reader.uint32());
                    break;
                case 44:
                    message.paymentInviteMessage = $root.proto.Message.PaymentInviteMessage.decode(reader, reader.uint32());
                    break;
                case 45:
                    message.interactiveMessage = $root.proto.Message.InteractiveMessage.decode(reader, reader.uint32());
                    break;
                case 46:
                    message.reactionMessage = $root.proto.Message.ReactionMessage.decode(reader, reader.uint32());
                    break;
                case 47:
                    message.stickerSyncRmrMessage = $root.proto.Message.StickerSyncRMRMessage.decode(reader, reader.uint32());
                    break;
                case 48:
                    message.interactiveResponseMessage = $root.proto.Message.InteractiveResponseMessage.decode(reader, reader.uint32());
                    break;
                case 49:
                    message.pollCreationMessage = $root.proto.Message.PollCreationMessage.decode(reader, reader.uint32());
                    break;
                case 50:
                    message.pollUpdateMessage = $root.proto.Message.PollUpdateMessage.decode(reader, reader.uint32());
                    break;
                case 51:
                    message.keepInChatMessage = $root.proto.Message.KeepInChatMessage.decode(reader, reader.uint32());
                    break;
                case 53:
                    message.documentWithCaptionMessage = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                case 54:
                    message.requestPhoneNumberMessage = $root.proto.Message.RequestPhoneNumberMessage.decode(reader, reader.uint32());
                    break;
                case 55:
                    message.viewOnceMessageV2 = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                case 56:
                    message.encReactionMessage = $root.proto.Message.EncReactionMessage.decode(reader, reader.uint32());
                    break;
                case 58:
                    message.editedMessage = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                case 59:
                    message.viewOnceMessageV2Extension = $root.proto.Message.FutureProofMessage.decode(reader, reader.uint32());
                    break;
                default:
                    reader.skipType(tag & 7);
                    break;
                }
            }
            return message;
        };

        /**
         * Decodes a Message message from the specified reader or buffer, length delimited.
         * @function decodeDelimited
         * @memberof proto.Message
         * @static
         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
         * @returns {proto.Message} Message
         * @throws {Error} If the payload is not a reader or valid buffer
         * @throws {$protobuf.util.ProtocolError} If required fields are missing
         */
        Message.decodeDelimited = function decodeDelimited(reader) {
            if (!(reader instanceof $Reader))
                reader = new $Reader(reader);
            return this.decode(reader, reader.uint32());
        };

        /**
         * Verifies a Message message.
         * @function verify
         * @memberof proto.Message
         * @static
         * @param {Object.<string,*>} message Plain object to verify
         * @returns {string|null} `null` if valid, otherwise the reason why it is not
         */
        Message.verify = function verify(message) {
            if (typeof message !== "object" || message === null)
                return "object expected";
            if (message.conversation != null && message.hasOwnProperty("conversation"))
                if (!$util.isString(message.conversation))
                    return "conversation: string expected";
            if (message.senderKeyDistributionMessage != null && message.hasOwnProperty("senderKeyDistributionMessage")) {
                var error = $root.proto.Message.SenderKeyDistributionMessage.verify(message.senderKeyDistributionMessage);
                if (error)
                    return "senderKeyDistributionMessage." + error;
            }
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage")) {
                var error = $root.proto.Message.ImageMessage.verify(message.imageMessage);
                if (error)
                    return "imageMessage." + error;
            }
            if (message.contactMessage != null && message.hasOwnProperty("contactMessage")) {
                var error = $root.proto.Message.ContactMessage.verify(message.contactMessage);
                if (error)
                    return "contactMessage." + error;
            }
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage")) {
                var error = $root.proto.Message.LocationMessage.verify(message.locationMessage);
                if (error)
                    return "locationMessage." + error;
            }
            if (message.extendedTextMessage != null && message.hasOwnProperty("extendedTextMessage")) {
                var error = $root.proto.Message.ExtendedTextMessage.verify(message.extendedTextMessage);
                if (error)
                    return "extendedTextMessage." + error;
            }
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage")) {
                var error = $root.proto.Message.DocumentMessage.verify(message.documentMessage);
                if (error)
                    return "documentMessage." + error;
            }
            if (message.audioMessage != null && message.hasOwnProperty("audioMessage")) {
                var error = $root.proto.Message.AudioMessage.verify(message.audioMessage);
                if (error)
                    return "audioMessage." + error;
            }
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage")) {
                var error = $root.proto.Message.VideoMessage.verify(message.videoMessage);
                if (error)
                    return "videoMessage." + error;
            }
            if (message.call != null && message.hasOwnProperty("call")) {
                var error = $root.proto.Message.Call.verify(message.call);
                if (error)
                    return "call." + error;
            }
            if (message.chat != null && message.hasOwnProperty("chat")) {
                var error = $root.proto.Message.Chat.verify(message.chat);
                if (error)
                    return "chat." + error;
            }
            if (message.protocolMessage != null && message.hasOwnProperty("protocolMessage")) {
                var error = $root.proto.Message.ProtocolMessage.verify(message.protocolMessage);
                if (error)
                    return "protocolMessage." + error;
            }
            if (message.contactsArrayMessage != null && message.hasOwnProperty("contactsArrayMessage")) {
                var error = $root.proto.Message.ContactsArrayMessage.verify(message.contactsArrayMessage);
                if (error)
                    return "contactsArrayMessage." + error;
            }
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage")) {
                var error = $root.proto.Message.HighlyStructuredMessage.verify(message.highlyStructuredMessage);
                if (error)
                    return "highlyStructuredMessage." + error;
            }
            if (message.fastRatchetKeySenderKeyDistributionMessage != null && message.hasOwnProperty("fastRatchetKeySenderKeyDistributionMessage")) {
                var error = $root.proto.Message.SenderKeyDistributionMessage.verify(message.fastRatchetKeySenderKeyDistributionMessage);
                if (error)
                    return "fastRatchetKeySenderKeyDistributionMessage." + error;
            }
            if (message.sendPaymentMessage != null && message.hasOwnProperty("sendPaymentMessage")) {
                var error = $root.proto.Message.SendPaymentMessage.verify(message.sendPaymentMessage);
                if (error)
                    return "sendPaymentMessage." + error;
            }
            if (message.liveLocationMessage != null && message.hasOwnProperty("liveLocationMessage")) {
                var error = $root.proto.Message.LiveLocationMessage.verify(message.liveLocationMessage);
                if (error)
                    return "liveLocationMessage." + error;
            }
            if (message.requestPaymentMessage != null && message.hasOwnProperty("requestPaymentMessage")) {
                var error = $root.proto.Message.RequestPaymentMessage.verify(message.requestPaymentMessage);
                if (error)
                    return "requestPaymentMessage." + error;
            }
            if (message.declinePaymentRequestMessage != null && message.hasOwnProperty("declinePaymentRequestMessage")) {
                var error = $root.proto.Message.DeclinePaymentRequestMessage.verify(message.declinePaymentRequestMessage);
                if (error)
                    return "declinePaymentRequestMessage." + error;
            }
            if (message.cancelPaymentRequestMessage != null && message.hasOwnProperty("cancelPaymentRequestMessage")) {
                var error = $root.proto.Message.CancelPaymentRequestMessage.verify(message.cancelPaymentRequestMessage);
                if (error)
                    return "cancelPaymentRequestMessage." + error;
            }
            if (message.templateMessage != null && message.hasOwnProperty("templateMessage")) {
                var error = $root.proto.Message.TemplateMessage.verify(message.templateMessage);
                if (error)
                    return "templateMessage." + error;
            }
            if (message.stickerMessage != null && message.hasOwnProperty("stickerMessage")) {
                var error = $root.proto.Message.StickerMessage.verify(message.stickerMessage);
                if (error)
                    return "stickerMessage." + error;
            }
            if (message.groupInviteMessage != null && message.hasOwnProperty("groupInviteMessage")) {
                var error = $root.proto.Message.GroupInviteMessage.verify(message.groupInviteMessage);
                if (error)
                    return "groupInviteMessage." + error;
            }
            if (message.templateButtonReplyMessage != null && message.hasOwnProperty("templateButtonReplyMessage")) {
                var error = $root.proto.Message.TemplateButtonReplyMessage.verify(message.templateButtonReplyMessage);
                if (error)
                    return "templateButtonReplyMessage." + error;
            }
            if (message.productMessage != null && message.hasOwnProperty("productMessage")) {
                var error = $root.proto.Message.ProductMessage.verify(message.productMessage);
                if (error)
                    return "productMessage." + error;
            }
            if (message.deviceSentMessage != null && message.hasOwnProperty("deviceSentMessage")) {
                var error = $root.proto.Message.DeviceSentMessage.verify(message.deviceSentMessage);
                if (error)
                    return "deviceSentMessage." + error;
            }
            if (message.messageContextInfo != null && message.hasOwnProperty("messageContextInfo")) {
                var error = $root.proto.MessageContextInfo.verify(message.messageContextInfo);
                if (error)
                    return "messageContextInfo." + error;
            }
            if (message.listMessage != null && message.hasOwnProperty("listMessage")) {
                var error = $root.proto.Message.ListMessage.verify(message.listMessage);
                if (error)
                    return "listMessage." + error;
            }
            if (message.viewOnceMessage != null && message.hasOwnProperty("viewOnceMessage")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.viewOnceMessage);
                if (error)
                    return "viewOnceMessage." + error;
            }
            if (message.orderMessage != null && message.hasOwnProperty("orderMessage")) {
                var error = $root.proto.Message.OrderMessage.verify(message.orderMessage);
                if (error)
                    return "orderMessage." + error;
            }
            if (message.listResponseMessage != null && message.hasOwnProperty("listResponseMessage")) {
                var error = $root.proto.Message.ListResponseMessage.verify(message.listResponseMessage);
                if (error)
                    return "listResponseMessage." + error;
            }
            if (message.ephemeralMessage != null && message.hasOwnProperty("ephemeralMessage")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.ephemeralMessage);
                if (error)
                    return "ephemeralMessage." + error;
            }
            if (message.invoiceMessage != null && message.hasOwnProperty("invoiceMessage")) {
                var error = $root.proto.Message.InvoiceMessage.verify(message.invoiceMessage);
                if (error)
                    return "invoiceMessage." + error;
            }
            if (message.buttonsMessage != null && message.hasOwnProperty("buttonsMessage")) {
                var error = $root.proto.Message.ButtonsMessage.verify(message.buttonsMessage);
                if (error)
                    return "buttonsMessage." + error;
            }
            if (message.buttonsResponseMessage != null && message.hasOwnProperty("buttonsResponseMessage")) {
                var error = $root.proto.Message.ButtonsResponseMessage.verify(message.buttonsResponseMessage);
                if (error)
                    return "buttonsResponseMessage." + error;
            }
            if (message.paymentInviteMessage != null && message.hasOwnProperty("paymentInviteMessage")) {
                var error = $root.proto.Message.PaymentInviteMessage.verify(message.paymentInviteMessage);
                if (error)
                    return "paymentInviteMessage." + error;
            }
            if (message.interactiveMessage != null && message.hasOwnProperty("interactiveMessage")) {
                var error = $root.proto.Message.InteractiveMessage.verify(message.interactiveMessage);
                if (error)
                    return "interactiveMessage." + error;
            }
            if (message.reactionMessage != null && message.hasOwnProperty("reactionMessage")) {
                var error = $root.proto.Message.ReactionMessage.verify(message.reactionMessage);
                if (error)
                    return "reactionMessage." + error;
            }
            if (message.stickerSyncRmrMessage != null && message.hasOwnProperty("stickerSyncRmrMessage")) {
                var error = $root.proto.Message.StickerSyncRMRMessage.verify(message.stickerSyncRmrMessage);
                if (error)
                    return "stickerSyncRmrMessage." + error;
            }
            if (message.interactiveResponseMessage != null && message.hasOwnProperty("interactiveResponseMessage")) {
                var error = $root.proto.Message.InteractiveResponseMessage.verify(message.interactiveResponseMessage);
                if (error)
                    return "interactiveResponseMessage." + error;
            }
            if (message.pollCreationMessage != null && message.hasOwnProperty("pollCreationMessage")) {
                var error = $root.proto.Message.PollCreationMessage.verify(message.pollCreationMessage);
                if (error)
                    return "pollCreationMessage." + error;
            }
            if (message.pollUpdateMessage != null && message.hasOwnProperty("pollUpdateMessage")) {
                var error = $root.proto.Message.PollUpdateMessage.verify(message.pollUpdateMessage);
                if (error)
                    return "pollUpdateMessage." + error;
            }
            if (message.keepInChatMessage != null && message.hasOwnProperty("keepInChatMessage")) {
                var error = $root.proto.Message.KeepInChatMessage.verify(message.keepInChatMessage);
                if (error)
                    return "keepInChatMessage." + error;
            }
            if (message.documentWithCaptionMessage != null && message.hasOwnProperty("documentWithCaptionMessage")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.documentWithCaptionMessage);
                if (error)
                    return "documentWithCaptionMessage." + error;
            }
            if (message.requestPhoneNumberMessage != null && message.hasOwnProperty("requestPhoneNumberMessage")) {
                var error = $root.proto.Message.RequestPhoneNumberMessage.verify(message.requestPhoneNumberMessage);
                if (error)
                    return "requestPhoneNumberMessage." + error;
            }
            if (message.viewOnceMessageV2 != null && message.hasOwnProperty("viewOnceMessageV2")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.viewOnceMessageV2);
                if (error)
                    return "viewOnceMessageV2." + error;
            }
            if (message.encReactionMessage != null && message.hasOwnProperty("encReactionMessage")) {
                var error = $root.proto.Message.EncReactionMessage.verify(message.encReactionMessage);
                if (error)
                    return "encReactionMessage." + error;
            }
            if (message.editedMessage != null && message.hasOwnProperty("editedMessage")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.editedMessage);
                if (error)
                    return "editedMessage." + error;
            }
            if (message.viewOnceMessageV2Extension != null && message.hasOwnProperty("viewOnceMessageV2Extension")) {
                var error = $root.proto.Message.FutureProofMessage.verify(message.viewOnceMessageV2Extension);
                if (error)
                    return "viewOnceMessageV2Extension." + error;
            }
            return null;
        };

        /**
         * Creates a Message message from a plain object. Also converts values to their respective internal types.
         * @function fromObject
         * @memberof proto.Message
         * @static
         * @param {Object.<string,*>} object Plain object
         * @returns {proto.Message} Message
         */
        Message.fromObject = function fromObject(object) {
            if (object instanceof $root.proto.Message)
                return object;
            var message = new $root.proto.Message();
            if (object.conversation != null)
                message.conversation = String(object.conversation);
            if (object.senderKeyDistributionMessage != null) {
                if (typeof object.senderKeyDistributionMessage !== "object")
                    throw TypeError(".proto.Message.senderKeyDistributionMessage: object expected");
                message.senderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.fromObject(object.senderKeyDistributionMessage);
            }
            if (object.imageMessage != null) {
                if (typeof object.imageMessage !== "object")
                    throw TypeError(".proto.Message.imageMessage: object expected");
                message.imageMessage = $root.proto.Message.ImageMessage.fromObject(object.imageMessage);
            }
            if (object.contactMessage != null) {
                if (typeof object.contactMessage !== "object")
                    throw TypeError(".proto.Message.contactMessage: object expected");
                message.contactMessage = $root.proto.Message.ContactMessage.fromObject(object.contactMessage);
            }
            if (object.locationMessage != null) {
                if (typeof object.locationMessage !== "object")
                    throw TypeError(".proto.Message.locationMessage: object expected");
                message.locationMessage = $root.proto.Message.LocationMessage.fromObject(object.locationMessage);
            }
            if (object.extendedTextMessage != null) {
                if (typeof object.extendedTextMessage !== "object")
                    throw TypeError(".proto.Message.extendedTextMessage: object expected");
                message.extendedTextMessage = $root.proto.Message.ExtendedTextMessage.fromObject(object.extendedTextMessage);
            }
            if (object.documentMessage != null) {
                if (typeof object.documentMessage !== "object")
                    throw TypeError(".proto.Message.documentMessage: object expected");
                message.documentMessage = $root.proto.Message.DocumentMessage.fromObject(object.documentMessage);
            }
            if (object.audioMessage != null) {
                if (typeof object.audioMessage !== "object")
                    throw TypeError(".proto.Message.audioMessage: object expected");
                message.audioMessage = $root.proto.Message.AudioMessage.fromObject(object.audioMessage);
            }
            if (object.videoMessage != null) {
                if (typeof object.videoMessage !== "object")
                    throw TypeError(".proto.Message.videoMessage: object expected");
                message.videoMessage = $root.proto.Message.VideoMessage.fromObject(object.videoMessage);
            }
            if (object.call != null) {
                if (typeof object.call !== "object")
                    throw TypeError(".proto.Message.call: object expected");
                message.call = $root.proto.Message.Call.fromObject(object.call);
            }
            if (object.chat != null) {
                if (typeof object.chat !== "object")
                    throw TypeError(".proto.Message.chat: object expected");
                message.chat = $root.proto.Message.Chat.fromObject(object.chat);
            }
            if (object.protocolMessage != null) {
                if (typeof object.protocolMessage !== "object")
                    throw TypeError(".proto.Message.protocolMessage: object expected");
                message.protocolMessage = $root.proto.Message.ProtocolMessage.fromObject(object.protocolMessage);
            }
            if (object.contactsArrayMessage != null) {
                if (typeof object.contactsArrayMessage !== "object")
                    throw TypeError(".proto.Message.contactsArrayMessage: object expected");
                message.contactsArrayMessage = $root.proto.Message.ContactsArrayMessage.fromObject(object.contactsArrayMessage);
            }
            if (object.highlyStructuredMessage != null) {
                if (typeof object.highlyStructuredMessage !== "object")
                    throw TypeError(".proto.Message.highlyStructuredMessage: object expected");
                message.highlyStructuredMessage = $root.proto.Message.HighlyStructuredMessage.fromObject(object.highlyStructuredMessage);
            }
            if (object.fastRatchetKeySenderKeyDistributionMessage != null) {
                if (typeof object.fastRatchetKeySenderKeyDistributionMessage !== "object")
                    throw TypeError(".proto.Message.fastRatchetKeySenderKeyDistributionMessage: object expected");
                message.fastRatchetKeySenderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.fromObject(object.fastRatchetKeySenderKeyDistributionMessage);
            }
            if (object.sendPaymentMessage != null) {
                if (typeof object.sendPaymentMessage !== "object")
                    throw TypeError(".proto.Message.sendPaymentMessage: object expected");
                message.sendPaymentMessage = $root.proto.Message.SendPaymentMessage.fromObject(object.sendPaymentMessage);
            }
            if (object.liveLocationMessage != null) {
                if (typeof object.liveLocationMessage !== "object")
                    throw TypeError(".proto.Message.liveLocationMessage: object expected");
                message.liveLocationMessage = $root.proto.Message.LiveLocationMessage.fromObject(object.liveLocationMessage);
            }
            if (object.requestPaymentMessage != null) {
                if (typeof object.requestPaymentMessage !== "object")
                    throw TypeError(".proto.Message.requestPaymentMessage: object expected");
                message.requestPaymentMessage = $root.proto.Message.RequestPaymentMessage.fromObject(object.requestPaymentMessage);
            }
            if (object.declinePaymentRequestMessage != null) {
                if (typeof object.declinePaymentRequestMessage !== "object")
                    throw TypeError(".proto.Message.declinePaymentRequestMessage: object expected");
                message.declinePaymentRequestMessage = $root.proto.Message.DeclinePaymentRequestMessage.fromObject(object.declinePaymentRequestMessage);
            }
            if (object.cancelPaymentRequestMessage != null) {
                if (typeof object.cancelPaymentRequestMessage !== "object")
                    throw TypeError(".proto.Message.cancelPaymentRequestMessage: object expected");
                message.cancelPaymentRequestMessage = $root.proto.Message.CancelPaymentRequestMessage.fromObject(object.cancelPaymentRequestMessage);
            }
            if (object.templateMessage != null) {
                if (typeof object.templateMessage !== "object")
                    throw TypeError(".proto.Message.templateMessage: object expected");
                message.templateMessage = $root.proto.Message.TemplateMessage.fromObject(object.templateMessage);
            }
            if (object.stickerMessage != null) {
                if (typeof object.stickerMessage !== "object")
                    throw TypeError(".proto.Message.stickerMessage: object expected");
                message.stickerMessage = $root.proto.Message.StickerMessage.fromObject(object.stickerMessage);
            }
            if (object.groupInviteMessage != null) {
                if (typeof object.groupInviteMessage !== "object")
                    throw TypeError(".proto.Message.groupInviteMessage: object expected");
                message.groupInviteMessage = $root.proto.Message.GroupInviteMessage.fromObject(object.groupInviteMessage);
            }
            if (object.templateButtonReplyMessage != null) {
                if (typeof object.templateButtonReplyMessage !== "object")
                    throw TypeError(".proto.Message.templateButtonReplyMessage: object expected");
                message.templateButtonReplyMessage = $root.proto.Message.TemplateButtonReplyMessage.fromObject(object.templateButtonReplyMessage);
            }
            if (object.productMessage != null) {
                if (typeof object.productMessage !== "object")
                    throw TypeError(".proto.Message.productMessage: object expected");
                message.productMessage = $root.proto.Message.ProductMessage.fromObject(object.productMessage);
            }
            if (object.deviceSentMessage != null) {
                if (typeof object.deviceSentMessage !== "object")
                    throw TypeError(".proto.Message.deviceSentMessage: object expected");
                message.deviceSentMessage = $root.proto.Message.DeviceSentMessage.fromObject(object.deviceSentMessage);
            }
            if (object.messageContextInfo != null) {
                if (typeof object.messageContextInfo !== "object")
                    throw TypeError(".proto.Message.messageContextInfo: object expected");
                message.messageContextInfo = $root.proto.MessageContextInfo.fromObject(object.messageContextInfo);
            }
            if (object.listMessage != null) {
                if (typeof object.listMessage !== "object")
                    throw TypeError(".proto.Message.listMessage: object expected");
                message.listMessage = $root.proto.Message.ListMessage.fromObject(object.listMessage);
            }
            if (object.viewOnceMessage != null) {
                if (typeof object.viewOnceMessage !== "object")
                    throw TypeError(".proto.Message.viewOnceMessage: object expected");
                message.viewOnceMessage = $root.proto.Message.FutureProofMessage.fromObject(object.viewOnceMessage);
            }
            if (object.orderMessage != null) {
                if (typeof object.orderMessage !== "object")
                    throw TypeError(".proto.Message.orderMessage: object expected");
                message.orderMessage = $root.proto.Message.OrderMessage.fromObject(object.orderMessage);
            }
            if (object.listResponseMessage != null) {
                if (typeof object.listResponseMessage !== "object")
                    throw TypeError(".proto.Message.listResponseMessage: object expected");
                message.listResponseMessage = $root.proto.Message.ListResponseMessage.fromObject(object.listResponseMessage);
            }
            if (object.ephemeralMessage != null) {
                if (typeof object.ephemeralMessage !== "object")
                    throw TypeError(".proto.Message.ephemeralMessage: object expected");
                message.ephemeralMessage = $root.proto.Message.FutureProofMessage.fromObject(object.ephemeralMessage);
            }
            if (object.invoiceMessage != null) {
                if (typeof object.invoiceMessage !== "object")
                    throw TypeError(".proto.Message.invoiceMessage: object expected");
                message.invoiceMessage = $root.proto.Message.InvoiceMessage.fromObject(object.invoiceMessage);
            }
            if (object.buttonsMessage != null) {
                if (typeof object.buttonsMessage !== "object")
                    throw TypeError(".proto.Message.buttonsMessage: object expected");
                message.buttonsMessage = $root.proto.Message.ButtonsMessage.fromObject(object.buttonsMessage);
            }
            if (object.buttonsResponseMessage != null) {
                if (typeof object.buttonsResponseMessage !== "object")
                    throw TypeError(".proto.Message.buttonsResponseMessage: object expected");
                message.buttonsResponseMessage = $root.proto.Message.ButtonsResponseMessage.fromObject(object.buttonsResponseMessage);
            }
            if (object.paymentInviteMessage != null) {
                if (typeof object.paymentInviteMessage !== "object")
                    throw TypeError(".proto.Message.paymentInviteMessage: object expected");
                message.paymentInviteMessage = $root.proto.Message.PaymentInviteMessage.fromObject(object.paymentInviteMessage);
            }
            if (object.interactiveMessage != null) {
                if (typeof object.interactiveMessage !== "object")
                    throw TypeError(".proto.Message.interactiveMessage: object expected");
                message.interactiveMessage = $root.proto.Message.InteractiveMessage.fromObject(object.interactiveMessage);
            }
            if (object.reactionMessage != null) {
                if (typeof object.reactionMessage !== "object")
                    throw TypeError(".proto.Message.reactionMessage: object expected");
                message.reactionMessage = $root.proto.Message.ReactionMessage.fromObject(object.reactionMessage);
            }
            if (object.stickerSyncRmrMessage != null) {
                if (typeof object.stickerSyncRmrMessage !== "object")
                    throw TypeError(".proto.Message.stickerSyncRmrMessage: object expected");
                message.stickerSyncRmrMessage = $root.proto.Message.StickerSyncRMRMessage.fromObject(object.stickerSyncRmrMessage);
            }
            if (object.interactiveResponseMessage != null) {
                if (typeof object.interactiveResponseMessage !== "object")
                    throw TypeError(".proto.Message.interactiveResponseMessage: object expected");
                message.interactiveResponseMessage = $root.proto.Message.InteractiveResponseMessage.fromObject(object.interactiveResponseMessage);
            }
            if (object.pollCreationMessage != null) {
                if (typeof object.pollCreationMessage !== "object")
                    throw TypeError(".proto.Message.pollCreationMessage: object expected");
                message.pollCreationMessage = $root.proto.Message.PollCreationMessage.fromObject(object.pollCreationMessage);
            }
            if (object.pollUpdateMessage != null) {
                if (typeof object.pollUpdateMessage !== "object")
                    throw TypeError(".proto.Message.pollUpdateMessage: object expected");
                message.pollUpdateMessage = $root.proto.Message.PollUpdateMessage.fromObject(object.pollUpdateMessage);
            }
            if (object.keepInChatMessage != null) {
                if (typeof object.keepInChatMessage !== "object")
                    throw TypeError(".proto.Message.keepInChatMessage: object expected");
                message.keepInChatMessage = $root.proto.Message.KeepInChatMessage.fromObject(object.keepInChatMessage);
            }
            if (object.documentWithCaptionMessage != null) {
                if (typeof object.documentWithCaptionMessage !== "object")
                    throw TypeError(".proto.Message.documentWithCaptionMessage: object expected");
                message.documentWithCaptionMessage = $root.proto.Message.FutureProofMessage.fromObject(object.documentWithCaptionMessage);
            }
            if (object.requestPhoneNumberMessage != null) {
                if (typeof object.requestPhoneNumberMessage !== "object")
                    throw TypeError(".proto.Message.requestPhoneNumberMessage: object expected");
                message.requestPhoneNumberMessage = $root.proto.Message.RequestPhoneNumberMessage.fromObject(object.requestPhoneNumberMessage);
            }
            if (object.viewOnceMessageV2 != null) {
                if (typeof object.viewOnceMessageV2 !== "object")
                    throw TypeError(".proto.Message.viewOnceMessageV2: object expected");
                message.viewOnceMessageV2 = $root.proto.Message.FutureProofMessage.fromObject(object.viewOnceMessageV2);
            }
            if (object.encReactionMessage != null) {
                if (typeof object.encReactionMessage !== "object")
                    throw TypeError(".proto.Message.encReactionMessage: object expected");
                message.encReactionMessage = $root.proto.Message.EncReactionMessage.fromObject(object.encReactionMessage);
            }
            if (object.editedMessage != null) {
                if (typeof object.editedMessage !== "object")
                    throw TypeError(".proto.Message.editedMessage: object expected");
                message.editedMessage = $root.proto.Message.FutureProofMessage.fromObject(object.editedMessage);
            }
            if (object.viewOnceMessageV2Extension != null) {
                if (typeof object.viewOnceMessageV2Extension !== "object")
                    throw TypeError(".proto.Message.viewOnceMessageV2Extension: object expected");
                message.viewOnceMessageV2Extension = $root.proto.Message.FutureProofMessage.fromObject(object.viewOnceMessageV2Extension);
            }
            return message;
        };

        /**
         * Creates a plain object from a Message message. Also converts values to other types if specified.
         * @function toObject
         * @memberof proto.Message
         * @static
         * @param {proto.Message} message Message
         * @param {$protobuf.IConversionOptions} [options] Conversion options
         * @returns {Object.<string,*>} Plain object
         */
        Message.toObject = function toObject(message, options) {
            if (!options)
                options = {};
            var object = {};
            if (options.defaults) {
                object.conversation = "";
                object.senderKeyDistributionMessage = null;
                object.imageMessage = null;
                object.contactMessage = null;
                object.locationMessage = null;
                object.extendedTextMessage = null;
                object.documentMessage = null;
                object.audioMessage = null;
                object.videoMessage = null;
                object.call = null;
                object.chat = null;
                object.protocolMessage = null;
                object.contactsArrayMessage = null;
                object.highlyStructuredMessage = null;
                object.fastRatchetKeySenderKeyDistributionMessage = null;
                object.sendPaymentMessage = null;
                object.liveLocationMessage = null;
                object.requestPaymentMessage = null;
                object.declinePaymentRequestMessage = null;
                object.cancelPaymentRequestMessage = null;
                object.templateMessage = null;
                object.stickerMessage = null;
                object.groupInviteMessage = null;
                object.templateButtonReplyMessage = null;
                object.productMessage = null;
                object.deviceSentMessage = null;
                object.messageContextInfo = null;
                object.listMessage = null;
                object.viewOnceMessage = null;
                object.orderMessage = null;
                object.listResponseMessage = null;
                object.ephemeralMessage = null;
                object.invoiceMessage = null;
                object.buttonsMessage = null;
                object.buttonsResponseMessage = null;
                object.paymentInviteMessage = null;
                object.interactiveMessage = null;
                object.reactionMessage = null;
                object.stickerSyncRmrMessage = null;
                object.interactiveResponseMessage = null;
                object.pollCreationMessage = null;
                object.pollUpdateMessage = null;
                object.keepInChatMessage = null;
                object.documentWithCaptionMessage = null;
                object.requestPhoneNumberMessage = null;
                object.viewOnceMessageV2 = null;
                object.encReactionMessage = null;
                object.editedMessage = null;
                object.viewOnceMessageV2Extension = null;
            }
            if (message.conversation != null && message.hasOwnProperty("conversation"))
                object.conversation = message.conversation;
            if (message.senderKeyDistributionMessage != null && message.hasOwnProperty("senderKeyDistributionMessage"))
                object.senderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.toObject(message.senderKeyDistributionMessage, options);
            if (message.imageMessage != null && message.hasOwnProperty("imageMessage"))
                object.imageMessage = $root.proto.Message.ImageMessage.toObject(message.imageMessage, options);
            if (message.contactMessage != null && message.hasOwnProperty("contactMessage"))
                object.contactMessage = $root.proto.Message.ContactMessage.toObject(message.contactMessage, options);
            if (message.locationMessage != null && message.hasOwnProperty("locationMessage"))
                object.locationMessage = $root.proto.Message.LocationMessage.toObject(message.locationMessage, options);
            if (message.extendedTextMessage != null && message.hasOwnProperty("extendedTextMessage"))
                object.extendedTextMessage = $root.proto.Message.ExtendedTextMessage.toObject(message.extendedTextMessage, options);
            if (message.documentMessage != null && message.hasOwnProperty("documentMessage"))
                object.documentMessage = $root.proto.Message.DocumentMessage.toObject(message.documentMessage, options);
            if (message.audioMessage != null && message.hasOwnProperty("audioMessage"))
                object.audioMessage = $root.proto.Message.AudioMessage.toObject(message.audioMessage, options);
            if (message.videoMessage != null && message.hasOwnProperty("videoMessage"))
                object.videoMessage = $root.proto.Message.VideoMessage.toObject(message.videoMessage, options);
            if (message.call != null && message.hasOwnProperty("call"))
                object.call = $root.proto.Message.Call.toObject(message.call, options);
            if (message.chat != null && message.hasOwnProperty("chat"))
                object.chat = $root.proto.Message.Chat.toObject(message.chat, options);
            if (message.protocolMessage != null && message.hasOwnProperty("protocolMessage"))
                object.protocolMessage = $root.proto.Message.ProtocolMessage.toObject(message.protocolMessage, options);
            if (message.contactsArrayMessage != null && message.hasOwnProperty("contactsArrayMessage"))
                object.contactsArrayMessage = $root.proto.Message.ContactsArrayMessage.toObject(message.contactsArrayMessage, options);
            if (message.highlyStructuredMessage != null && message.hasOwnProperty("highlyStructuredMessage"))
                object.highlyStructuredMessage = $root.proto.Message.HighlyStructuredMessage.toObject(message.highlyStructuredMessage, options);
            if (message.fastRatchetKeySenderKeyDistributionMessage != null && message.hasOwnProperty("fastRatchetKeySenderKeyDistributionMessage"))
                object.fastRatchetKeySenderKeyDistributionMessage = $root.proto.Message.SenderKeyDistributionMessage.toObject(message.fastRatchetKeySenderKeyDistributionMessage, options);
            if (message.sendPaymentMessage != null && message.hasOwnProperty("sendPaymentMessage"))
                object.sendPaymentMessage = $root.proto.Message.SendPaymentMessage.toObject(message.sendPaymentMessage, options);
            if (message.liveLocationMessage != null && message.hasOwnProperty("liveLocationMessage"))
                object.liveLocationMessage = $root.proto.Message.LiveLocationMessage.toObject(message.liveLocationMessage, options);
            if (message.requestPaymentMessage != null && message.hasOwnProperty("requestPaymentMessage"))
                object.requestPaymentMessage = $root.proto.Message.RequestPaymentMessage.toObject(message.requestPaymentMessage, options);
            if (message.declinePaymentRequestMessage != null && message.hasOwnProperty("declinePaymentRequestMessage"))
                object.declinePaymentRequestMessage = $root.proto.Message.DeclinePaymentRequestMessage.toObject(message.declinePaymentRequestMessage, options);
            if (message.cancelPaymentRequestMessage != null && message.hasOwnProperty("cancelPaymentRequestMessage"))
                object.cancelPaymentRequestMessage = $root.proto.Message.CancelPaymentRequestMessage.toObject(message.cancelPaymentRequestMessage, options);
            if (message.templateMessage != null && message.hasOwnProperty("templateMessage"))
                object.templateMessage = $root.proto.Message.TemplateMessage.toObject(message.templateMessage, options);
            if (message.stickerMessage != null && message.hasOwnProperty("stickerMessage"))
                object.stickerMessage = $root.proto.Message.StickerMessage.toObject(message.stickerMessage, options);
            if (message.groupInviteMessage != null && message.hasOwnProperty("groupInviteMessage"))
                object.groupInviteMessage = $root.proto.Message.GroupInviteMessage.toObject(message.groupInviteMessage, options);
            if (message.templateButtonReplyMessage != null && message.hasOwnProperty("templateButtonReplyMessage"))
                object.templateButtonReplyMessage = $root.proto.Message.TemplateButtonReplyMessage.toObject(message.templateButtonReplyMessage, options);
            if (message.productMessage != null && message.hasOwnProperty("productMessage"))
                object.productMessage = $root.proto.Message.ProductMessage.toObject(message.productMessage, options);
            if (message.deviceSentMessage != null && message.hasOwnProperty("deviceSentMessage"))
                object.deviceSentMessage = $root.proto.Message.DeviceSentMessage.toObject(message.deviceSentMessage, options);
            if (message.messageContextInfo != null && message.hasOwnProperty("messageContextInfo"))
                object.messageContextInfo = $root.proto.MessageContextInfo.toObject(message.messageContextInfo, options);
            if (message.listMessage != null && message.hasOwnProperty("listMessage"))
                object.listMessage = $root.proto.Message.ListMessage.toObject(message.listMessage, options);
            if (message.viewOnceMessage != null && message.hasOwnProperty("viewOnceMessage"))
                object.viewOnceMessage = $root.proto.Message.FutureProofMessage.toObject(message.viewOnceMessage, options);
            if (message.orderMessage != null && message.hasOwnProperty("orderMessage"))
                object.orderMessage = $root.proto.Message.OrderMessage.toObject(message.orderMessage, options);
            if (message.listResponseMessage != null && message.hasOwnProperty("listResponseMessage"))
                object.listResponseMessage = $root.proto.Message.ListResponseMessage.toObject(message.listResponseMessage, options);
            if (message.ephemeralMessage != null && message.hasOwnProperty("ephemeralMessage"))
                object.ephemeralMessage = $root.proto.Message.FutureProofMessage.toObject(message.ephemeralMessage, options);
            if (message.invoiceMessage != null && message.hasOwnProperty("invoiceMessage"))
                object.invoiceMessage = $root.proto.Message.InvoiceMessage.toObject(message.invoiceMessage, options);
            if (message.buttonsMessage != null && message.hasOwnProperty("buttonsMessage"))
                object.buttonsMessage = $root.proto.Message.ButtonsMessage.toObject(message.buttonsMessage, options);
            if (message.buttonsResponseMessage != null && message.hasOwnProperty("buttonsResponseMessage"))
                object.buttonsResponseMessage = $root.proto.Message.ButtonsResponseMessage.toObject(message.buttonsResponseMessage, options);
            if (message.paymentInviteMessage != null && message.hasOwnProperty("paymentInviteMessage"))
                object.paymentInviteMessage = $root.proto.Message.PaymentInviteMessage.toObject(message.paymentInviteMessage, options);
            if (message.interactiveMessage != null && message.hasOwnProperty("interactiveMessage"))
                object.interactiveMessage = $root.proto.Message.InteractiveMessage.toObject(message.interactiveMessage, options);
            if (message.reactionMessage != null && message.hasOwnProperty("reactionMessage"))
                object.reactionMessage = $root.proto.Message.ReactionMessage.toObject(message.reactionMessage, options);
            if (message.stickerSyncRmrMessage != null && message.hasOwnProperty("stickerSyncRmrMessage"))
                object.stickerSyncRmrMessage = $root.proto.Message.StickerSyncRMRMessage.toObject(message.stickerSyncRmrMessage, options);
            if (message.interactiveResponseMessage != null && message.hasOwnProperty("interactiveResponseMessage"))
                object.interactiveResponseMessage = $root.proto.Message.InteractiveResponseMessage.toObject(message.interactiveResponseMessage, options);
            if (message.pollCreationMessage != null && message.hasOwnProperty("pollCreationMessage"))
                object.pollCreationMessage = $root.proto.Message.PollCreationMessage.toObject(message.pollCreationMessage, options);
            if (message.pollUpdateMessage != null && message.hasOwnProperty("pollUpdateMessage"))
                object.pollUpdateMessage = $root.proto.Message.PollUpdateMessage.toObject(message.pollUpdateMessage, options);
            if (message.keepInChatMessage != null && message.hasOwnProperty("keepInChatMessage"))
                object.keepInChatMessage = $root.proto.Message.KeepInChatMessage.toObject(message.keepInChatMessage, options);
            if (message.documentWithCaptionMessage != null && message.hasOwnProperty("documentWithCaptionMessage"))
                object.documentWithCaptionMessage = $root.proto.Message.FutureProofMessage.toObject(message.documentWithCaptionMessage, options);
            if (message.requestPhoneNumberMessage != null && message.hasOwnProperty("requestPhoneNumberMessage"))
                object.requestPhoneNumberMessage = $root.proto.Message.RequestPhoneNumberMessage.toObject(message.requestPhoneNumberMessage, options);
            if (message.viewOnceMessageV2 != null && message.hasOwnProperty("viewOnceMessageV2"))
                object.viewOnceMessageV2 = $root.proto.Message.FutureProofMessage.toObject(message.viewOnceMessageV2, options);
            if (message.encReactionMessage != null && message.hasOwnProperty("encReactionMessage"))
                object.encReactionMessage = $root.proto.Message.EncReactionMessage.toObject(message.encReactionMessage, options);
            if (message.editedMessage != null && message.hasOwnProperty("editedMessage"))
                object.editedMessage = $root.proto.Message.FutureProofMessage.toObject(message.editedMessage, options);
            if (message.viewOnceMessageV2Extension != null && message.hasOwnProperty("viewOnceMessageV2Extension"))
                object.viewOnceMessageV2Extension = $root.proto.Message.FutureProofMessage.toObject(message.viewOnceMessageV2Extension, options);
            return object;
        };

        /**
         * Converts this Message to JSON.
         * @function toJSON
         * @memberof proto.Message
         * @instance
         * @returns {Object.<string,*>} JSON object
         */
        Message.prototype.toJSON = function toJSON() {
            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
        };

        Message.AppStateFatalExceptionNotification = (function() {

            /**
             * Properties of an AppStateFatalExceptionNotification.
             * @memberof proto.Message
             * @interface IAppStateFatalExceptionNotification
             * @property {Array.<string>|null} [collectionNames] AppStateFatalExceptionNotification collectionNames
             * @property {number|Long|null} [timestamp] AppStateFatalExceptionNotification timestamp
             */

            /**
             * Constructs a new AppStateFatalExceptionNotification.
             * @memberof proto.Message
             * @classdesc Represents an AppStateFatalExceptionNotification.
             * @implements IAppStateFatalExceptionNotification
             * @constructor
             * @param {proto.Message.IAppStateFatalExceptionNotification=} [properties] Properties to set
             */
            function AppStateFatalExceptionNotification(properties) {
                this.collectionNames = [];
                if (properties)
                    for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                        if (properties[keys[i]] != null)
                            this[keys[i]] = properties[keys[i]];
            }

            /**
             * AppStateFatalExceptionNotification collectionNames.
             * @member {Array.<string>} collectionNames
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @instance
             */
            AppStateFatalExceptionNotification.prototype.collectionNames = $util.emptyArray;

            /**
             * AppStateFatalExceptionNotification timestamp.
             * @member {number|Long} timestamp
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @instance
             */
            AppStateFatalExceptionNotification.prototype.timestamp = $util.Long ? $util.Long.fromBits(0,0,false) : 0;

            /**
             * Creates a new AppStateFatalExceptionNotification instance using the specified properties.
             * @function create
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {proto.Message.IAppStateFatalExceptionNotification=} [properties] Properties to set
             * @returns {proto.Message.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification instance
             */
            AppStateFatalExceptionNotification.create = function create(properties) {
                return new AppStateFatalExceptionNotification(properties);
            };

            /**
             * Encodes the specified AppStateFatalExceptionNotification message. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @function encode
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {proto.Message.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppStateFatalExceptionNotification.encode = function encode(message, writer) {
                if (!writer)
                    writer = $Writer.create();
                if (message.collectionNames != null && message.collectionNames.length)
                    for (var i = 0; i < message.collectionNames.length; ++i)
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.collectionNames[i]);
                if (message.timestamp != null && Object.hasOwnProperty.call(message, "timestamp"))
                    writer.uint32(/* id 2, wireType 0 =*/16).int64(message.timestamp);
                return writer;
            };

            /**
             * Encodes the specified AppStateFatalExceptionNotification message, length delimited. Does not implicitly {@link proto.Message.AppStateFatalExceptionNotification.verify|verify} messages.
             * @function encodeDelimited
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {proto.Message.IAppStateFatalExceptionNotification} message AppStateFatalExceptionNotification message or plain object to encode
             * @param {$protobuf.Writer} [writer] Writer to encode to
             * @returns {$protobuf.Writer} Writer
             */
            AppStateFatalExceptionNotification.encodeDelimited = function encodeDelimited(message, writer) {
                return this.encode(message, writer).ldelim();
            };

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer.
             * @function decode
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @param {number} [length] Message length if known beforehand
             * @returns {proto.Message.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppStateFatalExceptionNotification.decode = function decode(reader, length) {
                if (!(reader instanceof $Reader))
                    reader = $Reader.create(reader);
                var end = length === undefined ? reader.len : reader.pos + length, message = new $root.proto.Message.AppStateFatalExceptionNotification();
                while (reader.pos < end) {
                    var tag = reader.uint32();
                    switch (tag >>> 3) {
                    case 1:
                        if (!(message.collectionNames && message.collectionNames.length))
                            message.collectionNames = [];
                        message.collectionNames.push(reader.string());
                        break;
                    case 2:
                        message.timestamp = reader.int64();
                        break;
                    default:
                        reader.skipType(tag & 7);
                        break;
                    }
                }
                return message;
            };

            /**
             * Decodes an AppStateFatalExceptionNotification message from the specified reader or buffer, length delimited.
             * @function decodeDelimited
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
             * @returns {proto.Message.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
             * @throws {Error} If the payload is not a reader or valid buffer
             * @throws {$protobuf.util.ProtocolError} If required fields are missing
             */
            AppStateFatalExceptionNotification.decodeDelimited = function decodeDelimited(reader) {
                if (!(reader instanceof $Reader))
                    reader = new $Reader(reader);
                return this.decode(reader, reader.uint32());
            };

            /**
             * Verifies an AppStateFatalExceptionNotification message.
             * @function verify
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {Object.<string,*>} message Plain object to verify
             * @returns {string|null} `null` if valid, otherwise the reason why it is not
             */
            AppStateFatalExceptionNotification.verify = function verify(message) {
                if (typeof message !== "object" || message === null)
                    return "object expected";
                if (message.collectionNames != null && message.hasOwnProperty("collectionNames")) {
                    if (!Array.isArray(message.collectionNames))
                        return "collectionNames: array expected";
                    for (var i = 0; i < message.collectionNames.length; ++i)
                        if (!$util.isString(message.collectionNames[i]))
                            return "collectionNames: string[] expected";
                }
                if (message.timestamp != null && message.hasOwnProperty("timestamp"))
                    if (!$util.isInteger(message.timestamp) && !(message.timestamp && $util.isInteger(message.timestamp.low) && $util.isInteger(message.timestamp.high)))
                        return "timestamp: integer|Long expected";
                return null;
            };

            /**
             * Creates an AppStateFatalExceptionNotification message from a plain object. Also converts values to their respective internal types.
             * @function fromObject
             * @memberof proto.Message.AppStateFatalExceptionNotification
             * @static
             * @param {Object.<string,*>} object Plain object
             * @returns {proto.Message.AppStateFatalExceptionNotification} AppStateFatalExceptionNotification
             */
            AppStateFatalExceptionNotification.fromObject = function fromObject(object) {
                if (object instanceof $root.proto.Message.AppStateFatalExceptionNotification)
                    return object;
                var message = new $root.proto.Message.AppStateFatalExceptionNotification();
                if (object.collectionNames) {
                    if (!Array.isArray(object.collectionNames))
                        throw TypeError(".proto.Message.AppStateFatalExceptionNotification.collectionNames: array expected");
                    message.collectionNames = [];
                    for (var i = 0; i < object.collectionNames.length; ++i)
                        message.collectionNames[i] = String(object.collectionNames[i]);
                }
                if (object.timestamp != null)
                    if ($util.Long)
                        (message.timestamp = $util.Long.fromValue(object.timestamp)).unsigned = false;
                    else if (typeof object.timestamp === "string")
                        message.timestamp = parseInt(object.timestamp, 10);
                    else if (typeof object.timestamp === "number")
                        message.timestamp = object.timestamp;
                    else if (typeof object.timestamp === "object")
                        message.timestamp = new $util.LongBits(object.timestamp.low >>> 0, object.timestamp.high >>> 0).toNumber();
  